/*
 * Decompiled with CFR 0.152.
 */
package enercad2007.printdlg;

import core.Config;
import core.ImageFop;
import enercad2007.DM_Trad_SIA;
import enercad2007.Ecad2007;
import enercad2007.Globals;
import enercad2007.printdlg.PrtSIA;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Locale;
import jecadcomp.Out_Flux;

public class FoFlux {
    PrtSIA prtSIA;
    Out_Flux out_flux = new Out_Flux(true);
    private static int ff = 1;
    static String unit = "MJ";
    Font FT_P6 = new Font("Dialog", 0, 6 * ff);
    Font FT_P7 = new Font("Dialog", 0, 7 * ff);
    Font FT_P8 = new Font("Dialog", 0, 8 * ff);
    Font FT_P9 = new Font("Dialog", 0, 9 * ff);
    Font FT_P10 = new Font("Dialog", 0, 10 * ff);
    Font FT_P11 = new Font("Dialog", 0, 11 * ff);
    Font FT_B6 = new Font("Dialog", 1, 6 * ff);
    Font FT_B7 = new Font("Dialog", 1, 7 * ff);
    Font FT_B8 = new Font("Dialog", 1, 8 * ff);
    Font FT_B9 = new Font("Dialog", 1, 9 * ff);
    Font FT_B10 = new Font("Dialog", 1, 10 * ff);
    Font FT_B14 = new Font("Dialog", 1, 14);
    Rectangle rec_img = new Rectangle(65, 424, 450, 270);
    Config config = new Config(System.getProperty("conf.file.name"));

    public FoFlux(PrtSIA prtSIA) {
        this.prtSIA = prtSIA;
        unit = Ecad2007.getCalcmod() < 7 ? "MJ" : "kWh";
    }

    public String buildFoJFlux() {
        DM_Trad_SIA dm_tradSIA = Ecad2007.getTraduction_SIA("jflux");
        String foString = "";
        String foSection = FoFlux.fo(0);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("\\$_titleF1", dm_tradSIA.getCodeLan("$_title"));
        map.put("\\$_nom", dm_tradSIA.getCodeLan("$_nom"));
        map.put("\\%_nom", this.prtSIA.cleanS(Ecad2007.getDM_Pro().getNOM_B()));
        map.put("\\$_dossier", dm_tradSIA.getCodeLan("$_dossier"));
        map.put("\\%_dossier", this.prtSIA.cleanS(Ecad2007.getDM_Pro().getNO_B()));
        map.put("\\$_logiciel", dm_tradSIA.getCodeLan("$_logiciel"));
        map.put("\\%_logiciel", this.prtSIA.ECAD_ID);
        map.put("\\$_printDate", dm_tradSIA.getCodeLan("$_printDate"));
        map.put("\\%_printDate", this.prtSIA.now);
        if (Ecad2007.getCalcmod() < 7) {
            map.put("\\%_QH_B", String.format(Locale.ENGLISH, "%.0f", Ecad2007.getDM_Zone(0).getQh()));
        } else {
            map.put("\\%_QH_B", Globals.format("%,.1f", Ecad2007.getDM_Zone(0).getQh()));
        }
        map.put("\\$_page", dm_tradSIA.getCodeLan("$_page"));
        foString = foString + this.prtSIA.loadFo(foSection, map);
        foSection = FoFlux.fo(1);
        map = new HashMap();
        map.put("\\%_userID", this.prtSIA.USER_ID);
        map.put("\\%_ecadURL", "www.enercad.ch");
        map.put("\\%_fileNAME", this.prtSIA.getProjectFileName());
        foString = foString + this.prtSIA.loadFo(foSection, map);
        double Qtr = Ecad2007.getDM_Zone(0).getQtr();
        double Qt = Ecad2007.getDM_Zone(0).getQt();
        double Qtw = Ecad2007.getDM_Zone(0).getQtw();
        double Qtf = Ecad2007.getDM_Zone(0).getQtf();
        double Qv = Ecad2007.getDM_Zone(0).getQv();
        double Qe = Ecad2007.getDM_Zone(0).getQe();
        double Qp = Ecad2007.getDM_Zone(0).getQp();
        double Qs = Ecad2007.getDM_Zone(0).getQs();
        double Fap = Ecad2007.getDM_Zone(0).getFap();
        double out1 = Qtr;
        double out2 = Qt - Qtr - Qtw - Qtf;
        double out3 = Qtw;
        double out4 = Qv;
        double out5 = Qtf;
        double in1 = (Qe + Qp) * Fap;
        double in2 = Qs * Fap;
        double in3 = out1 + out2 + out3 + out4 + out5 - in1 - in2;
        double in = in1 + in2 + in3;
        double out = out1 + out2 + out3 + out4 + out5;
        DecimalFormat df1 = Ecad2007.getDecimalFormat("0.0");
        map = new HashMap();
        map.put("\\$_le_flux_Qi", dm_tradSIA.getCodeLan("$_le_flux_Qi"));
        map.put("\\%_flux_Qia", this.prtSIA.cleanS(Globals.format("%.1f", in1)));
        map.put("\\%_flux_Qir", this.prtSIA.cleanS(Globals.format("%.0f", in1 / in * 100.0)));
        map.put("\\$_le_flux_Qsun", dm_tradSIA.getCodeLan("$_le_flux_Qs"));
        map.put("\\%_flux_Qsuna", this.prtSIA.cleanS(Globals.format("%.1f", in2)));
        map.put("\\%_flux_Qsunr", this.prtSIA.cleanS(Globals.format("%.0f", in2 / in * 100.0)));
        map.put("\\$_le_flux_Qh", dm_tradSIA.getCodeLan("$_le_flux_Qh"));
        map.put("\\%_flux_Qha", this.prtSIA.cleanS(Globals.format("%.1f", in3)));
        map.put("\\%_flux_Qhr", this.prtSIA.cleanS(Globals.format("%.0f", in3 / in * 100.0)));
        map.put("\\$_le_flux_Qtoit", dm_tradSIA.getCodeLan("$_le_flux_Qtoit"));
        map.put("\\%_flux_Qtoitr", this.prtSIA.cleanS(Globals.format("%.0f", out1 / out * 100.0)));
        map.put("\\%_flux_Qtoita", this.prtSIA.cleanS(Globals.format("%.1f", out1)));
        map.put("\\$_le_flux_Qmurs", dm_tradSIA.getCodeLan("$_le_flux_Qmurs"));
        map.put("\\%_flux_Qmursr", this.prtSIA.cleanS(Globals.format("%.0f", out2 / out * 100.0)));
        map.put("\\%_flux_Qmursa", this.prtSIA.cleanS(Globals.format("%.1f", out2)));
        map.put("\\$_le_flux_Qfen", dm_tradSIA.getCodeLan("$_le_flux_Qfen"));
        map.put("\\%_flux_Qfenr", this.prtSIA.cleanS(Globals.format("%.0f", out3 / out * 100.0)));
        map.put("\\%_flux_Qfena", this.prtSIA.cleanS(Globals.format("%.1f", out3)));
        map.put("\\$_le_flux_Qv", dm_tradSIA.getCodeLan("$_le_flux_Qv"));
        map.put("\\%_flux_Qvr", this.prtSIA.cleanS(Globals.format("%.0f", out4 / out * 100.0)));
        map.put("\\%_flux_Qva", this.prtSIA.cleanS(Globals.format("%.1f", out4)));
        map.put("\\$_le_flux_Qsol", dm_tradSIA.getCodeLan("$_le_flux_Qsol"));
        map.put("\\%_flux_Qsolr", this.prtSIA.cleanS(Globals.format("%.0f", out5 / out * 100.0)));
        map.put("\\%_flux_Qsola", this.prtSIA.cleanS(Globals.format("%.1f", out5)));
        foString = foString + "    <fo:flow flow-name=\"xsl-region-body\">\n";
        foString = foString + "        <fo:block role=\"body\" font-family=\"Arial, Helvetica, sans-serif\" font-size=\"8pt\">\n";
        foString = foString + "        <fo:block role=\"div\"  start-indent=\"0cm\" end-indent=\"0cm\" space-before.conditionality=\"retain\"  keep-together.within-page=\"always\">\n";
        foString = foString + this.prtSIA.loadFo(FoFlux.fo(2), map);
        Ecad2007.getDM_Zone(0).getCalcZone(1);
        foString = foString + Ecad2007.getDM_Zone(0).setFop(10, -1) + "\n";
        foString = foString + "        </fo:block>\n";
        foString = foString + "      </fo:block>\n";
        foString = foString + "   <fo:block id=\"last-page\"/>\n";
        foString = foString + "    </fo:flow>\n";
        foString = foString + FoFlux.fo(3);
        Globals.println(10000, "Printing FoFlux");
        Globals.println(10000, foString);
        Globals.println(10000, "--------------------------------------------------------------------------------------------------------------");
        Globals.println(10000, foString);
        Globals.println(10000, "--------------------------------------------------------------------------------------------------------------");
        return foString;
    }

    public static String fo(int section) {
        String[] fo = new String[30];
        fo[0] = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n<fo:root \n    xmlns:fo=\"http://www.w3.org/1999/XSL/Format\" \n    xmlns:html=\"http://www.w3.org/1999/xhtml\" writing-mode=\"lr-tb\" hyphenate=\"false\" text-align=\"start\" role=\"doc\">\n    <fo:layout-master-set>\n        <fo:simple-page-master page-width=\"210mm\" page-height=\"297mm\" master-name=\"first-page\">\n            <fo:region-body column-gap=\"12pt\" column-count=\"1\" margin-left=\"1.8cm\" margin-bottom=\"1.5cm\" margin-right=\"1.0cm\" margin-top=\"4.0cm\"/>\n            <fo:region-before display-align=\"before\" extent=\"1.8cm\" region-name=\"page-header\"/>\n            <fo:region-after display-align=\"after\" extent=\"1.5cm\" region-name=\"page-footer\"/>\n            <fo:region-start extent=\"1.8cm\"/>\n            <fo:region-end extent=\"1.0cm\"/>\n        </fo:simple-page-master>\n        <fo:simple-page-master page-width=\"210mm\" page-height=\"297mm\" master-name=\"all-pages\">\n            <fo:region-body column-gap=\"12pt\" column-count=\"1\" margin-left=\"1.8cm\" margin-bottom=\"1.5cm\" margin-right=\"1.0cm\" margin-top=\"4.0cm\"/>\n            <fo:region-before display-align=\"before\" extent=\"1.8cm\" region-name=\"page-header\"/>\n            <fo:region-after display-align=\"after\" extent=\"1.5cm\" region-name=\"page-footer\"/>\n            <fo:region-start extent=\"1.8cm\"/>\n            <fo:region-end extent=\"1.0cm\"/>\n        </fo:simple-page-master>\n     </fo:layout-master-set>\n \n    <fo:page-sequence master-reference=\"first-page\">\n<!-- header 1\u00e8re page-->\n        <fo:static-content flow-name=\"page-header\">\n                <fo:block start-indent=\"0cm\" end-indent=\"0cm\" space-before=\"0.25cm\" space-before.conditionality=\"retain\">    \n                    <fo:wrapper>\n                        <fo:table border-collapse=\"separate\" border-spacing=\"0px\" table-layout=\"fixed\" width=\"17cm\" border-style=\"hidden\" role=\"table\" font-size=\"14pt\" font-weight=\"bold\">\n                            <fo:table-body start-indent=\"0pt\" end-indent=\"0pt\" text-indent=\"0pt\" last-line-end-indent=\"0pt\" text-align=\"start\" text-align-last=\"relative\">\n                                <fo:table-row role=\"tr\" display-align=\"before\">\n                                    <fo:table-cell padding=\"2px\" role=\"td\"><fo:block>$_titleF1</fo:block></fo:table-cell>\n                                </fo:table-row>\n                            </fo:table-body>\n                        </fo:table> \n                        <fo:table border-collapse=\"separate\" border-spacing=\"0px\" table-layout=\"fixed\" width=\"17cm\" role=\"table\" border=\"0.1mm solid black\" margin=\"2px\" font-size=\"8pt\">\n                            <fo:table-column role=\"col\" column-width=\"2.2cm\"/>\n                            <fo:table-column role=\"col\" column-width=\"11cm\"/>\n                            <fo:table-column role=\"col\" column-width=\"2.2cm\"/>\n                            <fo:table-column role=\"col\" column-width=\"1.6cm\"/>\n                            <fo:table-body start-indent=\"0pt\" end-indent=\"0pt\" text-indent=\"0pt\" last-line-end-indent=\"0pt\" text-align=\"start\" text-align-last=\"relative\">\n                                <fo:table-row role=\"tr\" text-align=\"left\">\n                                    <fo:table-cell padding=\"4px\" role=\"td\" background-color=\"#cccccc\"><fo:block>$_nom</fo:block></fo:table-cell>\n                                    <fo:table-cell padding=\"4px\" role=\"td\" background-color=\"#eeeeee\"><fo:block>%_nom</fo:block></fo:table-cell>\n                                    <fo:table-cell padding=\"4px\" role=\"td\" background-color=\"#cccccc\"><fo:block>$_dossier</fo:block></fo:table-cell>\n                                    <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" background-color=\"#eeeeee\"><fo:block>%_dossier</fo:block></fo:table-cell>\n                                </fo:table-row>\n                                <fo:table-row role=\"tr\" text-align=\"left\">\n                                    <fo:table-cell padding=\"4px\" role=\"td\" background-color=\"#cccccc\"><fo:block>$_logiciel</fo:block></fo:table-cell>\n                                    <fo:table-cell padding=\"4px\" role=\"td\" background-color=\"#eeeeee\"><fo:block>%_logiciel</fo:block></fo:table-cell>\n                                    <fo:table-cell padding=\"4px\" role=\"td\" background-color=\"#cccccc\"><fo:block>Q<fo:inline baseline-shift=\"sub\" font-size=\"6pt\">h</fo:inline> [" + unit + "/m" + "<fo:inline baseline-shift=\"super\" font-size=\"6pt\">2</fo:inline>" + "]:</fo:block></fo:table-cell>\n                                    <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" background-color=\"#eeeeee\" font-weight=\"bold\"><fo:block>%_QH_B</fo:block></fo:table-cell>\n                                </fo:table-row>\n                                <fo:table-row role=\"tr\" text-align=\"left\">\n                                    <fo:table-cell padding=\"4px\" role=\"td\" background-color=\"#cccccc\"><fo:block>$_printDate</fo:block></fo:table-cell>\n                                    <fo:table-cell padding=\"4px\" role=\"td\" background-color=\"#eeeeee\"><fo:block>%_printDate</fo:block></fo:table-cell>\n                                    <fo:table-cell padding=\"4px\" role=\"td\" background-color=\"#cccccc\"><fo:block>$_page</fo:block></fo:table-cell>\n                                    <fo:table-cell padding=\"4px\" role=\"td\" text-align=\"center\" background-color=\"#eeeeee\"><fo:block>1/<fo:page-number-citation ref-id=\"last-page\"/></fo:block></fo:table-cell>\n                                </fo:table-row>\n                            </fo:table-body>\n                        </fo:table>\n                    </fo:wrapper>\n                </fo:block>\n                <fo:block space-before=\"1em\" space-after=\"1em\" role=\"p\"/>\n                <fo:block space-before=\"1em\" space-after=\"1em\" role=\"p\"/>      \n        </fo:static-content>\n";
        fo[1] = "<!-- footer 1\u00e8re page-->\n        <fo:static-content flow-name=\"page-footer\">\n            <fo:block start-indent=\"0cm\" end-indent=\"0cm\" space-after=\"1cm\" space-after.conditionality=\"retain\">    \n                <fo:table border-collapse=\"separate\" border-spacing=\"0px\" table-layout=\"fixed\" width=\"17cm\" border-style=\"hidden\" role=\"table\" font-size=\"8pt\" font-style=\"italic\">\n                    <fo:table-column role=\"col\" column-width=\"6.0cm\"/>\n                    <fo:table-column role=\"col\" column-width=\"11.0cm\"/>\n                    <fo:table-body start-indent=\"0pt\" end-indent=\"0pt\" text-indent=\"0pt\" last-line-end-indent=\"0pt\" text-align=\"start\" text-align-last=\"relative\">\n                        <fo:table-row role=\"tr\">\n                            <fo:table-cell padding=\"2px\" role=\"td\">\n                                <fo:block>\n                                    <fo:basic-link text-decoration=\"underline\" color=\"blue\" role=\"a\" external-destination=\"url('http://%_ecadURL')\">\n                                        %_ecadURL\n                                    </fo:basic-link>\n                                    %_userID\n                                </fo:block>\n                            </fo:table-cell>\n                            <fo:table-cell padding=\"2px\" role=\"td\" text-align=\"right\">\n                                <fo:block>%_fileNAME</fo:block>\n                            </fo:table-cell>\n                        </fo:table-row>\n                    </fo:table-body>\n                </fo:table>\n            </fo:block>\n         </fo:static-content>\n        \n";
        fo[2] = "        <!-- titre l\u00e9gendes du dessin outFlux -->\n                <fo:block role=\"div\">\n                    <fo:table border-collapse=\"separate\" border-spacing=\"0px\" table-layout=\"fixed\" width=\"17cm\" role=\"table\" border-style=\"hidden\"  margin=\"2px\" font-size=\"8pt\">\n                        <fo:table-column role=\"col\" column-width=\"4.0cm\"/>\n                        <fo:table-column role=\"col\" column-width=\"9.0cm\"/>\n                        <fo:table-column role=\"col\" column-width=\"4.0cm\"/>\n                        <fo:table-body start-indent=\"0pt\" end-indent=\"0pt\" text-indent=\"0pt\" last-line-end-indent=\"0pt\" text-align=\"start\" text-align-last=\"relative\">\n                            <fo:table-row role=\"tr\" height=\"0.5cm\">\n                                <fo:table-cell padding=\"2px\" role=\"td\" background-color=\"#ffffff\" text-align=\"left\"><fo:block font-size=\"9pt\" font-weight=\"bold\"></fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"2px\" role=\"td\" background-color=\"#ffffff\"><fo:block></fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"2px\" role=\"td\" background-color=\"#ffffff\" text-align=\"left\"><fo:block font-size=\"9pt\" font-weight=\"bold\"></fo:block></fo:table-cell>\n                            </fo:table-row>\n                            <fo:table-row height=\"1.5cm\">\n                                 <fo:table-cell span=\"all\">\n                                     <fo:block/>\n                                 </fo:table-cell>\n                             </fo:table-row>\n                            <!-- l\u00e9gendes du dessin outFlux -->\n                            <fo:table-row role=\"tr\" height=\"1.68cm\">\n                                <fo:table-cell padding=\"2px\" role=\"td\" background-color=\"#ffffff\"><fo:block font-size=\"9pt\">$_le_flux_Qi</fo:block><fo:block font-size=\"9pt\">%_flux_Qia " + unit + " (%_flux_Qir %)</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"2px\" role=\"td\" background-color=\"#ffffff\"><fo:block></fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"2px\" role=\"td\" background-color=\"#ffffff\"><fo:block font-size=\"9pt\">$_le_flux_Qtoit</fo:block><fo:block font-size=\"9pt\">%_flux_Qtoita " + unit + " (%_flux_Qtoitr %)</fo:block></fo:table-cell>\n                            </fo:table-row>\n                            <fo:table-row role=\"tr\" height=\"1.68cm\">\n                                <fo:table-cell padding=\"2px\" role=\"td\" background-color=\"#ffffff\"><fo:block font-size=\"9pt\"></fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"2px\" role=\"td\" background-color=\"#ffffff\"><fo:block></fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"2px\" role=\"td\" background-color=\"#ffffff\"><fo:block font-size=\"9pt\">$_le_flux_Qmurs</fo:block><fo:block font-size=\"9pt\">%_flux_Qmursa " + unit + " (%_flux_Qmursr %)</fo:block></fo:table-cell>\n                            </fo:table-row>\n                            <fo:table-row role=\"tr\" height=\"1.68cm\">\n                                <fo:table-cell padding=\"2px\" role=\"td\" background-color=\"#ffffff\"><fo:block font-size=\"9pt\">$_le_flux_Qsun</fo:block><fo:block font-size=\"9pt\">%_flux_Qsuna " + unit + " (%_flux_Qsunr %)</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"2px\" role=\"td\" background-color=\"#ffffff\"><fo:block></fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"2px\" role=\"td\" background-color=\"#ffffff\"><fo:block font-size=\"9pt\">$_le_flux_Qfen</fo:block><fo:block font-size=\"9pt\">%_flux_Qfena  " + unit + " (%_flux_Qfenr %)</fo:block></fo:table-cell>\n                            </fo:table-row>\n                            <fo:table-row role=\"tr\" height=\"1.68cm\">\n                                <fo:table-cell padding=\"2px\" role=\"td\" background-color=\"#ffffff\"><fo:block font-size=\"9pt\"></fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"2px\" role=\"td\" background-color=\"#ffffff\"><fo:block></fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"2px\" role=\"td\" background-color=\"#ffffff\"><fo:block font-size=\"9pt\">$_le_flux_Qv</fo:block><fo:block font-size=\"9pt\">%_flux_Qva " + unit + " (%_flux_Qvr %)</fo:block></fo:table-cell>\n                            </fo:table-row>\n                            <fo:table-row role=\"tr\" height=\"1.68cm\">\n                                <fo:table-cell padding=\"2px\" role=\"td\" background-color=\"#ffffff\"><fo:block font-size=\"9pt\">$_le_flux_Qh</fo:block><fo:block font-size=\"9pt\">%_flux_Qha " + unit + " (%_flux_Qhr %)</fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"2px\" role=\"td\" background-color=\"#ffffff\"><fo:block></fo:block></fo:table-cell>\n                                <fo:table-cell padding=\"2px\" role=\"td\" background-color=\"#ffffff\"><fo:block font-size=\"9pt\">$_le_flux_Qsol</fo:block><fo:block font-size=\"9pt\">%_flux_Qsola " + unit + " (%_flux_Qsolr %)</fo:block></fo:table-cell>\n                            </fo:table-row>\n                        </fo:table-body>\n                    </fo:table>\n                </fo:block>\n                <fo:block space-after=\"2cm\"/>\n";
        fo[3] = "    <!-- end of document -->\n     </fo:page-sequence>\n    </fo:root>";
        return fo[section];
    }

    private Image getFluxDiagramm() {
        this.out_flux.setFont(this.FT_P11);
        this.out_flux.setBounds(this.rec_img);
        this.out_flux.setVal(Ecad2007.getDM_Zone(0));
        BufferedImage buffImg = new BufferedImage(this.rec_img.width, this.rec_img.height, 2);
        Graphics2D g2d = buffImg.createGraphics();
        this.out_flux.paint(g2d);
        return buffImg;
    }

    public ImageFop[] getImageFop() {
        ImageFop[] imageFop = new ImageFop[]{new ImageFop(this.getFluxDiagramm(), this.rec_img.x, this.rec_img.y)};
        return imageFop;
    }
}

