/*
 * Decompiled with CFR 0.152.
 */
package enercad2007.printdlg;

import core.Calculation;
import core.Config;
import enercad2007.DM_Trad;
import enercad2007.Ecad2007;
import enercad2007.Globals;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComponent;
import jecadcomp.GraphElements;

public class PrtFenetreU
extends JComponent
implements Printable {
    private int zf = 10;
    private int ff = 4;
    private String componentCode;
    private Vector[] vectorDataM16;
    private double[] wvalue;
    private transient Calculation calc;
    private int[] page;
    int[] pa = new int[]{0, 0, 181, 280};
    private String[] dataC1 = new String[8];
    transient Config config;
    DM_Trad c1_trad;
    DM_Trad c2_trad;
    DM_Trad gen_trad;
    DM_Trad mf_trad;
    Font FT_P6 = new Font("Dialog", 0, 6 * this.ff);
    Font FT_P7 = new Font("Dialog", 0, 7 * this.ff);
    Font FT_P8 = new Font("Dialog", 0, 8 * this.ff);
    Font FT_P9 = new Font("Dialog", 0, 9 * this.ff);
    Font FT_P10 = new Font("Dialog", 0, 10 * this.ff);
    Font FT_B6 = new Font("Dialog", 1, 6 * this.ff);
    Font FT_B7 = new Font("Dialog", 1, 7 * this.ff);
    Font FT_B8 = new Font("Dialog", 1, 8 * this.ff);
    Font FT_B9 = new Font("Dialog", 1, 9 * this.ff);
    Font FT_B10 = new Font("Dialog", 1, 10 * this.ff);
    static final float[] dash1 = new float[]{10.0f};
    static final BasicStroke dashed = new BasicStroke(0.1f, 0, 0, 10.0f, dash1, 0.0f);
    static final BasicStroke line0f1 = new BasicStroke(0.01f);
    static final BasicStroke line1f0 = new BasicStroke();
    String txt_titre = "Calcul valeur U";
    String txt_comp = "Nom du composant";
    String txt_calc_justif = "Calcul de justification - Page coefficient-U";
    String txt_mat = "Mat\u00e9riaux";
    String txt_num_val = "Valeurs num\u00e9riques";
    String txt_inter_res = "R\u00e9sultats interm\u00e9diaires";
    String txt_ver = "Verre";
    String txt_icl = "Intercalaires";
    String txt_cad = "Cadres ou portes";
    String txt_voil = "Voilages";
    String txt_ver_therm = "Verre: transmission thermique";
    String txt_ver_sol = "Verre: transmission de rayonnement solaire";
    String txt_icl_therm = "Intercalaire: transmission thermique";
    String txt_lr = "Intercalaire: longueur relative (ml par m\u00b2 de fen\u00eatre) *";
    String txt_cad_therm = "Cadre: transmission thermique y compris intercalaire";
    String txt_ff = "Fraction de cadre";
    String txt_fv = "Facteur de voilage (rideaux, stores, salissures ...)";
    String txt_reploss = "R\u00e9partition des pertes";
    String txt_c1_u = "Valeur U";
    String txt_m_leg1 = "* La longueur relative de l'intercalaire d\u00e9finit la longueur \u00e0 prendre en compte par m\u00b2 de fen\u00eatre (vide ma\u00e7onnerie). Des ponts thermiques lin\u00e9aires \u00e9ventuels de l'embrasure sont d\u00e9finis s\u00e9par\u00e9ment.";

    public PrtFenetreU(String componentCode, Vector[] vectorDataM16, double[] wvalue, Calculation calc) {
        this.componentCode = componentCode.toString();
        this.vectorDataM16 = (Vector[])vectorDataM16.clone();
        this.wvalue = (double[])wvalue.clone();
        this.calc = calc;
        this.jbInit();
    }

    public PrtFenetreU(String componentCode, Vector[] vectorDataM16, double[] wvalue, Calculation calc, int[] page) {
        this.componentCode = componentCode.toString();
        this.vectorDataM16 = (Vector[])vectorDataM16.clone();
        this.wvalue = (double[])wvalue.clone();
        this.calc = calc;
        this.page = (int[])page.clone();
        this.jbInit();
    }

    private void jbInit() {
        this.config = new Config(System.getProperty("conf.file.name"));
        this.c1_trad = new DM_Trad("c1");
        this.c2_trad = new DM_Trad("c2");
        this.gen_trad = Ecad2007.getTraduction("gen");
        this.mf_trad = Ecad2007.getTraduction("mf");
        String cname = this.getClass().getName();
        this.initLang();
        int index = cname.indexOf(".");
        if (index > 0) {
            cname = cname.substring(index + 4);
        }
        this.setSize(this.pa[2] * this.zf, this.pa[3] * this.zf);
    }

    private String[] getArrayFromRef(int dim, String ref) {
        String[] res = null;
        String[] tmp = null;
        ListIterator lit = this.vectorDataM16[dim].listIterator();
        while (lit.hasNext()) {
            tmp = (String[])lit.next();
            if (!tmp[tmp.length - 1].equals(ref)) continue;
            res = tmp;
            break;
        }
        return res;
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(this.pa[0] * this.zf, this.pa[1] * this.zf, this.pa[2] * this.zf, this.pa[3] * this.zf);
    }

    private void initLang() {
        if (this.c1_trad != null) {
            this.txt_titre = this.c2_trad.getCodeLan("titre");
            this.txt_calc_justif = this.c2_trad.getCodeLan("calc_justif", this.txt_calc_justif);
            this.txt_comp = this.gen_trad.getCodeLan("comp");
            this.txt_mat = this.gen_trad.getCodeLan("mat");
            this.txt_num_val = this.c1_trad.getCodeLan("ti_num");
            this.txt_inter_res = this.gen_trad.getCodeLan("inter_res");
            this.txt_ver = this.c1_trad.getCodeLan("ver");
            this.txt_icl = this.c1_trad.getCodeLan("m_ti_icl");
            this.txt_cad = this.c1_trad.getCodeLan("cad");
            this.txt_voil = this.c1_trad.getCodeLan("voil");
            this.txt_ver_therm = this.txt_ver + ": " + this.c1_trad.getCodeLan("trtherm");
            this.txt_ver_sol = this.txt_ver + ": " + this.c1_trad.getCodeLan("trraysol");
            this.txt_icl_therm = this.txt_icl + ": " + this.c1_trad.getCodeLan("trtherm");
            this.txt_lr = this.txt_icl + ": " + this.c1_trad.getCodeLan("lr") + " *";
            this.txt_cad_therm = this.txt_cad.substring(0, this.txt_cad.indexOf(" ")) + ": " + this.c1_trad.getCodeLan("trtherm") + " " + this.c1_trad.getCodeLan("icl_incl");
            this.txt_ff = this.c1_trad.getCodeLan("ff");
            this.txt_fv = this.c1_trad.getCodeLan("fv");
            this.txt_reploss = this.c1_trad.getCodeLan("reploss");
            this.txt_c1_u = this.c1_trad.getCodeLan("c1_u");
            this.txt_m_leg1 = "* " + this.c1_trad.getCodeLan("m_leg1");
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        FontMetrics fm = null;
        DecimalFormat df = Ecad2007.getDecimalFormat("0");
        DecimalFormat df1 = Ecad2007.getDecimalFormat("0.0");
        DecimalFormat df2 = Ecad2007.getDecimalFormat("0.00");
        DecimalFormat df3 = Ecad2007.getDecimalFormat("0.000");
        DecimalFormat df00 = Ecad2007.getDecimalFormat("00");
        Object[] object = Ecad2007.getDMpr_Comp().getComponentByBitWiseCheck(this.componentCode, 4);
        String[] refs = (String[])object[10];
        this.dataC1[0] = (String)object[0];
        for (int ii = 0; ii < 4; ++ii) {
            this.dataC1[3 + ii] = refs[ii];
        }
        int dim = 0;
        String tmp = "";
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.black);
        g2.setFont(this.FT_B10);
        g2.drawString(this.txt_titre, 0, 0 * this.zf);
        g2.setColor(new Color(228, 228, 228));
        g2.fillRect(0, 4 * this.zf, 40 * this.zf, 10 * this.zf);
        g2.setColor(Color.black);
        g2.setStroke(line0f1);
        g2.drawRect(0, 4 * this.zf, 181 * this.zf, 10 * this.zf);
        g2.drawLine(40 * this.zf, 4 * this.zf, 40 * this.zf, 14 * this.zf);
        g2.setStroke(line1f0);
        g2.setFont(this.FT_P8);
        g2.drawString(this.mf_trad.getCodeLan("projet") + ":", this.zf, 8 * this.zf);
        g2.drawString(this.txt_comp + ":", this.zf, (int)(12.5 * (double)this.zf));
        g2.drawString(Ecad2007.getDM_Pro().getNOM_B(), 41 * this.zf, 8 * this.zf);
        if (this.componentCode.startsWith("1") || this.componentCode.startsWith("2")) {
            g2.drawString(this.gen_trad.getCodeLan("toit") + ": " + this.dataC1[0], 41 * this.zf, (int)(12.5 * (double)this.zf));
        } else if (this.componentCode.startsWith("4")) {
            g2.drawString(this.gen_trad.getCodeLan("mur") + ": " + this.dataC1[0], 41 * this.zf, (int)(12.5 * (double)this.zf));
        }
        g2.setFont(this.FT_B8);
        tmp = this.txt_mat;
        g2.drawString(tmp, this.zf, 27 * this.zf);
        tmp = this.txt_num_val;
        g2.drawString(tmp, this.zf, 70 * this.zf);
        tmp = this.txt_inter_res;
        g2.drawString(tmp, this.zf, 130 * this.zf);
        g2.setFont(this.FT_P8);
        tmp = this.txt_ver;
        g2.drawString(tmp, 5 * this.zf, 33 * this.zf);
        tmp = this.txt_icl;
        g2.drawString(tmp, 5 * this.zf, 39 * this.zf);
        tmp = this.txt_cad;
        g2.drawString(tmp, 5 * this.zf, 45 * this.zf);
        tmp = this.txt_voil;
        g2.drawString(tmp, 5 * this.zf, 51 * this.zf);
        g2.setFont(this.FT_B8);
        tmp = this.txt_num_val;
        g2.setFont(this.FT_P7);
        String[] str = this.getArrayFromRef(0, this.dataC1[3]);
        g2.drawRect(50 * this.zf, 30 * this.zf, 105 * this.zf, 5 * this.zf);
        tmp = str[0];
        g2.drawString(tmp, 51 * this.zf, 33 * this.zf);
        tmp = "Ug = " + str[1];
        g2.drawString(tmp, 110 * this.zf, 33 * this.zf);
        tmp = "g = " + str[2];
        g2.drawString(tmp, 127 * this.zf, 33 * this.zf);
        str = this.getArrayFromRef(3, this.dataC1[6]);
        g2.drawRect(50 * this.zf, 36 * this.zf, 105 * this.zf, 5 * this.zf);
        tmp = str[0];
        g2.drawString(tmp, 51 * this.zf, 39 * this.zf);
        tmp = "Ui = " + str[1];
        g2.drawString(tmp, 127 * this.zf, 39 * this.zf);
        str = this.getArrayFromRef(1, this.dataC1[4]);
        g2.drawRect(50 * this.zf, 42 * this.zf, 105 * this.zf, 5 * this.zf);
        tmp = str[0];
        g2.drawString(tmp, 51 * this.zf, 45 * this.zf);
        tmp = "Uf = " + str[1];
        g2.drawString(tmp, 110 * this.zf, 45 * this.zf);
        tmp = "Ff = " + str[2];
        g2.drawString(tmp, 127 * this.zf, 45 * this.zf);
        str = this.getArrayFromRef(2, this.dataC1[5]);
        g2.drawRect(50 * this.zf, 48 * this.zf, 105 * this.zf, 5 * this.zf);
        tmp = str[0];
        g2.drawString(tmp, 51 * this.zf, 51 * this.zf);
        tmp = "Fv = " + str[1];
        g2.drawString(tmp, 127 * this.zf, 51 * this.zf);
        int dx = 86;
        g2.setColor(new Color(128, 128, 255));
        g2.fillRect(50 * this.zf, 75 * this.zf, dx * this.zf, 4 * this.zf);
        g2.fillRect(50 * this.zf, 81 * this.zf, dx * this.zf, 4 * this.zf);
        g2.setColor(new Color(224, 224, 224, 224));
        g2.fillRect(50 * this.zf, 87 * this.zf, dx * this.zf, 4 * this.zf);
        g2.fillRect(50 * this.zf, 93 * this.zf, dx * this.zf, 4 * this.zf);
        g2.setColor(new Color(160, 160, 160));
        g2.fillRect(50 * this.zf, 99 * this.zf, dx * this.zf, 4 * this.zf);
        g2.fillRect(50 * this.zf, 105 * this.zf, dx * this.zf, 4 * this.zf);
        g2.setColor(new Color(240, 240, 240));
        g2.fillRect(50 * this.zf, 111 * this.zf, dx * this.zf, 4 * this.zf);
        g2.setColor(Color.black);
        g2.setFont(this.FT_P7);
        tmp = this.txt_ver_therm;
        g2.drawString(tmp, (dx - 35) * this.zf, 78 * this.zf);
        tmp = "Ug";
        g2.drawString(tmp, (51 + dx) * this.zf, 78 * this.zf);
        tmp = "[W/m\u00b2K]";
        g2.drawString(tmp, (70 + dx) * this.zf, 78 * this.zf);
        tmp = this.txt_ver_sol;
        g2.drawString(tmp, 51 * this.zf, 84 * this.zf);
        tmp = "g";
        g2.drawString(tmp, 137 * this.zf, 84 * this.zf);
        tmp = "[0...1]";
        g2.drawString(tmp, 156 * this.zf, 84 * this.zf);
        tmp = this.txt_icl_therm;
        g2.drawString(tmp, 51 * this.zf, 90 * this.zf);
        tmp = "Ui";
        g2.drawString(tmp, 137 * this.zf, 90 * this.zf);
        tmp = "[W/mK]";
        g2.drawString(tmp, 156 * this.zf, 90 * this.zf);
        tmp = this.txt_lr;
        g2.drawString(tmp, 51 * this.zf, 96 * this.zf);
        tmp = "Lr";
        g2.drawString(tmp, 137 * this.zf, 96 * this.zf);
        tmp = "[m/m\u00b2]";
        g2.drawString(tmp, 156 * this.zf, 96 * this.zf);
        tmp = this.txt_cad_therm;
        g2.drawString(tmp, 51 * this.zf, 102 * this.zf);
        tmp = "Uf";
        g2.drawString(tmp, 137 * this.zf, 102 * this.zf);
        tmp = "[W/m\u00b2K]";
        g2.drawString(tmp, 156 * this.zf, 102 * this.zf);
        tmp = this.txt_ff;
        g2.drawString(tmp, 51 * this.zf, 108 * this.zf);
        tmp = "Ff";
        g2.drawString(tmp, 137 * this.zf, 108 * this.zf);
        tmp = "[0...1]";
        g2.drawString(tmp, 156 * this.zf, 108 * this.zf);
        tmp = this.txt_fv;
        g2.drawString(tmp, 51 * this.zf, 114 * this.zf);
        tmp = "Fv";
        g2.drawString(tmp, 137 * this.zf, 114 * this.zf);
        tmp = "[0...1]";
        g2.drawString(tmp, 156 * this.zf, 114 * this.zf);
        g2.setFont(this.FT_P7);
        g2.drawRect((58 + dx) * this.zf, (int)(74.5 * (double)this.zf), 10 * this.zf, (int)(4.5 * (double)this.zf));
        tmp = df2.format(this.wvalue[0]);
        g2.drawString(tmp, (59 + dx) * this.zf, 78 * this.zf);
        g2.drawRect((58 + dx) * this.zf, (int)(80.5 * (double)this.zf), 10 * this.zf, (int)(4.5 * (double)this.zf));
        tmp = df2.format(this.wvalue[1]);
        g2.drawString(tmp, (59 + dx) * this.zf, 84 * this.zf);
        g2.drawRect((58 + dx) * this.zf, (int)(86.5 * (double)this.zf), 10 * this.zf, (int)(4.5 * (double)this.zf));
        tmp = df2.format(this.wvalue[2]);
        g2.drawString(tmp, (59 + dx) * this.zf, 90 * this.zf);
        g2.drawRect((58 + dx) * this.zf, (int)(92.5 * (double)this.zf), 10 * this.zf, (int)(4.5 * (double)this.zf));
        tmp = df2.format(this.wvalue[3]);
        g2.drawString(tmp, (59 + dx) * this.zf, 96 * this.zf);
        g2.drawRect((58 + dx) * this.zf, (int)(98.5 * (double)this.zf), 10 * this.zf, (int)(4.5 * (double)this.zf));
        tmp = df2.format(this.wvalue[4]);
        g2.drawString(tmp, (59 + dx) * this.zf, 102 * this.zf);
        g2.drawRect((58 + dx) * this.zf, (int)(104.5 * (double)this.zf), 10 * this.zf, (int)(4.5 * (double)this.zf));
        tmp = df2.format(this.wvalue[5]);
        g2.drawString(tmp, (59 + dx) * this.zf, 108 * this.zf);
        g2.drawRect((58 + dx) * this.zf, (int)(110.5 * (double)this.zf), 10 * this.zf, (int)(4.5 * (double)this.zf));
        tmp = df2.format(this.wvalue[6]);
        g2.drawString(tmp, (59 + dx) * this.zf, 114 * this.zf);
        int eldx = 85;
        int eldy = 85;
        int elmx = 50;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        GraphElements gel = new GraphElements(Ecad2007.getMatLibrary(), false);
        gel.setBounds(new Rectangle(26, 20, 200, 200));
        gel.drawWindow(this.wvalue[5], this.wvalue[6]);
        Rectangle rec = new Rectangle(elmx * this.zf, 144 * this.zf, eldx * this.zf, eldy * this.zf);
        BufferedImage buffImg = new BufferedImage((int)((double)rec.width / 1.6), (int)((double)rec.height / 1.6), 2);
        Graphics2D g2d = buffImg.createGraphics();
        g2d.setColor(Color.white);
        g2d.fillRect(0, 0, rec.width, rec.height);
        int yz = 400;
        int xz = 400;
        gel.setOpaque(true);
        g2d.scale(rec.getWidth() / (double)xz, rec.getHeight() / (double)yz);
        gel.paint(g2d);
        g2d.dispose();
        g2.drawImage(buffImg, null, rec.x, rec.y);
        g2.setColor(new Color(160, 160, 160));
        g2.drawRect(rec.x + 3, rec.y + 2, (int)(rec.getWidth() / (double)xz * (double)gel.getWidth()) - 9, (int)(rec.getHeight() / (double)yz * (double)gel.getHeight()) - 8);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.black);
        g2.setFont(this.FT_P9);
        fm = g2.getFontMetrics();
        tmp = this.txt_reploss;
        dim = fm.stringWidth(tmp);
        g2.drawString(tmp, (45 + dx) * this.zf - dim / 2, 148 * this.zf);
        Map URes = this.calc.getCompFen(this.wvalue[4], this.wvalue[0], this.wvalue[5], this.wvalue[6], this.wvalue[1], this.wvalue[2], this.wvalue[3]);
        g2.setColor(new Color(128, 128, 255));
        g2.fillRect((40 + dx) * this.zf, 157 * this.zf, 10 * this.zf, (int)(4.5 * (double)this.zf));
        g2.fillRect((40 + dx) * this.zf, 163 * this.zf, 10 * this.zf, (int)(4.5 * (double)this.zf));
        g2.fillRect((40 + dx) * this.zf, 169 * this.zf, 10 * this.zf, (int)(4.5 * (double)this.zf));
        g2.setFont(this.FT_B7);
        fm = g2.getFontMetrics();
        g2.setColor(Color.black);
        g2.drawRect((40 + dx) * this.zf, 157 * this.zf, 10 * this.zf, (int)(4.5 * (double)this.zf));
        tmp = df.format(URes.get("PG"));
        dim = fm.stringWidth(tmp);
        g2.drawString(tmp, (45 + dx) * this.zf - dim / 2, (int)(160.5 * (double)this.zf));
        g2.setColor(Color.black);
        g2.drawRect((40 + dx) * this.zf, 163 * this.zf, 10 * this.zf, (int)(4.5 * (double)this.zf));
        tmp = df.format(URes.get("PI"));
        dim = fm.stringWidth(tmp);
        g2.drawString(tmp, (45 + dx) * this.zf - dim / 2, (int)(166.5 * (double)this.zf));
        g2.setColor(Color.black);
        g2.drawRect((40 + dx) * this.zf, 169 * this.zf, 10 * this.zf, (int)(4.5 * (double)this.zf));
        tmp = df.format(URes.get("PF"));
        dim = fm.stringWidth(tmp);
        g2.drawString(tmp, (45 + dx) * this.zf - dim / 2, (int)(172.5 * (double)this.zf));
        g2.setFont(this.FT_B9);
        fm = g2.getFontMetrics();
        tmp = this.txt_c1_u + " = " + df2.format(URes.get("U")) + " [W/m\u00b2K]";
        dim = fm.stringWidth(tmp);
        g2.drawString(tmp, (45 + dx) * this.zf - dim / 2, 185 * this.zf);
        g2.setFont(this.FT_P8);
        fm = g2.getFontMetrics();
        tmp = this.txt_ver;
        dim = fm.stringWidth(tmp);
        g2.drawString(tmp, (38 + dx) * this.zf - dim, (int)(160.5 * (double)this.zf));
        tmp = this.txt_icl;
        dim = fm.stringWidth(tmp);
        g2.drawString(tmp, (38 + dx) * this.zf - dim, (int)(166.5 * (double)this.zf));
        tmp = this.txt_cad.substring(0, this.txt_cad.indexOf(" "));
        dim = fm.stringWidth(tmp);
        g2.drawString(tmp, (38 + dx) * this.zf - dim, (int)(172.5 * (double)this.zf));
        tmp = "[%]";
        g2.drawString(tmp, (52 + dx) * this.zf, (int)(160.5 * (double)this.zf));
        g2.drawString(tmp, (52 + dx) * this.zf, (int)(166.5 * (double)this.zf));
        g2.drawString(tmp, (52 + dx) * this.zf, (int)(172.5 * (double)this.zf));
        String text = this.txt_m_leg1;
        rec = new Rectangle(this.zf, 212 * this.zf, 179 * this.zf, 20 * this.zf);
        AttributedString as = new AttributedString(text);
        AttributedCharacterIterator aci = as.getIterator();
        Font font = this.FT_P7;
        g2.setFont(font);
        as.addAttribute(TextAttribute.FONT, font);
        int fty = font.getSize();
        LineBreakMeasurer measurer = new LineBreakMeasurer(aci, g2d.getFontRenderContext());
        float wrappingWidth = rec.width;
        while (measurer.getPosition() < aci.getEndIndex()) {
            String line = text.substring(measurer.getPosition(), measurer.nextOffset(wrappingWidth));
            measurer.setPosition(measurer.nextOffset(wrappingWidth));
            g2.drawString(line, rec.x, fty + rec.y);
            fty += font.getSize();
        }
        g2.setFont(this.FT_P7);
        String now = "";
        Calendar calendar = Calendar.getInstance();
        if (Ecad2007.getLicenseLevel() > 2L) {
            tmp = Globals.getGenericName() + " " + Globals.getVersion() + " - " + "www.enercad.ch" + " - " + Ecad2007.getUserName();
            now = df00.format(calendar.get(5)) + "/" + df00.format(calendar.get(2) + 1) + "/" + String.valueOf(calendar.get(1)) + "   " + df00.format(calendar.get(11)) + ":" + df00.format(calendar.get(12)) + ":" + df00.format(calendar.get(13));
        } else {
            tmp = Globals.getGenericName() + " " + Globals.getVersion() + " - uncertified EDU licence";
            now = df00.format(calendar.get(5)) + "/" + df00.format(calendar.get(2) + 1) + "/" + String.valueOf(calendar.get(1));
        }
        g2.drawString(tmp, 0, 266 * this.zf);
        tmp = this.txt_calc_justif + " - " + now;
        g2.drawString(tmp, 0, 271 * this.zf);
        fm = g2.getFontMetrics();
        if (this.page != null) {
            if (this.page.length == 1) {
                tmp = String.valueOf(this.page[0]);
                dim = fm.stringWidth(tmp);
                g2.drawString(tmp, 181 * this.zf - dim, 271 * this.zf);
            } else if (this.page.length == 2) {
                tmp = String.valueOf(this.page[0]) + " / " + String.valueOf(this.page[1]);
                dim = fm.stringWidth(tmp);
                g2.drawString(tmp, 181 * this.zf - dim, 271 * this.zf);
            }
        }
        tmp = Globals.getProjectAbsolutePath();
        String pattern = System.getProperty("file.separator");
        pattern = pattern.replaceAll("\\\\", "\\\\\\\\");
        tmp = tmp.replaceAll("&", "+");
        tmp = tmp.replaceAll("\\\\", "\\\\\\\\");
        tmp = new Globals().getTruncatedString(tmp, pattern, 60);
        tmp = tmp.replaceAll("\\\\\\\\", "\\\\");
        dim = fm.stringWidth(tmp);
        g2.drawString(tmp, this.pa[2] * this.zf - dim, 266 * this.zf);
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) {
        if (pageIndex != 0) {
            return 1;
        }
        this.paintComponent(g);
        return 0;
    }
}

