/*
 * Decompiled with CFR 0.152.
 */
package enercad2007.printdlg;

import core.Config;
import core.ImageFop;
import enercad2007.DM_Trad_SIA;
import enercad2007.Ecad2007;
import enercad2007.Globals;
import enercad2007.printdlg.FoCeb;
import enercad2007.printdlg.FoFlux;
import enercad2007.printdlg.FoGlobal;
import enercad2007.printdlg.FoGlobal2016;
import enercad2007.printdlg.FoPonctuel;
import enercad2007.printdlg.FoPonctuel2016;
import enercad2007.printdlg.FoReport;
import enercad2007.printdlg.FoTable;
import enercad2007.printdlg.FoTable2016;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class PrtSIA {
    String groupe;
    int code;
    int lan = Ecad2007.getCodeLan();
    FoGlobal foGlobal;
    FoGlobal2016 foGlobal2016;
    FoPonctuel foPonctuel;
    FoPonctuel2016 foPonctuel2016;
    FoFlux foFlux;
    FoTable foTable;
    FoTable2016 foTable2016;
    FoReport foReport;
    FoCeb foCeb;
    String fopForm;
    ImageFop[] imageFop;
    DecimalFormat df00;
    static final String CHECK_0 = "&#927;";
    static final String CHECK_1 = "&#8855;";
    public static final String SUPER_2 = "<fo:inline baseline-shift=\"super\" font-size=\"6pt\">2</fo:inline>";
    public static final String SUPER_3 = "<fo:inline baseline-shift=\"super\" font-size=\"6pt\">3</fo:inline>";
    public static final String QTH = "q<fo:inline baseline-shift=\"sub\" font-size=\"6pt\">th</fo:inline>";
    Globals globals = new Globals();
    Calendar calendar = Calendar.getInstance();
    String now;
    String ECAD_ID = "";
    Config config = new Config(System.getProperty("conf.file.name"));
    String USER_ID = Ecad2007.getUserName();
    String FILE_NAME = Globals.getProjectAbsolutePath();
    Map<String, String> trUnicode = new HashMap<String, String>(50);

    public PrtSIA(String groupe) {
        this.groupe = groupe;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            Ecad2007.trace(ex);
        }
    }

    private void jbInit() throws Exception {
        this.df00 = Ecad2007.getDecimalFormat("00");
        DM_Trad_SIA dm_tradSIA = Ecad2007.getTraduction_SIA(this.groupe);
        if (Ecad2007.getLicenseLevel() > 2L) {
            this.ECAD_ID = Globals.getGenericName() + " " + Globals.ext_ver + " - " + dm_tradSIA.getCodeLan("$_no_certif") + " " + Globals.getCertNum(Ecad2007.getIntCalcmod());
            this.now = this.df00.format(this.calendar.get(5)) + "/" + this.df00.format(this.calendar.get(2) + 1) + "/" + String.valueOf(this.calendar.get(1)) + "   " + this.df00.format(this.calendar.get(11)) + ":" + this.df00.format(this.calendar.get(12)) + ":" + this.df00.format(this.calendar.get(13));
        } else {
            this.ECAD_ID = Globals.getGenericName() + " " + Globals.ext_ver + " - uncertified EDU licence";
            this.now = this.df00.format(this.calendar.get(5)) + "/" + this.df00.format(this.calendar.get(2) + 1) + "/" + String.valueOf(this.calendar.get(1));
        }
        if (Globals.int_ver < 510) {
            if (this.groupe.equals("jglobal")) {
                this.foGlobal = new FoGlobal(this);
            } else if (this.groupe.equals("jponctuel")) {
                this.foPonctuel = new FoPonctuel(this);
            } else if (this.groupe.equals("jflux")) {
                this.foFlux = new FoFlux(this);
            } else if (this.groupe.equals("jtable")) {
                this.foTable = new FoTable(this);
            } else if (this.groupe.equals("resume")) {
                this.foReport = new FoReport(this);
            } else if (this.groupe.equals("cecb")) {
                this.foCeb = new FoCeb(this);
            }
        } else if (Ecad2007.getCalcmod() < 7) {
            if (this.groupe.equals("jglobal")) {
                this.foGlobal = new FoGlobal(this);
            } else if (this.groupe.equals("jponctuel")) {
                this.foPonctuel = new FoPonctuel(this);
            } else if (this.groupe.equals("jflux")) {
                this.foFlux = new FoFlux(this);
            } else if (this.groupe.equals("jtable")) {
                this.foTable = new FoTable(this);
            } else if (this.groupe.equals("resume")) {
                this.foReport = new FoReport(this);
            } else if (this.groupe.equals("cecb")) {
                this.foCeb = new FoCeb(this);
            }
        } else if (this.groupe.equals("jglobal")) {
            this.foGlobal2016 = new FoGlobal2016(this);
        } else if (this.groupe.equals("jponctuel")) {
            this.foPonctuel2016 = new FoPonctuel2016(this);
        } else if (this.groupe.equals("jflux")) {
            this.foFlux = new FoFlux(this);
        } else if (this.groupe.equals("jtable")) {
            this.foTable2016 = new FoTable2016(this);
        } else if (this.groupe.equals("resume")) {
            this.foReport = new FoReport(this);
        } else if (this.groupe.equals("cecb")) {
            this.foCeb = new FoCeb(this);
        }
        this.trUnicode.put("\u00e7", "&#231;");
        this.trUnicode.put("\u00c7", "&#199;");
        this.trUnicode.put("\u00e9", "&#233;");
        this.trUnicode.put("\u00c9", "&#201;");
        this.trUnicode.put("\u00e8", "&#232;");
        this.trUnicode.put("\u00c8", "&#200;");
        this.trUnicode.put("\u00ea", "&#234;");
        this.trUnicode.put("\u00ca", "&#202;");
        this.trUnicode.put("\u00eb", "&#235;");
        this.trUnicode.put("\u00cb", "&#203;");
        this.trUnicode.put("\u00e0", "&#224;");
        this.trUnicode.put("\u00c0", "&#192;");
        this.trUnicode.put("\u00e1", "&#225;");
        this.trUnicode.put("\u00c1", "&#193;");
        this.trUnicode.put("\u00e2", "&#226;");
        this.trUnicode.put("\u00c2", "&#194");
        this.trUnicode.put("\u00e4", "&#228;");
        this.trUnicode.put("\u00c4", "&#196;");
        this.trUnicode.put("\u00e5", "&#165");
        this.trUnicode.put("\u00c5", "&#197");
        this.trUnicode.put("\u00ee", "&#238;");
        this.trUnicode.put("\u00ce", "&#206;");
        this.trUnicode.put("\u00ef", "&#239;");
        this.trUnicode.put("\u00cf", "&#207;");
        this.trUnicode.put("\u00f4", "&#244;");
        this.trUnicode.put("\u00d4", "&#212;");
        this.trUnicode.put("\u00f6", "&#246;");
        this.trUnicode.put("\u00d6", "&#214;");
        this.trUnicode.put("\u00fb", "&#251;");
        this.trUnicode.put("\u00db", "&#219;");
        this.trUnicode.put("\u00f9", "&#249;");
        this.trUnicode.put("\u00d9", "&#217;");
        this.trUnicode.put("\u00fc", "&#252;");
        this.trUnicode.put("\u00dc", "&#220;");
        this.trUnicode.put("\u00b2", "&#178;");
        this.trUnicode.put("\u00b3", "&#179;");
        this.trUnicode.put("\u00b0", "&#176;");
        this.trUnicode.put("\u00ba", "&#186;");
        this.trUnicode.put("\u00f8", "&#248;");
        this.trUnicode.put("\u00d8", "&#216;");
        this.trUnicode.put("/", "&#47;");
        this.trUnicode.put("\\u0022", "&#34;");
        this.trUnicode.put("'", "&#39;");
        this.trUnicode.put("_", "&#95;");
        this.trUnicode.put("<", "&#60;");
        this.trUnicode.put(">", "&#62;");
        this.trUnicode.put("^", "&#94;");
        this.trUnicode.put("!", "&#33;");
        this.trUnicode.put("#", "&#35;");
        this.trUnicode.put("&", "&#38;");
        this.trUnicode.put("?", "&#63;");
        this.trUnicode.put("@", "&#64;");
        this.trUnicode.put("\u00b1", "&#177");
        this.trUnicode.put(" ", " ");
        this.trUnicode.put("*", "*");
        this.trUnicode.put("+", "+");
        this.trUnicode.put("-", "-");
        this.trUnicode.put("=", "=");
        this.trUnicode.put("%", "%");
        this.trUnicode.put("(", "&#40;");
        this.trUnicode.put(")", "&#41;");
        this.trUnicode.put("[", "&#91;");
        this.trUnicode.put("\\u005c", "&#92;");
        this.trUnicode.put("]", "&#93;");
        this.trUnicode.put("{", "&#123;");
        this.trUnicode.put("|", "&#124;");
        this.trUnicode.put("}", "&#125;");
        this.trUnicode.put("~", "&#126;");
        this.trUnicode.put(".", ".");
        this.trUnicode.put(":", ":");
        this.trUnicode.put(",", ",");
        this.trUnicode.put(";", ";");
    }

    public String buildFoJGlobal() {
        if (Globals.int_ver < 510) {
            return this.foGlobal.buildFoJGlobal();
        }
        if (Ecad2007.getCalcmod() < 7) {
            return this.foGlobal.buildFoJGlobal();
        }
        if (Globals.int_ver >= 520 && Ecad2007.getLicenseLevel() > 2L) {
            return this.foGlobal2016.buildFoJGlobal();
        }
        return this.foGlobal2016.buildFoJGlobal();
    }

    public String buildFoJPonctuel() {
        if (Globals.int_ver < 510) {
            return this.foPonctuel.buildFoJPonctuel();
        }
        if (Ecad2007.getCalcmod() < 7) {
            return this.foPonctuel.buildFoJPonctuel();
        }
        if (Globals.int_ver >= 520 && Ecad2007.getLicenseLevel() > 2L) {
            return this.foPonctuel2016.buildFoJPonctuel();
        }
        return this.foPonctuel2016.buildFoJPonctuel();
    }

    public void buildFoJFlux() {
        this.fopForm = this.foFlux.buildFoJFlux();
        this.imageFop = this.foFlux.getImageFop();
    }

    public void buildFoJTable() {
        if (Globals.int_ver < 510) {
            this.fopForm = this.foTable.buildFoJTable();
            this.imageFop = this.foTable.getImageFop();
        } else if (Ecad2007.getCalcmod() < 7) {
            this.fopForm = this.foTable.buildFoJTable();
            this.imageFop = this.foTable.getImageFop();
        } else {
            this.fopForm = this.foTable2016.buildFoJTable();
            this.imageFop = this.foTable2016.getImageFop();
        }
    }

    public String buildFoJReport() {
        return this.foReport.buildFoJReport();
    }

    public void buildFoJCeb() {
        this.fopForm = this.foCeb.buildFoJCeb();
        this.imageFop = this.foCeb.getImageFop();
    }

    public String cleanS(String txt) {
        if (txt == null) {
            txt = "-";
        }
        txt = (txt = txt.trim()).equals("") ? "-" : this.cleanString(txt);
        return txt;
    }

    public ImageFop[] getImagesFop() {
        return this.imageFop;
    }

    public String getFopForm() {
        return this.fopForm;
    }

    protected String getProjectFileName() {
        String pattern = System.getProperty("file.separator");
        pattern = pattern.replaceAll("\\\\", "\\\\\\\\");
        this.FILE_NAME = this.FILE_NAME.replaceAll("&", "+");
        this.FILE_NAME = this.FILE_NAME.replaceAll("\\\\", "\\\\\\\\");
        this.FILE_NAME = this.globals.getTruncatedString(this.FILE_NAME, pattern, 60);
        return this.FILE_NAME;
    }

    protected String getUserId() {
        return this.USER_ID;
    }

    public String loadFo(String fo, Map<String, Object> map) {
        String res = fo;
        for (String key : map.keySet()) {
            String obj = (String)map.get(key);
            if (obj == null) {
                obj = " ";
            }
            res = res.replaceAll(key, obj);
        }
        return res;
    }

    public String cleanString(String txt) {
        char[] ctxt = txt.toCharArray();
        StringBuffer sb = new StringBuffer(1000);
        String tmp = "";
        String rc = "";
        for (int ii = 0; ii < ctxt.length; ++ii) {
            tmp = String.valueOf(ctxt[ii]);
            int c = Character.getNumericValue(ctxt[ii]);
            if (c > -1 && c < 36) {
                sb.append(tmp);
                continue;
            }
            rc = this.trUnicode.get(tmp);
            if (rc != null) {
                sb.append(rc);
                continue;
            }
            sb.append("&#95;");
        }
        return sb.toString();
    }
}

