/*
 * Decompiled with CFR 0.152.
 */
package enercad2007.printdlg;

import core.Calculation;
import core.Config;
import enercad2007.DM_Trad;
import enercad2007.DMpr_ValU;
import enercad2007.Ecad2007;
import enercad2007.Globals;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import jecadcomp.GraphElements;

public class PrtValeurU
extends JComponent
implements Printable {
    private static final long serialVersionUID = 1L;
    private int zf = 10;
    private int ff = 4;
    private transient DMpr_ValU datamodule;
    private String type;
    private transient Calculation calc;
    private int[] page;
    int[] pa = new int[]{0, 0, 181, 280};
    int intern = 0;
    int extern = 0;
    double dd = 0.0;
    transient Config config;
    DM_Trad c2_trad;
    DM_Trad gen_trad;
    DM_Trad mf_trad;
    DM_Trad symbol_trad;
    Font FT_P6 = new Font("Dialog", 0, 6 * this.ff);
    Font FT_P7 = new Font("Dialog", 0, 7 * this.ff);
    Font FT_P8 = new Font("Dialog", 0, 8 * this.ff);
    Font FT_P9 = new Font("Dialog", 0, 9 * this.ff);
    Font FT_P10 = new Font("Dialog", 0, 10 * this.ff);
    Font FT_B6 = new Font("Dialog", 1, 6 * this.ff);
    Font FT_B7 = new Font("Dialog", 1, 7 * this.ff);
    Font FT_B8 = new Font("Dialog", 1, 8 * this.ff);
    Font FT_B9 = new Font("Dialog", 1, 9 * this.ff);
    Font FT_B10 = new Font("Dialog", 1, 10 * this.ff);
    Font FT_B14 = new Font("Dialog", 1, 14);
    DecimalFormat df1;
    DecimalFormat df2;
    DecimalFormat df3;
    DecimalFormat df00;
    static final float[] dash1 = new float[]{10.0f};
    static final BasicStroke dashed = new BasicStroke(0.1f, 0, 0, 10.0f, dash1, 0.0f);
    static final BasicStroke line0f1 = new BasicStroke(0.01f);
    static final BasicStroke line1f0 = new BasicStroke();
    String txt_titre = "Calcul valeur U - \u00e9l\u00e9ment(s) compos\u00e9s";
    String txt_comp = "Nom du composant";
    String txt_calc_justif = "Calcul de justification - Page coefficient-U";
    String txt_int = "int\u00e9rieur";
    String txt_ext = "ext\u00e9rieur";
    String txt_c2_u = "Valeur U";
    String txt_c2_u_dyn = "Valeur U dynamique";
    String txt_fill = "Remplissage";
    String txt_struct = "Structure";
    String txt_layer = "Couches";
    String txt_rho = "densit\u00e9";
    String txt_d = "\u00e9paisseur";
    String txt_dtot = "Epaisseur totale";
    String txt_rtot = "R\u00e9sistance totale";

    public PrtValeurU(String type, DMpr_ValU datamodule, Calculation calc) {
        this.type = type;
        this.datamodule = datamodule.clone();
        this.calc = calc;
        this.jbInit();
    }

    public PrtValeurU(String type, DMpr_ValU datamodule, Calculation calc, int[] page) {
        this.type = type.toString();
        this.datamodule = datamodule.clone();
        this.calc = calc;
        if (page != null) {
            this.page = (int[])page.clone();
        }
        this.jbInit();
    }

    private void jbInit() {
        this.config = new Config(System.getProperty("conf.file.name"));
        this.c2_trad = new DM_Trad("c2");
        this.gen_trad = Ecad2007.getTraduction("gen");
        this.mf_trad = Ecad2007.getTraduction("mf");
        this.symbol_trad = Ecad2007.getTraduction("symbol");
        String cname = this.getClass().getName();
        this.initLang();
        int index = cname.indexOf(".");
        if (index > 0) {
            cname = cname.substring(index + 4);
        }
        this.setSize(this.pa[2] * this.zf, this.pa[3] * this.zf);
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(this.pa[0] * this.zf, this.pa[1] * this.zf, this.pa[2] * this.zf, this.pa[3] * this.zf);
    }

    private void initLang() {
        if (this.c2_trad != null) {
            this.txt_titre = this.c2_trad.getCodeLan("titre", this.txt_titre);
            this.txt_comp = this.gen_trad.getCodeLan("comp", this.txt_comp);
            this.txt_calc_justif = this.c2_trad.getCodeLan("calc_justif", this.txt_calc_justif);
            this.txt_int = this.gen_trad.getCodeLan("int");
            this.txt_ext = this.gen_trad.getCodeLan("ext");
            this.txt_c2_u = this.c2_trad.getCodeLan("c2_u", this.txt_c2_u);
            this.txt_c2_u_dyn = this.c2_trad.getCodeLan("Udyn", this.txt_c2_u_dyn);
            this.txt_fill = this.c2_trad.getCodeLan("fill", this.txt_fill);
            this.txt_struct = this.c2_trad.getCodeLan("struct", this.txt_struct);
            this.txt_layer = this.c2_trad.getCodeLan("layer", this.txt_layer);
            this.txt_rho = this.c2_trad.getCodeLan("rho", this.txt_rho);
            this.txt_d = this.symbol_trad.getCodeLan("d", this.txt_d);
            this.txt_dtot = this.symbol_trad.getCodeLan("dtot");
            this.txt_rtot = this.c2_trad.getCodeLan("rtot", this.txt_rtot);
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D g2 = (Graphics2D)graphics;
        FontMetrics fm = null;
        this.df1 = Ecad2007.getDecimalFormat("0.0");
        this.df2 = Ecad2007.getDecimalFormat("0.00");
        this.df3 = Ecad2007.getDecimalFormat("0.000");
        this.df00 = Ecad2007.getDecimalFormat("00");
        Object[][] data = (Object[][])this.datamodule.getDlgData();
        String[][] dimdata = this.datamodule.getDlgd();
        String[][] flags = this.datamodule.getDlgFlags();
        Object[][] dataOrig = data;
        String[][] dimdataOrig = dimdata;
        double[] RS = this.datamodule.getDimRS();
        int nlay = this.datamodule.getNLAY();
        double[] PT = this.datamodule.getPontTherm();
        double Rmoy = 0.0;
        double RmoyD = 0.0;
        int coucheCh = this.datamodule.getCoucheCh();
        int coucheSt = this.datamodule.getCoucheSt();
        int cCh = coucheCh;
        if (this.type.equals("2") || this.type.equals("3")) {
            if (coucheCh >= 0) {
                coucheCh = nlay - coucheCh - 1;
            }
            if (coucheSt >= 0) {
                coucheSt = nlay - coucheSt - 1;
            }
        }
        int dim = 0;
        String tmp = "";
        int tmpi = 0;
        double tmpd = 0.0;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.black);
        g2.setFont(this.FT_B10);
        g2.drawString(this.txt_titre, 0, 0 * this.zf);
        g2.setColor(new Color(228, 228, 228));
        g2.fillRect(0, 4 * this.zf, 40 * this.zf, 10 * this.zf);
        g2.setColor(Color.black);
        g2.setStroke(line0f1);
        g2.drawRect(0, 4 * this.zf, 181 * this.zf, 10 * this.zf);
        g2.drawLine(40 * this.zf, 4 * this.zf, 40 * this.zf, 14 * this.zf);
        g2.setStroke(line1f0);
        g2.setFont(this.FT_P8);
        g2.drawString(this.mf_trad.getCodeLan("projet") + ":", this.zf, 8 * this.zf);
        g2.drawString(this.txt_comp + ":", this.zf, 13 * this.zf);
        if (Globals.isEnerCAD()) {
            g2.drawString(Ecad2007.getDM_Pro().getNOM_B(), 41 * this.zf, 8 * this.zf);
        }
        if (this.type.equals("0") || this.type.equals("1")) {
            g2.drawString(this.gen_trad.getCodeLan("toit") + ": " + this.datamodule.getComponentName(), 41 * this.zf, 13 * this.zf);
        } else if (this.type.equals("2")) {
            g2.drawString(this.gen_trad.getCodeLan("mur") + ": " + this.datamodule.getComponentName(), 41 * this.zf, 13 * this.zf);
        } else if (this.type.equals("3")) {
            g2.drawString(this.gen_trad.getCodeLan("plan") + ": " + this.datamodule.getComponentName(), 41 * this.zf, 13 * this.zf);
        }
        int rs = 1;
        int mmdec = 0;
        if (RS[1] > 0.0) {
            rs = 2;
        }
        for (int iii = 0; iii < rs; ++iii) {
            mmdec = iii * 90 * this.zf;
            g2.setFont(this.FT_B8);
            tmp = iii == 0 ? this.txt_fill : this.txt_struct;
            g2.setStroke(line0f1);
            g2.drawRect(0, 19 * this.zf + mmdec, 181 * this.zf, 5 * this.zf);
            g2.setStroke(line1f0);
            g2.drawString(tmp, this.zf, 23 * this.zf + mmdec);
            g2.setFont(this.FT_P8);
            tmp = this.txt_layer;
            g2.drawString(tmp, 0, 29 * this.zf + mmdec);
            g2.setFont(this.FT_P7);
            fm = g2.getFontMetrics();
            tmp = this.txt_rho;
            dim = fm.stringWidth(tmp) / 2;
            g2.drawString(tmp, 121 * this.zf - dim, 28 * this.zf + mmdec);
            tmp = "[kg/m\u00b3]";
            dim = fm.stringWidth(tmp) / 2;
            g2.drawString(tmp, 121 * this.zf - dim, 32 * this.zf + mmdec);
            tmp = "lambda";
            dim = fm.stringWidth(tmp) / 2;
            g2.drawString(tmp, 136 * this.zf - dim, 28 * this.zf + mmdec);
            tmp = "[W/mk]";
            dim = fm.stringWidth(tmp) / 2;
            g2.drawString(tmp, 136 * this.zf - dim, 32 * this.zf + mmdec);
            tmp = this.txt_d;
            dim = fm.stringWidth(tmp) / 2;
            g2.drawString(tmp, 157 * this.zf - dim, 28 * this.zf + mmdec);
            tmp = "[cm]";
            dim = fm.stringWidth(tmp) / 2;
            g2.drawString(tmp, 157 * this.zf - dim, 32 * this.zf + mmdec);
            g2.drawString("R [m\u00b2K/W]", 170 * this.zf - dim, 28 * this.zf + mmdec);
            tmp = this.type.equals("0") || this.type.equals("1") ? "Rse" : "Rsi";
            dim = fm.stringWidth(tmp) / 2;
            g2.drawString(tmp, 185 * this.zf - dim, 33 * this.zf + mmdec);
            tmp = this.type.equals("0") || this.type.equals("1") ? "Rsi" : "Rse";
            dim = fm.stringWidth(tmp) / 2;
            g2.drawString(tmp, 185 * this.zf - dim, 82 * this.zf + mmdec);
            g2.setStroke(line0f1);
            g2.drawRect(0, 34 * this.zf + mmdec, 181 * this.zf, 44 * this.zf);
            g2.drawRect(149 * this.zf, 34 * this.zf + mmdec, 18 * this.zf, 49 * this.zf);
            g2.drawRect(167 * this.zf, 30 * this.zf + mmdec, 14 * this.zf, 53 * this.zf);
            g2.setStroke(line1f0);
            g2.setFont(this.FT_P6);
            tmpi = 38 * this.zf;
            fm = g2.getFontMetrics();
            int[] ie = new int[]{0, 1};
            if (this.type.equals("0") || this.type.equals("1")) {
                ie = new int[]{1, 0};
            }
            dim = fm.stringWidth(this.df3.format(this.datamodule.getDimRS()[0]));
            g2.drawString(String.valueOf(this.df2.format(this.datamodule.getRAie()[ie[0]])), 181 * this.zf - dim, 33 * this.zf + mmdec);
            dim = fm.stringWidth(this.df3.format(this.datamodule.getDimRS()[1]));
            g2.drawString(String.valueOf(this.df2.format(this.datamodule.getRAie()[ie[1]])), 181 * this.zf - dim, 82 * this.zf + mmdec);
            this.dd = 0.0;
            for (int ii = 0; ii < nlay; ++ii) {
                g2.drawString((String)data[ii][0 + iii * 5], this.zf, tmpi + mmdec);
                if (data[ii][3 + iii * 5] != null) {
                    dim = fm.stringWidth((String)data[ii][3 + iii * 5]);
                    g2.drawString((String)data[ii][3 + iii * 5], 125 * this.zf - dim, tmpi + mmdec);
                }
                dim = fm.stringWidth((String)data[ii][1 + iii * 5]);
                g2.drawString((String)data[ii][1 + iii * 5], 145 * this.zf - dim, tmpi + mmdec);
                if (dimdata[ii][1] == null) break;
                tmp = dimdata[ii][1].equals("-1") ? dimdata[ii][0] : dimdata[ii][1];
                dim = fm.stringWidth(tmp);
                g2.drawString(tmp, 161 * this.zf - dim, tmpi + mmdec);
                this.dd += Globals.getDoubleValue(tmp);
                tmpd = cCh >= 0 ? (this.type.equals("0") || this.type.equals("1") ? (ii < cCh ? Globals.getDoubleValue(tmp) / Globals.getDoubleValue(data[ii][1 + iii * 5]) / 100.0 : (ii == cCh ? Globals.getDoubleValue(tmp) / Globals.getDoubleValue(data[ii][1 + iii * 5]) / 200.0 : 0.0)) : (ii < cCh ? 0.0 : (ii == cCh ? Globals.getDoubleValue(tmp) / Globals.getDoubleValue(data[ii][1 + iii * 5]) / 200.0 : Globals.getDoubleValue(tmp) / Globals.getDoubleValue(data[ii][1 + iii * 5]) / 100.0))) : Globals.getDoubleValue(tmp) / Globals.getDoubleValue(data[ii][1 + iii * 5]) / 100.0;
                dim = fm.stringWidth(this.df3.format(tmpd));
                g2.drawString(this.df3.format(tmpd), 180 * this.zf - dim, tmpi + mmdec);
                tmpi += 3 * this.zf;
            }
            dim = fm.stringWidth(this.df1.format(this.dd));
            g2.drawString(this.df1.format(this.dd), 161 * this.zf - dim, 82 * this.zf + mmdec);
            g2.setFont(this.FT_P8);
            g2.drawString(String.valueOf(this.df1.format(RS[iii] * 100.0) + " cm"), 0, 82 * this.zf + mmdec);
            fm = g2.getFontMetrics(g2.getFont());
            tmp = this.txt_dtot + " [cm]";
            dim = fm.stringWidth(tmp);
            g2.drawString(tmp, 147 * this.zf - dim, 82 * this.zf + mmdec);
            tmp = this.txt_rtot + " R [m\u00b2K/W]";
            dim = fm.stringWidth(tmp);
            g2.drawString(tmp, 165 * this.zf - dim, 92 * this.zf + mmdec);
            tmp = this.txt_c2_u + " = 1/R [W/m\u00b2K]";
            dim = fm.stringWidth(tmp);
            g2.drawString(tmp, 165 * this.zf - dim, 98 * this.zf + mmdec);
            if (iii == 0) {
                tmp = this.txt_c2_u_dyn + " [W/m\u00b2K]";
                dim = fm.stringWidth(tmp);
                g2.drawString(tmp, 165 * this.zf - dim, 104 * this.zf + mmdec);
                double[] tmpdd = new double[]{100.0, 0.0};
                Rmoy = this.calc.getRMoy(tmpdd, coucheCh, coucheSt, nlay);
                Rmoy = this.calc.getRmoyAvecPontThermique(Rmoy, PT[1], (int)PT[0]);
                RmoyD = this.calc.getRmoyD(this.type, nlay);
            } else if (iii == 1) {
                double[] tmpdd = new double[]{0.0, 100.0};
                Rmoy = this.calc.getRMoy(tmpdd, coucheCh, coucheSt, nlay);
                Rmoy = this.calc.getRmoyAvecPontThermique(Rmoy, PT[1], (int)PT[0]);
            }
            g2.setFont(this.FT_P8);
            fm = g2.getFontMetrics(g2.getFont());
            tmp = this.df2.format(Rmoy);
            dim = fm.stringWidth(tmp);
            g2.drawString(tmp, 180 * this.zf - dim, 92 * this.zf + mmdec);
            g2.setFont(this.FT_B8);
            tmp = this.df2.format(1.0 / Rmoy);
            dim = fm.stringWidth(tmp);
            g2.drawString(tmp, 180 * this.zf - dim, 98 * this.zf + mmdec);
            g2.setFont(this.FT_P8);
            if (iii == 0) {
                tmp = this.df2.format(1.0 / RmoyD);
                dim = fm.stringWidth(tmp);
                g2.drawString(tmp, 180 * this.zf - dim, 104 * this.zf + mmdec);
            }
            if (iii != 1) continue;
            Rmoy = this.calc.getRMoy(RS, coucheCh, coucheSt, nlay);
            Rmoy = this.calc.getRmoyAvecPontThermique(Rmoy, PT[1], (int)PT[0]);
            g2.setFont(this.FT_B8);
            fm = g2.getFontMetrics(g2.getFont());
            tmp = this.txt_rtot + " R [m\u00b2K/W]";
            dim = fm.stringWidth(tmp);
            g2.drawString(tmp, 165 * this.zf - dim, 195 * this.zf);
            tmp = this.df2.format(Rmoy);
            dim = fm.stringWidth(tmp);
            g2.drawString(tmp, 180 * this.zf - dim, 195 * this.zf);
            tmp = this.txt_c2_u + " = 1/R [W/m\u00b2K]";
            dim = fm.stringWidth(tmp);
            g2.drawString(tmp, 165 * this.zf - dim, 201 * this.zf);
            tmp = this.df2.format(1.0 / Rmoy);
            dim = fm.stringWidth(tmp);
            g2.drawString(tmp, 180 * this.zf - dim, 201 * this.zf);
        }
        double ddxr = 0.0;
        double ddxs = 0.0;
        int eldy = 35;
        int elmx = 31;
        int elmy = 212;
        int dxr = 0;
        int dxs = 0;
        int dx = 190 - 2 * elmx;
        if (rs == 2) {
            int tmpdx = (int)(((double)this.pa[2] - (double)(2 * elmx)) * (double)eldy / this.dd * (RS[0] + RS[1]));
            if (tmpdx > dx) {
                tmpd = (double)dx / (double)tmpdx * (double)eldy;
                elmy += (eldy - (int)tmpd) / 2;
                eldy = (int)tmpd;
            } else {
                tmpi = (dx - tmpdx) / 2;
                elmx += tmpi;
                dx = tmpdx;
            }
            ddxr = RS[0] / (RS[0] + RS[1]);
            ddxs = RS[1] / (RS[0] + RS[1]);
            dxr = (int)(ddxr * (double)dx);
            dxs = (int)(ddxs * (double)dx);
        } else {
            ddxr = 1.0;
            ddxs = 0.0;
            dxr = dx;
            dxs = 0;
        }
        HashMap<String, Integer> configMap = new HashMap<String, Integer>(10);
        Integer nt = new Integer(this.config.getPropertyInt("constants", "nt"));
        configMap.put("NT", nt);
        Map<String, String[]> lib = this.datamodule.getDataM4();
        lib.putAll(this.datamodule.getDataM4P());
        GraphElements gel = new GraphElements(lib, configMap, false);
        gel.setBorder(BorderFactory.createLineBorder(Color.black));
        gel.setMargins(0, 0);
        gel.setBackground(Color.white);
        Rectangle recE = new Rectangle((rs == 1 ? 35 : elmx) * this.zf, elmy * this.zf, dxr * this.zf, eldy * this.zf);
        Rectangle recS = new Rectangle((elmx + dxr) * this.zf - 2, elmy * this.zf, dxs * this.zf, eldy * this.zf);
        BufferedImage buffImg = new BufferedImage(recE.width, recE.height, 2);
        Graphics2D g2d = buffImg.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int yz = 200;
        int xz = yz * dx / eldy;
        boolean b_op = gel.isOpaque();
        gel.setFont(this.FT_B14);
        gel.setOpaque(true);
        double th2 = Ecad2007.getDM_Zone(0).getTH2();
        for (int iii = 0; iii < rs; ++iii) {
            if (iii == 0) {
                gel.setBounds(new Rectangle(0, 0, (int)(ddxr * (double)xz), yz));
                gel.drawElements(dataOrig, flags, dimdataOrig, nlay, 1);
                if (this.type.equals("0") || this.type.equals("1")) {
                    gel.drawTemp(this.extern, th2, this.intern);
                } else {
                    gel.drawTemp(this.intern, th2, this.extern);
                }
                g2d.scale(recE.getWidth() / (ddxr * (double)xz), recE.getHeight() / (double)yz);
                gel.paint(g2d);
                g2d.dispose();
                g2.drawImage(buffImg, null, recE.x, recE.y);
            } else if (iii == 1) {
                buffImg = recS.width < 2 ? new BufferedImage(2, recS.height, 2) : new BufferedImage(recS.width, recS.height, 2);
                g2d = buffImg.createGraphics();
                gel.setBounds(new Rectangle(0, 0, (int)(ddxs * (double)xz), yz));
                gel.drawElements(dataOrig, flags, dimdataOrig, nlay, 2);
                if (this.type.equals("0") || this.type.equals("1")) {
                    gel.drawTemp(this.extern, th2, this.intern);
                } else {
                    gel.drawTemp(this.intern, th2, this.extern);
                }
                if (recS.width < 2) {
                    g2d.scale(2.0 / ((double)xz * ddxs), recS.getHeight() / (double)yz);
                } else {
                    g2d.scale(recS.getWidth() / ((double)xz * ddxs), recS.getHeight() / (double)yz);
                }
                gel.paint(g2d);
                g2d.dispose();
                g2.drawImage(buffImg, null, recS.x - 1, recS.y);
            }
            gel.setOpaque(b_op);
        }
        if (rs == 2) {
            g2.setStroke(line0f1);
            g2.drawLine((elmx - 2) * this.zf, 258 * this.zf, (elmx + dx + 4) * this.zf, 258 * this.zf);
            g2.drawLine(elmx * this.zf, 252 * this.zf, elmx * this.zf, 260 * this.zf);
            g2.drawLine((elmx + dxr) * this.zf, 252 * this.zf, (elmx + dxr) * this.zf, 260 * this.zf);
            g2.drawLine((elmx + dx) * this.zf, 252 * this.zf, (elmx + dx) * this.zf, 260 * this.zf);
            g2.setStroke(line1f0);
            g2.fillOval((int)(((double)elmx - 0.5) * (double)this.zf), (int)(257.5 * (double)this.zf), this.zf, this.zf);
            g2.fillOval((int)(((double)elmx - 0.5 + (double)dxr) * (double)this.zf), (int)(257.5 * (double)this.zf), this.zf, this.zf);
            g2.fillOval((int)(((double)elmx - 0.5 + (double)dx) * (double)this.zf), (int)(257.5 * (double)this.zf), this.zf, this.zf);
            g2.setFont(this.FT_P7);
            fm = g2.getFontMetrics(g2.getFont());
            tmp = "R = " + this.df1.format(RS[0] * 100.0) + " cm";
            dim = fm.stringWidth(tmp);
            g2.drawString(tmp, (elmx + dxr / 2) * this.zf - dim / 2, 256 * this.zf);
            tmp = "S = " + this.df1.format(RS[1] * 100.0) + " cm";
            dim = fm.stringWidth(tmp);
            if (dim < dxs) {
                g2.drawString(tmp, (elmx + dxr + dxs / 2) * this.zf - dim / 2, 256 * this.zf);
            } else {
                g2.drawString(tmp, (elmx + dx + 2) * this.zf, 256 * this.zf);
            }
        }
        g2.setStroke(line0f1);
        g2.drawLine(181 * this.zf, (elmy - 2) * this.zf, 181 * this.zf, (elmy + eldy + 2) * this.zf);
        g2.drawLine(176 * this.zf, elmy * this.zf, 184 * this.zf, elmy * this.zf);
        g2.drawLine(176 * this.zf, (elmy + eldy) * this.zf, 184 * this.zf, (elmy + eldy) * this.zf);
        g2.setStroke(line1f0);
        g2.fillOval((int)(180.5 * (double)this.zf), (int)(((double)elmy - 0.5) * (double)this.zf), this.zf, this.zf);
        g2.fillOval((int)(180.5 * (double)this.zf), (int)(((double)(elmy + eldy) - 0.5) * (double)this.zf), this.zf, this.zf);
        g2.setFont(this.FT_P7);
        tmp = this.df1.format(this.dd);
        dim = fm.stringWidth(tmp);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        AffineTransform oldTransform = g2.getTransform();
        AffineTransform at = null;
        at = eldy * this.zf - this.zf > dim ? AffineTransform.getTranslateInstance(186 * this.zf, (eldy / 2 + elmy) * this.zf + dim / 2) : AffineTransform.getTranslateInstance(186 * this.zf, (elmy - 2) * this.zf);
        g2.transform(at);
        g2.transform(AffineTransform.getRotateInstance(4.71238898038469));
        g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
        g2.drawString(tmp, 0, 0);
        g2.setTransform(oldTransform);
        g2.setFont(this.FT_P7);
        String now = "";
        Calendar calendar = Calendar.getInstance();
        if (Ecad2007.getLicenseLevel() > 2L) {
            tmp = Globals.getGenericName() + " " + Globals.getVersion() + " - " + "www.enercad.ch" + " - " + Ecad2007.getUserName();
            now = this.df00.format(calendar.get(5)) + "/" + this.df00.format(calendar.get(2) + 1) + "/" + String.valueOf(calendar.get(1)) + "   " + this.df00.format(calendar.get(11)) + ":" + this.df00.format(calendar.get(12)) + ":" + this.df00.format(calendar.get(13));
        } else {
            tmp = Globals.getGenericName() + " " + Globals.getVersion() + " - uncertified EDU licence";
            now = this.df00.format(calendar.get(5)) + "/" + this.df00.format(calendar.get(2) + 1) + "/" + String.valueOf(calendar.get(1));
        }
        g2.drawString(tmp, 0, 266 * this.zf);
        tmp = this.txt_calc_justif + " - " + now;
        g2.drawString(tmp, 0, 271 * this.zf);
        fm = g2.getFontMetrics();
        if (this.page != null) {
            if (this.page.length == 1) {
                tmp = String.valueOf(this.page[0]);
                dim = fm.stringWidth(tmp);
                g2.drawString(tmp, 181 * this.zf - dim, 271 * this.zf);
            } else if (this.page.length == 2) {
                tmp = String.valueOf(this.page[0]) + " / " + String.valueOf(this.page[1]);
                dim = fm.stringWidth(tmp);
                g2.drawString(tmp, 181 * this.zf - dim, 271 * this.zf);
            }
        }
        if (Globals.isEnerCAD()) {
            tmp = Globals.getProjectAbsolutePath();
            String pattern = System.getProperty("file.separator");
            pattern = pattern.replaceAll("\\\\", "\\\\\\\\");
            tmp = tmp.replaceAll("&", "+");
            tmp = tmp.replaceAll("\\\\", "\\\\\\\\");
            tmp = new Globals().getTruncatedString(tmp, pattern, 60);
            tmp = tmp.replaceAll("\\\\\\\\", "\\\\");
            dim = fm.stringWidth(tmp);
            g2.drawString(tmp, 181 * this.zf - dim, 266 * this.zf);
        }
        g2.setFont(this.FT_P8);
        tmp = this.type.equals("0") || this.type.equals("1") ? this.txt_ext : this.txt_int;
        g2.drawString(tmp, 0, 213 * this.zf);
        tmp = this.type.equals("0") || this.type.equals("1") ? this.txt_int : this.txt_ext;
        g2.drawString(tmp, 0, 246 * this.zf);
    }

    public String getComponentName() {
        return this.datamodule.getComponentName();
    }

    public void setTemps(int intern, int extern) {
        this.intern = intern;
        this.extern = extern;
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) {
        if (pageIndex != 0) {
            return 1;
        }
        this.paintComponent(g);
        return 0;
    }
}

