/*
 * Decompiled with CFR 0.152.
 */
package jTreeBiblio_510;

import enercad2007.Globals;
import jTreeBiblio_510.AbstractTreeTableModel;
import jTreeBiblio_510.MapTreeModel;
import jTreeBiblio_510.TreeTableModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.tree.TreePath;

public class BiblioModel
extends AbstractTreeTableModel {
    protected String[] cNames = new String[]{"", "lambda", "c", "rh\u00f4", "alpha", "vm", "d", "source"};
    protected String[] cTooltip = new String[]{"", "Conductibilit\u00e9 thermique [W/mk]", "Chaleur sp\u00e9cifique [Wh/kgK]", "Densit\u00e9 [kg/m\u00b2]", "Facteur d'absorption de rayonnement [0...1] (Surface absorbante TWD)", "Conductivit\u00e9 de vapeur d'eau [mg/mhPa]", "Epaisseur [cm]", "Source de l'enregistrement"};
    protected Class[] cTypes = new Class[]{TreeTableModel.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class};
    protected Map map;
    protected Map<String, String[]> datamap;
    private Map<String, String[]> fulldatamap;
    protected MapTreeModel maptreemodel;
    protected int colNbr = 8;

    public BiblioModel(Vector<String[]> vector) {
        super(null);
        this.maptreemodel = new MapTreeModel(vector);
        this.root = "root";
        this.map = this.maptreemodel.getMap();
        this.datamap = this.maptreemodel.getDataMap();
    }

    public BiblioModel(Vector<String[]> vector, String[] cNames, String[] cTooltip, int order) {
        super(null);
        this.maptreemodel = new MapTreeModel(vector, order);
        this.cNames = cNames;
        this.cTooltip = cTooltip;
        this.root = "root";
        this.map = this.maptreemodel.getMap();
        this.datamap = this.maptreemodel.getDataMap();
        if (vector.get(0).length > 3) {
            this.colNbr = vector.get(0).length;
        }
        if (cNames.length > 2) {
            this.cTypes = new Class[this.colNbr];
            this.cTypes[0] = TreeTableModel.class;
            for (int cter = 1; cter < this.colNbr; ++cter) {
                this.cTypes[cter] = String.class;
            }
        }
    }

    public BiblioModel(Vector<String[]> vector, String[] cNames, String[] cTooltip) {
        this(vector, cNames, cTooltip, 0);
    }

    @Override
    public int getChildCount(Object node) {
        Collection children = (Collection)this.map.get(node);
        return children == null ? 0 : children.size();
    }

    @Override
    public Object getChild(Object node, int index) {
        Iterator it = ((Collection)this.map.get(node)).iterator();
        ArrayList li = new ArrayList();
        while (it.hasNext()) {
            li.add(it.next());
        }
        return li.get(index);
    }

    protected String[] getParent(String codeRef) {
        String[] res;
        block9: {
            res = new String[2];
            String[] ldata = new String[this.colNbr];
            Collection<String[]> col = this.datamap.values();
            Iterator<String[]> it = col.iterator();
            String tmp = "";
            res[0] = (String)this.root;
            res[1] = "-1";
            try {
                if (codeRef.compareTo("0,0") != 0) {
                    while (it.hasNext()) {
                        ldata = it.next();
                        if (ldata[this.colNbr - 1].indexOf(",") != -1 && Globals.getIntValue(tmp = ldata[this.colNbr - 1].substring(ldata[this.colNbr - 1].indexOf(",") + 1).trim(), -1) == 0) {
                            ldata[this.colNbr - 1] = ldata[this.colNbr - 1].substring(0, ldata[this.colNbr - 1].indexOf(","));
                        }
                        if (ldata[this.colNbr - 1].trim().compareTo(codeRef.trim()) != 0) continue;
                        res[0] = ldata[this.colNbr - 1];
                        res[1] = ldata[this.colNbr - 2];
                        if (res[1].compareTo("") == 0) {
                            res[1] = "0,0";
                            continue;
                        }
                        if (res[1].compareTo("-") == 0) {
                            String cref = "";
                            if (codeRef.indexOf(",") != -1) {
                                res[1] = cref = codeRef.substring(0, codeRef.indexOf(","));
                            } else {
                                cref = codeRef;
                                res[1] = "-1";
                            }
                        }
                        break block9;
                    }
                    break block9;
                }
                res[0] = (String)this.root;
                res[1] = "-1";
            }
            catch (NullPointerException e) {
                res[0] = (String)this.root;
                res[1] = "-1";
            }
        }
        return res;
    }

    public TreePath getRootPath(String codeRef) {
        TreePath treePath = this.getFullTreePath(codeRef);
        Object[] object = new Object[]{this.root, treePath.getPathComponent(1)};
        return new TreePath(object);
    }

    @Override
    public String getRootPos(TreePath path) {
        String[] ldata = new String[this.colNbr];
        String pos = "";
        String ref = "";
        Object[] object = new Object[]{this.root, path.getPathComponent(1)};
        TreePath rootPath = new TreePath(object);
        if (path != null) {
            ldata = this.datamap.get(rootPath.getLastPathComponent());
            pos = ldata[this.colNbr - 2];
            ref = ldata[this.colNbr - 1];
            if (pos.equals("-")) {
                pos = ref;
            }
            pos = pos.indexOf(",") == -1 ? ref : ref.substring(0, ref.indexOf(","));
            return pos;
        }
        return "-1";
    }

    @Override
    public String[] getRootPoss(TreePath[] path) {
        String[] res = new String[path.length];
        for (int cter = 0; cter < path.length; ++cter) {
            res[cter] = this.getRootPos(path[cter]);
        }
        return res;
    }

    @Override
    public boolean isRoot(TreePath treePath) {
        boolean res = false;
        if (this.root.toString().equals(treePath.getLastPathComponent().toString().trim())) {
            res = true;
        }
        return res;
    }

    @Override
    public boolean isLeaf(Object node) {
        String[] ldata = new String[this.colNbr];
        String temp = "";
        int rref = 0;
        ldata = this.datamap.get(node);
        if (ldata != null) {
            if (ldata[this.colNbr - 1] == null) {
                return this.getChildCount(node) == 0;
            }
            temp = ldata[this.colNbr - 1].trim();
            rref = temp.indexOf(44) == -1 ? 0 : temp.indexOf(44) + 1;
            return rref != 0;
        }
        return this.getChildCount(node) == 0;
    }

    @Override
    public String getCodeRef(TreePath path) {
        if (path != null) {
            return (String)path.getLastPathComponent();
        }
        return "-1";
    }

    @Override
    public String[] getCodeRefAsArray(TreePath path) {
        String[] ldata = new String[this.colNbr];
        if (path != null) {
            ldata = this.datamap.get(path.getLastPathComponent());
            return ldata;
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        return this.cNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.cNames[column];
    }

    @Override
    public Class getColumnClass(int column) {
        return this.cTypes[column];
    }

    @Override
    public String getHeaderToolTip(int column) {
        return this.cTooltip[column];
    }

    public void insertNodes(String[][] nodes) {
        Vector<String[]> vector = new Vector<String[]>(20);
        for (int cter = 0; cter < nodes.length; ++cter) {
            vector.addElement(nodes[cter]);
        }
        this.maptreemodel.insertData(vector);
    }

    @Override
    public Map<String, String[]> getDataMap() {
        return this.datamap;
    }

    @Override
    public Map getDirMap() {
        return this.map;
    }

    @Override
    public Collection[] getNodes() {
        return this.maptreemodel.getNodes();
    }

    public Object getDatamapObject(String key) {
        return this.datamap.get(key);
    }

    public String[] getDirRefs(int dir) {
        String[] refs = null;
        Collection<String[]> col = this.datamap.values();
        Iterator<String[]> it = col.iterator();
        String[] ldata = new String[this.colNbr];
        ArrayList<String> al = new ArrayList<String>(20);
        String codeRef = "";
        String pos = "";
        int lref = 0;
        int rref = 0;
        boolean b_dir = false;
        boolean b_dirPlus = false;
        while (it.hasNext()) {
            int cter;
            String[] tmp;
            ldata = it.next();
            codeRef = ldata[this.colNbr - 1];
            pos = ldata[this.colNbr - 2];
            if (codeRef.indexOf(",") != -1) {
                lref = Globals.getIntValue(codeRef.substring(0, codeRef.indexOf(",")));
                rref = Globals.getIntValue(codeRef.substring(codeRef.indexOf(",") + 1));
                if (rref != 0) {
                    if (pos.equals("-")) {
                        b_dir = true;
                    } else if (pos.indexOf(",") == -1) {
                        b_dir = pos.equals(String.valueOf(lref));
                    } else {
                        tmp = pos.split(",");
                        for (cter = 0; cter < tmp.length; ++cter) {
                            if (!tmp[cter].equals(String.valueOf(dir))) continue;
                            b_dir = true;
                            break;
                        }
                    }
                }
            }
            if (codeRef.indexOf(",") == -1 || rref == 0) {
                lref = codeRef.indexOf(",") == -1 ? Globals.getIntValue(codeRef) : Globals.getIntValue(codeRef.substring(0, codeRef.indexOf(",")));
                if (pos.indexOf(",") != -1) {
                    tmp = pos.split(",");
                    for (cter = 0; cter < tmp.length; ++cter) {
                        if (!tmp[cter].equals(String.valueOf(dir))) continue;
                        b_dirPlus = true;
                        break;
                    }
                } else if (!pos.equals("-") && !pos.equals("") && pos.equals(String.valueOf(dir))) {
                    b_dirPlus = true;
                }
            }
            if (b_dirPlus) {
                String[] tmpRefs = this.getDirRefs(lref);
                for (cter = 0; cter < tmpRefs.length; ++cter) {
                    al.add(tmpRefs[cter]);
                }
            }
            if (lref == dir && b_dir) {
                al.add(codeRef);
            }
            b_dir = false;
            b_dirPlus = false;
        }
        if (!al.isEmpty()) {
            refs = new String[al.size()];
            for (int cter = 0; cter < al.size(); ++cter) {
                refs[cter] = al.get(cter).toString();
            }
        }
        return refs;
    }

    public String[] getDirRefs(String dir) {
        String[] refs = null;
        Collection<String[]> collection = this.datamap.values();
        Iterator<String[]> it = collection.iterator();
        String[] ldata = new String[this.colNbr];
        ArrayList<String> al = new ArrayList<String>(20);
        String codeRef = "";
        String pos = "";
        boolean b_dir = false;
        boolean b_dirPlus = false;
        while (it.hasNext()) {
            int cter;
            String[] tmpRefs;
            ldata = it.next();
            codeRef = ldata[this.colNbr - 1];
            pos = ldata[this.colNbr - 2];
            if (pos.equals("-") && codeRef.indexOf(",") > 0) {
                pos = codeRef.substring(0, codeRef.indexOf(","));
            }
            if (pos.equals(dir)) {
                b_dir = true;
            }
            if (codeRef.equals(pos)) {
                b_dirPlus = true;
            }
            if (b_dir) {
                al.add(codeRef);
                if (codeRef.indexOf(",") == -1 && (tmpRefs = this.getDirRefs(codeRef)) != null) {
                    for (cter = 0; cter < tmpRefs.length; ++cter) {
                        al.add(tmpRefs[cter]);
                    }
                }
            }
            if (b_dirPlus) {
                tmpRefs = this.getDirRefs(pos);
                for (cter = 0; cter < tmpRefs.length; ++cter) {
                    al.add(tmpRefs[cter]);
                }
            }
            b_dir = false;
            b_dirPlus = false;
        }
        if (!al.isEmpty()) {
            refs = new String[al.size()];
            for (int cter = 0; cter < al.size(); ++cter) {
                refs[cter] = ((String)al.get(cter)).trim();
            }
        }
        return refs;
    }

    public String getFirstFreeRef(int parentRef) {
        int cter;
        ArrayList<Integer> al = new ArrayList<Integer>(20);
        String[] ldata = new String[this.colNbr];
        Collection<String[]> col = this.datamap.values();
        Iterator<String[]> it = col.iterator();
        int lref = 0;
        int rref = 0;
        String tmp = "";
        String res = "";
        int prev = 0;
        while (it.hasNext()) {
            ldata = it.next();
            tmp = ldata[this.colNbr - 1];
            if (tmp.indexOf(",") == -1) continue;
            lref = Globals.getIntValue(tmp.substring(0, tmp.indexOf(",")), -2);
            if (tmp.length() > tmp.indexOf(",")) {
                rref = Globals.getIntValue(tmp.substring(tmp.indexOf(",") + 1), -2);
            }
            if (lref != 1) continue;
            al.add(new Integer(rref));
        }
        int[] tblRef = new int[al.size()];
        for (cter = 0; cter < tblRef.length; ++cter) {
            tblRef[cter] = Globals.getIntValue(al.get(cter));
        }
        Arrays.sort(tblRef);
        prev = 1;
        for (cter = 0; cter < tblRef.length && prev >= tblRef[cter]; ++cter) {
            prev = tblRef[cter] + 1;
        }
        res = String.valueOf(parentRef) + "," + String.valueOf(prev);
        return res;
    }

    @Override
    public TreePath getFullTreePath(String codeRef) {
        String[] parent = new String[2];
        ArrayList<Object> li = new ArrayList<Object>();
        parent[1] = codeRef;
        do {
            parent = this.getParent(parent[1]);
            li.add(0, parent[0]);
        } while (parent[1].compareTo("-1") != 0);
        if (parent[1].compareTo("-1") == 0) {
            li.add(0, this.root);
        }
        TreePath path = new TreePath(li.toArray());
        return path;
    }

    @Override
    public Object getValueAt(Object node, int column) {
        String[] ldata = new String[this.colNbr];
        boolean b_leaf = false;
        if (this.isLeaf(node)) {
            b_leaf = true;
            ldata = this.datamap.get(node);
        }
        try {
            if (b_leaf) {
                return ldata[column];
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    public void removeNodes(String[] nodes) {
        this.maptreemodel.deleteData(nodes);
    }

    public Map<String, String[]> getFullDataMap() {
        return this.fulldatamap;
    }

    public void setFullDataMap(Map<String, String[]> fulldatamap) {
        this.fulldatamap = fulldatamap;
    }

    @Override
    public void setValueAt(Object aValue, Object node, int column) {
        System.out.println("BiblioModel.setValueAt(" + aValue + "," + column + ")");
    }

    public void updateNode(String ref, String[] values) {
        this.maptreemodel.updateNodeData(ref, values);
    }
}

