/*
 * Decompiled with CFR 0.152.
 */
package jTreeBiblio_510;

import enercad2007.Ecad2007;
import jTreeBiblio_510.BiblioModel;
import jTreeBiblio_510.JTreeTable;
import jTreeBiblio_510.VM_cat;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Map;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.tree.TreePath;

public class JTreeBiblio_510
extends JPanel {
    private static final long serialVersionUID = 1L;
    JScrollPane pnl_bibl;
    JPanel pnl_0 = new JPanel();
    protected JTreeTable treeTable;
    protected transient BiblioModel model;
    protected Vector<String[]> vector;
    String[] cNames;
    String[] cTooltips;
    int order = 0;
    Font FT_STAND1 = new Font("Dialog", 0, 11);
    Font FT_BOLD1 = new Font("Dialog", 1, 11);
    Rectangle rect;
    protected String name;
    int dx = 0;
    int dy = 0;
    int mx = 0;
    int my = 0;
    String txt_error = "Erreur de connexion";

    public JTreeBiblio_510() {
        this.cNames = new String[8];
        this.cTooltips = new String[8];
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            Ecad2007.trace(ex);
        }
    }

    public JTreeBiblio_510(Vector<String[]> vector, String[] cNames, String[] cTooltips) {
        this.vector = vector;
        this.cNames = cNames;
        this.cTooltips = cTooltips;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            Ecad2007.trace(ex);
        }
    }

    public JTreeBiblio_510(Vector<String[]> vector, String[] cNames, String[] cTooltips, String error) {
        this.vector = vector;
        this.cNames = cNames;
        this.cTooltips = cTooltips;
        this.txt_error = error;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            Ecad2007.trace(ex);
        }
    }

    public JTreeBiblio_510(Vector<String[]> vector, String[] cNames, String[] cTooltips, int order) {
        this.vector = vector;
        this.cNames = cNames;
        this.cTooltips = cTooltips;
        this.order = order;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            Ecad2007.trace(ex);
        }
    }

    private void jbInit() throws Exception {
        boolean b_vector = false;
        if (this.vector == null) {
            this.vector = new VM_cat("JTreeBiblio.jar", "cat.vect").getV4Data();
        }
        if (this.vector == null) {
            b_vector = true;
        } else if (this.vector.isEmpty()) {
            b_vector = true;
        }
        if (b_vector) {
            String[] ldata = null;
            if (this.cNames != null) {
                ldata = new String[this.cNames.length + 2];
                ldata[0] = this.txt_error;
                ldata[this.cNames.length + 1] = "0";
                ldata[this.cNames.length] = "-";
                this.vector.add(ldata);
            }
        }
        this.model = this.cNames == null ? new BiblioModel(this.vector) : new BiblioModel(this.vector, this.cNames, this.cTooltips, this.order);
        this.setBackground(Color.white);
        this.setFont(new Font("Dialog", 0, 11));
        this.setMinimumSize(new Dimension(1, 1));
        this.setPreferredSize(new Dimension(400, 250));
        this.setLayout(null);
        if (this.model != null) {
            this.treeTable = new JTreeTable(this.model);
            if (this.cNames[0] == null && this.cTooltips[0] == null) {
                int dim = this.vector.firstElement().length - 2;
                Color[] colors = new Color[dim];
                for (int cter = 0; cter < dim; ++cter) {
                    colors[cter] = Color.white;
                }
                this.treeTable.setColumnsColors(colors);
            }
        }
        this.treeTable.setFontRec(this.FT_STAND1);
        this.treeTable.setFontTitle(this.FT_BOLD1);
        this.treeTable.setFontHeader(this.FT_BOLD1);
        this.treeTable.addMouseListener(new JTreeBiblio_mouseAdapter(this));
        this.pnl_bibl = new JScrollPane(this.treeTable);
        this.pnl_bibl.setVisible(true);
        this.pnl_0.setFont(new Font("Dialog", 0, 11));
        this.pnl_0.setOpaque(true);
        this.add((Component)this.pnl_bibl, null);
        this.add((Component)this.pnl_0, null);
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2p = (Graphics2D)g.create();
        g2p.setColor(Color.white);
        g2p.fillRect(0, 0, this.dx, this.dy);
    }

    public void collapseAll() {
        this.treeTable.collapseAll();
    }

    private void drawComponent() {
        this.pnl_0.setBounds(new Rectangle(0, 0, this.dx, this.dy));
        if (this.model != null) {
            this.pnl_bibl.setSize(this.dx, this.dy);
        }
    }

    public int[] getColumnsWidths() {
        return this.treeTable.getColumnsWidths();
    }

    public Map<String, String[]> getDataMap() {
        return this.model.getDataMap();
    }

    public Object getDatamapObject(String key) {
        return this.model.getDatamapObject(key);
    }

    public String[] getDirRefs(int dir) {
        return this.model.getDirRefs(dir);
    }

    public String[] getDirRefs(String dir) {
        return this.model.getDirRefs(dir);
    }

    public String getFirstFreeRef(int parentRef) {
        return this.model.getFirstFreeRef(parentRef);
    }

    @Override
    public String getName() {
        return this.treeTable.getName();
    }

    public String[] getParentRefs(String ref) {
        return this.treeTable.getParentRefs(ref);
    }

    public String getRootPosSel() {
        return this.treeTable.getRootPosSel();
    }

    public String[] getRootPosSels() {
        return this.treeTable.getRootPosSels();
    }

    public int getSelectedRow() {
        return this.treeTable.getSelectedRow();
    }

    public int[] getSelectedRows() {
        return this.treeTable.getSelectedRows();
    }

    public Object getValueAt(int column) {
        return this.treeTable.getValueAt(this.getSelectedRow(), column);
    }

    public String getRefSel() {
        return this.treeTable.getRefSel();
    }

    public String[] getRefSels() {
        return this.treeTable.getRefSels();
    }

    public void insertNode(String[] nodes, boolean showBit) {
        String[][] nodes2dim = new String[1][nodes.length];
        nodes2dim[0] = nodes;
        this.model.insertNodes(nodes2dim);
        if (showBit) {
            this.treeTable.updateUI();
            this.treeTable.setSelection(nodes[nodes.length - 1]);
        }
    }

    public boolean isLeafSel() {
        return this.treeTable.isLeafSel();
    }

    public void refresh(Vector<String[]> vector) {
        this.vector = vector;
        this.model = new BiblioModel(vector, this.cNames, this.cTooltips);
        this.treeTable.refreshTreeTable(this.model);
    }

    public void removeNode(String node) {
        String[] refs = new String[]{node};
        this.model.removeNodes(refs);
        this.treeTable.updateUI();
    }

    public void removeNodes(String[] nodes) {
        this.model.removeNodes(nodes);
        this.treeTable.updateUI();
    }

    public void removeSelections() {
        this.treeTable.removeSelections();
    }

    public Map<String, String[]> getFullDataMap() {
        return this.model.getFullDataMap();
    }

    public void setFullDataMap(Map<String, String[]> fulldatamap) {
        this.model.setFullDataMap(fulldatamap);
    }

    @Override
    public void setName(String name) {
        this.treeTable.setName(name);
    }

    public void setRowSelection(int row) {
        this.treeTable.setSelection(row);
    }

    public void setRowsSelection(int[] rows) {
        this.treeTable.setSelection(rows);
    }

    public void setRefSel(String ref) {
        this.setRefSel(ref, false);
    }

    public void setRefSel(String ref, boolean b_dir) {
        String[] tblRef = new String[]{ref};
        this.treeTable.setSelections(tblRef, b_dir);
        int sel = this.treeTable.getSelectedRow();
        int height = this.treeTable.getRowHeight() + 1;
        this.treeTable.scrollRectToVisible(new Rectangle(0, sel * height, this.dx, height));
    }

    public void setRefSels(String[] ref) {
        this.treeTable.setSelections(ref, false);
    }

    public void setRefSels(String[] ref, boolean b_dir) {
        this.treeTable.setSelections(ref, b_dir);
    }

    public void setTreeSelectionMode(int selectionMode) {
        this.treeTable.setTreeSelectionMode(selectionMode);
    }

    public void updateBiblio(String[] values) {
        String ref = this.getRefSel();
        this.model.updateNode(ref, values);
        this.treeTable.updateUI();
        this.treeTable.setSelection(ref);
    }

    void mouseClicked(MouseEvent me) {
        if (this.getClass() == JTreeBiblio_510.class) {
            me.setSource(this);
            this.dispatchEvent(me);
        }
    }

    public void showNode(String ref) {
        this.treeTable.setVisibleNode(ref);
    }

    @Override
    public void setBounds(Rectangle rect) {
        this.rect = rect;
        this.dx = rect.width;
        this.dy = rect.height;
        this.mx = rect.x;
        this.my = rect.y;
        this.setSize(rect.width, rect.height);
        this.setLocation(rect.x, rect.y);
        this.drawComponent();
    }

    public String[] getArraySel() {
        String ref = this.getRefSel();
        TreePath path = this.model.getFullTreePath(ref);
        String[] res = this.model.getCodeRefAsArray(path);
        return res;
    }

    public void setColumnsWidth(int[] dx) {
        this.treeTable.setColumnsWidth(dx);
    }

    public void setConnectionErrorMessage(String error) {
        this.txt_error = error;
    }

    public void setColumnsAlignment(int[] alignments) {
        this.treeTable.setColumnsAlignment(alignments);
    }

    public void setColumnsColors(Color[] colors) {
        this.treeTable.setColumnsColors(colors);
    }

    public int getRowHeight() {
        return this.treeTable.getRowHeight();
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(this.mx, this.my, this.dx, this.dy);
    }

    class JTreeBiblio_mouseAdapter
    extends MouseAdapter {
        JTreeBiblio_510 adaptee;

        JTreeBiblio_mouseAdapter(JTreeBiblio_510 adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.adaptee.mouseClicked(e);
        }
    }
}

