/*
 * Decompiled with CFR 0.152.
 */
package jTreeBiblio_510;

import jTreeBiblio_510.TreeTableModel;
import jTreeBiblio_510.TreeTableModelAdapter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class JTreeTable
extends JTable {
    private static final long serialVersionUID = 1L;
    protected TreeTableCellRenderer tree;
    protected transient TreeTableModel treeTableModel;
    protected Color[] colors;
    protected int headerHeight;
    Font FT_BOLD1 = new Font("Dialog", 1, 11);
    Font FT_STAND1 = new Font("Dialog", 0, 11);
    int nbrcol = 8;

    public JTreeTable(TreeTableModel treeTableModel) {
        this.treeTableModel = treeTableModel;
        this.tree = new TreeTableCellRenderer(treeTableModel);
        super.setModel(new TreeTableModelAdapter(treeTableModel, this.tree));
        ListToTreeSelectionModelWrapper selectionWrapper = new ListToTreeSelectionModelWrapper();
        this.tree.setSelectionModel(selectionWrapper);
        this.setSelectionModel(selectionWrapper.getListSelectionModel());
        this.setDefaultRenderer(TreeTableModel.class, this.tree);
        this.setDefaultEditor(TreeTableModel.class, new TreeTableCellEditor());
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setAutoCreateColumnsFromModel(false);
        this.setRequestFocusEnabled(false);
        this.setSelectionMode(0);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        for (int cter = 0; cter < this.tree.getRowCount(); ++cter) {
            int children = treeTableModel.getChildCount(this.tree.getPathForRow(cter).getLastPathComponent());
            if (children != 0) continue;
            this.tree.expandRow(cter);
        }
        TableColumnModel columnmodel = this.getColumnModel();
        this.nbrcol = columnmodel.getColumnCount();
        DefaultTableCellRenderer cr01r = new DefaultTableCellRenderer();
        DefaultTableCellRenderer cr02r = new DefaultTableCellRenderer();
        DefaultTableCellRenderer cr03r = new DefaultTableCellRenderer();
        cr01r.setBackground(new Color(223, 223, 223));
        cr02r.setBackground(new Color(239, 239, 239));
        cr03r.setBackground(new Color(191, 191, 255));
        if (this.nbrcol > 0) {
            columnmodel.getColumn(0).setPreferredWidth(400);
        }
        if (this.nbrcol > 1) {
            columnmodel.getColumn(1).setPreferredWidth(50);
            cr01r.setHorizontalAlignment(4);
            columnmodel.getColumn(1).setCellRenderer(cr01r);
        }
        if (this.nbrcol > 2) {
            columnmodel.getColumn(2).setPreferredWidth(50);
            columnmodel.getColumn(2).setCellRenderer(cr02r);
        }
        if (this.nbrcol > 3) {
            columnmodel.getColumn(3).setPreferredWidth(50);
            columnmodel.getColumn(3).setCellRenderer(cr01r);
        }
        if (this.nbrcol > 4) {
            columnmodel.getColumn(4).setPreferredWidth(50);
        }
        if (this.nbrcol > 5) {
            columnmodel.getColumn(5).setPreferredWidth(50);
        }
        if (this.nbrcol > 6) {
            columnmodel.getColumn(6).setPreferredWidth(50);
        }
        if (this.nbrcol > 7) {
            columnmodel.getColumn(7).setPreferredWidth(100);
        }
        if (this.tree.getRowHeight() < 1) {
            this.setRowHeight(18);
        }
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel){
            Font font;

            @Override
            public String getToolTipText(MouseEvent me) {
                String tip = null;
                Point pp = me.getPoint();
                int index = this.columnModel.getColumnIndexAtX(pp.x);
                int realIndex = this.columnModel.getColumn(index).getModelIndex();
                tip = ((TreeTableModelAdapter)JTreeTable.this.getModel()).getHeaderToolTip(realIndex);
                if (tip.compareTo("") == 0) {
                    tip = null;
                }
                return tip;
            }

            @Override
            public Font getFont() {
                return this.font;
            }

            @Override
            public void setFont(Font font) {
                this.font = font;
                int dim = this.columnModel.getColumnCount();
                int height = this.getHeight();
                FontMetrics fm = this.getFontMetrics(font);
            }
        };
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.tree != null) {
            this.tree.updateUI();
        }
        LookAndFeel.installColorsAndFont(this, "Tree.background", "Tree.foreground", "Tree.font");
        this.resetColumnColors();
    }

    public int[] getColumnsWidths() {
        TableColumnModel columnmodel = this.getColumnModel();
        int ncol = columnmodel.getColumnCount();
        int[] res = new int[ncol];
        if (ncol == 0) {
            return null;
        }
        for (int cter = 0; cter < ncol; ++cter) {
            res[cter] = columnmodel.getColumn(cter).getPreferredWidth();
        }
        return res;
    }

    @Override
    public int getEditingRow() {
        return this.getColumnClass(this.editingColumn) == TreeTableModel.class ? -1 : this.editingRow;
    }

    @Override
    public int getRowHeight() {
        return this.tree.getRowHeight();
    }

    public void collapseAll() {
        for (int cter = 0; cter < this.tree.getRowCount(); ++cter) {
            if (!this.tree.isExpanded(cter)) continue;
            this.tree.collapsePath(this.tree.getPathForRow(cter));
        }
        this.tree.removeSelectionPath(this.tree.getSelectionPath());
    }

    public void expandAll() {
        for (int cter = 0; cter < this.tree.getRowCount(); ++cter) {
            if (this.tree.isExpanded(cter)) continue;
            this.tree.expandRow(cter);
        }
    }

    private void resetColumnColors() {
        if (this.colors != null) {
            this.setColumnsColors(this.colors);
        }
    }

    public void setColumnsAlignment(int[] alignments) {
        TableColumnModel columnmodel = this.getColumnModel();
        int ncol = columnmodel.getColumnCount();
        if (ncol == 0) {
            return;
        }
        for (int ii = 1; ii < ncol; ++ii) {
            if (ii >= alignments.length) continue;
            DefaultTableCellRenderer dtcr = new DefaultTableCellRenderer();
            dtcr.setHorizontalAlignment(alignments[ii]);
            TableColumn tc = columnmodel.getColumn(ii);
            DefaultTableCellRenderer tcr = (DefaultTableCellRenderer)tc.getCellRenderer();
            if (tcr != null) {
                dtcr.setBackground(tcr.getBackground());
            }
            tc.setCellRenderer(dtcr);
        }
    }

    public void setColumnsColors(Color[] colors) {
        TableColumnModel columnmodel = this.getColumnModel();
        int ncol = columnmodel.getColumnCount();
        if (ncol == 0) {
            return;
        }
        int ncolors = colors.length;
        this.colors = colors;
        for (int cter = 1; cter < ncol; ++cter) {
            DefaultTableCellRenderer dtcr = new DefaultTableCellRenderer();
            TableColumn column = this.getColumnModel().getColumn(this.convertColumnIndexToView(cter));
            if (cter < ncolors) {
                dtcr.setBackground(colors[cter]);
            } else {
                dtcr.setBackground(Color.white);
            }
            column.setCellRenderer(dtcr);
        }
    }

    public void setColumnsWidth(int[] dx) {
        TableColumnModel columnmodel = this.getColumnModel();
        int ncol = columnmodel.getColumnCount();
        if (ncol == 0) {
            return;
        }
        for (int cter = 0; cter < ncol; ++cter) {
            if (cter >= dx.length) continue;
            if (dx[cter] > 0) {
                columnmodel.getColumn(cter).setPreferredWidth(dx[cter]);
                continue;
            }
            columnmodel.removeColumn(columnmodel.getColumn(cter));
            if (--ncol >= 0) continue;
            ncol = 0;
        }
    }

    public void setFontRec(Font font) {
        this.setFont(font);
        this.FT_STAND1 = font;
    }

    public void setFontTitle(Font font) {
        this.tree.setFont(font);
        this.FT_BOLD1 = font;
    }

    public void setFontHeader(Font font) {
        JTableHeader head = this.getTableHeader();
        head.setFont(font);
    }

    public void setTreeSelectionMode(int selectionMode) {
        if (selectionMode == 0) {
            this.setSelectionMode(0);
        } else if (selectionMode == 1) {
            this.setSelectionMode(1);
        } else if (selectionMode == 2) {
            this.setSelectionMode(2);
        }
    }

    @Override
    public void setRowHeight(int rowHeight) {
        super.setRowHeight(rowHeight);
        if (this.tree != null && this.tree.getRowHeight() != rowHeight) {
            this.tree.setRowHeight(this.getRowHeight());
        }
    }

    public void setSelection(int row) {
        this.tree.setSelectionRow(row);
    }

    public void setSelection(int[] rows) {
        this.tree.setSelectionRows(rows);
    }

    public void setSelection(String codeRef) {
        TreePath path = this.treeTableModel.getFullTreePath(codeRef);
        this.collapseAll();
        this.tree.makeVisible(path);
        this.tree.setSelectionPath(path);
    }

    public void setSelections(String[] codeRef) {
        this.setSelections(codeRef, false);
    }

    public void setSelections(String[] codeRef, boolean b_dir) {
        int cter;
        TreePath[] path = new TreePath[codeRef.length];
        this.collapseAll();
        for (cter = 0; cter < codeRef.length; ++cter) {
            if (codeRef[cter].indexOf(",") != -1) {
                if (b_dir) continue;
                path[cter] = this.treeTableModel.getFullTreePath(codeRef[cter]);
                this.tree.makeVisible(path[cter]);
                continue;
            }
            if (!b_dir) continue;
            path[cter] = this.treeTableModel.getFullTreePath(codeRef[cter]);
            this.tree.makeVisible(path[cter]);
        }
        for (cter = 0; cter < path.length; ++cter) {
            if (path[cter] == null) continue;
            this.tree.addSelectionPath(path[cter]);
        }
    }

    public String[] getVisibleNodes() {
        int count = this.tree.getRowCount();
        Vector<String> vector = new Vector<String>(20);
        TreePath path = null;
        String ref = "";
        for (int cter = 0; cter < count; ++cter) {
            path = this.tree.getPathForRow(cter);
            if (!this.tree.isVisible(path) || this.treeTableModel.isRoot(path.getParentPath())) continue;
            ref = this.treeTableModel.getCodeRef(path);
            vector.add(ref);
        }
        Object[] object = vector.toArray();
        String[] codeRef = new String[vector.size()];
        for (int cter = 0; cter < object.length; ++cter) {
            codeRef[cter] = (String)object[cter];
        }
        return codeRef;
    }

    public TreeTableCellRenderer getTree() {
        return this.tree;
    }

    public String getRootPosSel() {
        TreePath path = this.tree.getSelectionPath();
        String res = this.treeTableModel.getRootPos(path);
        return res;
    }

    public String[] getRootPosSels() {
        TreePath[] path = this.tree.getSelectionPaths();
        String[] res = this.treeTableModel.getRootPoss(path);
        return res;
    }

    public String[] getParentRefs(String ref) {
        TreePath path = this.treeTableModel.getFullTreePath(ref);
        int dimpath = path.getPathCount();
        String tmp = path.getLastPathComponent().toString();
        if (tmp != null && tmp.indexOf(",") > 0) {
            path = path.getParentPath();
        }
        if (path.getLastPathComponent().equals(ref)) {
            --dimpath;
        }
        if (dimpath < 1) {
            dimpath = 2;
        }
        ArrayList<String> li = new ArrayList<String>(dimpath);
        if (path == null) {
            return null;
        }
        while (path != null) {
            if (path.getLastPathComponent().equals(this.treeTableModel.getRoot())) {
                li.add(0, "-1");
            } else {
                li.add(0, this.treeTableModel.getCodeRef(path).trim());
            }
            path = path.getParentPath();
        }
        dimpath = li.size();
        String[] refs = new String[dimpath];
        for (int cter = 0; cter < dimpath; ++cter) {
            refs[dimpath - cter - 1] = (String)li.get(cter);
        }
        return refs;
    }

    public String getRefSel() {
        TreePath path = this.tree.getSelectionPath();
        String res = this.treeTableModel.getCodeRef(path);
        return res;
    }

    public String[] getRefSels() {
        String[] array = null;
        TreePath[] path = this.tree.getSelectionPaths();
        if (path != null) {
            array = new String[path.length];
            for (int cter = 0; cter < array.length; ++cter) {
                array[cter] = this.treeTableModel.getCodeRef(path[cter]);
            }
        }
        return array;
    }

    public void showInsertedNodes(String[][] nodes) {
        int row = nodes.length;
        int col = nodes[0].length;
        String[] ref = new String[row];
        for (int cter = 0; cter < row; ++cter) {
            ref[cter] = nodes[cter][col - 1];
        }
        this.setSelections(ref);
    }

    public void setVisibleNode(String codeRef) {
        TreePath path = this.treeTableModel.getFullTreePath(codeRef);
        this.tree.makeVisible(path);
    }

    public void setVisibleNodes(String[] codeRef) {
        TreePath path = null;
        for (int cter = 0; cter < codeRef.length; ++cter) {
            path = this.treeTableModel.getFullTreePath(codeRef[cter]);
            this.tree.makeVisible(path);
        }
    }

    public boolean isLeaf(String ref) {
        int rref = -1;
        String cdref = ref.trim();
        rref = cdref.indexOf(44) == -1 ? 0 : cdref.indexOf(44) + 1;
        return rref != 0;
    }

    public boolean isLeafSel() {
        TreePath path = this.tree.getSelectionPath();
        Object node = path.getLastPathComponent();
        return this.treeTableModel.isLeaf(node);
    }

    public void refreshTreeTable(TreeTableModel treeTableModel) {
        String[] Coderef = this.getVisibleNodes();
        this.treeTableModel = treeTableModel;
        this.tree = new TreeTableCellRenderer(treeTableModel);
        super.setModel(new TreeTableModelAdapter(treeTableModel, this.tree));
        ListToTreeSelectionModelWrapper selectionWrapper = new ListToTreeSelectionModelWrapper();
        this.tree.setSelectionModel(selectionWrapper);
        this.setSelectionModel(selectionWrapper.getListSelectionModel());
        this.setDefaultRenderer(TreeTableModel.class, this.tree);
        this.setDefaultEditor(TreeTableModel.class, new TreeTableCellEditor());
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setFont(this.FT_BOLD1);
        this.setVisibleNodes(Coderef);
    }

    public void removeSelections() {
        TreePath[] path = this.tree.getSelectionPaths();
        this.tree.removeSelectionPaths(path);
    }

    class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel {
        protected boolean updatingListSelectionModel;

        public ListToTreeSelectionModelWrapper() {
            this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
        }

        ListSelectionModel getListSelectionModel() {
            return this.listSelectionModel;
        }

        @Override
        public void resetRowSelection() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    super.resetRowSelection();
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        protected ListSelectionListener createListSelectionListener() {
            return new ListSelectionHandler();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateSelectedPathsFromSelectedRows() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    int min = this.listSelectionModel.getMinSelectionIndex();
                    int max = this.listSelectionModel.getMaxSelectionIndex();
                    this.clearSelection();
                    if (min != -1 && max != -1) {
                        for (int counter = min; counter <= max; ++counter) {
                            TreePath selPath;
                            if (!this.listSelectionModel.isSelectedIndex(counter) || (selPath = JTreeTable.this.tree.getPathForRow(counter)) == null) continue;
                            this.addSelectionPath(selPath);
                        }
                    }
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        class ListSelectionHandler
        implements ListSelectionListener {
            ListSelectionHandler() {
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListToTreeSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows();
            }
        }
    }

    static class TreeTableTextField
    extends JTextField {
        int offset;

        @Override
        public void setBounds(int x, int y, int w, int h) {
            int newX = Math.max(x, this.offset);
            super.setBounds(newX, y, w - (newX - x), h);
        }
    }

    public class TreeTableCellEditor
    extends DefaultCellEditor {
        public TreeTableCellEditor() {
            super(new TreeTableTextField());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Component component = super.getTableCellEditorComponent(table, value, isSelected, row, column);
            TreeTableCellRenderer t = JTreeTable.this.getTree();
            try {
                boolean rv = t.isRootVisible();
                int offsetRow = rv ? row : row - 1;
                Rectangle bounds = t.getRowBounds(offsetRow);
                int offset = bounds.x;
                TreeCellRenderer tcr = t.getCellRenderer();
                if (tcr instanceof DefaultTreeCellRenderer) {
                    Object node = t.getPathForRow(offsetRow).getLastPathComponent();
                    Icon icon = t.getModel().isLeaf(node) ? ((DefaultTreeCellRenderer)tcr).getLeafIcon() : (JTreeTable.this.tree.isExpanded(offsetRow) ? ((DefaultTreeCellRenderer)tcr).getOpenIcon() : ((DefaultTreeCellRenderer)tcr).getClosedIcon());
                    if (icon != null) {
                        offset += ((DefaultTreeCellRenderer)tcr).getIconTextGap() + icon.getIconWidth();
                    }
                }
                ((TreeTableTextField)this.getComponent()).offset = offset;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return component;
        }

        @Override
        public boolean isCellEditable(EventObject e) {
            if (e instanceof MouseEvent) {
                MouseEvent me = (MouseEvent)e;
                if (me.getModifiers() == 0 || me.getModifiers() == 16) {
                    for (int counter = JTreeTable.this.getColumnCount() - 1; counter >= 0; --counter) {
                        if (JTreeTable.this.getColumnClass(counter) != TreeTableModel.class) continue;
                        int row = me.getY() / JTreeTable.this.getRowHeight();
                        String res = JTreeTable.this.treeTableModel.getCodeRef(JTreeTable.this.tree.getPathForRow(row));
                        if (JTreeTable.this.isLeaf(res)) break;
                        if (JTreeTable.this.tree.isExpanded(row)) {
                            JTreeTable.this.tree.collapseRow(row);
                            break;
                        }
                        JTreeTable.this.tree.expandRow(row);
                        break;
                    }
                }
                return me.getClickCount() >= 3;
            }
            return e == null;
        }
    }

    class PrivateTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        float alignment;
        String ref;

        public PrivateTableCellRenderer(float alignment) {
            this.alignment = alignment;
        }

        public PrivateTableCellRenderer(float alignment, String ref) {
            this.alignment = alignment;
            this.ref = ref;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object object, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setAlignmentX(4.0f);
            return this;
        }

        public String getRef() {
            return this.ref;
        }
    }

    class PrivateTreeCellRenderer
    extends JLabel
    implements TreeCellRenderer {
        Map dataMap;
        transient TreeTableModel treetablemodel;
        Map<String, String[]> fulldatamap;
        String ref = "";

        public PrivateTreeCellRenderer(Map dataMap) {
            this.dataMap = dataMap;
            this.setBackground(Color.blue);
            this.setOpaque(true);
        }

        public PrivateTreeCellRenderer(TreeTableModel treetablemodel) {
            this.treetablemodel = treetablemodel;
            this.dataMap = treetablemodel.getDataMap();
        }

        public PrivateTreeCellRenderer() {
            this.setOpaque(true);
        }

        public String getRefSel() {
            return this.ref;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            String[] data;
            String ref = value.toString();
            String node = null;
            Color textForeground = Color.black;
            if (this.dataMap != null && (data = (String[])this.dataMap.get(ref)) != null) {
                node = data[0];
            }
            if (node != null) {
                this.setText(node);
            }
            if (leaf) {
                this.setIcon(UIManager.getIcon("Tree.leafIcon"));
            } else if (expanded) {
                this.setIcon(UIManager.getIcon("Tree.openIcon"));
            } else {
                this.setIcon(UIManager.getIcon("Tree.closedIcon"));
            }
            if (sel) {
                this.setForeground(UIManager.getColor("Tree.selectionForeground"));
                this.setBackground(UIManager.getColor("Tree.selectionBackground"));
                this.ref = ref;
            } else {
                this.setForeground(textForeground);
                this.setBackground(UIManager.getColor("Tree.textBackground"));
                this.ref = "";
            }
            return this;
        }
    }

    class TreeTableCellRenderer
    extends JTree
    implements TableCellRenderer {
        protected int visibleRow;
        protected TreeTableModel treeTableModel;
        protected String id;

        public TreeTableCellRenderer(TreeModel model) {
            super(model);
            this.treeTableModel = (TreeTableModel)model;
            this.setOpaque(true);
            this.setCellRenderer(new PrivateTreeCellRenderer(this.treeTableModel));
        }

        @Override
        public void updateUI() {
            super.updateUI();
            TreeCellRenderer tcr = this.getCellRenderer();
            if (tcr instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer dtcr = (DefaultTreeCellRenderer)tcr;
                dtcr.setTextSelectionColor(UIManager.getColor("Table.selectionForeground"));
                dtcr.setBackgroundSelectionColor(UIManager.getColor("Table.selectionBackground"));
            }
        }

        @Override
        public void setRowHeight(int rowHeight) {
            if (rowHeight > 0) {
                super.setRowHeight(rowHeight);
                if (JTreeTable.this != null && JTreeTable.this.getRowHeight() != rowHeight) {
                    JTreeTable.this.setRowHeight(this.getRowHeight());
                }
            }
        }

        @Override
        public void setBounds(int xx, int yy, int width, int height) {
            super.setBounds(xx, 0, width, JTreeTable.this.getHeight());
        }

        @Override
        public void paint(Graphics g) {
            g.translate(0, -this.visibleRow * this.getRowHeight());
            super.paint(g);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            this.visibleRow = row;
            return this;
        }

        public Object getValueAt(Object parent, int column) {
            return parent;
        }
    }
}

