/*
 * Decompiled with CFR 0.152.
 */
package jecadcomp;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import javax.swing.CellEditor;
import javax.swing.JMenuBar;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import jecadcomp.GraphElements;
import jecadcomp.PrivateGlassPane;

public class CBListener
extends MouseInputAdapter {
    Toolkit toolkit = Toolkit.getDefaultToolkit();
    Component[] liveComponent;
    JMenuBar menuBar;
    GraphElements graphElements;
    PrivateGlassPane glassPane;
    Container contentPane;
    boolean inDrag = false;

    public CBListener(Component[] liveComponent, JMenuBar menuBar, PrivateGlassPane glassPane, Container contentPane) {
        this.liveComponent = liveComponent;
        this.menuBar = menuBar;
        this.glassPane = glassPane;
        this.contentPane = contentPane;
        if (liveComponent != null) {
            for (int ii = 0; ii < liveComponent.length; ++ii) {
                if (!(liveComponent[ii] instanceof GraphElements)) continue;
                this.graphElements = (GraphElements)liveComponent[ii];
                break;
            }
            if (this.graphElements != null && liveComponent.length > 1) {
                Component[] tmp_comp = new Component[liveComponent.length - 1];
                int cter = 0;
                for (int ii = 0; ii < liveComponent.length; ++ii) {
                    if (liveComponent[ii] instanceof GraphElements) continue;
                    tmp_comp[cter] = liveComponent[ii];
                    ++cter;
                }
                this.liveComponent = tmp_comp;
            }
        }
    }

    private void redispatchMouseEvent(MouseEvent me, boolean repaint) {
        Component component = null;
        Container container = this.contentPane;
        boolean inComponent = false;
        boolean inMenuBar = false;
        Point glassPanePoint = me.getPoint();
        Point containerPoint = SwingUtilities.convertPoint(this.glassPane, glassPanePoint, this.contentPane);
        int eventID = me.getID();
        if (containerPoint.y < 0) {
            inMenuBar = true;
            container = this.menuBar;
            containerPoint = SwingUtilities.convertPoint(this.glassPane, glassPanePoint, this.menuBar);
            this.testForDrag(eventID);
        }
        if (container != null) {
            component = SwingUtilities.getDeepestComponentAt(container, containerPoint.x, containerPoint.y);
        }
        if (component == null) {
            return;
        }
        if (this.liveComponent != null) {
            for (int cter = 0; cter < this.liveComponent.length; ++cter) {
                if (!component.equals(this.liveComponent[cter])) continue;
                inComponent = true;
                this.testForDrag(eventID);
            }
        }
        if (inMenuBar || inComponent || this.inDrag) {
            Point componentPoint = SwingUtilities.convertPoint(this.glassPane, glassPanePoint, component);
            component.dispatchEvent(new MouseEvent(component, eventID, me.getWhen(), me.getModifiers(), componentPoint.x, componentPoint.y, me.getClickCount(), me.isPopupTrigger()));
        }
    }

    private void testForDrag(int eventID) {
        if (eventID == 501) {
            this.inDrag = true;
        }
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        Point glassPanePoint = me.getPoint();
        Component component = null;
        Point containerPoint = SwingUtilities.convertPoint(this.glassPane, glassPanePoint, this.contentPane);
        boolean b_component = false;
        this.redispatchMouseEvent(me, false);
        if (this.graphElements == null) {
            return;
        }
        if (this.contentPane != null) {
            component = SwingUtilities.getDeepestComponentAt(this.contentPane, containerPoint.x, containerPoint.y);
        }
        if (component == null) {
            return;
        }
        if (this.liveComponent != null) {
            for (int cter = 0; cter < this.liveComponent.length; ++cter) {
                if (!component.equals(this.liveComponent[cter])) continue;
                b_component = true;
            }
            if (!b_component) {
                this.graphElements.hidePopup();
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        this.redispatchMouseEvent(me, false);
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        this.redispatchMouseEvent(me, false);
    }

    @Override
    public void mouseEntered(MouseEvent me) {
        this.redispatchMouseEvent(me, false);
    }

    @Override
    public void mouseExited(MouseEvent me) {
        this.redispatchMouseEvent(me, false);
    }

    @Override
    public void mousePressed(MouseEvent me) {
        Point glassPanePoint = me.getPoint();
        Component component = null;
        Container container = this.contentPane;
        Point containerPoint = SwingUtilities.convertPoint(this.glassPane, glassPanePoint, this.contentPane);
        boolean b_component = false;
        this.redispatchMouseEvent(me, false);
        if (container != null) {
            component = SwingUtilities.getDeepestComponentAt(container, containerPoint.x, containerPoint.y);
        }
        if (component == null) {
            return;
        }
        if (this.liveComponent != null) {
            for (int cter = 0; cter < this.liveComponent.length; ++cter) {
                if (!component.equals(this.liveComponent[cter])) continue;
                b_component = true;
            }
            if (!b_component && this.liveComponent != null) {
                int cter;
                JTable jTb = null;
                int row = -1;
                int col = -1;
                for (cter = 0; cter < this.liveComponent.length; ++cter) {
                    if (this.liveComponent[cter] instanceof JTable && row == -1) {
                        jTb = (JTable)this.liveComponent[cter];
                        row = jTb.getSelectedRow();
                        col = jTb.getSelectedColumn();
                        continue;
                    }
                    if (!(this.liveComponent[cter] instanceof GraphElements)) continue;
                }
                for (cter = 0; cter < this.liveComponent.length; ++cter) {
                    if (!(this.liveComponent[cter] instanceof CellEditor)) continue;
                    ((CellEditor)((Object)this.liveComponent[cter])).stopCellEditing();
                    this.glassPane.setVisible(false);
                }
                if (jTb != null) {
                    jTb.changeSelection(row, col, false, false);
                }
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        this.redispatchMouseEvent(me, true);
        this.inDrag = false;
    }
}

