/*
 * Decompiled with CFR 0.152.
 */
package jecadcomp;

import enercad2007.Ecad2007;
import enercad2007.Globals;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.text.DecimalFormat;
import javax.swing.JPanel;

public class Ceb
extends JPanel {
    Rectangle rect;
    int dx = 0;
    int dy = 0;
    Color[] clr_ceb = new Color[7];
    Graphics2D g2;
    boolean b_print = false;
    DecimalFormat df1;
    Font FT_STAND = Globals.FT_STAND1;
    Font ft_stand;
    int cqh = 0;
    double rqh = 0.0;
    double qh = 0.0;
    int cep = 0;
    double rep = 0.0;
    double ep = 0.0;
    double mco2;
    double rco2;
    int cco2 = 0;
    double epr;
    double fepr;
    int units = 0;
    static String unit = "MJ/m\u00b2";
    final double ECH_MAX = 300.0;
    final double ECH_UNIT = 50.0;

    public Ceb() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Ceb(boolean b_print) {
        this.b_print = b_print;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Ceb(double[] values) {
        this(false, values);
    }

    public Ceb(boolean b_print, double[] values) {
        this.b_print = b_print;
        if (values != null) {
            if (values.length > 0) {
                this.qh = values[0];
            }
            if (values.length > 1) {
                this.rqh = values[1];
                this.cqh = this.getClassRQH(values[1]);
            }
            if (values.length > 2) {
                this.ep = values[2];
            }
            if (values.length > 3) {
                this.rep = values[3];
                this.cep = this.getClassREP(values[3]);
            }
            if (values.length > 4) {
                this.mco2 = values[4];
            }
            if (values.length > 5) {
                this.rco2 = values[5];
                this.cco2 = this.getClassRCO2(values[5]);
            }
            if (values.length > 6) {
                this.epr = values[6];
            }
            if (values.length > 7) {
                this.fepr = values[7];
            }
        }
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() {
        this.df1 = Ecad2007.getDecimalFormat("0.0");
        this.clr_ceb[0] = new Color(51, 153, 102);
        this.clr_ceb[1] = new Color(51, 204, 51);
        this.clr_ceb[2] = new Color(224, 255, 153);
        this.clr_ceb[3] = new Color(255, 255, 0);
        this.clr_ceb[4] = new Color(255, 204, 0);
        this.clr_ceb[5] = new Color(255, 153, 0);
        this.clr_ceb[6] = new Color(255, 102, 0);
        this.setFontSize(this.FT_STAND.getSize());
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.b_print) {
            graphics.setColor(new Color(255, 255, 255, 0));
            graphics.fillRect(this.rect.x, this.rect.y, this.rect.width, this.rect.height);
        }
        this.paintComponentX(graphics);
    }

    public void paintComponentX(Graphics graphics) {
        char ch;
        this.g2 = (Graphics2D)graphics.create();
        this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.b_print) {
            this.g2.setColor(new Color(255, 255, 255, 0));
        } else {
            this.g2.setColor(new Color(63, 63, 63));
        }
        this.g2.fillRect(0, 0, this.dx, this.dy);
        double zx = 0.0098 * (double)this.dx;
        double zy = 0.018 * (double)this.dy;
        double offsetX = 20.0 * (double)this.dx / 300.0;
        double offsetY = 20.0 * (double)this.dy / 300.0;
        int fs = (int)(zy * 7.0 - 6.0);
        for (double ii = 0.0; ii < 7.0; ii += 1.0) {
            GeneralPath polygonCeb = new GeneralPath(0, 6);
            polygonCeb.moveTo(offsetX, 7.0 * ii * zy + offsetY);
            polygonCeb.lineTo(offsetX + 8.0 * zx + 4.0 * ii * zx, 7.0 * ii * zy + offsetY);
            polygonCeb.lineTo(offsetX + 11.0 * zx + 4.0 * ii * zx, 7.0 * ii * zy + offsetY + 3.0 * zy);
            polygonCeb.lineTo(offsetX + 8.0 * zx + 4.0 * ii * zx, 7.0 * ii * zy + offsetY + 6.0 * zy);
            polygonCeb.lineTo(offsetX, 7.0 * ii * zy + offsetY + 6.0 * zy);
            polygonCeb.closePath();
            if (this.b_print) {
                this.g2.setColor(Color.black);
            } else {
                this.g2.setColor(Color.white);
            }
            this.g2.fill(polygonCeb);
            polygonCeb = new GeneralPath(0, 6);
            polygonCeb.moveTo(offsetX + 1.0, 7.0 * ii * zy + offsetY + 1.0);
            polygonCeb.lineTo(offsetX + 8.0 * zx + 4.0 * ii * zx - 1.0, 7.0 * ii * zy + offsetY + 1.0);
            polygonCeb.lineTo(offsetX + 11.0 * zx + 4.0 * ii * zx - 1.0, 7.0 * ii * zy + offsetY + 3.0 * zy);
            polygonCeb.lineTo(offsetX + 8.0 * zx + 4.0 * ii * zx - 1.0, 7.0 * ii * zy + offsetY + 6.0 * zy - 1.0);
            polygonCeb.lineTo(offsetX + 1.0, 7.0 * ii * zy + offsetY + 6.0 * zy - 1.0);
            polygonCeb.closePath();
            this.g2.setColor(this.clr_ceb[(int)ii]);
            this.g2.fill(polygonCeb);
            this.setFontSize(fs);
            this.g2.setFont(this.ft_stand);
            this.g2.setColor(Color.black);
            ch = (char)(65 + (int)ii);
            this.g2.drawString(String.valueOf(ch), (int)(offsetX + 2.0 * zy), (int)(offsetY + 5.0 * zy + 7.0 * ii * zy));
        }
        double dta = 21.0;
        fs = (int)(zy * 3.0);
        this.setFontSize(fs);
        this.g2.setFont(this.ft_stand);
        if (this.b_print) {
            this.g2.setColor(Color.black);
        } else {
            this.g2.setColor(Color.white);
        }
        if (!this.b_print) {
            for (int ii = 0; ii < 4; ++ii) {
                this.g2.drawString(String.valueOf(ii * 100), (int)(offsetX + (dta + 66.0) * zx), (int)(offsetY + 14.0 * zy * (double)ii + (double)(this.ft_stand.getSize() / 2)));
            }
        }
        for (double ii = 0.0; ii < 8.0; ii += 1.0) {
            this.g2.drawLine((int)(offsetX + (dta + 62.0) * zx), (int)(offsetY + 7.0 * zy * ii), (int)(offsetX + (dta + 64.0) * zx), (int)(offsetY + 7.0 * zy * ii));
        }
        this.g2.drawLine((int)(offsetX + (dta + 62.0) * zx), (int)offsetY, (int)(offsetX + (dta + 62.0) * zx), (int)(offsetY + 49.0 * zy));
        GeneralPath polygonCeb = new GeneralPath(0, 6);
        ch = '\u0000';
        if (this.rep > 0.0) {
            polygonCeb.moveTo(offsetX + 41.0 * zx, 14.0 * this.rep * zy + offsetY - 3.0 * zy);
            polygonCeb.lineTo(offsetX + 55.0 * zx, 14.0 * this.rep * zy + offsetY - 3.0 * zy);
            polygonCeb.lineTo(offsetX + 58.0 * zx, 14.0 * this.rep * zy + offsetY + 0.0 * zy);
            polygonCeb.lineTo(offsetX + 55.0 * zx, 14.0 * this.rep * zy + offsetY + 3.0 * zy);
            polygonCeb.lineTo(offsetX + 41.0 * zx, 14.0 * this.rep * zy + offsetY + 3.0 * zy);
            polygonCeb.lineTo(offsetX + 38.0 * zx, 14.0 * this.rep * zy + offsetY + 0.0 * zy);
            polygonCeb.closePath();
            if (this.b_print) {
                this.g2.setColor(Color.black);
            } else {
                this.g2.setColor(Color.white);
            }
            this.g2.fill(polygonCeb);
            polygonCeb = new GeneralPath(0, 6);
            polygonCeb.moveTo(offsetX + 41.0 * zx, 14.0 * this.rep * zy + offsetY - 3.0 * zy + 1.0);
            polygonCeb.lineTo(offsetX + 55.0 * zx, 14.0 * this.rep * zy + offsetY - 3.0 * zy + 1.0);
            polygonCeb.lineTo(offsetX + 58.0 * zx - 1.0, 14.0 * this.rep * zy + offsetY + 0.0 * zy);
            polygonCeb.lineTo(offsetX + 55.0 * zx, 14.0 * this.rep * zy + offsetY + 3.0 * zy - 1.0);
            polygonCeb.lineTo(offsetX + 41.0 * zx, 14.0 * this.rep * zy + offsetY + 3.0 * zy - 1.0);
            polygonCeb.lineTo(offsetX + 38.0 * zx + 1.0, 14.0 * this.rep * zy + offsetY + 0.0 * zy);
            polygonCeb.closePath();
            this.g2.setColor(this.clr_ceb[this.cep]);
            this.g2.fill(polygonCeb);
            fs = (int)(zy * 7.0 - 6.0);
            this.setFontSize(fs);
            this.g2.setFont(this.ft_stand);
            this.g2.setColor(Color.black);
            ch = (char)(65 + this.cep);
            this.g2.drawString(String.valueOf(ch), (int)(offsetX + 41.5 * zx), (int)(14.0 * this.rep * zy + offsetY + 2.0 * zy));
            fs = (int)(zy * 3.5);
            this.setFontSize(fs);
            this.g2.setFont(this.ft_stand);
            this.g2.drawString(this.df1.format(this.ep), (int)(offsetX + 45.5 * zx), (int)(14.0 * this.rep * zy + offsetY + 2.0 * zy));
        }
        if (this.rqh > 0.0) {
            dta = 22.0;
            polygonCeb = new GeneralPath(0, 6);
            polygonCeb.moveTo(offsetX + (dta + 41.0) * zx, 14.0 * this.rqh * zy + offsetY - 3.0 * zy);
            polygonCeb.lineTo(offsetX + (dta + 55.0) * zx, 14.0 * this.rqh * zy + offsetY - 3.0 * zy);
            polygonCeb.lineTo(offsetX + (dta + 58.0) * zx, 14.0 * this.rqh * zy + offsetY + 0.0 * zy);
            polygonCeb.lineTo(offsetX + (dta + 55.0) * zx, 14.0 * this.rqh * zy + offsetY + 3.0 * zy);
            polygonCeb.lineTo(offsetX + (dta + 41.0) * zx, 14.0 * this.rqh * zy + offsetY + 3.0 * zy);
            polygonCeb.lineTo(offsetX + (dta + 38.0) * zx, 14.0 * this.rqh * zy + offsetY + 0.0 * zy);
            polygonCeb.closePath();
            if (this.b_print) {
                this.g2.setColor(Color.black);
            } else {
                this.g2.setColor(Color.white);
            }
            this.g2.fill(polygonCeb);
            polygonCeb = new GeneralPath(0, 6);
            polygonCeb.moveTo(offsetX + (dta + 41.0) * zx, 14.0 * this.rqh * zy + offsetY - 3.0 * zy + 1.0);
            polygonCeb.lineTo(offsetX + (dta + 55.0) * zx, 14.0 * this.rqh * zy + offsetY - 3.0 * zy + 1.0);
            polygonCeb.lineTo(offsetX + (dta + 58.0) * zx - 1.0, 14.0 * this.rqh * zy + offsetY + 0.0 * zy);
            polygonCeb.lineTo(offsetX + (dta + 55.0) * zx, 14.0 * this.rqh * zy + offsetY + 3.0 * zy - 1.0);
            polygonCeb.lineTo(offsetX + (dta + 41.0) * zx, 14.0 * this.rqh * zy + offsetY + 3.0 * zy - 1.0);
            polygonCeb.lineTo(offsetX + (dta + 38.0) * zx + 1.0, 14.0 * this.rqh * zy + offsetY + 0.0 * zy);
            polygonCeb.closePath();
            this.g2.setColor(this.clr_ceb[this.cqh]);
            this.g2.fill(polygonCeb);
            fs = (int)(zy * 7.0 - 6.0);
            this.setFontSize(fs);
            this.g2.setFont(this.ft_stand);
            this.g2.setColor(Color.black);
            ch = (char)(65 + this.cqh);
            this.g2.drawString(String.valueOf(ch), (int)(offsetX + (dta + 41.5) * zx), (int)(14.0 * this.rqh * zy + offsetY + 2.0 * zy));
            fs = (int)(zy * 3.5);
            this.setFontSize(fs);
            this.g2.setFont(this.ft_stand);
            this.g2.drawString(this.df1.format(this.qh), (int)(offsetX + (dta + 45.0) * zx), (int)(14.0 * this.rqh * zy + offsetY + 2.0 * zy));
        }
    }

    @Override
    public void setBounds(Rectangle rect) {
        this.rect = rect;
        this.dx = rect.width;
        this.dy = rect.height;
        this.setSize(this.dx + 1, this.dy + 1);
        this.setLocation(rect.x, rect.y);
    }

    private void setFontSize(int size) {
        this.ft_stand = new Font(this.FT_STAND.getName(), this.FT_STAND.getStyle(), size);
    }

    public Color[] getCebColors() {
        return this.clr_ceb;
    }

    public int getClassRQH(double rqh) {
        this.cqh = (int)(rqh * 100.0 / 50.0);
        if (this.cqh < 0) {
            this.cqh = 0;
        }
        if (this.cqh > 6) {
            this.cqh = 6;
        }
        return this.cqh;
    }

    public int getClassREP(double rep) {
        this.cep = (int)(rep * 100.0 / 50.0);
        if (this.cep < 0) {
            this.cep = 0;
        }
        if (this.cep > 6) {
            this.cep = 6;
        }
        return this.cep;
    }

    public int getClassRCO2() {
        this.cco2 = (int)(this.rco2 * 100.0 / 50.0);
        if (this.cco2 < 0) {
            this.cco2 = 0;
        }
        if (this.cco2 > 6) {
            this.cco2 = 6;
        }
        return this.cco2;
    }

    public int getClassRCO2(double rco2) {
        this.cco2 = (int)(rco2 * 100.0 / 50.0);
        if (this.cco2 < 0) {
            this.cco2 = 0;
        }
        if (this.cco2 > 6) {
            this.cco2 = 6;
        }
        return this.cco2;
    }

    public double[] getValues() {
        return new double[]{this.qh, this.rqh, this.ep, this.rep, this.mco2, this.rco2, this.epr, this.fepr};
    }

    public void setUnits(int units) {
        this.units = units;
        unit = units == 0 ? "MJ/m\u00b2" : "kWh/m\u00b2";
    }

    public void setValues(double[] values) {
        if (values != null) {
            if (values.length > 0) {
                this.qh = values[0];
            }
            if (values.length > 1) {
                this.rqh = values[1];
                this.cqh = this.getClassRQH(values[1]);
            }
            if (values.length > 2) {
                this.ep = values[2];
            }
            if (values.length > 3) {
                this.rep = values[3];
                this.cep = this.getClassREP(values[3]);
            }
            if (values.length > 4) {
                this.mco2 = values[4];
            }
            if (values.length > 5) {
                this.rco2 = values[5];
                this.cco2 = this.getClassRCO2(values[5]);
            }
            if (values.length > 6) {
                this.epr = values[6];
            }
            if (values.length > 7) {
                this.fepr = values[7];
            }
            this.repaint();
        }
    }
}

