/*
 * Decompiled with CFR 0.152.
 */
package jecadcomp;

import enercad2007.Globals;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import javax.swing.JButton;
import jecadcomp.CompassCardListener;
import jecadcomp.OrientationEvent;

public class CompassCard2016
extends JButton {
    int dx = 0;
    int dy = 0;
    int px = 120;
    int py = 50;
    double parc = 11.25;
    Rectangle rect;
    int diff = 10;
    Ellipse2D ellipse1;
    Ellipse2D ellipse2;
    Area circle1;
    Area circle2;
    Area area;
    Area[] ar = new Area[16];
    Area ar_label;
    Area ar_diff;
    Arc2D[] arc = new Arc2D[16];
    Area[] arrow = new Area[2];
    Area[] sb = new Area[2];
    Color[] ar_clrs = new Color[16];
    boolean[] isInArea = new boolean[16];
    Point[] ptint = new Point[16];
    Point[] ptext = new Point[16];
    String[] compassCardText = new String[16];
    final String[][] txt_angles = new String[][]{{"0\u00b0", "22.5\u00b0", "45\u00b0", "67.5\u00b0", "90\u00b0", "112.5\u00b0", "135\u00b0", "157.5\u00b0", "180\u00b0", "202.5\u00b0", "225\u00b0", "247.5\u00b0", "270\u00b0", "292.5\u00b0", "315\u00b0", "337.5\u00b0"}, {"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""}};
    Color clrDark = new Color(100, 100, 100);
    Color clrLight = Color.white;
    Color clrSelArea = Color.red;
    Color clrArea = new Color(150, 150, 150);
    Color clrEnabled = new Color(225, 225, 225);
    Color foreground = this.getForeground();
    Font FT_BOLD = new Font("Dialog", 1, 11);
    Font FT_STAND = new Font("Dialog", 0, 11);
    boolean b_enabled = true;
    boolean b_posneg = false;
    int type = 0;
    int orientation = 0;
    int startorientation = 0;
    Point pointer;

    public CompassCard2016() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public CompassCard2016(boolean posneg) {
        this.b_posneg = posneg;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public CompassCard2016(int type, boolean posneg) {
        this.type = type;
        this.b_posneg = posneg;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        double rad;
        int ii;
        this.setContentAreaFilled(false);
        if (this.compassCardText[0] == null) {
            this.compassCardText[0] = "Nord";
            this.compassCardText[1] = "Nord-est";
            this.compassCardText[2] = "Est";
            this.compassCardText[3] = "Sud-est";
            this.compassCardText[4] = "Sud";
            this.compassCardText[5] = "Sud-ouest";
            this.compassCardText[6] = "Ouest";
            this.compassCardText[7] = "Nord-ouest";
        }
        for (ii = 0; ii < 9; ++ii) {
            this.ar_clrs[ii] = this.clrArea;
            rad = (double)ii * Math.PI / 8.0;
            rad *= 100.0;
            rad = Math.round(rad);
            this.txt_angles[1][ii] = String.valueOf(rad / 100.0) + " rad";
        }
        if (this.b_posneg) {
            for (ii = 9; ii < 16; ++ii) {
                this.ar_clrs[ii] = this.clrArea;
                rad = (double)ii * Math.PI / 8.0 - Math.PI * 2;
                rad *= 100.0;
                rad = Math.round(rad);
                this.txt_angles[0][ii] = String.valueOf((double)ii * 22.5 - 360.0) + "\u00b0";
                this.txt_angles[1][ii] = String.valueOf(rad / 100.0) + " rad";
            }
        } else {
            for (ii = 8; ii < 16; ++ii) {
                this.ar_clrs[ii] = this.clrArea;
                rad = (double)ii * Math.PI / 8.0;
                rad *= 100.0;
                rad = Math.round(rad);
                this.txt_angles[1][ii] = String.valueOf(rad / 100.0) + " rad";
            }
        }
        this.ar_clrs[1] = this.clrSelArea;
        this.addMouseListener(new CompassCard2016_MouseAdapter(this));
        this.addMouseMotionListener(new CompassCard2016_MouseMotionAdapter(this));
        this.paintAreas();
    }

    @Override
    public boolean contains(int x, int y) {
        boolean res = false;
        if (this.ar[0] != null) {
            for (int cter = 0; cter < 16; ++cter) {
                if (this.ar[cter].contains(x, y)) {
                    this.isInArea[cter] = true;
                    res = true;
                    continue;
                }
                this.isInArea[cter] = false;
            }
        }
        if (this.ar_label != null && this.ar_label.contains(x, y)) {
            res = true;
        }
        if (this.ar_diff != null && this.ar_diff.contains(x, y)) {
            res = true;
        }
        return res;
    }

    private void paintAreas() {
        this.ellipse1 = new Ellipse2D.Double(this.px / 2, this.py / 2, this.dx, this.dy);
        this.circle1 = new Area(this.ellipse1);
        this.ellipse2 = new Ellipse2D.Double(this.px / 2 + this.diff, this.py / 2 + this.diff, this.dx - 2 * this.diff, this.dy - 2 * this.diff);
        this.circle2 = new Area(this.ellipse2);
        this.area = new Area(this.circle1);
        this.area.subtract(this.circle2);
        this.ar_label = new Area(new Rectangle(this.px / 2 + this.dx / 2 - 20, this.py / 2 + this.dy / 2 - 8, 40, 16));
        this.ar_diff = new Area(this.ellipse2);
        this.ar_diff.subtract(this.ar_label);
        int tx1 = 0;
        int tx2 = 0;
        for (int cter = 0; cter < 16; ++cter) {
            if (cter == 1) {
                tx1 = 0;
                tx2 = -1;
            } else if (cter == 2) {
                tx1 = -2;
                tx2 = -2;
            } else {
                tx1 = 1;
                tx2 = 1;
            }
            GeneralPath gp = new GeneralPath();
            gp.append(new Arc2D.Double(this.px / 2, this.py / 2, this.dx, this.dy, 5.0 * this.parc + (double)cter * 22.5 + (double)tx1, 22.5, 0), false);
            gp.append(new Arc2D.Double(this.px / 2 + this.diff, this.py / 2 + this.diff, this.dx - 2 * this.diff, this.dy - 2 * this.diff, 5.0 * this.parc + (double)(cter + 1) * 22.5 + (double)tx2, -22.5, 0), true);
            gp.closePath();
            this.ar[cter] = new Area(gp);
        }
        this.paintArcs();
        if (this.type < 2) {
            this.paintBuilding();
        } else {
            this.paintArrow();
        }
    }

    private void paintArcs() {
        Globals.println("CompassCard2016.paintArcs orientation: " + this.orientation);
        for (int ii = 0; ii < 16; ++ii) {
            int fc = 17 - this.startorientation;
            if (this.startorientation == 0) {
                fc = 1;
            }
            if (this.b_posneg) {
                if (ii < 8) {
                    this.arc[ii] = new Arc2D.Double(this.px / 2 + this.diff + 3, this.py / 2 + this.diff + 3, this.dx - 2 * (this.diff + 3), this.dy - 2 * (this.diff + 3), (double)(-ii + fc) * 22.5 + 45.0, 22.5, 0);
                    continue;
                }
                this.arc[ii] = new Arc2D.Double(this.px / 2 + this.diff + 3, this.py / 2 + this.diff + 3, this.dx - 2 * (this.diff + 3), this.dy - 2 * (this.diff + 3), (double)(-ii + fc) * 22.5 + 45.0, -22.5, 0);
                continue;
            }
            this.arc[ii] = new Arc2D.Double(this.px / 2 + this.diff + 3, this.py / 2 + this.diff + 3, this.dx - 2 * (this.diff + 3), this.dy - 2 * (this.diff + 3), (double)(-ii + fc) * 22.5 + 45.0, 22.5, 0);
        }
    }

    private void paintBuilding() {
        GeneralPath gp = new GeneralPath();
        float delta = 5.0f;
        float cc = (float)(this.dx / 2 - this.diff) - delta;
        float cred = 1.0f;
        gp.moveTo((float)(this.px / 2 + this.dx / 2) - (float)((double)cc * Math.cos(0.7853981633974483)), (float)(this.py / 2 + this.dy / 2) - (float)((double)(cc / cred) * Math.sin(0.7853981633974483)));
        gp.lineTo((float)(this.px / 2 + this.dx / 2) + (float)((double)cc * Math.cos(0.7853981633974483)), (float)(this.py / 2 + this.dy / 2) - (float)((double)(cc / cred) * Math.sin(0.7853981633974483)));
        gp.lineTo((float)(this.px / 2 + this.dx / 2) + (float)((double)cc * Math.cos(0.7853981633974483)), (float)(this.py / 2 + this.dy / 2) + (float)((double)(cc / cred) * Math.sin(0.7853981633974483)));
        gp.lineTo((float)(this.px / 2 + this.dx / 2) - (float)((double)cc * Math.cos(0.7853981633974483)), (float)(this.py / 2 + this.dy / 2) + (float)((double)(cc / cred) * Math.sin(0.7853981633974483)));
        gp.closePath();
        this.sb[0] = new Area(gp);
        gp = new GeneralPath();
        gp.moveTo((float)(this.px / 2 + this.dx / 2) - (float)((double)cc * Math.cos(0.7853981633974483)), (float)(this.py / 2 + this.dy / 2) - (float)((double)(cc / cred) * Math.sin(0.7853981633974483)));
        gp.lineTo((float)(this.px / 2 + this.dx / 2) + (float)((double)cc * Math.cos(0.7853981633974483)), (float)(this.py / 2 + this.dy / 2) - (float)((double)(cc / cred) * Math.sin(0.7853981633974483)));
        gp.lineTo((float)(this.px / 2 + this.dx / 2) + (float)((double)cc * Math.cos(0.7853981633974483)), (float)(this.py / 2 + this.dy / 2) - (float)((double)(cc / cred) * Math.sin(0.7853981633974483)) + 5.0f);
        gp.lineTo((float)(this.px / 2 + this.dx / 2) - (float)((double)cc * Math.cos(0.7853981633974483)), (float)(this.py / 2 + this.dy / 2) - (float)((double)(cc / cred) * Math.sin(0.7853981633974483)) + 5.0f);
        gp.closePath();
        this.sb[1] = new Area(gp);
        AffineTransform at = new AffineTransform();
        if (this.b_posneg) {
            double radians = this.getCompassCardRadians();
            if (radians < 0.0) {
                radians += Math.PI * 2;
            }
            at.rotate(radians, this.px / 2 + this.dx / 2, this.py / 2 + this.dy / 2);
        } else {
            at.rotate(this.getCompassCardRadians(), this.px / 2 + this.dx / 2, this.py / 2 + this.dy / 2);
        }
        this.sb[0].transform(at);
        this.sb[1].transform(at);
    }

    private void paintArrow() {
        GeneralPath gp = new GeneralPath();
        gp.moveTo(this.px / 2 + this.dx / 2, this.py / 2 + this.diff + 5);
        gp.lineTo(this.px / 2 + this.dx / 2, this.py / 2 + this.dy - this.diff - 12);
        gp.lineTo(this.px / 2 + this.dx / 2 - 6, this.py / 2 + this.dy - this.diff - 7);
        gp.closePath();
        this.arrow[0] = new Area(gp);
        gp = new GeneralPath();
        gp.moveTo(this.px / 2 + this.dx / 2, this.py / 2 + this.diff + 5);
        gp.lineTo(this.px / 2 + this.dx / 2, this.py / 2 + this.dy - this.diff - 12);
        gp.lineTo(this.px / 2 + this.dx / 2 + 6, this.py / 2 + this.dy - this.diff - 7);
        gp.closePath();
        this.arrow[1] = new Area(gp);
        AffineTransform at = new AffineTransform();
        if (this.b_posneg) {
            double radians = this.getCompassCardRadians();
            if (radians < 0.0) {
                radians += Math.PI * 2;
            }
            at.rotate(radians, this.px / 2 + this.dx / 2, this.py / 2 + this.dy / 2);
        } else {
            at.rotate(this.getCompassCardRadians(), this.px / 2 + this.dx / 2, this.py / 2 + this.dy / 2);
        }
        this.arrow[0].transform(at);
        this.arrow[1].transform(at);
    }

    private Point[] getPoints(String intext) {
        double cc = 0.0;
        Point[] res = new Point[16];
        double degrad = Math.PI / 180;
        if (intext.equals("int")) {
            if (this.ptint[0] != null) {
                return this.ptint;
            }
            cc = (this.dx - 2 * this.diff) / 2;
        } else if (intext.equals("ext")) {
            if (this.ptext[0] != null) {
                return this.ptext;
            }
            cc = this.dx / 2;
        }
        for (int cter = 0; cter < 16; ++cter) {
            res[cter] = new Point(this.dx / 2 + (int)(cc * Math.sin(this.parc * degrad)), this.dx / 2 - (int)(cc * Math.cos(this.parc * degrad)));
            this.parc += 22.5;
        }
        return res;
    }

    @Override
    protected void paintBorder(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        this.ptint = this.getPoints("int");
        this.ptext = this.getPoints("ext");
        for (int cter = 0; cter < 16; ++cter) {
            g2.setColor(this.clrDark);
            g2.draw(new Line2D.Double(this.px / 2 + this.ptint[cter].x, this.py / 2 + this.ptint[cter].y, this.px / 2 + this.ptext[cter].x, this.py / 2 + this.ptext[cter].y));
            g2.setColor(this.clrLight);
            if (cter < 1) {
                g2.draw(new Line2D.Double(this.px / 2 + this.ptint[cter].x + 1, this.py / 2 + this.ptint[cter].y, this.px / 2 + this.ptext[cter].x + 1, this.py / 2 + this.ptext[cter].y));
                continue;
            }
            if (cter < 3) {
                g2.draw(new Line2D.Double(this.px / 2 + this.ptint[cter].x, this.py / 2 + this.ptint[cter].y + 1, this.px / 2 + this.ptext[cter].x, this.py / 2 + this.ptext[cter].y + 1));
                continue;
            }
            if (cter < 5) {
                g2.draw(new Line2D.Double(this.px / 2 + this.ptint[cter].x + 1, this.py / 2 + this.ptint[cter].y, this.px / 2 + this.ptext[cter].x + 1, this.py / 2 + this.ptext[cter].y));
                continue;
            }
            if (cter < 7) {
                g2.draw(new Line2D.Double(this.px / 2 + this.ptint[cter].x, this.py / 2 + this.ptint[cter].y + 1, this.px / 2 + this.ptext[cter].x, this.py / 2 + this.ptext[cter].y + 1));
                continue;
            }
            g2.draw(new Line2D.Double(this.px / 2 + this.ptint[cter].x + 1, this.py / 2 + this.ptint[cter].y, this.px / 2 + this.ptext[cter].x + 1, this.py / 2 + this.ptext[cter].y));
        }
        g2.setColor(this.clrLight);
        g2.drawOval(this.px / 2, this.py / 2, this.dx - 1, this.dy - 1);
        g2.setColor(this.clrDark);
        g2.drawOval(this.px / 2, this.py / 2, this.dx - 1, this.dy - 1);
        g2.setColor(this.clrLight);
        g2.drawOval(this.px / 2 + this.diff + 1, this.py / 2 + this.diff + 1, this.dx - (2 * this.diff + 2), this.dy - (2 * this.diff + 1));
        g2.setColor(this.clrDark);
        g2.drawOval(this.px / 2 + this.diff, this.py / 2 + this.diff, this.dx - (2 * this.diff + 1), this.dy - (2 * this.diff + 1));
    }

    @Override
    public void paintComponent(Graphics g) {
        int ii;
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.ptint = this.getPoints("int");
        this.ptext = this.getPoints("ext");
        g2.setColor(this.clrEnabled);
        g2.fill(this.area);
        if (this.type == 0) {
            this.paintArrow();
            g2.setColor(Color.yellow);
            g2.fill(this.arrow[0]);
            g2.setColor(Color.black);
            g2.draw(this.arrow[0]);
            g2.draw(this.arrow[1]);
        } else if (this.type == 1) {
            this.paintBuilding();
            g2.setColor(new Color(255, 204, 204));
            g2.fill(this.sb[0]);
            g2.setColor(Color.black);
            g2.draw(this.sb[0]);
        } else if (this.type == 2) {
            this.paintBuilding();
            g2.setColor(new Color(255, 204, 204));
            g2.fill(this.sb[0]);
            g2.setColor(Color.black);
            g2.draw(this.sb[0]);
            g2.setColor(Color.yellow);
            g2.fill(this.sb[1]);
            g2.setColor(Color.black);
            g2.draw(this.sb[1]);
        }
        Rectangle rect = this.ar_label.getBounds();
        g2.setColor(this.getBackground());
        g2.fillRect(rect.x, rect.y, rect.width, rect.height);
        g2.setColor(this.clrEnabled);
        g2.setFont(this.FT_STAND);
        g2.draw3DRect(rect.x, rect.y, rect.width, rect.height, false);
        g2.setColor(Color.black);
        FontMetrics fm = g2.getFontMetrics();
        int or = (16 + this.orientation - this.startorientation) % 16;
        g2.drawString(this.txt_angles[0][or], this.px / 2 + this.dx / 2 - fm.stringWidth(this.txt_angles[0][or]) / 2, this.ar_label.getBounds().y + 6 + fm.getHeight() / 2);
        g2.setFont(this.FT_BOLD);
        for (int cter = 0; cter < 16; ++cter) {
            g2.setColor(this.ar_clrs[cter]);
            g2.fill(this.ar[cter]);
        }
        g2.setColor(this.clrSelArea);
        if (this.b_posneg) {
            if (or < 9) {
                for (ii = 0; ii < or; ++ii) {
                    g2.draw(this.arc[ii]);
                }
            } else {
                for (ii = 0; ii < 16 - or; ++ii) {
                    g2.draw(this.arc[14 - ii]);
                }
            }
        } else {
            for (ii = 0; ii < this.orientation; ++ii) {
                g2.draw(this.arc[ii]);
            }
        }
        if (this.b_enabled) {
            g2.setColor(Color.black);
        } else {
            g2.setColor(this.clrDark);
        }
        g2.drawString(this.compassCardText[0], this.px / 2 + this.dx / 2 - g2.getFontMetrics().stringWidth(this.compassCardText[0]) / 2, this.py / 2 - this.diff);
        g2.drawString(this.compassCardText[1], this.px / 2 + (int)((double)this.dx * Math.PI / 8.0) + this.dx / 2 + this.diff, this.py / 2 + this.dy / 4 - this.diff);
        g2.drawString(this.compassCardText[2], this.px / 2 + this.dx + this.diff, this.py / 2 + this.dy / 2 + this.FT_BOLD.getSize() / 2);
        g2.drawString(this.compassCardText[3], this.px / 2 + (int)((double)this.dx * Math.PI / 8.0) + this.dx / 2 + this.diff, this.py / 2 + this.dy - this.diff + this.FT_BOLD.getSize() / 2);
        g2.drawString(this.compassCardText[4], this.px / 2 + this.dx / 2 - g2.getFontMetrics().stringWidth(this.compassCardText[4]) / 2, this.py / 2 + this.dy + this.diff + this.FT_BOLD.getSize() / 2);
        g2.drawString(this.compassCardText[5], this.px / 2 + this.dx / 2 - (int)((double)this.dx * Math.PI / 8.0) - g2.getFontMetrics().stringWidth(this.compassCardText[5]) - this.diff / 2, this.py / 2 + this.dy - this.diff + this.FT_BOLD.getSize() / 2);
        g2.drawString(this.compassCardText[6], this.px / 2 - g2.getFontMetrics().stringWidth(this.compassCardText[6]) - this.diff, this.py / 2 + this.dy / 2 + this.FT_BOLD.getSize() / 2);
        g2.drawString(this.compassCardText[7], this.px / 2 + this.dx / 2 - (int)((double)this.dx * Math.PI / 8.0) - g2.getFontMetrics().stringWidth(this.compassCardText[7]) - this.diff / 2, this.py / 2 + this.dy / 4 - this.diff);
    }

    protected void resetOrientation() {
        this.orientation = 0;
        if (this.type == 0) {
            this.paintArrow();
        } else {
            this.paintBuilding();
        }
        for (int cter = 0; cter < 16; ++cter) {
            if (cter == (16 - this.startorientation + 1) % 16) {
                this.ar_clrs[cter] = this.clrSelArea;
                this.orientation = (16 - cter + 1) % 16;
                continue;
            }
            this.ar_clrs[cter] = this.clrArea;
        }
        this.paintArcs();
    }

    @Override
    public void setBounds(Rectangle rect) {
        this.rect = rect;
        this.dx = rect.width - this.px;
        this.dy = rect.height - this.py;
        this.dy = this.dx = Math.max(this.dx, this.dy);
        this.setSize(this.dx + this.px + 1, this.dy + this.py + 1);
        this.setLocation(rect.x, rect.y);
        this.paintAreas();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.b_enabled = enabled;
        this.repaint();
    }

    public void setSelectedColors(Color enabledColor, Color disabledColor) {
        this.clrSelArea = enabledColor;
        this.clrArea = disabledColor;
        this.repaint();
    }

    public void setCompassCardText(String[] compassCardText) {
        for (int cter = 0; cter < 8; ++cter) {
            this.compassCardText[cter] = compassCardText[cter * 2];
        }
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setDiff(int diff) {
        if (2 * diff + 1 < this.dx) {
            this.diff = diff;
            this.repaint();
        }
    }

    private GeneralPath getArc2DFromArea(Area area) {
        int ii;
        GeneralPath gp = new GeneralPath();
        float[] coord = null;
        float[] start = null;
        int seg_type = 0;
        int index = 0;
        Vector<float[]> vector = new Vector<float[]>(100);
        PathIterator pi = area.getPathIterator(null, 1.0);
        Rectangle2D rectangle = area.getBounds2D();
        while (!pi.isDone()) {
            coord = new float[2];
            seg_type = pi.currentSegment(coord);
            switch (seg_type) {
                case 0: {
                    vector.insertElementAt(coord, 0);
                    ++index;
                    break;
                }
                case 1: {
                    vector.insertElementAt(coord, index);
                    ++index;
                }
            }
            pi.next();
        }
        start = new float[2];
        start = (float[])vector.get(0);
        int size = vector.size();
        for (int jj = size - 1; jj >= 0; --jj) {
            coord = (float[])vector.get(jj);
            if (start[0] != coord[0] || start[1] != coord[1]) continue;
            vector.remove(jj);
        }
        coord = (float[])vector.get(0);
        vector.insertElementAt(start, 0);
        size = vector.size();
        for (ii = 0; ii < vector.size(); ++ii) {
            coord = (float[])vector.get(ii);
            System.out.print("start: " + start[0] + "," + start[1]);
            System.out.println(" px: " + (this.px / 2 + this.dx / 2) + " py: " + (this.py / 2 + this.dy / 2) + " rectangle: " + rectangle.getX() + ", " + rectangle.getY() + ": " + coord[0] + ": " + coord[1]);
        }
        coord = (float[])vector.get(0);
        gp.moveTo(coord[0], coord[1]);
        for (ii = 1; ii < size; ++ii) {
            coord = (float[])vector.get(ii);
            gp.lineTo(coord[0], coord[1]);
        }
        return gp;
    }

    public int getDefaultOrientation() {
        return this.startorientation;
    }

    public int getDegrees() {
        String orient = this.txt_angles[0][this.orientation];
        orient = orient.substring(0, orient.indexOf("\u00b0"));
        return Integer.parseInt(orient);
    }

    public double getDegrees(boolean posneg) {
        double res = 0.0;
        if (posneg) {
            if (this.orientation > 8) {
                res = (double)(10 - this.orientation) * 22.5;
            }
        } else {
            res = (double)this.orientation * 22.5;
        }
        return res;
    }

    public double getCompassCardRadians() {
        String orient = this.txt_angles[1][this.orientation];
        orient = orient.substring(0, orient.indexOf(" rad"));
        return Double.parseDouble(orient);
    }

    public double getRadians(int orientation) {
        int orientId = orientation % 16;
        System.out.println("orientId: " + orientId);
        return (double)orientId * Math.PI / 4.0;
    }

    public double getRadians(boolean posneg) {
        double res = 0.0;
        if (posneg) {
            if (this.orientation > 4) {
                res = (double)(6 - this.orientation) * Math.PI / 4.0;
            }
        } else {
            res = (double)this.orientation * Math.PI / 4.0;
        }
        return res;
    }

    public double getRadians(boolean posneg, int orientation) {
        double res = 0.0;
        res = posneg ? (orientation > 4 ? (double)(6 - orientation) * Math.PI / 4.0 : (double)orientation * Math.PI / 4.0) : (double)orientation * Math.PI / 4.0;
        System.out.println("getRadians() orientation: " + orientation + " res: " + res);
        return res;
    }

    public int getOrientation() {
        Globals.println("CompassCard2016.getOrientation: " + this.orientation);
        return this.orientation;
    }

    public int getOrientationRef() {
        return (16 + this.orientation - this.startorientation) % 16;
    }

    private void setOrientation(int orientation) {
        Globals.println("CompassCard2016.setOrientation: " + orientation);
        if (orientation < 16) {
            this.orientation = orientation;
            for (int cter = 0; cter < 16; ++cter) {
                this.isInArea[cter] = cter == orientation;
            }
        }
    }

    public void setDefaultOrientation(int orientation) {
        if (orientation < 16) {
            this.orientation = 0;
            this.startorientation = orientation;
            if (this.type == 0) {
                this.paintArrow();
            } else {
                this.paintBuilding();
            }
            for (int cter = 0; cter < 16; ++cter) {
                if (cter == (16 - orientation + 1) % 16) {
                    this.ar_clrs[cter] = this.clrSelArea;
                    this.orientation = (16 - cter + 1) % 16;
                    continue;
                }
                this.ar_clrs[cter] = this.clrArea;
            }
            this.paintArcs();
        }
    }

    public void addCompassCardListener(CompassCardListener ccl) {
        this.listenerList.add(CompassCardListener.class, ccl);
    }

    public void removeCompassCardListener(CompassCardListener ccl) {
        this.listenerList.remove(CompassCardListener.class, ccl);
    }

    @Override
    protected void fireActionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        int id = ae.getID();
        String command = ae.getActionCommand();
        long when = ae.getWhen();
        int modifiers = ae.getModifiers();
        OrientationEvent oe = new OrientationEvent(source, id, command, when, modifiers);
        this.fireOrientationChanged(oe);
    }

    protected void fireOrientationChanged(OrientationEvent oe) {
        boolean b_ar = false;
        int orientation = 0;
        for (int cter = 0; cter < 16; ++cter) {
            if (!this.ar[cter].contains(this.pointer)) continue;
            b_ar = true;
            orientation = (16 - cter + 1) % 16;
            break;
        }
        Object[] listeners = this.listenerList.getListenerList();
        oe.setSource(this);
        oe.setOrientation(orientation);
        oe.setOrientationRef((16 + orientation - this.startorientation) % 16);
        for (int ii = listeners.length - 2; ii >= 0; ii -= 2) {
            if (listeners[ii] != CompassCardListener.class || !b_ar) continue;
            ((CompassCardListener)listeners[ii + 1]).orientationChanged(oe);
        }
    }

    private void mousePressed(MouseEvent me) {
        this.pointer = me.getPoint();
    }

    private void mouseClicked(MouseEvent me) {
    }

    private void mouseReleased(MouseEvent me) {
        int cter;
        boolean b_ar = false;
        for (cter = 0; cter < 16; ++cter) {
            if (!this.ar[cter].contains(me.getPoint())) continue;
            b_ar = true;
            break;
        }
        if (b_ar) {
            for (cter = 0; cter < 16; ++cter) {
                if (this.isInArea[cter]) {
                    this.ar_clrs[cter] = this.clrSelArea;
                    this.orientation = (16 - cter + 1) % 16;
                    continue;
                }
                this.ar_clrs[cter] = this.clrArea;
            }
        }
    }

    private void mouseMoved(MouseEvent me) {
        if (this.ar_label.contains(me.getPoint())) {
            int orientation = this.getOrientation();
            int or = (16 + orientation - this.startorientation) % 16;
            this.setToolTipText(this.txt_angles[1][or]);
        } else {
            this.setToolTipText(null);
        }
    }

    class CompassCard2016_MouseMotionAdapter
    extends MouseMotionAdapter {
        CompassCard2016 adaptee;

        CompassCard2016_MouseMotionAdapter(CompassCard2016 adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void mouseMoved(MouseEvent me) {
            this.adaptee.mouseMoved(me);
        }
    }

    class CompassCard2016_MouseAdapter
    extends MouseAdapter {
        CompassCard2016 adaptee;

        CompassCard2016_MouseAdapter(CompassCard2016 adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void mousePressed(MouseEvent me) {
            this.adaptee.mousePressed(me);
        }

        @Override
        public void mouseClicked(MouseEvent me) {
            this.adaptee.mouseClicked(me);
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            this.adaptee.mouseReleased(me);
        }
    }
}

