/*
 * Decompiled with CFR 0.152.
 */
package jecadcomp;

import core.Config;
import core.hibernate.pro.db.Envelope;
import enercad2007.DM_Trad;
import enercad2007.Ecad2007;
import enercad2007.Globals;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import jecadcomp.CompassCard;
import jecadcomp.CompassCardListener;
import jecadcomp.OrientationEvent;

public class DlgCompassCard
extends JDialog {
    Container parent;
    boolean modal = false;
    String title = "";
    Font FT_STAND = new Font("Dialog", 0, 11);
    JPanel jPa_0 = new JPanel();
    JPanel jPa_1 = new JPanel();
    JButton jB_esc = new JButton();
    JButton jB_ok = new JButton();
    CompassCard compassCard;
    int orientation = 0;
    int prevorient = 0;
    Globals globals = new Globals();
    transient Config config = new Config(System.getProperty("conf.file.name"));
    DM_Trad gen_trad;
    DM_Trad horizon_trad;
    int exitstate = 0;
    boolean posneg = false;
    String className;
    Dimension size = new Dimension(300, 210);
    transient Vector<Envelope> rotatedElements;
    int type = 0;
    String txt_nord = "Nord";
    String txt_ne = "N-E";
    String txt_est = "Est";
    String txt_se = "S-E";
    String txt_sud = "Sud";
    String txt_so = "S-O";
    String txt_ouest = "Ouest";
    String txt_no = "N-O";
    String[] txt_orient;
    String txt_cancel = "Annuler";
    int prevOrId = 0;
    double prevRadians = 0.0;

    public DlgCompassCard() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DlgCompassCard(JFrame frame, String title, boolean modal) {
        super(frame, title, modal);
        this.parent = frame;
        this.title = title;
        this.modal = modal;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public DlgCompassCard(JFrame frame, String title, boolean modal, boolean posneg) {
        super(frame, title, modal);
        this.parent = frame;
        this.title = title;
        this.modal = modal;
        this.posneg = posneg;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public DlgCompassCard(JFrame frame, String title, boolean modal, boolean posneg, int type) {
        super(frame, title, modal);
        this.parent = frame;
        this.title = title;
        this.modal = modal;
        this.posneg = posneg;
        this.type = type;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DlgCompassCard(JDialog dialog, String title, boolean modal) {
        super(dialog, title, modal);
        this.parent = dialog;
        this.modal = modal;
        try {
            this.jbInit();
            this.setDlgLocation(dialog);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public DlgCompassCard(JInternalFrame internalMainFrame, String title, boolean modal) {
        super((Frame)internalMainFrame.getTopLevelAncestor(), title, modal);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        if (this.globals != null) {
            this.FT_STAND = Globals.FT_STAND1;
            this.gen_trad = Ecad2007.getTraduction("gen");
            this.horizon_trad = Ecad2007.getTraduction("horizon");
            this.txt_nord = this.gen_trad.getCodeLan("nord");
            this.txt_ne = this.horizon_trad.getCodeLan("FS2");
            this.txt_est = this.gen_trad.getCodeLan("est");
            this.txt_se = this.horizon_trad.getCodeLan("FS4");
            this.txt_sud = this.gen_trad.getCodeLan("sud");
            this.txt_so = this.horizon_trad.getCodeLan("FS6");
            this.txt_ouest = this.gen_trad.getCodeLan("ouest");
            this.txt_no = this.horizon_trad.getCodeLan("FS8");
            this.txt_orient = new String[]{this.txt_nord, this.txt_ne, this.txt_est, this.txt_se, this.txt_sud, this.txt_so, this.txt_ouest, this.txt_no};
            this.txt_cancel = this.gen_trad.getCodeLan("cancel");
            this.className = this.getClass().getName();
            this.className = this.className.substring(this.className.lastIndexOf(".") + 1);
        }
        this.getContentPane().setLayout(null);
        this.setFont(this.FT_STAND);
        this.setResizable(false);
        this.setSize(new Dimension(this.size.width, this.size.height + 25));
        this.addKeyListener(new DlgCompassCard_keyAdapter(this));
        this.addWindowListener(new DlgCompassCard_windowAdapter(this));
        this.compassCard = new CompassCard(this.type, this.posneg);
        this.compassCard.setBounds(new Rectangle(25, 0, 220, 150));
        this.compassCard.setCompassCardText(this.txt_orient);
        this.compassCard.addCompassCardListener(new DlgCompassCard_CompassCardAdapter(this));
        this.jPa_0.setBounds(new Rectangle(0, 1, this.size.width, this.size.height));
        this.jPa_0.setLayout(null);
        this.jB_esc.setText(this.txt_cancel);
        this.jB_esc.addActionListener(new DlgCompassCard_actionAdapter(this));
        this.jB_esc.setBounds(new Rectangle(178, 170, 100, 22));
        this.jB_esc.setFont(this.FT_STAND);
        this.jB_esc.setBorder(BorderFactory.createRaisedBevelBorder());
        this.jB_ok.setText("Ok");
        this.jB_ok.setBounds(new Rectangle(68, 170, 100, 22));
        this.jB_ok.setFont(this.FT_STAND);
        this.jB_ok.setBorder(BorderFactory.createRaisedBevelBorder());
        this.jB_ok.addActionListener(new DlgCompassCard_actionAdapter(this));
        this.jB_ok.addKeyListener(new DlgCompassCard_keyAdapter(this));
        this.jPa_1.setFont(this.FT_STAND);
        this.jPa_1.setBorder(BorderFactory.createLoweredBevelBorder());
        this.jPa_1.setBounds(new Rectangle(7, 9, this.size.width - 30, this.size.height - 60));
        this.jPa_1.setLayout(null);
        this.getContentPane().add((Component)this.jPa_0, null);
        this.jPa_1.add((Component)this.compassCard, null);
        this.jPa_0.add((Component)this.jB_ok, null);
        this.jPa_0.add((Component)this.jB_esc, null);
        this.jPa_0.add((Component)this.jPa_1, null);
        this.globals.setLocation(this, this.config.getPropertyString("properties", "pos", new String[]{this.className}));
    }

    private void closeWindow() {
        String location = String.valueOf(this.getLocation().x) + "," + String.valueOf(this.getLocation().y);
        this.config.setPropertyString("properties", "pos", new String[]{this.className}, location);
        int deforient = this.compassCard.getDefaultOrientation();
        this.compassCard.resetOrientation();
        Ecad2007.getDM_Facade().turnAllAZId(deforient - this.prevorient);
        Integer[] ids_z = Ecad2007.getDM_ElementKeys();
        for (int ii = 0; ii < ids_z.length; ++ii) {
            if (ids_z[ii] == 0) {
                this.rotatedElements = Ecad2007.getDM_Element(ids_z[ii]).turnAllAZOfElements(2, (double)(deforient - this.prevorient) * 0.7853981633974483);
            } else {
                Ecad2007.getDM_Element(ids_z[ii]).turnAllAZOfElements(2, (double)(deforient - this.prevorient) * 0.7853981633974483);
            }
            Ecad2007.getInternalMainFrame(ids_z[ii]).refreshFrontModule(Ecad2007.getDM_Facade());
            if (Ecad2007.getInternalMainFrame(ids_z[ii]).getSelectedIndex() != 2) continue;
            Ecad2007.getInternalMainFrame(ids_z[ii]).refreshFrontMenu();
        }
        this.prevorient = deforient;
        Ecad2007.getMainFrame().updateCalc();
    }

    public void refresh() {
        this.compassCard.repaint();
    }

    private void setDlgLocation(JDialog dialog) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dlgSize = dialog.getSize();
        Dimension size = this.getSize();
        Point dlgLocation = dialog.getLocation();
        if (dlgSize.height > screenSize.height) {
            dlgSize.height = screenSize.height;
        }
        if (dlgSize.width > screenSize.width) {
            dlgSize.width = screenSize.width;
        }
        this.setLocation((dlgSize.width - size.width) / 2 + dlgLocation.x, (dlgSize.height - size.height) / 2 + dlgLocation.y);
    }

    private void setDlgLocation(JFrame frame) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = frame.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    public int getExitState() {
        return this.exitstate;
    }

    public int getOrientationId() {
        return this.compassCard.getOrientation();
    }

    public int getDeltaOrientationId() {
        int res = 0;
        int orientation = this.getOrientationId();
        res = orientation - this.prevOrId;
        this.prevOrId = orientation;
        return res;
    }

    public double getDetlaRadians() {
        double res = 0.0;
        int orientation = this.getOrientationId();
        double radians = this.compassCard.getRadians(orientation);
        this.prevRadians = res = radians - this.prevRadians;
        return res;
    }

    public String getOrientationText() {
        int id = 0;
        return this.txt_orient[id];
    }

    public void setDefaultOrientationId(int id) {
        this.compassCard.setDefaultOrientation(id);
        this.prevorient = this.compassCard.getOrientation();
    }

    public void setType(int type) {
        this.type = type;
        this.compassCard.setType(this.type);
    }

    private void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.jB_ok) {
            this.exitstate = 2;
            Ecad2007.getDM_Facade().updateRows();
            Integer[] ids_z = Ecad2007.getDM_ElementKeys();
            for (int ii = 0; ii < this.rotatedElements.size(); ++ii) {
                Envelope envelope = this.rotatedElements.get(ii);
                double radorient = Globals.getDoubleValue(envelope.getAz_e());
                int id_e = Globals.getIntValue(envelope.getId_e());
                HashMap<String, Object> cmap = new HashMap<String, Object>(1);
                HashMap<String, Object> wmap = new HashMap<String, Object>(1);
                cmap.put("AZ_E", new Double(radorient));
                wmap.put("ID_E", new Integer(id_e));
                for (int jj = 0; jj < ids_z.length; ++jj) {
                    Ecad2007.getDM_Element(ids_z[jj]).updateTableWithWhereClause(cmap, wmap);
                    Ecad2007.getInternalMainFrame(ids_z[jj]).refreshFrontMenu(true);
                }
            }
            String location = String.valueOf(this.getLocation().x) + "," + String.valueOf(this.getLocation().y);
            this.config.setPropertyString("properties", "pos", new String[]{this.className}, location);
            this.prevorient = this.compassCard.getDefaultOrientation();
            this.compassCard.resetOrientation();
            for (int ii = 0; ii < ids_z.length; ++ii) {
                Ecad2007.eraseDM_Element(ids_z[ii]);
                Ecad2007.eraseDM_Zone(ids_z[ii]);
            }
            this.dispose();
        } else if (ae.getSource() == this.jB_esc) {
            this.closeWindow();
            this.dispose();
        }
    }

    public void orientationChanged(OrientationEvent oe) {
        int deltaorient = 0;
        this.orientation = oe.getOrientation();
        deltaorient = this.orientation - this.prevorient;
        this.prevorient = this.orientation;
        Ecad2007.getDM_Facade().turnAllAZId(deltaorient);
        Integer[] ids_z = Ecad2007.getDM_ElementKeys();
        for (int ii = 0; ii < ids_z.length; ++ii) {
            if (ids_z[ii] == 0) {
                this.rotatedElements = Ecad2007.getDM_Element(ids_z[ii]).turnAllAZOfElements(2, (double)deltaorient * 0.7853981633974483);
            } else {
                Ecad2007.getDM_Element(ids_z[ii]).turnAllAZOfElements(2, (double)deltaorient * 0.7853981633974483);
            }
            Ecad2007.getInternalMainFrame(ids_z[ii]).refreshFrontMenu();
        }
        Ecad2007.getMainFrame().updateCalc();
    }

    private void keyReleased(KeyEvent ke) {
        if (ke.getKeyCode() == 10) {
            this.exitstate = 2;
            this.dispose();
        }
    }

    private void itemStateChanged(ItemEvent ie) {
    }

    private void windowClosing(WindowEvent we) {
        this.closeWindow();
    }

    class DlgCompassCard_windowAdapter
    extends WindowAdapter {
        DlgCompassCard adaptee;

        DlgCompassCard_windowAdapter(DlgCompassCard adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void windowClosing(WindowEvent we) {
            this.adaptee.windowClosing(we);
        }
    }

    class DlgCompassCard_itemAdapter
    implements ItemListener {
        DlgCompassCard adaptee;

        DlgCompassCard_itemAdapter(DlgCompassCard adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void itemStateChanged(ItemEvent ie) {
            this.adaptee.itemStateChanged(ie);
        }
    }

    class DlgCompassCard_keyAdapter
    extends KeyAdapter {
        DlgCompassCard adaptee;

        DlgCompassCard_keyAdapter(DlgCompassCard adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void keyReleased(KeyEvent ke) {
            this.adaptee.keyReleased(ke);
        }
    }

    class DlgCompassCard_CompassCardAdapter
    implements CompassCardListener {
        DlgCompassCard adaptee;

        DlgCompassCard_CompassCardAdapter(DlgCompassCard adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void orientationChanged(OrientationEvent oe) {
            this.adaptee.orientationChanged(oe);
        }
    }

    class DlgCompassCard_actionAdapter
    implements ActionListener {
        DlgCompassCard adaptee;

        DlgCompassCard_actionAdapter(DlgCompassCard adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            this.adaptee.actionPerformed(ae);
        }
    }
}

