/*
 * Decompiled with CFR 0.152.
 */
package jecadcomp;

import enercad2007.DM_Trad;
import enercad2007.Ecad2007;
import enercad2007.Globals;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.EmptyStackException;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

public class DlgVentilation
extends JDialog {
    private static final long serialVersionUID = 1L;
    boolean modal = false;
    String title = "";
    Font FT_STAND = new Font("Dialog", 0, 11);
    JPanel jPa_0 = new JPanel();
    JPanel jPa_1 = new JPanel();
    JButton jB_esc = new JButton();
    JButton jB_ok = new JButton();
    JLabel jLa_fv = new JLabel();
    JLabel jLa_nv = new JLabel();
    DlgVentilation_ComboBoxModel mo_nv;
    JComboBox<VentilationItem[]> jCb_nv;
    DlgVentilation_ComboBoxModel mo_fv;
    JComboBox<VentilationItem[]> jCb_fv;
    double[] f_nv;
    double[] f_fv;
    String nvfv;
    JLabel jLa_qth = new JLabel();
    JLabel jLa_qth_res = new JLabel();
    JLabel jLa_qth_res_unit = new JLabel("[m\u00b3/hm\u00b2]");
    Globals globals = new Globals();
    DM_Trad gen_trad;
    DM_Trad imf_trad;
    transient DlgVentilation_EventQueue dlgNF_EQ;
    int exitstate = 0;
    String txt_nv = "<html><body>Rendement de la r&eacute;cup&eacute;ration de chaleur &eta;<sub>v</sub></body></html>";
    String txt_fv = "Efficatit\u00e9 ventilation";
    String txt_qth = "<html><body>D&eacute;bit d'air neuf thermiquement actif</body></html>";
    String txt_nv_01 = "\u00c9changeur de chaleur \u00e0 plaque";
    String txt_nv_02 = "\u00c9changeur enthalpique";
    String txt_nv_03 = "Boucle de circulation de chauffage";
    String txt_nv_04 = "Appareils de ventilation";
    String txt_nv_05 = "Appareils de ventilation (enthalpie)";
    String txt_nv_06 = "Sans r\u00e9cup\u00e9ration de chaleur";
    String txt_nv_pop_01 = "<html><body>  <table><tr>   <td valign='top'>-</td>   <td '>Construction \u00e0 flux \u00e0 contre-courant ou crois\u00e9s</td></tr></table> </body></html>";
    String txt_nv_pop_02 = "<html><body>  <table><tr>   <td valign='top'>-</td>   <td align='left'>Roue, roue thermique, plaques</td></tr></table> </body></html>";
    String txt_nv_pop_03 = "<html><body>  <table><tr>   <td valign='top'>-</td>   <td align='left'>Boucle de circulation tuyau de chauffage</td></tr></table></body></html>";
    String txt_nv_pop_04 = "<html><body>  <table width='200px'><tr>   <td valign='top'>-</td>   <td>Ventilation dans s&eacute;jour et chambre &agrave; choucher, extracteurs dans salle de bains et WC</td></tr></table> </body></html>";
    String txt_nv_pop_05 = "<html><body>  <table width='200px'><tr align='left'>   <td valign='top'>-</td>   <td>Ventilation dans s&eacute;jour et chambre &agrave; choucher, extracteurs dans salle de bains et WC,transfert par entalpie</td></tr></table> </body></html>";
    String txt_fv_01 = "<html><body>Double flux, CO<sub>2</sub> ou HR</body></html>";
    String txt_fv_02 = "Simple ou double flux";
    String txt_fv_03 = "Double flux fixe ou fen\u00eatres";
    String txt_fv_04 = "A\u00e9ration interne";
    String txt_fv_05 = "A\u00e9ration simple";
    String txt_fv_pop_01 = "<html><body>  <table width='200px'><tr>   <td valign='top'>-</td>   <td>Ventilation &agrave; double flux, &agrave; plusieurs vitesses r&eacute;gl&eacute;es en fonction du C0<sub>2</sub> ou de l'humidit\u00e9</td></tr></table> </body></html>";
    String txt_fv_pop_02 = "<html><body>  <table width='200px'><tr>\t<td valign='top'>-</td>\t<td>Ventilation &agrave; double flux - &agrave; plusieurs vitesses r&eacute;gl&eacute;es mnauellement</td>\t</tr><tr>\t<td valign='top'>-</td>\t<td>Ventilation &agrave; simple flux (avec compensation d'air par des entr&eacute;es d'air neuf), &agrave; plusieurs itesses r&eacute;gl&eacute;es en fonction due CO<sub>2</sub> ou de l'humidit&eacute;</td></tr></table> </body></html>";
    String txt_fv_pop_03 = "<html><body>  <table width='200px'><tr>   <td valign='top'>-</td>   <td>Ventilation \u00e0 double flux, &agrave; vitesse unique sans r\u00e9glage du d&eacute;bit d'air</td>   </tr><tr>   <td valign='top'>-</td>   <td>Ventilation automatique par les fen&ecirc;tres</td></tr></table> </body></html>";
    String txt_fv_pop_04 = "<html><body>  <table width='200px'><tr>   <td valign='top'>-</td>   <td>installation d'air repris dans des locaux int&eacute;rieurs borgnes (avec compensation     d'air par les fen&ecirc;tres des locaux ext&eacute;rieurs), &agrave; vitesse unique r&eacute;gl&eacute;e \u00e0 la demande</td></tr></table> </body></html>";
    String txt_fv_pop_05 = "<html><body>  <table width='200px'><tr>   <td valign='top'>-</td>   <td>Installation simple d'air repris (avec compensation d'ar par entr&eacute;es d'air neuf ou par les fen&ecirc;tres) - &agrave; vitesse unique sans r&eacute;glage du d\u00e9bit d'air</td></tr></table> </body></html>";
    String[][] nv = new String[][]{{this.txt_nv_01, this.txt_nv_02, this.txt_nv_03, this.txt_nv_04, this.txt_nv_05, this.txt_nv_06}, {this.txt_nv_pop_01, this.txt_nv_pop_02, this.txt_nv_pop_03, this.txt_nv_pop_04, this.txt_nv_pop_05, null}};
    String[][] fv = new String[][]{{this.txt_fv_01, this.txt_fv_02, this.txt_fv_03, this.txt_fv_04, this.txt_fv_05}, {this.txt_fv_pop_01, this.txt_fv_pop_02, this.txt_fv_pop_03, this.txt_fv_pop_04, this.txt_fv_pop_05}};
    String txt_rend = "<html><body>Rendement de la r&eacute;cup&eacute;ration de chaleur [&eta;<sub>v</sub>]</body></html>";
    String txt_eff = "<html><body>Facteur de correction pour l'efficatit&eacute; de la ventilation [f<sub>v</sub>]</body></html>";
    String txt_cancel = "Annuler";

    public DlgVentilation() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public DlgVentilation(JFrame frame, String title, boolean modal) {
        super(frame, title, modal);
        this.title = title;
        this.modal = modal;
        try {
            this.jbInit();
            this.pack();
            this.SetDlgLocation(frame);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public DlgVentilation(JDialog dialog, String title, boolean modal) {
        super(dialog, title, modal);
        this.modal = modal;
        this.title = title;
        try {
            this.jbInit();
            this.pack();
            this.SetDlgLocation(dialog);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public DlgVentilation(JInternalFrame internalMainFrame, String title, boolean modal) {
        super((Frame)internalMainFrame.getTopLevelAncestor(), title, modal);
        try {
            this.jbInit();
            this.globals.setLocation(this);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        if (this.globals != null) {
            this.FT_STAND = Globals.FT_STAND1;
            this.gen_trad = Ecad2007.getTraduction("gen");
            this.imf_trad = Ecad2007.getTraduction("imf");
            this.txt_nv = this.surroundHtml(this.imf_trad.getCodeLan("nv"));
            this.txt_nv_01 = this.imf_trad.getCodeLan("nv_01");
            this.txt_nv_02 = this.imf_trad.getCodeLan("nv_02");
            this.txt_nv_03 = this.imf_trad.getCodeLan("nv_03");
            this.txt_nv_04 = this.imf_trad.getCodeLan("nv_04");
            this.txt_nv_05 = this.imf_trad.getCodeLan("nv_05");
            this.txt_nv_06 = this.imf_trad.getCodeLan("nv_06");
            this.txt_nv_pop_01 = this.surroundHtml(this.imf_trad.getCodeLan("nv_pop_01"));
            this.txt_nv_pop_02 = this.surroundHtml(this.imf_trad.getCodeLan("nv_pop_02"));
            this.txt_nv_pop_03 = this.surroundHtml(this.imf_trad.getCodeLan("nv_pop_03"));
            this.txt_nv_pop_04 = this.surroundHtml(this.imf_trad.getCodeLan("nv_pop_04"));
            this.txt_nv_pop_05 = this.surroundHtml(this.imf_trad.getCodeLan("nv_pop_05"));
            this.txt_fv = this.imf_trad.getCodeLan("fv");
            this.txt_fv_01 = this.surroundHtml(this.imf_trad.getCodeLan("fv_01"));
            this.txt_fv_02 = this.imf_trad.getCodeLan("fv_02");
            this.txt_fv_03 = this.imf_trad.getCodeLan("fv_03");
            this.txt_fv_04 = this.imf_trad.getCodeLan("fv_04");
            this.txt_fv_05 = this.imf_trad.getCodeLan("fv_05");
            this.txt_fv_pop_01 = this.surroundHtml(this.imf_trad.getCodeLan("fv_pop_01"));
            this.txt_fv_pop_02 = this.surroundHtml(this.imf_trad.getCodeLan("fv_pop_02"));
            this.txt_fv_pop_03 = this.surroundHtml(this.imf_trad.getCodeLan("fv_pop_03"));
            this.txt_fv_pop_04 = this.surroundHtml(this.imf_trad.getCodeLan("fv_pop_04"));
            this.txt_fv_pop_05 = this.surroundHtml(this.imf_trad.getCodeLan("fv_pop_05"));
            this.nv = new String[][]{{this.txt_nv_01, this.txt_nv_02, this.txt_nv_03, this.txt_nv_04, this.txt_nv_05, this.txt_nv_06}, {this.txt_nv_pop_01, this.txt_nv_pop_02, this.txt_nv_pop_03, this.txt_nv_pop_04, this.txt_nv_pop_05, null}};
            this.fv = new String[][]{{this.txt_fv_01, this.txt_fv_02, this.txt_fv_03, this.txt_fv_04, this.txt_fv_05}, {this.txt_fv_pop_01, this.txt_fv_pop_02, this.txt_fv_pop_03, this.txt_fv_pop_04, this.txt_fv_pop_05}};
            this.txt_eff = this.surroundHtml(this.imf_trad.getCodeLan("efficiency"));
            this.txt_qth = this.surroundHtml(this.imf_trad.getCodeLan("qth"));
            this.txt_rend = this.surroundHtml(this.imf_trad.getCodeLan("recovery"));
            this.txt_cancel = this.gen_trad.getCodeLan("cancel");
            if (Ecad2007.getInternalMainFrames().size() > 0) {
                this.f_nv = Ecad2007.getActiveInternalMainFrame().getZone().getVentPerformances();
                this.f_fv = Ecad2007.getActiveInternalMainFrame().getZone().getVentEfficiencies();
                this.nvfv = Ecad2007.getActiveInternalMainFrame().getZone().getNvFv();
            }
        }
        this.getContentPane().setLayout(null);
        this.addKeyListener(new DlgVentilation_KeyAdapter(this));
        this.jPa_0.setBounds(new Rectangle(0, 0, 510, 160));
        this.jPa_0.setLayout(null);
        this.jPa_0.setSize(new Dimension(500, 196));
        this.jB_esc.setText(this.txt_cancel);
        this.jB_esc.addActionListener(new DlgVentilation_ActionAdapter(this));
        this.jB_esc.setBounds(new Rectangle(374, 162, 100, 22));
        this.jB_esc.setFont(this.FT_STAND);
        this.jB_esc.setBorder(BorderFactory.createRaisedBevelBorder());
        this.jB_ok.setText("Ok");
        this.jB_ok.setBounds(new Rectangle(267, 162, 100, 22));
        this.jB_ok.setFont(this.FT_STAND);
        this.jB_ok.setBorder(BorderFactory.createRaisedBevelBorder());
        this.jB_ok.addActionListener(new DlgVentilation_ActionAdapter(this));
        this.jB_ok.addKeyListener(new DlgVentilation_KeyAdapter(this));
        this.jPa_1.setFont(this.FT_STAND);
        this.jPa_1.setBorder(BorderFactory.createLoweredBevelBorder());
        this.jPa_1.setBounds(new Rectangle(5, 10, 500, 110));
        this.jPa_1.setLayout(null);
        this.jPa_1.setSize(new Dimension(490, 140));
        this.setFont(this.FT_STAND);
        this.setResizable(false);
        this.setSize(new Dimension(500, 220));
        this.getContentPane().add((Component)this.jPa_0, null);
        this.jLa_nv.setBounds(9, 22, 150, 38);
        this.jLa_nv.setFont(this.FT_STAND);
        this.jLa_nv.setText(this.txt_rend);
        this.mo_nv = new DlgVentilation_ComboBoxModel(this.nv, this.f_nv);
        this.jCb_nv = new JComboBox(this.mo_nv);
        this.jCb_nv.setRenderer(new VentilationItemRenderer());
        this.jCb_nv.setBounds(new Rectangle(172, 31, 270, 20));
        this.jCb_nv.setFont(this.FT_STAND);
        this.jLa_fv.setBounds(9, 66, 150, 38);
        this.jLa_fv.setFont(this.FT_STAND);
        this.jLa_fv.setText(this.txt_eff);
        this.mo_fv = new DlgVentilation_ComboBoxModel(this.fv, this.f_fv);
        this.jCb_fv = new JComboBox(this.mo_fv);
        this.jCb_fv.setRenderer(new VentilationItemRenderer());
        this.jCb_fv.setBounds(new Rectangle(172, 74, 270, 20));
        this.jCb_fv.setFont(this.FT_STAND);
        this.setSelectedNvFv(this.nvfv);
        this.jCb_nv.addItemListener(new DlgVentilation_ItemAdapter(this));
        this.jCb_fv.addItemListener(new DlgVentilation_ItemAdapter(this));
        this.jLa_qth.setBounds(9, 100, 150, 38);
        this.jLa_qth.setFont(this.FT_STAND);
        this.jLa_qth.setText(this.txt_qth);
        this.jLa_qth_res.setBounds(172, 110, 40, 19);
        this.jLa_qth_res.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1), BorderFactory.createEmptyBorder(0, 0, 0, 2)));
        this.jLa_qth_res.setHorizontalAlignment(4);
        this.jLa_qth_res.setFont(this.FT_STAND);
        this.jLa_qth_res_unit.setBounds(220, 110, 50, 19);
        this.jLa_qth_res_unit.setFont(this.FT_STAND);
        this.jPa_1.add((Component)this.jLa_nv, null);
        this.jPa_1.add(this.jCb_nv, null);
        this.jPa_1.add((Component)this.jLa_fv, null);
        this.jPa_1.add(this.jCb_fv, null);
        this.jPa_1.add((Component)this.jLa_qth, null);
        this.jPa_1.add((Component)this.jLa_qth_res, null);
        this.jPa_1.add((Component)this.jLa_qth_res_unit, null);
        this.jPa_0.add((Component)this.jB_ok, null);
        this.jPa_0.add((Component)this.jB_esc, null);
        this.jPa_0.add((Component)this.jPa_1, null);
        this.dlgNF_EQ = new DlgVentilation_EventQueue(this);
        Toolkit.getDefaultToolkit().getSystemEventQueue().push(this.dlgNF_EQ);
    }

    private void SetDlgLocation(JDialog dialog) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dlgSize = dialog.getSize();
        Dimension size = this.getSize();
        Point dlgLocation = dialog.getLocation();
        if (dlgSize.height > screenSize.height) {
            dlgSize.height = screenSize.height;
        }
        if (dlgSize.width > screenSize.width) {
            dlgSize.width = screenSize.width;
        }
        this.setLocation((dlgSize.width - size.width) / 2 + dlgLocation.x, (dlgSize.height - size.height) / 2 + dlgLocation.y);
    }

    private int getNvId(float nv) {
        int res = 5;
        for (int ii = 0; ii <= res; ++ii) {
            if (this.f_nv[ii] != (double)nv) continue;
            res = ii;
            break;
        }
        return res;
    }

    private int getFvId(float fv) {
        int res = 4;
        for (int ii = 0; ii <= res; ++ii) {
            if (this.f_fv[ii] != (double)fv) continue;
            res = ii;
            break;
        }
        return res;
    }

    private String surroundHtml(String text) {
        return "<html><body>" + text + "</body></html>";
    }

    private void SetDlgLocation(JFrame frame) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = frame.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    public int getExitState() {
        return this.exitstate;
    }

    public double[] getEffAirFlow() {
        double[] res = new double[]{0.7, 0.0, 1.0};
        double q14 = Ecad2007.getDM_Zone(0).getNai0(0);
        Object o_nv = this.jCb_nv.getSelectedItem();
        double nv = 0.0;
        Object o_fv = this.jCb_fv.getSelectedItem();
        double fv = 0.0;
        if (o_nv instanceof VentilationItem) {
            nv = ((VentilationItem)o_nv).getFactor();
        }
        if (o_fv instanceof VentilationItem) {
            fv = ((VentilationItem)o_fv).getFactor();
        }
        res[0] = (q14 - 0.15) * (1.0 - nv);
        res[0] = res[0] / fv;
        res[0] = res[0] + 0.15;
        res[1] = nv;
        res[2] = fv;
        Globals.println("q14: " + q14 + ", nv = " + nv + ", fv = " + fv + ", res = " + res[0]);
        return res;
    }

    public int[] getSelectedNvFv() {
        int id_nv = this.jCb_nv.getSelectedIndex();
        int id_fv = this.jCb_fv.getSelectedIndex();
        return new int[]{id_nv, id_fv};
    }

    public void setSelectedNvFv(String nvfv) {
        int id_nv = 5;
        int id_fv = 2;
        double qth = 0.7;
        if (nvfv != null && nvfv.length() > 2) {
            id_nv = Globals.getIntValue(nvfv.substring(0, 1));
            id_fv = Globals.getIntValue(nvfv.substring(2));
        }
        double q14 = Ecad2007.getDM_Zone(0).getNai0(0);
        qth = (q14 - 0.15) * (1.0 - this.f_nv[id_nv]);
        qth /= this.f_fv[id_fv];
        qth += 0.15;
        try {
            this.jCb_nv.setSelectedIndex(id_nv);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.jCb_fv.setSelectedIndex(id_fv);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.jLa_qth_res.setText(String.format(new Locale("GB"), "%.2f", qth));
    }

    private void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.jB_ok) {
            this.exitstate = 2;
            this.dispose();
        }
        if (ae.getSource() == this.jB_esc) {
            this.exitstate = 0;
            this.dispose();
        }
    }

    private void keyReleased(KeyEvent ke) {
        if (ke.getKeyCode() == 10) {
            this.exitstate = 2;
            this.dispose();
        }
    }

    private void itemStateChanged(ItemEvent ie) {
        if (ie.getSource() == this.jCb_nv) {
            Object object = this.jCb_nv.getSelectedItem();
            if (object instanceof VentilationItem) {
                String tooltip = ((VentilationItem)object).getTooltip();
                this.jCb_nv.setToolTipText(tooltip);
            }
            double qth = this.getEffAirFlow()[0];
            this.jLa_qth_res.setText(String.format(new Locale("GB"), "%.2f", qth));
        } else if (ie.getSource() == this.jCb_fv) {
            Object object = this.jCb_fv.getSelectedItem();
            if (object instanceof VentilationItem) {
                String tooltip = ((VentilationItem)object).getTooltip();
                this.jCb_fv.setToolTipText(tooltip);
            }
            double qth = this.getEffAirFlow()[0];
            this.jLa_qth_res.setText(String.format(new Locale("GB"), "%.2f", qth));
        }
    }

    class VentilationItem {
        int id;
        double factor;
        String value;
        String tooltip;

        public VentilationItem(int id, String value) {
            this.id = id;
            this.value = value;
        }

        public VentilationItem(int id, String[] values) {
            this.id = id;
            if (values != null && values.length == 2) {
                this.value = values[0];
                this.tooltip = values[1];
            }
        }

        public VentilationItem(int id, double factor, String[] values) {
            this.id = id;
            if (values != null) {
                if (values.length == 2) {
                    this.value = values[0];
                    this.tooltip = values[1];
                }
                this.factor = factor;
            }
        }

        public void setId(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public void setFactor(double factor) {
            this.factor = factor;
        }

        public double getFactor() {
            return this.factor;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setTooltip(String tooltip) {
            this.tooltip = tooltip;
        }

        public String getTooltip() {
            return this.tooltip;
        }
    }

    class VentilationItemRenderer
    extends BasicComboBoxRenderer
    implements ListCellRenderer {
        VentilationItemRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof VentilationItem) {
                VentilationItem fi = (VentilationItem)value;
                this.setText(fi.getValue());
                this.setToolTipText(fi.getTooltip());
            }
            return this;
        }
    }

    class DlgVentilation_ComboBoxModel
    extends DefaultComboBoxModel {
        private static final long serialVersionUID = 1L;
        transient VentilationItem[] items;

        public DlgVentilation_ComboBoxModel(VentilationItem[] items) {
            if (items == null) {
                this.items = items;
            }
        }

        public DlgVentilation_ComboBoxModel(String[] values) {
            if (this.items != null) {
                int dim = this.items.length;
                VentilationItem[] items = new VentilationItem[dim];
                for (int ii = 0; ii < dim; ++ii) {
                    items[ii] = new VentilationItem(ii, values[ii]);
                }
                this.addItems();
            }
        }

        public DlgVentilation_ComboBoxModel(String[][] values) {
            if (values != null) {
                int dim = values[0].length;
                VentilationItem[] items = new VentilationItem[dim];
                for (int ii = 0; ii < dim; ++ii) {
                    items[ii] = new VentilationItem(ii, new String[]{values[0][ii], values[1][ii]});
                    this.addElement(items[ii]);
                }
            }
        }

        public DlgVentilation_ComboBoxModel(String[][] values, double[] factors) {
            if (values != null) {
                int dim = values[0].length;
                VentilationItem[] items = new VentilationItem[dim];
                for (int ii = 0; ii < dim; ++ii) {
                    items[ii] = new VentilationItem(ii, factors[ii], new String[]{values[0][ii], values[1][ii]});
                    this.addElement(items[ii]);
                }
            }
        }

        private void addItems() {
            if (this.items != null) {
                for (int ii = 0; ii < this.items.length; ++ii) {
                    this.addElement(this.items[ii]);
                }
            }
        }

        @Override
        public VentilationItem getSelectedItem() {
            Object selectedItem = super.getSelectedItem();
            if (selectedItem instanceof VentilationItem) {
                return (VentilationItem)super.getSelectedItem();
            }
            return null;
        }

        VentilationItem[] sort(VentilationItem[] items) {
            if (items == null) {
                return items;
            }
            if (items.length < 16) {
                return items;
            }
            VentilationItem[] res = new VentilationItem[16];
            for (int ii = 0; ii < 8; ++ii) {
                res[ii * 2] = items[ii];
                res[ii * 2 + 1] = items[ii + 8];
            }
            return res;
        }
    }

    class DlgVentilation_EventQueue
    extends EventQueue {
        DlgVentilation adaptee;

        public DlgVentilation_EventQueue(DlgVentilation adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void dispatchEvent(AWTEvent event) {
            super.dispatchEvent(event);
            if (event == null) {
                return;
            }
            if (event instanceof KeyEvent) {
                KeyEvent ke = (KeyEvent)event;
                if (ke.getKeyCode() == 10) {
                    super.pop();
                    this.adaptee.exitstate = 2;
                    this.adaptee.jB_ok.doClick();
                } else if (ke.getKeyCode() == 27) {
                    super.pop();
                    this.adaptee.jB_esc.doClick();
                }
            }
        }

        @Override
        public void pop() {
            try {
                super.pop();
            }
            catch (EmptyStackException esex) {
                Globals.println("DlgVentilation_EventQueue: " + esex.getMessage());
            }
        }
    }

    class DlgVentilation_ItemAdapter
    implements ItemListener {
        DlgVentilation adaptee;

        DlgVentilation_ItemAdapter(DlgVentilation adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void itemStateChanged(ItemEvent ie) {
            this.adaptee.itemStateChanged(ie);
        }
    }

    class DlgVentilation_KeyAdapter
    extends KeyAdapter {
        DlgVentilation adaptee;

        DlgVentilation_KeyAdapter(DlgVentilation adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void keyReleased(KeyEvent ke) {
            this.adaptee.keyReleased(ke);
        }
    }

    class DlgVentilation_ActionAdapter
    implements ActionListener {
        DlgVentilation adaptee;

        DlgVentilation_ActionAdapter(DlgVentilation adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            this.adaptee.actionPerformed(ae);
        }
    }
}

