/*
 * Decompiled with CFR 0.152.
 */
package jecadcomp;

import core.Calculation;
import enercad2007.Ecad2007;
import enercad2007.Globals;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.SystemColor;
import java.awt.TexturePaint;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import jecadcomp.Pattern;
import jecadcomp.PrivateGlassPane;

public class GraphElements
extends JPanel {
    JPanel jPa_0 = new JPanel();
    int dim = 10;
    Point[] pt = new Point[this.dim];
    JLabel[] jLa = new JLabel[this.dim];
    Font font = new Font("Dialog", 0, 11);
    Color clr_temp = new Color(255, 0, 0);
    Color clr_pp = new Color(0, 0, 255);
    Color clr_ps = new Color(0, 0, 90);
    Color clr_cond = new Color(128, 128, 255);
    Color clr_popbg = new Color(246, 250, 222);
    Color clr_popborder = new Color(180, 190, 90);
    transient Object[][] row;
    transient Object[][] data;
    String[][] flags;
    String[][] dimdata;
    int coucheCh = -1;
    int coucheSt = -1;
    int nlay;
    int rs;
    protected float rai;
    protected float rae;
    protected boolean refreshBit = false;
    boolean b_text = true;
    boolean b_inverse = false;
    boolean b_enabled = true;
    int mx = 15;
    int my = 15;
    int dx = 1;
    int dy = 1;
    int cx = 28;
    int cy = 15;
    int prevpty = 0;
    TreeMap tmCat = new TreeMap();
    Map<String, String[]> cat = new HashMap<String, String[]>();
    Rectangle rect = null;
    transient Graphics2D g2 = null;
    transient Graphics2D g2_mp = null;
    transient AlphaComposite ac = AlphaComposite.getInstance(3);
    transient BufferedImage buffG2 = null;
    transient BufferedImage buffImg = null;
    transient BufferedImage buffTemp = null;
    transient BufferedImage buffPP = null;
    transient BufferedImage buffPS = null;
    double[] ar_ps;
    double[] ar_pixps;
    double[] ar_pp;
    double[] ar_pixpp;
    double[] ar_temp;
    double[] ar_c;
    double[] ar_sd;
    double[] ar_p;
    Map config = null;
    DecimalFormat df1d;
    DecimalFormat df2;
    Globals globals = new Globals();
    transient Pattern pattern = new Pattern();
    transient Calculation calculation;
    transient GraphElements_MouseMotionAdapter gemma;
    Window parent;
    JWindow pop;
    PrivateGlassPane glasspane;
    JLabel jLa_temp = new JLabel();
    JLabel jLa_pp = new JLabel();
    JLabel jLa_ps = new JLabel();

    public GraphElements() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public GraphElements(boolean showtext) {
        this.b_text = showtext;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public GraphElements(Map<String, String[]> map) {
        this.cat = map;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public GraphElements(Map<String, String[]> map, Map config) {
        this.cat = map;
        this.config = config;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public GraphElements(Window parent, Map<String, String[]> map, Map config) {
        this.parent = parent;
        this.cat = map;
        this.config = config;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public GraphElements(Map<String, String[]> map, boolean showtext) {
        this.cat = map;
        this.b_text = showtext;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            Ecad2007.trace(ex);
        }
    }

    public GraphElements(Map<String, String[]> map, Map config, boolean showtext) {
        this.cat = map;
        this.config = config;
        this.b_text = showtext;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        if (this.parent == null) {
            this.pop = new JWindow();
        } else {
            this.parent.addComponentListener(new GraphElements_ComponentAdapter(this));
            this.parent.addWindowListener(new GraphElements_WindowAdapter(this));
            this.pop = new JWindow(this.parent);
        }
        this.df1d = Ecad2007.getDecimalFormat("#0.#");
        this.df2 = Ecad2007.getDecimalFormat("0.00");
        this.gemma = new GraphElements_MouseMotionAdapter(this);
        this.setBackground(SystemColor.control);
        this.setFont(this.font);
        this.setLayout(null);
        this.jPa_0.setBounds(new Rectangle(15, 15, 125, 125));
        this.jPa_0.setLayout(null);
        this.jPa_0.setBackground(Color.white);
        this.jPa_0.setFont(this.font);
        this.jPa_0.setBorder(BorderFactory.createLineBorder(Color.black));
        this.jPa_0.setOpaque(false);
        if (this.b_text) {
            for (int ii = 0; ii < this.dim; ++ii) {
                this.jLa[ii] = ii < 5 ? new JLabel(String.valueOf(20 - 5 * ii)) : new JLabel(String.valueOf(20 - 5 * (ii - 5)));
                this.jLa[ii].setSize(this.cx, this.cy);
                this.jLa[ii].setFont(this.font);
                this.jLa[ii].setHorizontalAlignment(0);
                this.add((Component)this.jLa[ii], null);
            }
            this.add((Component)this.jPa_0, null);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2p = (Graphics2D)g.create();
        if (this.b_text) {
            Container container = this.getParent();
            if (container == null) {
                g2p.setColor(this.getBackground());
            } else {
                g2p.setColor(container.getBackground());
            }
            g2p.fillRect(0, 0, this.dx, this.dy);
            g2p.setColor(Color.white);
            g2p.fillRect(this.mx, this.my, this.dx - 2 * this.mx, this.dy - 2 * this.my);
            g2p.setColor(Color.black);
            g2p.drawRect(this.mx, this.my, this.dx - 1 - 2 * this.mx, this.dy - 1 - 2 * this.my);
            BufferedImage image = new BufferedImage(this.cx, this.cy, 2);
            Graphics2D g2img = image.createGraphics();
            for (int ii = 0; ii < this.dim; ++ii) {
                this.jLa[ii].setFont(this.font);
                if (3 * this.cx >= this.dx && ii != 0 && ii != this.dim / 2 - 1 && ii != this.dim / 2 && ii != this.dim - 1) continue;
                image = new BufferedImage(this.cx, this.cy, 2);
                g2img = image.createGraphics();
                this.jLa[ii].paint(g2img);
                g2img.dispose();
                if (ii == 0) {
                    g2p.drawImage(image, null, this.pt[ii].x + 2, this.pt[ii].y);
                    continue;
                }
                if (ii == 4) {
                    g2p.drawImage(image, null, this.pt[ii].x - 2, this.pt[ii].y);
                    continue;
                }
                g2p.drawImage(image, null, this.pt[ii].x, this.pt[ii].y);
            }
        } else {
            g2p.setColor(Color.white);
            g2p.fillRect(0, 0, this.dx, this.dy);
        }
        if (this.buffImg != null) {
            g2p.drawImage(this.buffImg, null, 0, 0);
        }
        if (this.buffG2 != null) {
            g2p.drawImage(this.buffG2, null, 0, 0);
        }
    }

    private void drawComponent() {
        int cx = 28;
        int m5x = this.dx - cx - 3;
        if (this.pt == null) {
            return;
        }
        this.pt[0] = new Point(3, this.dy - this.my + 1);
        this.pt[1] = new Point((m5x - 3) / 4 + 3, this.dy - this.my + 1);
        this.pt[2] = new Point((m5x - 3) / 2 + 3, this.dy - this.my + 1);
        this.pt[3] = new Point(m5x - (m5x - 3) / 4, this.dy - this.my + 1);
        this.pt[4] = new Point(m5x, this.dy - this.my + 1);
        this.pt[5] = new Point(3, -1);
        this.pt[6] = new Point((m5x - 3) / 4 + 3, -1);
        this.pt[7] = new Point((m5x - 3) / 2 + 3, -1);
        this.pt[8] = new Point(m5x - (m5x - 3) / 4, -1);
        this.pt[9] = new Point(m5x, -1);
        if (this.b_text) {
            this.jPa_0.setBounds(this.mx, this.my, this.dx - 2 * this.mx, this.dy - 2 * this.my);
            for (int ii = 0; ii < this.dim; ++ii) {
                if (ii == 0) {
                    this.jLa[ii].setLocation(this.pt[ii].x + 2, this.pt[ii].y);
                    continue;
                }
                if (ii == 4) {
                    this.jLa[ii].setLocation(this.pt[ii].x - 2, this.pt[ii].y);
                    continue;
                }
                this.jLa[ii].setLocation(this.pt[ii]);
            }
        } else {
            this.jPa_0.setBounds(0, 0, this.dx, this.dy);
        }
    }

    private int getCoucheChByFlags() {
        int res = -1;
        int flag = 0;
        if (this.flags == null) {
            return res;
        }
        for (int ii = 0; ii < this.flags.length; ++ii) {
            if (this.flags[ii][0] == null || this.flags[ii][0].equals("") || this.flags[ii][0].equals("-") || ((flag = Globals.getIntValue(this.flags[ii][0])) & 0x10) != 16) continue;
            res = ii;
            break;
        }
        return res;
    }

    private int getCoucheStByFlags() {
        int res = -1;
        int flag = 0;
        if (this.flags == null) {
            return res;
        }
        for (int ii = 0; ii < this.flags.length; ++ii) {
            if (this.flags[ii][0] == null || this.flags[ii][0].equals("") || this.flags[ii][0].equals("-") || ((flag = Globals.getIntValue(this.flags[ii][0])) & 0x20) != 32) continue;
            res = ii;
            break;
        }
        return res;
    }

    public boolean getTempStatus() {
        return this.b_inverse;
    }

    public boolean getRefreshBit() {
        return this.refreshBit;
    }

    public void refreshCatalog(Map<String, String[]> catalog) {
        this.cat = catalog;
    }

    @Override
    @Deprecated
    public void setBackground(Color color) {
        Graphics2D g22 = null;
        if (this.dx <= 0) {
            return;
        }
        if (this.dy <= 0) {
            return;
        }
        if (this.getGraphics() != null) {
            g22 = (Graphics2D)this.getGraphics().create();
        }
        this.buffG2 = new BufferedImage(this.dx, this.dy, 2);
        this.g2 = this.buffG2.createGraphics();
        if (color != null) {
            this.g2.setColor(color);
        } else {
            this.g2.setColor(Color.white);
        }
        this.g2.fillRect(0, 0, this.dx, this.dy);
        if (g22 != null) {
            g22.drawImage(this.buffG2, null, 0, 0);
        }
        this.refreshBit = true;
    }

    @Override
    public void setBounds(Rectangle rect) {
        this.rect = rect;
        this.dx = rect.width;
        this.dy = rect.height;
        if (this.dx <= 0) {
            this.dx = 1;
        }
        if (this.dy <= 0) {
            this.dy = 1;
        }
        this.setSize(rect.width, rect.height);
        this.setLocation(rect.x, rect.y);
        this.drawComponent();
    }

    @Override
    public void setFont(Font font) {
        this.font = font;
    }

    public void setGlassPaneVisible(boolean visible) {
        if (this.glasspane != null) {
            this.glasspane.setVisible(visible);
        }
    }

    public void setMargins(int x, int y) {
        this.mx = x;
        this.my = y;
    }

    private void setPopupText(String[] text) {
        if (text == null) {
            return;
        }
        if (text.length > 0) {
            this.jLa_temp.setText(text[0]);
        }
        if (this.coucheCh == -1) {
            if (text.length > 1) {
                this.jLa_pp.setText(text[1]);
            }
            if (text.length > 2) {
                this.jLa_ps.setText(text[2]);
            }
        } else {
            this.jLa_pp.setText("");
            this.jLa_ps.setText("");
        }
    }

    public void hidePopup() {
        if (this.pop == null) {
            return;
        }
        this.g2.drawImage(this.buffG2, null, 0, 0);
        this.pop.setVisible(false);
        if (this.glasspane != null) {
            this.glasspane.setVisible(false);
            this.glasspane = null;
        }
    }

    public void addMousePointerLine() {
        if (Ecad2007.getLicenseLevel() < 2L) {
            return;
        }
        this.listenerList.add(GraphElements_MouseMotionAdapter.class, this.gemma);
        this.jPa_0.addMouseMotionListener(this.gemma);
        this.createPopup();
    }

    public void removeMousePointerLine() {
        this.listenerList.remove(GraphElements_MouseMotionAdapter.class, this.gemma);
        this.jPa_0.removeMouseMotionListener(this.gemma);
    }

    private void createPopup() {
        int width = 60;
        int height = 60;
        this.pop = this.parent == null ? new JWindow() : new JWindow(this.parent);
        JPanel jPa_pop = new JPanel();
        jPa_pop.setLayout(null);
        jPa_pop.setBounds(0, 0, width, height);
        jPa_pop.setOpaque(true);
        jPa_pop.setBackground(this.clr_popbg);
        jPa_pop.setBorder(BorderFactory.createLineBorder(this.clr_popborder));
        this.jLa_temp.setBounds(5, 5, width - 10, 17);
        this.jLa_temp.setFont(this.font);
        this.jLa_temp.setHorizontalAlignment(4);
        this.jLa_temp.setForeground(this.clr_temp);
        this.jLa_temp.setBackground(this.clr_popbg);
        this.jLa_pp.setBounds(5, 39, width - 10, 17);
        this.jLa_pp.setFont(this.font);
        this.jLa_pp.setHorizontalAlignment(4);
        this.jLa_pp.setForeground(this.clr_pp);
        this.jLa_pp.setBackground(this.clr_popbg);
        this.jLa_ps.setBounds(5, 22, width - 10, 17);
        this.jLa_ps.setFont(this.font);
        this.jLa_ps.setHorizontalAlignment(4);
        this.jLa_ps.setForeground(this.clr_ps);
        this.jLa_ps.setBackground(this.clr_popbg);
        jPa_pop.add(this.jLa_temp);
        jPa_pop.add(this.jLa_ps);
        jPa_pop.add(this.jLa_pp);
        this.pop.setLayout(null);
        this.pop.setSize(width, height);
        this.pop.addMouseMotionListener(this.gemma);
        this.pop.add(jPa_pop);
    }

    public void closePopup() {
        if (this.pop != null) {
            this.pop.dispose();
        }
    }

    public void setRAie(float[] raie) {
        this.rai = raie[0];
        this.rae = raie[1];
    }

    public void setRefreshBit(boolean refreshBit) {
        this.refreshBit = refreshBit;
    }

    public void setTempLabels(int intern, int extern) {
        double diff = ((double)intern - (double)extern) / 4.0;
        this.jLa[0].setText(String.valueOf(this.df1d.format(intern)));
        this.jLa[5].setText(this.jLa[0].getText());
        this.jLa[1].setText(String.valueOf(this.df1d.format((double)intern - diff)));
        this.jLa[2].setText(String.valueOf(this.df1d.format((double)intern - 2.0 * diff)));
        this.jLa[3].setText(String.valueOf(this.df1d.format((double)intern - 3.0 * diff)));
        for (int ii = 1; ii < 4; ++ii) {
            this.jLa[ii + 5].setText(this.jLa[ii].getText());
            this.jLa[ii].setFont(this.font);
            this.jLa[ii + 5].setFont(this.font);
        }
        this.jLa[4].setText(String.valueOf(this.df1d.format(extern)));
        this.jLa[9].setText(this.jLa[4].getText());
    }

    public void drawElements(Object[][] data, String[][] dimdata, int nlay, int rs) {
        this.drawElements(data, null, dimdata, nlay, rs);
    }

    public void drawElements(Object[][] data, String[][] flags, String[][] dimdata, int nlay, int rs) {
        int cter;
        Graphics2D g22 = null;
        int mcx = 2;
        if (this.getBorder() instanceof LineBorder) {
            mcx = 1;
        }
        if (this.getGraphics() != null) {
            g22 = (Graphics2D)this.getGraphics().create();
        }
        this.buffG2 = new BufferedImage(this.dx, this.dy, 2);
        this.g2 = this.buffG2.createGraphics();
        this.buffImg = new BufferedImage(this.dx, this.dy, 2);
        Graphics2D gbi = this.buffImg.createGraphics();
        this.data = data;
        this.flags = flags;
        this.dimdata = dimdata;
        this.rs = rs;
        int laycter = 0;
        for (int ii = 0; ii < data.length && data[ii][0] != null; ++ii) {
            ++laycter;
        }
        if (nlay > laycter) {
            nlay = laycter;
        }
        this.nlay = nlay;
        TexturePaint tpPatt = null;
        gbi.setComposite(this.ac);
        Color bgcolor = null;
        Color fgcolor = null;
        double sumdim = 0.0;
        double dbly = 0.0;
        double dtmp = 1.0;
        double diff = 0.0;
        String ref = "";
        int rsref = 0;
        int itmp = 0;
        int itmp2 = 0;
        int index = 0;
        int py = 0;
        int height = 0;
        rsref = rs == 1 ? 4 : 9;
        for (cter = 0; cter < nlay && dimdata[cter][1] != null; ++cter) {
            if (this.dimdata[cter][1].equals("-1")) {
                sumdim += Globals.getDoubleValue(this.dimdata[cter][0]);
                continue;
            }
            sumdim += Globals.getDoubleValue(this.dimdata[cter][1]);
        }
        if (sumdim == 0.0) {
            return;
        }
        if (this.b_text) {
            dtmp = this.my + 1;
            dbly = (double)(this.dy - 1 - 2 * this.my) / sumdim;
        } else {
            dtmp = 2.0;
            dbly = (double)(this.dy - 2) / sumdim;
        }
        for (cter = 0; cter < nlay; ++cter) {
            String[] values;
            String pp = null;
            ref = (String)data[cter][rsref];
            index = ref.indexOf(",");
            if (index >= 0) {
                itmp = Globals.getIntValue(ref.substring(0, index), -2);
            }
            if (dimdata[cter][1] == null) break;
            diff = this.dimdata[cter][1].equals("-1") ? dbly * Globals.getDoubleValue(this.dimdata[cter][0]) : dbly * Globals.getDoubleValue(this.dimdata[cter][1]);
            if (index != -1 && ref.substring(0, index).equals("00") && (values = this.cat.get(data[cter][rsref])) != null) {
                int cols = values.length;
                itmp = Globals.getIntValue(values[cols - 1].substring(0, values[cols - 1].indexOf(",")), -2);
                pp = values[19];
            }
            if (pp != null && !pp.equals("")) {
                itmp = 100;
            }
            int type = -1;
            if (itmp == 1 || itmp >= 100) {
                String[] values2 = this.cat.get(data[cter][rsref]);
                if (values2 == null) {
                    bgcolor = Color.white;
                    fgcolor = Color.black;
                } else {
                    pp = values2[19];
                    bgcolor = this.globals.getPatternBackgroundColor(pp);
                    fgcolor = this.globals.getPatternForegroundColor(pp);
                    type = this.globals.getPatternType(pp);
                }
                py = (int)(dtmp + 0.5);
                height = (int)(diff + 0.5);
            } else if (itmp == 2 || itmp == 11) {
                bgcolor = new Color(192, 192, 192);
                fgcolor = Color.black;
            } else if (itmp == -2) {
                String[] values3 = this.cat.get(data[cter][rsref]);
                if (values3 == null) {
                    bgcolor = Color.white;
                    fgcolor = Color.black;
                } else {
                    String pattern = values3[19];
                    bgcolor = this.globals.getPatternBackgroundColor(pattern);
                    fgcolor = this.globals.getPatternForegroundColor(pattern);
                    type = this.globals.getPatternType(pattern);
                    height = (int)(diff + 0.5);
                }
            } else if (itmp == 10) {
                bgcolor = new Color(128, 128, 128);
                fgcolor = Color.black;
            } else if (itmp == 15) {
                bgcolor = new Color(96, 96, 96);
                fgcolor = Color.black;
                py = (int)(dtmp + 0.5);
                height = (int)(diff + 0.5);
            } else if (itmp == 3 || itmp == 7) {
                bgcolor = new Color(255, 191, 128);
                fgcolor = Color.black;
            } else if (itmp == 6) {
                py = (int)(dtmp + 0.5);
                bgcolor = Color.white;
                fgcolor = Color.black;
            } else if (itmp == 8) {
                bgcolor = new Color(255, 255, 128);
                fgcolor = Color.black;
                py = (int)(dtmp + 0.5);
                height = (int)(diff + 0.5);
            } else if (itmp == 12 || itmp == 14) {
                bgcolor = Color.black;
                fgcolor = Color.black;
            } else if (itmp == 16) {
                bgcolor = new Color(255, 0, 0);
                fgcolor = Color.black;
            } else if (itmp == 13) {
                bgcolor = new Color(64, 192, 255);
                fgcolor = Color.black;
            } else {
                bgcolor = Color.white;
                fgcolor = Color.black;
            }
            tpPatt = itmp == 1 || itmp >= 100 || itmp == -2 ? this.pattern.getPattern(fgcolor, bgcolor, type, py, height) : this.pattern.getPatternByTypeRef(itmp, py, height);
            if (tpPatt != null) {
                this.g2.setPaint(tpPatt);
                tpPatt = null;
            } else {
                this.g2.setColor(bgcolor);
            }
            if (itmp == 16 && diff < 1.0) {
                diff = 0.5;
            }
            if (this.b_text) {
                if (dtmp < (double)(this.dy - this.my - 2)) {
                    this.g2.fillRect(this.mx + 1, (int)dtmp, this.dx - 2 - 2 * this.mx, (int)Math.round(diff + 0.5));
                } else {
                    this.g2.fillRect(this.mx + 1, (int)dtmp, this.dx - 2 - 2 * this.mx, (int)((long)(this.dy - 1 - this.my) - Math.round(dtmp + 0.5)));
                }
            } else if (dtmp + diff < (double)(this.dy - 2)) {
                this.g2.fillRect(mcx, (int)dtmp, this.dx - 2 * mcx, (int)Math.round(diff + 0.5));
            } else {
                this.g2.fillRect(mcx, (int)dtmp, this.dx - 2 * mcx, (int)((long)(this.dy - 1) - Math.round(dtmp + 0.5)));
            }
            dtmp += diff;
            if (cter >= nlay - 1) continue;
            String _ref = (String)data[cter + 1][rsref];
            index = _ref.indexOf(",");
            if (index >= 0) {
                itmp2 = Globals.getIntValue(_ref.substring(0, index), -2);
            }
            if (itmp == 16 || itmp2 == 16) {
                gbi.setColor(Color.red);
            } else if (itmp == 1) {
                gbi.setColor(bgcolor);
            } else {
                gbi.setColor(Color.black);
            }
            if (this.b_text) {
                if (!(dtmp < (double)(this.dy - this.my - 2)) || !(dtmp > (double)(this.my + 2))) continue;
                gbi.drawLine(this.mx + 1, (int)dtmp, this.dx - 2 - this.mx, (int)dtmp);
                continue;
            }
            if (!(dtmp < (double)(this.dy - 2)) || !(dtmp > 2.0)) continue;
            gbi.drawLine(mcx, (int)dtmp, this.dx - 2 * mcx, (int)dtmp);
        }
        if (this.b_text) {
            gbi.drawLine(this.mx + 1, this.dy - this.my - 1, this.dx - 2 - this.mx, this.dy - this.my - 1);
        }
        this.g2.drawImage(this.buffImg, null, 0, 0);
        if (g22 != null) {
            g22.drawImage(this.buffG2, null, 0, 0);
        }
        this.refreshBit = true;
    }

    public void drawEmptyImageIcon(Color color) {
        Graphics2D g22 = null;
        if (this.getGraphics() != null) {
            g22 = (Graphics2D)this.getGraphics().create();
        }
        this.buffG2 = new BufferedImage(this.dx, this.dy, 2);
        this.g2 = this.buffG2.createGraphics();
        if (color != null) {
            this.g2.setColor(color);
        } else {
            this.g2.setColor(Color.white);
        }
        this.g2.fillRect(1, 1, this.dx - 3, this.dy - 3);
        if (g22 != null) {
            g22.drawImage(this.buffG2, null, 0, 0);
        }
        this.refreshBit = true;
    }

    public void drawImageIcon(ImageIcon image) {
        Graphics2D g22 = null;
        Image img = null;
        if (image != null) {
            img = image.getImage();
        }
        if (this.getGraphics() != null) {
            g22 = (Graphics2D)this.getGraphics().create();
        }
        this.buffG2 = new BufferedImage(this.dx, this.dy, 2);
        this.g2 = this.buffG2.createGraphics();
        this.g2.drawImage(img, 1, 1, this.dx - 3, this.dy - 3, null);
        if (g22 != null) {
            g22.drawImage(this.buffG2, null, 0, 0);
        }
        this.refreshBit = true;
    }

    public void drawH20Pressures(double tex, double tin, String type) {
        this.drawH20Pressures(tex, tin, false, type);
    }

    public void drawH20Pressures(double tex, double tin, boolean condensLocation, String type) {
        int ii;
        int cter;
        if (Ecad2007.getLicenseLevel() < 2L) {
            return;
        }
        if (this.data == null) {
            return;
        }
        if (this.nlay <= 0) {
            this.repaint();
            return;
        }
        this.coucheCh = this.getCoucheChByFlags();
        this.coucheSt = this.getCoucheStByFlags();
        if (this.coucheCh >= 0) {
            return;
        }
        int nt = Globals.getIntValue(this.config.get("NT"));
        double lambdaDL = Globals.getDoubleValue(this.config.get("lambdaDL"));
        double F0 = 1.0E-6;
        double d_tot = 0.0;
        double d_sum = 0.0;
        double d_pixsum = 0.0;
        double sd_tot = 0.0;
        double sd_sum = 0.0;
        double sd_pixsum = 0.0;
        double sd_pixtot = 0.0;
        double[] dimtr = new double[this.nlay];
        double[] dimpixtr = new double[this.nlay];
        double[] dd = new double[this.nlay];
        double ddpix = 0.0;
        double r_pixsum = this.rai;
        this.ar_ps = new double[this.nlay * nt + 1];
        this.ar_pp = new double[this.nlay * nt + 1];
        this.ar_c = new double[this.nlay * nt + 1];
        this.ar_sd = new double[this.nlay * nt + 1];
        this.ar_p = new double[this.nlay * nt + 1];
        double[] ar_y = new double[this.nlay * nt + 1];
        double r_tot = this.rai + this.rae;
        double r_sum = this.rae;
        int dimx = this.dx - 2 * this.mx;
        int dimy = this.dy - 2 * this.my;
        double ycmax = 0.0;
        double ycmin = dimy;
        this.ar_pixps = new double[dimy];
        this.ar_pixpp = new double[dimy];
        if (this.rai == 0.0f && this.rae == 0.0f) {
            return;
        }
        this.repaint();
        this.row = new Object[this.nlay][8];
        if (this.calculation == null) {
            this.calculation = new Calculation();
        }
        double hrel = this.calculation.getRelativeHumidity(tex);
        double pin = 0.0;
        double pex = 0.0;
        pin = tin <= 0.0 ? hrel * 3.61633E12 * Math.pow(2.718, -6150.6 / (tin + 273.33)) : hrel * 1.40574E10 * Math.pow(2.718, -3928.5 / (tin + 231.667));
        pex = tex <= 0.0 ? 3.0738805E12 * Math.pow(2.718, -6150.6 / (tex + 273.33)) : 1.194879E10 * Math.pow(2.718, -3928.5 / (tex + 231.667));
        double p_sum = pex;
        double p_pixsum = pex;
        double pmin = pex;
        double pmax = 0.0;
        this.g2 = this.buffG2.createGraphics();
        this.buffPP = new BufferedImage(this.dx, this.dy, 2);
        GeneralPath plPP = new GeneralPath(0, this.nlay * nt);
        Graphics2D gbpp = this.buffPP.createGraphics();
        this.buffPS = new BufferedImage(this.dx, this.dy, 2);
        GeneralPath plPS = new GeneralPath(0, this.nlay * nt);
        Graphics2D gbps = this.buffPS.createGraphics();
        BasicStroke stroke = new BasicStroke(0.8f);
        int rsref = 0;
        rsref = this.rs == 1 ? 4 : 9;
        for (cter = 0; cter < this.nlay; ++cter) {
            if (this.dimdata[cter][1].equals("-1")) {
                d_tot += Globals.getDoubleValue(this.dimdata[cter][0]) / 100.0;
                continue;
            }
            d_tot += Globals.getDoubleValue(this.dimdata[cter][1]) / 100.0;
        }
        for (cter = 0; cter < this.nlay; ++cter) {
            if (!this.data[cter][rsref].equals("")) {
                this.row[cter] = type.equals("0") || type.equals("1") ? (Object[])this.cat.get(this.data[cter][rsref]) : (Object[])this.cat.get(this.data[this.nlay - cter - 1][rsref]);
            }
            try {
                if (type.equals("0") || type.equals("1")) {
                    if (this.dimdata[cter][1].equals("-1")) {
                        dimtr[cter] = Globals.getDoubleValue(this.dimdata[cter][0]) / 100.0;
                        dimpixtr[cter] = Math.round(Globals.getDoubleValue(this.dimdata[cter][0]) * (double)dimy / (100.0 * d_tot));
                    } else {
                        dimtr[cter] = Globals.getDoubleValue(this.dimdata[cter][1]) / 100.0;
                        dimpixtr[cter] = Math.round(Globals.getDoubleValue(this.dimdata[cter][1]) * (double)dimy / (100.0 * d_tot));
                    }
                } else if (this.dimdata[this.nlay - cter - 1][1].equals("-1")) {
                    dimtr[cter] = Globals.getDoubleValue(this.dimdata[this.nlay - cter - 1][0]) / 100.0;
                    dimpixtr[cter] = Math.round(Globals.getDoubleValue(this.dimdata[this.nlay - cter - 1][0]) * (double)dimy / (100.0 * d_tot));
                } else {
                    dimtr[cter] = Globals.getDoubleValue(this.dimdata[this.nlay - cter - 1][1]) / 100.0;
                    dimpixtr[cter] = Math.round(Globals.getDoubleValue(this.dimdata[this.nlay - cter - 1][1]) * (double)dimy / (100.0 * d_tot));
                }
            }
            catch (NumberFormatException nfe) {
                Globals.println(nfe.getMessage());
            }
            if (this.row[cter] != null) {
                r_tot += dimtr[cter] / Globals.getDouble(this.row[cter][6]);
                double vmin = Globals.getDoubleValue(this.row[cter][9]);
                double vmax = Globals.getDoubleValue(this.row[cter][10]);
                vmin = Math.max(vmin, F0);
                if (vmax == 0.0) {
                    vmax = vmin;
                }
                if (!(vmin + vmax > 0.0)) continue;
                sd_tot += dimtr[cter] * (lambdaDL / ((vmin + vmax) / 2.0));
                sd_pixtot += dimtr[cter] * (lambdaDL / ((vmin + vmax) / 2.0));
                continue;
            }
            return;
        }
        gbpp.setComposite(this.ac);
        gbpp.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gbpp.setStroke(stroke);
        gbpp.setColor(this.clr_pp);
        gbps.setComposite(this.ac);
        gbps.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gbps.setStroke(stroke);
        gbps.setColor(this.clr_ps);
        double Tinterf = tex;
        double a1 = (tex + 273.15) / 273.16;
        double ps = 0.0;
        double vmin = 0.0;
        double vmax = 0.0;
        ps = Tinterf < 0.0 ? Math.pow(10.0, 9.09685 * (1.0 - 1.0 / a1) - 3.56654 * Math.log10(1.0 / a1) + 0.87682 * (1.0 - a1) + 2.78614) : Math.pow(10.0, 2.78614 - 5.028 * Math.log10(a1) + 10.79574 * (1.0 - 1.0 / a1) + 1.50475E-4 * (1.0 - Math.pow(10.0, 8.2969 * (1.0 - a1))) + 4.2873E-4 * Math.pow(10.0, 4.76955 * (1.0 - 1.0 / a1) - 1.0));
        ar_y[0] = this.my;
        this.ar_pp[0] = p_sum;
        this.ar_ps[0] = ps;
        for (int cter2 = 0; cter2 < this.nlay; ++cter2) {
            dd[cter2] = dimtr[cter2] / (double)nt;
            for (int index = 0; index < nt; ++index) {
                d_sum += dd[cter2];
                r_sum += dd[cter2] / Globals.getDoubleValue(this.row[cter2][6]);
                if (type.equals("0") || type.equals("1")) {
                    ar_y[cter2 * nt + index] = (double)this.my + (double)dimy * (d_sum / d_tot);
                } else {
                    ar_y[this.nlay * nt - cter2 * nt - index - 1] = (double)this.my + (double)dimy * (1.0 - d_sum / d_tot);
                }
                Tinterf = tex + r_sum / r_tot * (tin - tex);
                a1 = (Tinterf + 273.15) / 273.16;
                ps = 0.0;
                double dp = 0.0;
                ps = Tinterf < 0.0 ? Math.pow(10.0, 9.09685 * (1.0 - 1.0 / a1) - 3.56654 * Math.log10(1.0 / a1) + 0.87682 * (1.0 - a1) + 2.78614) : Math.pow(10.0, 2.78614 - 5.028 * Math.log10(a1) + 10.79574 * (1.0 - 1.0 / a1) + 1.50475E-4 * (1.0 - Math.pow(10.0, 8.2969 * (1.0 - a1))) + 4.2873E-4 * Math.pow(10.0, 4.76955 * (1.0 - 1.0 / a1) - 1.0));
                vmin = Globals.getDoubleValue(this.row[cter2][9]);
                vmax = Globals.getDoubleValue(this.row[cter2][10]);
                if (vmin == 0.0) {
                    vmin = Math.max(vmax, F0);
                }
                if (vmax == 0.0) {
                    vmax = vmin;
                }
                double sd = 0.0;
                if (vmin + vmax > 0.0) {
                    sd = lambdaDL / ((vmin + vmax) / 2.0) * dd[cter2];
                }
                dp = sd_tot == 0.0 ? 0.0 : sd / sd_tot * (pin - pex);
                sd_sum += dp;
                int ii2 = cter2 * nt + index + 1;
                this.ar_pp[ii2] = p_sum += dp;
                this.ar_ps[ii2] = ps;
                if (pmin > p_sum) {
                    pmin = p_sum;
                }
                if (pmin > ps) {
                    pmin = ps;
                }
                if (pmax < p_sum) {
                    pmax = p_sum;
                }
                if (!(pmax < ps)) continue;
                pmax = ps;
            }
        }
        ddpix = d_tot / (double)dimy;
        d_pixsum = 0.0;
        double fi = 0.0;
        double prevpixpp = 0.0;
        double prevpixps = 0.0;
        int startii = 0;
        int prevjj = 0;
        if (type.equals("0") || type.equals("1")) {
            this.ar_pixpp[0] = this.ar_pp[0];
            this.ar_pixps[0] = this.ar_ps[0];
        } else {
            this.ar_pixpp[0] = this.ar_pp[this.ar_pp.length - 1];
            this.ar_pixps[0] = this.ar_ps[this.ar_ps.length - 1];
        }
        int dimar_y = ar_y.length;
        block6: for (int jj = 0; jj < dimar_y; ++jj) {
            for (int ii3 = startii; ii3 < dimy; ++ii3) {
                if ((double)(ii3 + 1) > ar_y[jj] - (double)this.my) {
                    fi = ((double)ii3 - (ar_y[jj] - (double)this.my)) / (ar_y[jj] - ar_y[prevjj] - (double)(2 * this.my));
                    if (type.equals("0") || type.equals("1")) {
                        this.ar_pixpp[ii3] = this.ar_pp[jj] + (this.ar_pp[jj] - this.ar_pp[prevjj]) * fi;
                        prevpixpp = this.ar_pixpp[ii3];
                        this.ar_pixps[ii3] = this.ar_ps[jj] + (this.ar_ps[jj] - this.ar_ps[prevjj]) * fi;
                        prevpixps = this.ar_pixps[ii3];
                        prevjj = jj;
                    } else {
                        this.ar_pixpp[ii3] = this.ar_pp[dimar_y - jj - 1] + (this.ar_pp[dimar_y - jj - 1] - this.ar_pp[prevjj]) * fi;
                        prevpixpp = this.ar_pixpp[ii3];
                        this.ar_pixps[ii3] = this.ar_ps[dimar_y - jj - 1] + (this.ar_ps[dimar_y - jj - 1] - this.ar_ps[prevjj]) * fi;
                        prevpixps = this.ar_pixps[ii3];
                        prevjj = dimar_y - jj - 1;
                    }
                    startii = ii3;
                    continue block6;
                }
                this.ar_pixpp[ii3] = prevpixpp;
                this.ar_pixps[ii3] = prevpixps;
            }
        }
        if (type.equals("0") || type.equals("1")) {
            this.ar_pixpp[dimy - 1] = this.ar_pp[this.ar_pp.length - 1];
            this.ar_pixps[dimy - 1] = this.ar_ps[this.ar_pp.length - 1];
        } else {
            this.ar_pixpp[dimy - 1] = this.ar_pp[0];
            this.ar_pixps[dimy - 1] = this.ar_ps[0];
        }
        for (ii = 0; ii < dimy; ++ii) {
            if (!(this.ar_pixpp[ii] > this.ar_pixps[ii])) continue;
            if (ycmax < (double)ii) {
                ycmax = ii;
            }
            if (!(ycmin > (double)ii)) continue;
            ycmin = ii;
        }
        if (type.equals("0") || type.equals("1")) {
            plPP.moveTo((float)((double)this.mx + (double)dimx * (this.ar_pp[0] - pmin) / (pmax - pmin)), (float)ar_y[0]);
            plPS.moveTo((float)((double)this.mx + (double)dimx * (this.ar_ps[0] - pmin) / (pmax - pmin)), (float)ar_y[0]);
        } else {
            plPP.moveTo((float)((double)this.mx + (double)dimx * (this.ar_pp[0] - pmin) / (pmax - pmin)), (float)dimy + (float)ar_y[0]);
            plPS.moveTo((float)((double)this.mx + (double)dimx * (this.ar_ps[0] - pmin) / (pmax - pmin)), (float)dimy + (float)ar_y[0]);
        }
        for (ii = 1; ii < ar_y.length - 1; ++ii) {
            if (type.equals("0") || type.equals("1")) {
                plPP.lineTo((float)((double)this.mx + (double)dimx * (this.ar_pp[ii] - pmin) / (pmax - pmin)), (float)ar_y[ii]);
                plPS.lineTo((float)((double)this.mx + (double)dimx * (this.ar_ps[ii] - pmin) / (pmax - pmin)), (float)ar_y[ii]);
                continue;
            }
            plPP.lineTo((float)((double)this.mx + (double)dimx * (this.ar_pp[ii] - pmin) / (pmax - pmin)), (float)ar_y[ar_y.length - ii - 1]);
            plPS.lineTo((float)((double)this.mx + (double)dimx * (this.ar_ps[ii] - pmin) / (pmax - pmin)), (float)ar_y[ar_y.length - ii - 1]);
        }
        gbpp.draw(plPP);
        gbps.draw(plPS);
        if (ycmin > 0.0 && ycmax > 0.0 && ycmin < ycmax) {
            HashMap<String, ImageIcon> ic_el = this.globals.getResources("element");
            this.g2.setColor(this.clr_cond);
            if (condensLocation) {
                this.g2.fillRect(this.mx + dimx + 4, this.my + (int)(ycmin + 0.5), 8, (int)(ycmax - ycmin + 0.5));
                this.g2.drawImage(((ImageIcon)ic_el.get("drop")).getImage(), this.mx + dimx + 4, this.my + dimy - 3, null);
            } else {
                this.g2.fillRect(3, this.my + (int)(ycmin + 0.5), 8, (int)(ycmax - ycmin + 0.5));
                this.g2.drawImage(((ImageIcon)ic_el.get("drop")).getImage(), 2, this.my + dimy - 3, null);
            }
        } else {
            this.g2.setColor(this.getBackground());
            if (condensLocation) {
                this.g2.fillRect(this.mx + dimx + 4, this.my + dimy - 3, 10, 16);
            } else {
                this.g2.fillRect(2, this.my + dimy - 3, 10, 16);
            }
        }
        this.g2.drawImage(this.buffPP, null, 0, 0);
        this.g2.drawImage(this.buffPS, null, 0, 0);
    }

    public void drawTemp(double tin, double tex) {
        this.drawTemp(tin, -257.0, tex);
    }

    public void drawTemp(double tin, double th2, double tex) {
        int cter;
        if (this.data == null) {
            return;
        }
        if (this.nlay <= 0) {
            this.repaint();
            return;
        }
        int nt = Globals.getIntValue(this.config.get("NT"));
        double temp = 0.0;
        double d_tot = 0.0;
        double d_sum = 0.0;
        double d_pixsum = 0.0;
        double[] dimtr = new double[this.nlay];
        double[] dimpix = new double[this.nlay];
        double[] dd = new double[this.nlay];
        double ddpix = 0.0;
        double r_tot = this.rai + this.rae;
        double r_sum = this.rai;
        double r_pixsum = this.rai;
        int xtmp = 0;
        int ytmp = 0;
        int x0 = 0;
        boolean y0 = false;
        int dimx = this.dx - 2 * this.mx;
        int dimy = this.dy - 2 * this.my;
        int t0 = 4;
        this.ar_temp = new double[dimy];
        this.repaint();
        this.row = new Object[this.nlay][8];
        this.g2 = this.buffG2.createGraphics();
        this.buffTemp = new BufferedImage(this.dx, this.dy, 2);
        GeneralPath polyline = new GeneralPath(0, this.nlay * nt);
        Graphics2D gbt = this.buffTemp.createGraphics();
        BasicStroke stroke = new BasicStroke(0.8f);
        int rsref = 0;
        rsref = this.rs == 1 ? 4 : 9;
        int coucheCh = this.getCoucheChByFlags();
        for (cter = 0; cter < this.nlay; ++cter) {
            if (!this.data[cter][rsref].equals("")) {
                this.row[cter] = this.cat.get(this.data[cter][rsref]);
            }
            try {
                if (this.dimdata[cter][1] == null) break;
                dimtr[cter] = this.dimdata[cter][1].equals("-1") ? Double.parseDouble(this.dimdata[cter][0]) / 100.0 : Double.parseDouble(this.dimdata[cter][1]) / 100.0;
            }
            catch (NumberFormatException nfe) {
                System.out.println(nfe.getMessage());
            }
            d_tot += dimtr[cter];
            if (this.row[cter] == null) continue;
            if (cter == coucheCh) {
                r_tot += dimtr[cter] / Globals.getDoubleValue(this.row[cter][6]) / 2.0;
                continue;
            }
            if (cter <= coucheCh) continue;
            r_tot += dimtr[cter] / Globals.getDoubleValue((String)this.row[cter][6]);
        }
        gbt.setComposite(this.ac);
        gbt.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gbt.setStroke(stroke);
        gbt.setColor(this.clr_temp);
        if (tin < tex) {
            this.b_inverse = true;
            polyline.moveTo(this.mx, this.my - t0);
        } else {
            x0 = this.mx - 1;
            polyline.moveTo(this.dx - this.mx - 1, this.my - t0);
        }
        for (cter = 0; cter < this.nlay; ++cter) {
            dd[cter] = dimtr[cter] / (double)nt;
            for (int index = 0; index < nt; ++index) {
                if (tin < tex) {
                    xtmp = (int)(r_sum / r_tot * (double)dimx) + this.mx;
                    ytmp = (int)((double)dimy * d_sum / d_tot) + this.my;
                } else {
                    xtmp = this.dx - this.mx - 1 - (int)(r_sum / r_tot * (double)dimx);
                    ytmp = (int)(d_sum / d_tot * (double)dimy) + this.my;
                }
                polyline.lineTo(xtmp, ytmp);
                d_sum += dd[cter];
                if (this.row[cter] == null) continue;
                if (cter == coucheCh && index >= 10) {
                    r_sum += dd[cter] / Globals.getDoubleValue(this.row[cter][6]);
                    continue;
                }
                if (cter <= coucheCh) continue;
                r_sum += dd[cter] / Globals.getDoubleValue(this.row[cter][6]);
            }
        }
        ddpix = d_tot / (double)dimy;
        double ddtmp = 0.0;
        int itmp = -1;
        for (int cter2 = 0; cter2 < dimy; ++cter2) {
            if (tin < tex) {
                this.ar_temp[cter2] = temp = r_pixsum / r_tot * (tex - tin) + tin;
            } else {
                temp = r_pixsum / r_tot * (tin - tex) + tex;
                this.ar_temp[cter2] = tin - temp;
            }
            if (itmp < this.nlay) {
                if (ddtmp < d_pixsum) {
                    ddtmp += dimtr[itmp + 1];
                    ++itmp;
                }
                if (itmp >= 0 && this.row[itmp] != null) {
                    r_pixsum += ddpix / Double.parseDouble((String)this.row[itmp][6]);
                }
            }
            d_pixsum += ddpix;
        }
        if (tin < tex) {
            polyline.lineTo(this.dx - this.mx - 1, this.dy - this.my + t0);
        } else {
            polyline.lineTo(this.mx, this.dy - this.my + t0);
        }
        gbt.draw(polyline);
        this.g2.drawImage(this.buffTemp, null, 0, 0);
    }

    public void drawPatternByTypeRef(int typeRef) {
        int mcx = 2;
        if (this.getBorder() instanceof LineBorder) {
            mcx = 1;
        }
        this.buffG2 = new BufferedImage(this.dx, this.dy, 2);
        this.g2 = this.buffG2.createGraphics();
        this.buffImg = new BufferedImage(this.dx, this.dy, 2);
        Graphics2D gbi = this.buffImg.createGraphics();
        TexturePaint tpPatt = null;
        gbi.setComposite(this.ac);
        double dtmp = 1.0;
        tpPatt = this.pattern.getPatternByTypeRef(typeRef, 0, this.rect.height);
        if (tpPatt != null) {
            this.g2.setPaint(tpPatt);
            tpPatt = null;
        }
        this.g2.fillRect(mcx, (int)dtmp, this.dx - 2 * mcx, (int)((long)(this.dy - 1) - Math.round(dtmp + 0.5)));
        this.g2.drawImage(this.buffImg, null, 0, 0);
        this.refreshBit = true;
    }

    public void drawPattern(String _pattern) {
        Graphics2D g22 = null;
        int mcx = 2;
        if (this.getBorder() instanceof LineBorder) {
            mcx = 1;
        }
        if (this.getGraphics() != null) {
            g22 = (Graphics2D)this.getGraphics().create();
        }
        this.buffG2 = new BufferedImage(this.dx, this.dy, 2);
        this.g2 = this.buffG2.createGraphics();
        this.buffImg = new BufferedImage(this.dx, this.dy, 2);
        Graphics2D gbi = this.buffImg.createGraphics();
        TexturePaint tpPatt = null;
        gbi.setComposite(this.ac);
        Color bgcolor = this.globals.getPatternBackgroundColor(_pattern);
        Color fgcolor = this.globals.getPatternForegroundColor(_pattern);
        int type = this.globals.getPatternType(_pattern);
        double dtmp = 1.0;
        if (bgcolor == null && fgcolor == null) {
            if (type == 2 || type == 11) {
                bgcolor = new Color(192, 192, 192);
                fgcolor = Color.black;
            } else if (type == 10) {
                bgcolor = new Color(128, 128, 128);
                fgcolor = Color.black;
            } else if (type == 15) {
                bgcolor = new Color(96, 96, 96);
                fgcolor = Color.black;
            } else if (type == 3 || type == 7) {
                bgcolor = new Color(255, 191, 128);
                fgcolor = Color.black;
            } else if (type == 6) {
                bgcolor = Color.white;
                fgcolor = Color.black;
            } else if (type == 8) {
                bgcolor = new Color(255, 255, 128);
                fgcolor = Color.black;
            } else if (type == 12 || type == 14) {
                bgcolor = Color.black;
                fgcolor = Color.black;
            } else if (type == 16) {
                bgcolor = new Color(255, 0, 0);
                fgcolor = Color.black;
            } else if (type == 13) {
                bgcolor = new Color(64, 192, 255);
                fgcolor = Color.black;
            } else {
                bgcolor = Color.white;
                fgcolor = Color.black;
            }
        }
        if ((tpPatt = this.pattern.getPattern(fgcolor, bgcolor, type, 0, this.rect.height)) != null) {
            this.g2.setPaint(tpPatt);
            tpPatt = null;
        } else {
            this.g2.setColor(bgcolor);
        }
        this.g2.fillRect(mcx, (int)dtmp, this.dx - 2 * mcx, (int)((long)(this.dy - 1) - Math.round(dtmp + 0.5)));
        this.g2.drawImage(this.buffImg, null, 0, 0);
        if (g22 != null) {
            g22.drawImage(this.buffG2, null, 0, 0);
        }
        this.refreshBit = true;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.b_enabled = enabled;
        this.pop.setVisible(false);
    }

    public void drawWindow(double ff, double fc) {
        int fmx;
        Graphics2D g22 = null;
        int fmy = fmx = (int)((double)(this.dx + this.dy) - Math.sqrt(Math.pow(this.dx + this.dy, 2.0) - 4.0 * ff * (double)this.dx * (double)this.dy)) / 4;
        int fdx = this.dx - 2 * fmx;
        int fdy = this.dy - 2 * fmy;
        if (this.getGraphics() != null) {
            g22 = (Graphics2D)this.getGraphics().create();
        }
        this.buffImg = new BufferedImage(this.dx, this.dy, 2);
        this.buffG2 = null;
        this.g2 = this.buffImg.createGraphics();
        this.g2.setColor(new Color(160, 160, 164));
        this.g2.fillRect(1, 1, this.dx - 3, this.dy - 3);
        if (ff < 1.0) {
            this.g2.setColor(new Color(128, 128, 255));
            this.g2.fillRect(1 + fmx, 1 + fmy, fdx - 2, fdy - 2);
            this.g2.setColor(new Color(128, 128, 128));
            this.g2.drawLine(1 + fmx, fmy + 1, fdx + fmx - 2, fmy + 1);
            this.g2.drawLine(fmx, fmy + 1, fmx, fmy + fdy - 2);
            this.g2.setColor(new Color(255, 255, 255));
            this.g2.drawLine(1 + fmx, fmy + fdy - 2, fdx + fmx - 2, fmy + fdy - 2);
            this.g2.drawLine(fmx + fdx - 2, fmy + 2, fmx + fdx - 2, fmy + fdy - 3);
        }
        if (fc > 0.0 && fc <= 1.0) {
            int vdy = (int)((double)this.dy * fc);
            this.g2.setColor(new Color(255, 255, 255));
            this.g2.fillRect(1, 1, this.dx - 3, vdy - 3);
            this.g2.setColor(new Color(224, 224, 224));
            for (int ii = 0; ii < vdy / 4; ++ii) {
                this.g2.drawLine(1, ii * 4 + 1, this.dx - 3, ii * 4 + 1);
            }
        }
        this.g2.drawImage(this.buffImg, null, 0, 0);
        if (g22 != null) {
            g22.drawImage(this.buffImg, null, 0, 0);
        }
        this.refreshBit = true;
    }

    private void mouseMoved(MouseEvent me) {
        int pty = me.getY();
        boolean b_pointer = false;
        if (!this.b_enabled) {
            return;
        }
        Object[] ll = this.listenerList.getListenerList();
        for (int ii = 0; ii < ll.length; ++ii) {
            if (!(ll[ii] instanceof GraphElements_MouseMotionAdapter) || this.nlay <= 0) continue;
            b_pointer = true;
            break;
        }
        if (me.getSource() == this.jPa_0) {
            if (b_pointer) {
                this.g2 = (Graphics2D)this.getGraphics();
                this.g2.setColor(Color.black);
                this.g2.setClip(0, 0, this.dx, this.dy - 1);
                this.g2.drawLine(this.mx, this.prevpty + this.my, this.dx - this.mx - 1, this.prevpty + this.my);
                this.g2.drawImage(this.buffG2, null, 0, 0);
                this.g2.drawLine(this.mx, pty + this.my, this.dx - this.mx - 1, pty + this.my);
                Point pter = me.getPoint();
                SwingUtilities.convertPointToScreen(pter, this);
                double temp = this.ar_temp[pty];
                if (this.ar_pixpp == null || this.ar_pixps == null) {
                    this.setPopupText(new String[]{String.format(new Locale("GB"), "%.1f \u00b0C", temp)});
                } else {
                    int pp = (int)(this.ar_pixpp[pty] + 0.5);
                    int ps = (int)(this.ar_pixps[pty] + 0.5);
                    this.setPopupText(new String[]{this.df1d.format((double)Math.round(100.0 * temp) / 100.0) + " \u00b0C", pp + " Pa", ps + " Pa"});
                }
                this.pop.setLocation(pter.x + 20, pter.y - this.pop.getHeight() - 10 + this.my);
                if (!this.pop.isVisible()) {
                    this.pop.setVisible(true);
                    if (this.parent instanceof JDialog) {
                        if (this.glasspane == null) {
                            this.glasspane = new PrivateGlassPane(new Component[]{this, this.jPa_0, this.pop}, ((JDialog)this.parent).getContentPane());
                            ((JDialog)this.parent).setGlassPane(this.glasspane);
                        }
                        this.glasspane.setVisible(true);
                    }
                }
                this.prevpty = pty;
            }
        } else if (me.getSource() == this.pop && b_pointer) {
            Point loc1 = this.jPa_0.getLocation();
            Point pter = me.getPoint();
            SwingUtilities.convertPointToScreen(pter, this.pop);
            pter.x += this.mx;
            pter.y += this.my;
            SwingUtilities.convertPointToScreen(loc1, this.jPa_0);
            Rectangle rec = new Rectangle(loc1, this.jPa_0.getSize());
            boolean b_pter = rec.contains(pter);
            if (b_pter) {
                pter = SwingUtilities.convertPoint(this.pop, me.getPoint(), this.jPa_0);
                pty = pter.y;
                SwingUtilities.convertPointToScreen(pter, this);
                double temp = this.ar_temp[pty];
                if (this.ar_pixpp != null && this.ar_pixps != null) {
                    int pp = (int)(this.ar_pixpp[pty] + 0.5);
                    int ps = (int)(this.ar_pixps[pty] + 0.5);
                    this.setPopupText(new String[]{this.df1d.format((double)Math.round(100.0 * temp) / 100.0) + " \u00b0C", pp + " Pa", ps + " Pa"});
                    this.pop.setLocation(pter.x + 20, pter.y - this.pop.getHeight() - 10 + this.my);
                }
                this.g2 = (Graphics2D)this.getGraphics();
                this.g2.setColor(Color.black);
                this.g2.setClip(0, 0, this.dx, this.dy - 1);
                this.g2.drawLine(this.mx, this.prevpty + this.my, this.dx - this.mx - 1, this.prevpty + this.my);
                this.g2.drawImage(this.buffG2, null, 0, 0);
                this.g2.drawLine(this.mx, pty + this.my, this.dx - this.mx - 1, pty + this.my);
                this.prevpty = pty;
            } else {
                this.hidePopup();
            }
        }
    }

    private void componentHidden(ComponentEvent ce) {
    }

    private void componentMoved(ComponentEvent ce) {
        if (ce.getSource() == this.parent) {
            this.closePopup();
        }
    }

    private void windowDeactivated(WindowEvent we) {
        if (we.getSource() == this.parent) {
            this.closePopup();
        }
    }

    class GraphElements_WindowAdapter
    extends WindowAdapter {
        GraphElements adaptee;

        public GraphElements_WindowAdapter(GraphElements adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void windowDeactivated(WindowEvent we) {
            this.adaptee.windowDeactivated(we);
        }
    }

    class GraphElements_ComponentAdapter
    extends ComponentAdapter {
        GraphElements adaptee;

        public GraphElements_ComponentAdapter(GraphElements adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void componentHidden(ComponentEvent ce) {
            this.adaptee.componentHidden(ce);
        }

        @Override
        public void componentMoved(ComponentEvent ce) {
            this.adaptee.componentMoved(ce);
        }
    }

    class GraphElements_MouseMotionAdapter
    extends MouseMotionAdapter {
        private GraphElements adaptee;

        public GraphElements_MouseMotionAdapter(GraphElements adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void mouseMoved(MouseEvent me) {
            this.adaptee.mouseMoved(me);
        }
    }
}

