/*
 * Decompiled with CFR 0.152.
 */
package jecadcomp;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;

public class HorizonIcon
extends ImageIcon {
    private static final long serialVersionUID = 1L;
    ImageIcon icon;
    ImageIcon icon2;
    Rectangle rec;
    int icdx = 0;
    int icdy = 0;
    int icmx = 0;
    String txt_N = "N";
    String txt_E = "E";
    String txt_S = "S";
    String txt_O = "O";
    double[] fs_b = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};

    public HorizonIcon(ImageIcon icon) {
        this.icon = icon;
        this.jBInit();
    }

    public HorizonIcon(ImageIcon icon, double[] fs_b, boolean af) {
        this.icon = icon;
        this.fs_b = fs_b;
        this.jBInit();
    }

    private void jBInit() {
        if (this.icon != null) {
            for (int ii = 0; ii < this.fs_b.length; ++ii) {
                this.fs_b[ii] = 1.0 - this.fs_b[ii];
            }
            this.rec = new Rectangle(0, 0, this.icon.getIconWidth(), this.icon.getIconHeight());
            this.icdx = this.icon.getIconWidth() / 9 * 8;
            this.icdy = this.icon.getIconHeight();
            this.icmx = this.icon.getIconWidth() - this.icdx;
            this.drawImageIcon();
        }
    }

    private void drawImageIcon() {
        int ii;
        if (this.icon == null) {
            return;
        }
        BufferedImage buffer = new BufferedImage(this.rec.width, this.rec.height, 2);
        Graphics2D g2d = buffer.createGraphics();
        Image img = this.icon.getImage();
        g2d.drawImage(img, 0, 0, this.rec.width, this.rec.height, null);
        g2d.setColor(new Color(73, 73, 73));
        double dy0 = (double)this.icdy - 2.0;
        double dyh = (double)this.icdy - 8.0;
        int dxw = this.icdx / 8 - 1;
        int dim = this.fs_b.length;
        int[] ady0 = new int[dim];
        for (ii = 0; ii < dim; ++ii) {
            ady0[ii] = (int)(dy0 - (this.fs_b[ii] * dyh * 1.8 - 0.5));
        }
        for (ii = 1; ii < dim; ++ii) {
            g2d.fillRect(this.icmx + (ii - 1) * dxw + ii, ady0[ii], dxw, (int)(dy0 - (double)ady0[ii] + 3.0));
        }
        g2d.setXORMode(new Color(190, 190, 190));
        g2d.setFont(new Font("Dialog", 1, 9));
        g2d.drawString(this.txt_N, this.icmx + 5, this.icdy / 2 + 1);
        g2d.setXORMode(new Color(200, 200, 200));
        g2d.drawString(this.txt_E, this.icmx + (dxw + 1) * 2 + 5, this.icdy / 2 + 1);
        g2d.setXORMode(new Color(200, 200, 200));
        g2d.drawString(this.txt_S, this.icmx + (dxw + 1) * 4 + 5, this.icdy / 2 + 1);
        g2d.setXORMode(new Color(200, 200, 200));
        g2d.drawString(this.txt_O, this.icmx + (dxw + 1) * 6 + 5, this.icdy / 2 + 1);
        this.icon2 = new ImageIcon(buffer);
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int ptx, int pty) {
        Graphics2D g2d = (Graphics2D)graphics;
        if (this.icon2 == null) {
            g2d.drawImage(this.icon.getImage(), 3, 2, this.rec.width, this.rec.height, null);
        } else {
            g2d.drawImage(this.icon2.getImage(), 3, 2, this.rec.width, this.rec.height, null);
        }
    }

    public void setCompassCardText(String[] ccText) {
        this.txt_N = ccText[0];
        this.txt_E = ccText[1];
        this.txt_S = ccText[2];
        this.txt_O = ccText[3];
        this.drawImageIcon();
    }

    public void setReductionFactors(double[] fs_b) {
        int dim = fs_b.length;
        if (dim != 9) {
            return;
        }
        for (int ii = 0; ii < dim; ++ii) {
            this.fs_b[ii] = 1.0 - fs_b[ii];
        }
        this.drawImageIcon();
    }

    public void setAngles(double[] as_b) {
        int dim = as_b.length;
        if (dim < 9) {
            return;
        }
        for (int ii = 0; ii < dim; ++ii) {
            this.fs_b[ii] = as_b[ii] / Math.PI * 2.0;
        }
        this.drawImageIcon();
    }
}

