/*
 * Decompiled with CFR 0.152.
 */
package jecadcomp;

import enercad2007.Globals;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jecadcomp.Pattern;

public class JHatchList
extends JPanel
implements ListSelectionListener {
    int dx = 0;
    int dy = 0;
    int dimx = 0;
    int dimy = 0;
    int dimxint = 0;
    int dimyint = 16;
    JList jli;
    DefaultListModel model;
    transient ListCellRenderer renderer;
    JScrollPane scrList;
    boolean b_valueChanged = false;
    int index = 0;
    transient Pattern pattern;
    transient TexturePaint[] tpaint;
    JLabel[] jLa;
    Font fonts;
    transient Border border;
    private Color fg = Color.black;
    private Color bg = Color.white;
    static final int[] patternType = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};

    public void drawComponent() {
    }

    public int getSelectedType() {
        int res = 0;
        int index = this.getSelectedIndex();
        if (index >= 0) {
            res = patternType[index];
        }
        return res;
    }

    protected Rectangle getRectangle() {
        Rectangle rectangle = new Rectangle(this.dx, this.dy, this.dimx, this.dimy);
        return rectangle;
    }

    public int getSelectedIndex() {
        return this.jli.getSelectedIndex();
    }

    public void setSelectedIndex(int index) {
        this.jli.setSelectedIndex(index);
        this.jli.scrollRectToVisible(new Rectangle(0, index * this.dimyint, this.dimxint, this.dimyint));
    }

    public void setSelectedType(int type) {
        for (int ii = 0; ii < patternType.length; ++ii) {
            if (type != patternType[ii]) continue;
            this.setSelectedIndex(ii);
            break;
        }
    }

    public TexturePaint getSelectedTexturePaint() {
        TexturePaint tp = null;
        Object object = this.jli.getSelectedValue();
        tp = object == null ? this.tpaint[0] : ((ListItem)object).getTexturePaint();
        return tp;
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setColor(Color.white);
        g2d.fillRect(this.dx, this.dy, this.dimx, this.dimy);
    }

    @Override
    public void setBounds(Rectangle rectangle) {
        this.dx = rectangle.x;
        this.dy = rectangle.y;
        this.dimx = rectangle.width;
        this.dimy = rectangle.height;
        this.setSize(rectangle.width, rectangle.height);
        this.setLocation(rectangle.x, rectangle.y);
        this.setJHatchList();
        this.jli.addListSelectionListener(new JHatchList_selectionAdapter(this));
    }

    @Override
    public void setBackground(Color background) {
        this.bg = background;
        this.refresh();
    }

    public void setBackground(Color background, boolean b_refresh) {
        this.bg = background;
        if (b_refresh) {
            this.refresh();
        }
    }

    @Override
    public void setForeground(Color foreground) {
        this.fg = foreground;
        this.refresh();
    }

    public void setForeground(Color foreground, boolean b_refresh) {
        this.fg = foreground;
        if (b_refresh) {
            this.refresh();
        }
    }

    private void setJHatchList() {
        int ii;
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        int dimsb = Globals.getIntValue(defaults.get("ScrollBar.width"));
        int dimtp = patternType.length;
        this.dimxint = this.dimx - dimsb - 1;
        this.tpaint = new TexturePaint[dimtp];
        this.pattern = new Pattern();
        this.tpaint[0] = this.pattern.getPattern(this.bg, this.bg, patternType[0], 0, this.dimyint);
        for (ii = 1; ii < dimtp; ++ii) {
            this.tpaint[ii] = this.pattern.getPattern(this.fg, this.bg, patternType[ii], 0, this.dimyint);
        }
        this.model = new DefaultListModel();
        this.jli = new JList(this.model);
        this.renderer = new JHatchListCellRenderer(this);
        this.jli.setCellRenderer(this.renderer);
        for (ii = 0; ii < dimtp; ++ii) {
            this.model.addElement(new ListItem(ii, this.tpaint[ii]));
        }
        this.scrList = new JScrollPane(this.jli);
        this.setLayout(new BorderLayout());
        this.add(this.scrList);
    }

    public void refresh() {
        if (this.model == null) {
            this.setJHatchList();
        } else {
            if (this.model.getSize() > 0) {
                this.model.removeAllElements();
            }
            for (int ii = 0; ii < patternType.length; ++ii) {
                this.tpaint[ii] = this.pattern.getPattern(this.fg, this.bg, patternType[ii], 0, this.dimyint);
                this.model.addElement(new ListItem(ii, this.tpaint[ii]));
            }
        }
    }

    public int getRowHeight() {
        return this.dimyint;
    }

    public void setRowHeight(int height) {
        this.dimyint = height;
    }

    @Override
    public void setBorder(Border border) {
        super.setBorder(null);
        this.border = border;
    }

    public void addListSelectionListener(ListSelectionListener aListener) {
        this.listenerList.add(ListSelectionListener.class, aListener);
    }

    public void removeListSelectionListener(ListSelectionListener aListener) {
        this.listenerList.remove(ListSelectionListener.class, aListener);
    }

    public void clearSelection() {
        this.jli.clearSelection();
    }

    public ListSelectionListener[] getListSelectionListeners() {
        return (ListSelectionListener[])this.listenerList.getListeners(ListSelectionListener.class);
    }

    protected void fireValueChanged(ListSelectionEvent lse) {
        Object[] listeners = this.listenerList.getListenerList();
        ListSelectionEvent plse = new ListSelectionEvent(this, lse.getFirstIndex(), lse.getLastIndex(), lse.getValueIsAdjusting());
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ListSelectionListener.class) continue;
            ((ListSelectionListener)listeners[i + 1]).valueChanged(plse);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent lse) {
        this.b_valueChanged = true;
        this.fireValueChanged(lse);
    }

    class JHatchList_selectionAdapter
    implements ListSelectionListener {
        JHatchList adaptee;

        JHatchList_selectionAdapter(JHatchList adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void valueChanged(ListSelectionEvent se) {
            this.adaptee.valueChanged(se);
        }
    }

    class HatchJLabel
    extends JLabel {
        transient Rectangle2D rec1;
        transient TexturePaint texturepaint;
        JHatchList parent;
        int previndex;
        boolean selected = false;

        HatchJLabel() {
            this.rec1 = new Rectangle2D.Float(0.0f, 0.0f, JHatchList.this.dimxint, JHatchList.this.dimyint);
        }

        HatchJLabel(JHatchList parent) {
            this.parent = parent;
            this.rec1 = new Rectangle2D.Float(0.0f, 0.0f, JHatchList.this.dimxint, JHatchList.this.dimyint);
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2D = (Graphics2D)g;
            float alphaValue = 0.65f;
            AlphaComposite ac = AlphaComposite.getInstance(3, alphaValue);
            g2D.setPaint(this.texturepaint);
            g2D.fill(this.rec1);
            if (this.selected) {
                g2D.setStroke(new BasicStroke(1.0f));
                Color selectcolor = this.brighter(this.parent.fg);
                g2D.setColor(selectcolor);
                g2D.drawRect(2, 2, JHatchList.this.dimxint - 5, JHatchList.this.dimyint - 6);
            }
            g2D.setStroke(new BasicStroke(1.0f));
            g2D.setColor(new Color(150, 150, 150));
            g2D.drawLine(0, JHatchList.this.dimyint - 1, JHatchList.this.dimxint, JHatchList.this.dimyint - 1);
        }

        private Color brighter(Color color) {
            Color res = color;
            long hc = 0L;
            if (color == null) {
                return (Color)UIManager.get("List.selectionBackground");
            }
            hc = color.hashCode() * -1;
            if (res.getRed() == res.getGreen() && res.getRed() == res.getBlue() && res.getGreen() == res.getBlue() && res.getRed() < 10) {
                res = new Color(25, 25, 25);
            }
            if (hc > 10000000L) {
                res = res.brighter().brighter();
            } else if (hc > 6000000L) {
                res = res.brighter();
            }
            return res;
        }

        public void setHatch(TexturePaint texturepaint) {
            this.texturepaint = texturepaint;
        }

        public void setIndex(int index) {
            this.previndex = index;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }
    }

    class JHatchListCellRenderer
    extends HatchJLabel
    implements ListCellRenderer {
        JHatchList parent;

        public JHatchListCellRenderer(JHatchList parent) {
            super(parent);
            this.parent = parent;
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setPreferredSize(new Dimension(JHatchList.this.dimxint, JHatchList.this.dimyint));
            this.setSelected(isSelected);
            if (value instanceof ListItem) {
                TexturePaint tp = ((ListItem)value).getTexturePaint();
                this.setHatch(tp);
            }
            return this;
        }
    }

    class ListItem {
        int id = -1;
        TexturePaint tpaint;

        public ListItem(int id, TexturePaint tpaint) {
            this.id = id;
            this.tpaint = tpaint;
        }

        public int getId() {
            return this.id;
        }

        public TexturePaint getTexturePaint() {
            return this.tpaint;
        }
    }
}

