/*
 * Decompiled with CFR 0.152.
 */
package jecadcomp;

import com.sun.java.swing.plaf.motif.MotifComboBoxUI;
import com.sun.java.swing.plaf.windows.WindowsComboBoxUI;
import enercad2007.Ecad2007;
import jTreeBiblio.JTreeBiblio;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxUI;

public class JTreeBiblioComboBox
extends JComboBox {
    ComboBoxRenderer renderer;
    TreeBiblioPopup treebibliopopup;
    JTreeBiblio treebiblio;
    Map datamap;
    Vector<String[]> vector;
    Font FT_STAND1 = new Font("Dialog", 0, 11);
    ItemListener itemListener;
    int dx;
    int dy;
    public int dimx;
    public int dimy;
    int colnbr = 1;
    int[] widths = null;
    int[] alignments = null;
    double[] divisors = null;
    DecimalFormat[] df = null;
    Color[] colors = null;
    int nbrlines = 6;
    Font[] fonts = null;
    String[] titles = null;
    String[] columnNames;
    String[] tooltips;

    public JTreeBiblioComboBox() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            Ecad2007.trace(ex);
        }
    }

    public JTreeBiblioComboBox(Vector<String[]> datas, String[] columnNames, String[] tooltips) {
        this.columnNames = columnNames;
        this.tooltips = tooltips;
        this.vector = datas;
        this.treebiblio = new JTreeBiblio(datas, columnNames, tooltips);
        this.updateUI();
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            Ecad2007.trace(ex);
        }
    }

    private void jbInit() throws Exception {
        this.setTreeBiblioComboBox();
        this.renderer = new ComboBoxRenderer();
        this.setRenderer(this.renderer);
        super.setSelectedIndex(-1);
    }

    @Override
    public void addItemListener(ItemListener itemListener) {
        this.itemListener = itemListener;
        super.addItemListener(itemListener);
    }

    public String getSelectedRef() {
        Object object = this.getSelectedItem();
        String res = "";
        if (object != null) {
            String[] temp = (String[])object;
            res = temp[temp.length - 1];
        }
        return res;
    }

    public void loadDatas(Vector<String[]> datas) {
        if (datas == null) {
            return;
        }
        if (datas.size() == 0) {
            return;
        }
        this.treebiblio = new JTreeBiblio(datas, this.columnNames, this.tooltips);
        this.reinitialize();
    }

    public void loadDatas(Vector<String[]> datas, String[] columnNames, String[] tooltips) {
        this.columnNames = columnNames;
        this.tooltips = tooltips;
        this.treebiblio = new JTreeBiblio(datas, columnNames, tooltips);
        this.reinitialize();
    }

    @Override
    public void setBounds(Rectangle rectangle) {
        this.dx = rectangle.x;
        this.dy = rectangle.y;
        this.dimx = rectangle.width;
        this.dimy = rectangle.height;
        int tot = 0;
        if (this.widths != null) {
            if (this.widths[0] == 0) {
                this.widths = this.treebiblio.getColumnsWidths();
            }
            for (int cter = 1; cter < this.widths.length; ++cter) {
                if (this.widths[cter] == 0) {
                    this.widths[cter] = this.dimx / this.colnbr;
                } else {
                    int n = cter;
                    this.widths[n] = this.widths[n] - 1;
                }
                tot += this.widths[cter];
            }
            this.widths[0] = this.dimx - this.dimy - tot - 2;
        } else {
            this.widths = new int[this.colnbr];
        }
        this.renderer = new ComboBoxRenderer();
        this.renderer.setPreferredSize(new Dimension(this.dimx - this.dimy, this.dimy));
        this.setRenderer(this.renderer);
        this.setSize(rectangle.width, rectangle.height);
        this.setLocation(rectangle.x, rectangle.y);
    }

    public void setColumnColors(Color[] colors) {
        this.renderer.setColumnColors(colors);
    }

    public void setColumnVisible(boolean[] visible) {
        int dim = visible.length;
        int wdim = this.widths.length;
        if (dim < 1) {
            return;
        }
        for (int ii = 1; ii < dim; ++ii) {
            if (ii >= wdim || visible[ii]) continue;
            this.widths[ii] = 0;
        }
        this.setWidths(this.widths);
    }

    public void setColumnDivisors(double[] divisors, DecimalFormat[] df) {
        int dimdiv = divisors.length;
        int dimdf = df.length;
        for (int cter = 0; cter < this.colnbr; ++cter) {
            this.divisors[cter] = cter < dimdiv ? divisors[cter] : divisors[dimdiv - 1];
            this.df[cter] = cter < dimdf ? df[cter] : df[dimdf - 1];
        }
        this.renderer.setColumnDivisor(this.divisors, this.df);
    }

    public void setColumnHorizontalTextAlignment(int[] alignments) {
        this.alignments = alignments;
        this.renderer.setColumnHorizontalTextAlignment(alignments);
    }

    public void setColumnTitles(String[] titles) {
        this.titles = titles;
        this.renderer.setColumnTitles(titles);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.renderer.setEnabled(enabled);
    }

    public void setPopupVisibleLines(int nbrlines) {
        this.nbrlines = nbrlines;
        this.treebibliopopup.setPopupVisibleLines(nbrlines);
    }

    public void setSelectedRef(String ref) {
        this.setRefSel(ref);
    }

    public void setRefSel(String ref) {
        super.removeItemListener(this.itemListener);
        this.treebiblio.setRefSel(ref);
        Object object = this.treebiblio.getDatamapObject(ref);
        this.renderer.setColumnTextes(object);
        this.setSelectedItem(object);
        super.addItemListener(this.itemListener);
    }

    @Override
    public void setSelectedIndex(int index) {
        if (index < 0) {
            this.removeSelectedItem();
        }
        this.treebiblio.collapseAll();
        super.setSelectedIndex(index);
    }

    @Override
    public void setSelectedItem(Object item) {
        if (item == null) {
            return;
        }
        this.removeAllItems();
        this.addItem(item);
        super.setSelectedItem(item);
    }

    public void setTreeBiblioComboBox() {
        this.removeAllItems();
        this.datamap = this.treebibliopopup.getDataMap();
        Collection collection = this.datamap.values();
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            this.addItem(it.next());
        }
        Object object = this.getItemAt(0);
        if (object == null) {
            int dim = this.getItemCount();
            for (int ii = 1; ii < dim && (object = this.getItemAt(ii)) == null; ++ii) {
            }
        }
        this.colnbr = object == null ? 1 : ((String[])object).length - 2;
        if (this.colnbr < 1) {
            this.colnbr = 1;
        }
        this.widths = new int[this.colnbr];
        this.colors = new Color[this.colnbr];
        this.fonts = new Font[this.colnbr];
        this.titles = new String[this.colnbr];
        this.df = new DecimalFormat[this.colnbr];
        this.divisors = new double[this.colnbr];
        for (int cter = 0; cter < this.colnbr; ++cter) {
            this.fonts[cter] = this.FT_STAND1;
            this.colors[cter] = cter % 2 == 0 ? Color.white : new Color(223, 223, 223);
        }
    }

    public void setWidths(int[] widths) {
        int tot = 0;
        int dim = widths.length;
        for (int cter = 1; cter < dim; ++cter) {
            tot += widths[cter];
        }
        widths[0] = this.dimx - this.dimy - tot - 2;
        this.renderer.setWidths(widths);
    }

    private void reinitialize() {
        this.updateUI();
        if (this.alignments != null) {
            this.setColumnHorizontalTextAlignment(this.alignments);
        }
        if (this.colors != null) {
            this.setColumnColors(this.colors);
        }
        if (this.widths != null) {
            this.setWidths(this.widths);
        }
        this.setPopupVisibleLines(this.nbrlines);
    }

    public void removeSelectedItem() {
        this.removeAllItems();
        this.renderer.clearColumnTextes();
    }

    @Override
    public void updateUI() {
        Object cui = (ComboBoxUI)UIManager.getUI(this);
        if (cui instanceof MetalComboBoxUI) {
            cui = new MetalTreeBiblioComboBoxUI(this.treebiblio);
        } else if (cui instanceof MotifComboBoxUI) {
            cui = new MotifTreeBiblioComboBoxUI(this.treebiblio);
        } else if (cui instanceof WindowsComboBoxUI) {
            cui = new WindowsTreeBiblioComboBoxUI(this.treebiblio);
        }
        this.setUI((ComboBoxUI)cui);
    }

    class TreeBiblioPopup
    implements ComboPopup,
    MouseMotionListener,
    MouseListener,
    KeyListener,
    PopupMenuListener {
        protected JComboBox comboBox;
        protected JTreeBiblio jtreebiblio;
        protected JPopupMenu popup;
        protected Color selectedBackground;
        protected Color selectedForeground;
        protected Color background;
        protected Color foreground;
        protected String code;
        protected int popupheight = 100;
        protected boolean hideNext = false;
        protected JList list = new JList();
        protected boolean mouseInside = false;

        public TreeBiblioPopup(JComboBox comboBox) {
            this.comboBox = comboBox;
            this.background = UIManager.getColor("ComboBox.background");
            this.foreground = UIManager.getColor("ComboBox.foreground");
            this.selectedBackground = UIManager.getColor("ComboBox.selectionBackground");
            this.selectedForeground = UIManager.getColor("ComboBox.selectionForeground");
            this.initializePopup();
        }

        public TreeBiblioPopup(JComboBox comboBox, JTreeBiblio jtreebiblio) {
            this.comboBox = comboBox;
            this.jtreebiblio = jtreebiblio;
            this.background = UIManager.getColor("ComboBox.background");
            this.foreground = UIManager.getColor("ComboBox.foreground");
            this.selectedBackground = UIManager.getColor("ComboBox.selectionBackground");
            this.selectedForeground = UIManager.getColor("ComboBox.selectionForeground");
            this.initializePopup();
        }

        protected Map getDataMap() {
            return this.jtreebiblio.getDataMap();
        }

        protected void setPopupVisibleLines(int nbrlines) {
            this.popupheight = this.jtreebiblio != null ? this.jtreebiblio.getRowHeight() * nbrlines + 4 : 100;
        }

        public void setTreeBiblio(JTreeBiblio jtreebiblio) {
            this.jtreebiblio = jtreebiblio;
        }

        public void setHideNext(boolean hideNext) {
            this.hideNext = hideNext;
        }

        @Override
        public void show() {
            try {
                if (this.popup.getPreferredSize().getWidth() == 0.0) {
                    this.jtreebiblio.setBounds(new Rectangle(0, 0, JTreeBiblioComboBox.this.dimx, this.popupheight));
                    this.popup.setPreferredSize(new Dimension(JTreeBiblioComboBox.this.dimx, this.popupheight));
                }
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
            }
            this.updatePopup();
            this.popup.show(this.comboBox, 0, this.comboBox.getHeight());
        }

        @Override
        public void hide() {
            this.popup.setVisible(false);
        }

        public JList getList() {
            return this.list;
        }

        @Override
        public MouseListener getMouseListener() {
            return this;
        }

        @Override
        public MouseMotionListener getMouseMotionListener() {
            return this;
        }

        @Override
        public KeyListener getKeyListener() {
            return this;
        }

        @Override
        public boolean isVisible() {
            return this.popup.isVisible();
        }

        @Override
        public void uninstallingUI() {
            this.popup.removePopupMenuListener(this);
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            if (!this.comboBox.isEnabled()) {
                return;
            }
            this.code = this.jtreebiblio.getRefSel();
            if (this.code != null) {
                this.code = this.code.trim();
            }
            int rref = -1;
            rref = this.code.indexOf(44) == -1 ? 0 : Integer.parseInt(this.code.substring(this.code.indexOf(44) + 1));
            if (rref != 0) {
                Object object = JTreeBiblioComboBox.this.treebiblio.getDatamapObject(this.code);
                JTreeBiblioComboBox.this.renderer.setColumnTextes(object);
                JTreeBiblioComboBox.this.setSelectedItem(object);
                this.comboBox.requestFocus();
            } else if (this.popup.isVisible()) {
                return;
            }
            this.togglePopup();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.mouseInside = true;
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.mouseInside = false;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 32 || e.getKeyCode() == 10) {
                this.togglePopup();
            }
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            this.hideNext = this.mouseInside;
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        protected void togglePopup() {
            if (this.isVisible() || this.hideNext) {
                this.hide();
            } else {
                this.show();
            }
            this.hideNext = false;
        }

        protected void initializePopup() {
            this.popup = new JPopupMenu();
            this.popup.setBorder(BorderFactory.createEmptyBorder());
            this.popup.setLayout(new BorderLayout());
            this.popup.setBackground(this.background);
            this.popup.addPopupMenuListener(this);
            this.popup.setPreferredSize(new Dimension(0, 0));
            this.initializeJTreeBiblio();
        }

        protected void initializeJTreeBiblio() {
            if (this.jtreebiblio != null) {
                this.jtreebiblio.addMouseListener(this);
                this.popup.add(this.jtreebiblio);
            }
        }

        protected void updatePopup() {
            this.popup.pack();
        }
    }

    class BasicComboBoxUI {
        BasicComboBoxUI() {
        }

        public void setPopupVisible(JComboBox combobox, boolean visible) {
            System.out.println("visible: " + visible + " : JComboBox visible:" + combobox.isVisible());
        }
    }

    class MotifTreeBiblioComboBoxUI
    extends MotifComboBoxUI {
        JTreeBiblio treebiblio;

        public MotifTreeBiblioComboBoxUI(JTreeBiblio treebiblio) {
            this.treebiblio = treebiblio;
        }

        @Override
        protected ComboPopup createPopup() {
            JTreeBiblioComboBox.this.treebibliopopup = new TreeBiblioPopup(this.comboBox, this.treebiblio);
            return JTreeBiblioComboBox.this.treebibliopopup;
        }
    }

    class WindowsTreeBiblioComboBoxUI
    extends WindowsComboBoxUI {
        JTreeBiblio treebiblio;

        public WindowsTreeBiblioComboBoxUI(JTreeBiblio treebiblio) {
            this.treebiblio = treebiblio;
        }

        protected ComboPopup createPopup() {
            JTreeBiblioComboBox.this.treebibliopopup = new TreeBiblioPopup(this.comboBox, this.treebiblio);
            return JTreeBiblioComboBox.this.treebibliopopup;
        }
    }

    class MetalTreeBiblioComboBoxUI
    extends MetalComboBoxUI {
        JTreeBiblio treebiblio;

        public MetalTreeBiblioComboBoxUI(JTreeBiblio treebiblio) {
            this.treebiblio = treebiblio;
        }

        @Override
        protected ComboPopup createPopup() {
            JTreeBiblioComboBox.this.treebibliopopup = new TreeBiblioPopup(this.comboBox, this.treebiblio);
            return JTreeBiblioComboBox.this.treebibliopopup;
        }
    }

    class ComboBoxRenderer
    extends JPanel
    implements ListCellRenderer {
        JLabel[] label;
        double[] divisor;
        DecimalFormat[] df;

        public ComboBoxRenderer() {
            int dimtot = 0;
            this.label = new JLabel[JTreeBiblioComboBox.this.colnbr];
            this.setLayout(null);
            for (int cter = 0; cter < JTreeBiblioComboBox.this.colnbr; ++cter) {
                this.label[cter] = new JLabel();
                if (JTreeBiblioComboBox.this.widths[cter] > 0) {
                    this.label[cter].setBounds(dimtot, 0, JTreeBiblioComboBox.this.widths[cter], JTreeBiblioComboBox.this.dimy);
                    dimtot += JTreeBiblioComboBox.this.widths[cter];
                    this.label[cter].setVerticalAlignment(1);
                    this.label[cter].setFont(JTreeBiblioComboBox.this.fonts[cter]);
                    this.label[cter].setOpaque(true);
                    this.label[cter].setBackground(JTreeBiblioComboBox.this.colors[cter]);
                    this.label[cter].setSize(JTreeBiblioComboBox.this.widths[cter], JTreeBiblioComboBox.this.dimy);
                }
                this.add(this.label[cter]);
            }
        }

        public void setColumnColors(Color[] newColors) {
            int dim = newColors.length;
            JTreeBiblioComboBox.this.colors = (Color[])newColors.clone();
            for (int ii = 0; ii < dim; ++ii) {
                this.label[ii].setBackground(JTreeBiblioComboBox.this.colors[ii]);
            }
        }

        protected void setColumnDivisor(double[] divisor, DecimalFormat[] df) {
            this.divisor = divisor;
            this.df = df;
            double tmp = 0.0;
            for (int ii = 0; ii < divisor.length; ++ii) {
                try {
                    tmp = Double.parseDouble(this.label[ii].getText());
                }
                catch (NumberFormatException nfe) {
                    System.out.println(nfe.getMessage());
                }
                if (tmp != 0.0 && divisor[ii] != 0.0) {
                    tmp /= divisor[ii];
                }
                if (this.label != null && this.label.length > ii) {
                    this.label[ii].setText(JTreeBiblioComboBox.this.titles[ii] + String.valueOf(df[ii].format(tmp)));
                }
                tmp = 0.0;
            }
        }

        public void setColumnHorizontalTextAlignment(int[] alignments) {
            int dim = alignments.length;
            for (int ii = 0; ii < dim; ++ii) {
                this.label[ii].setHorizontalAlignment(alignments[ii]);
            }
        }

        public void clearColumnTextes() {
            if (this.label == null) {
                return;
            }
            for (int ii = 0; ii < this.label.length; ++ii) {
                this.label[ii].setText(JTreeBiblioComboBox.this.titles[ii]);
            }
        }

        protected void setColumnTextes(String[] newText) {
            for (int ii = 0; ii < newText.length; ++ii) {
                try {
                    if (newText[ii] == null) {
                        this.label[ii].setText(JTreeBiblioComboBox.this.titles[ii]);
                        continue;
                    }
                    this.label[ii].setText(JTreeBiblioComboBox.this.titles[ii] + this.df[ii].format(Double.parseDouble(newText[ii]) / 100.0));
                    continue;
                }
                catch (Exception ex) {
                    if (JTreeBiblioComboBox.this.titles == null) {
                        this.label[ii].setText(newText[ii]);
                        continue;
                    }
                    if (JTreeBiblioComboBox.this.titles.length > ii) {
                        this.label[ii].setText(JTreeBiblioComboBox.this.titles[ii] + newText[ii]);
                        continue;
                    }
                    this.label[ii].setText(newText[ii]);
                }
            }
        }

        protected void setColumnTextes(Object object) {
            if (object == null) {
                return;
            }
            String[] tmp = null;
            int dim = ((String[])object).length - 2;
            if (dim > 0) {
                tmp = new String[dim];
                for (int cter = 0; cter < dim; ++cter) {
                    tmp[cter] = ((String[])object)[cter];
                }
                this.setColumnTextes(tmp);
            }
        }

        public void setColumnTitles(String[] newTitles) {
            for (int ii = 0; ii < newTitles.length; ++ii) {
                if (newTitles == null) continue;
                if (newTitles[ii] != null) {
                    this.label[ii].setText(newTitles[ii] + this.label[ii].getText());
                    continue;
                }
                this.label[ii].setText(this.label[ii].getText());
            }
        }

        @Override
        public void setEnabled(boolean enabled) {
            if (this.label != null) {
                for (int ii = 0; ii < this.label.length; ++ii) {
                    this.label[ii].setEnabled(enabled);
                }
            }
        }

        public void setWidths(int[] newWidths) {
            int dim = newWidths.length;
            int dimtot = 0;
            JTreeBiblioComboBox.this.widths = (int[])newWidths.clone();
            JTreeBiblioComboBox.this.treebiblio.setColumnsWidth(JTreeBiblioComboBox.this.widths);
            for (int ii = 0; ii < dim; ++ii) {
                this.label[ii].setBounds(dimtot, 0, JTreeBiblioComboBox.this.widths[ii], JTreeBiblioComboBox.this.dimy);
                dimtot += JTreeBiblioComboBox.this.widths[ii];
                this.label[ii].setSize(JTreeBiblioComboBox.this.widths[ii], JTreeBiblioComboBox.this.dimy);
            }
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String[] values = (String[])value;
            if (index < 0) {
                return this;
            }
            for (int cter = 0; cter < JTreeBiblioComboBox.this.colnbr; ++cter) {
                if (values == null) continue;
                if (JTreeBiblioComboBox.this.titles[cter] == null) {
                    this.label[cter].setText(values[cter]);
                    continue;
                }
                this.label[cter].setText(JTreeBiblioComboBox.this.titles[cter] + values[cter]);
            }
            return this;
        }
    }
}

