/*
 * Decompiled with CFR 0.152.
 */
package jecadcomp;

import core.Config;
import enercad2007.DM_Trad;
import enercad2007.DM_Zone;
import enercad2007.Ecad2007;
import enercad2007.Globals;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;

public class Out_Flux
extends JPanel {
    int dx = 0;
    int dy = 0;
    double eMin = 0.0;
    double eMax = 500.0;
    double OUT1 = 50.0;
    double OUT2 = 100.0;
    double OUT3 = 50.0;
    double OUT4 = 70.0;
    double OUT5 = 35.0;
    double OUTp1 = 35.0;
    double OUTp2 = 35.0;
    double OUTp5 = 35.0;
    double IN1 = 50.0;
    double IN2 = 80.0;
    double IN3 = this.OUT1 + this.OUT2 + this.OUT3 + this.OUT4 + this.OUT5 - this.IN1 - this.IN2;
    Font font = new Font("Dialog", 0, 11);
    Rectangle rect;
    transient Graphics2D g2;
    boolean b_print = false;
    String unit = "MJ/m\u00b2";
    int percents = 0;
    String pou = "%";
    String txt_flux_Qi = "Apports internes";
    String txt_flux_Qs = "Solaires";
    String txt_flux_Qh = "Chauffage";
    String txt_flux_Qtoit = "Pertes toiture";
    String txt_flux_Qmurs = "Murs";
    String txt_flux_Qfen = "Vitrage";
    String txt_flux_Qv = "Ventilation";
    String txt_flux_Qsol = "Plancher";
    DM_Trad out_trad;

    public Out_Flux() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            Ecad2007.trace(ex);
        }
    }

    public Out_Flux(boolean b_print) {
        this.b_print = b_print;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            Ecad2007.trace(ex);
        }
    }

    private void jbInit() throws Exception {
        this.out_trad = Ecad2007.getTraduction("out");
        this.txt_flux_Qi = this.out_trad.getCodeLan("flux_Qi");
        this.txt_flux_Qs = this.out_trad.getCodeLan("flux_Qs");
        this.txt_flux_Qh = this.out_trad.getCodeLan("flux_Qh");
        this.txt_flux_Qtoit = this.out_trad.getCodeLan("flux_Qtoit");
        this.txt_flux_Qmurs = this.out_trad.getCodeLan("flux_Qmurs");
        this.txt_flux_Qfen = this.out_trad.getCodeLan("flux_Qfen");
        this.txt_flux_Qv = this.out_trad.getCodeLan("flux_Qv");
        this.txt_flux_Qsol = this.out_trad.getCodeLan("flux_Qsol");
        Config config = new Config(System.getProperty("conf.file.name"));
        this.percents = config.getPropertyInt("properties", "percents");
        this.unit = Ecad2007.getCalcmod() < 7 ? "MJ/m\u00b2" : "kWH/m\u00b2";
    }

    @Override
    public void setFont(Font font) {
        this.font = font;
    }

    public void setVal(DM_Zone dm_zone) {
        this.setVal(dm_zone.getQt(), dm_zone.getQtr(), dm_zone.getQtw(), dm_zone.getQtf(), dm_zone.getQv(), dm_zone.getQsF(), dm_zone.getQpF(), dm_zone.getQeF(), dm_zone.getQTpr(), dm_zone.getQTpm(), dm_zone.getQTpf());
    }

    public void setVal(double Qt, double Qtr, double Qtw, double Qtf, double Qv, double Qsf, double Qpf, double Qef, double QTpr, double QTpm, double QTpf) {
        this.OUT1 = Qtr;
        this.OUT2 = Qt - Qtr - Qtw - Qtf;
        this.OUT3 = Qtw;
        this.OUT4 = Qv;
        this.OUT5 = Qtf;
        this.OUTp1 = QTpr;
        this.OUTp2 = QTpm;
        this.OUTp5 = QTpf;
        this.IN1 = Qef + Qpf;
        this.IN2 = Qsf;
        this.IN3 = this.OUT1 + this.OUT2 + this.OUT3 + this.OUT4 + this.OUT5 - this.IN1 - this.IN2;
        Globals.println("Out_Graph : donn\u00e9es charg\u00e9es :");
        Globals.println("OUT1 (pertes par transmission toiture) = " + Globals.format("%.1f", this.OUT1));
        Globals.println("OUT2 (pertes par transmission murs) = " + Globals.format("%.1f", this.OUT2));
        Globals.println("OUT3 (pertes par transmission fen\u00eatres) = " + Globals.format("%.1f", this.OUT3));
        Globals.println("OUT4 (pertes par ventilation) = " + Globals.format("%.1f", this.OUT4));
        Globals.println("OUT5 (pertes par transmission plancher) = " + Globals.format("%.1f", this.OUT5));
        Globals.println("OUTp1 (pertes ponts thermiques toiture) = " + Globals.format("%.1f", this.OUTp1));
        Globals.println("OUTp2 (pertes ponts thermiques murs) = " + Globals.format("%.1f", this.OUTp2));
        Globals.println("OUTp5 (pertes ponts thermiques plancher) = " + Globals.format("%.1f", this.OUTp5));
        Globals.println("IN1  (apports internes utilisables) = " + Globals.format("%.1f", this.IN1));
        Globals.println("IN2  (apports solaires utilisables) = " + Globals.format("%.1f", this.IN2));
        Globals.println("IN3  (demande de chaleur Qh) = " + Globals.format("%.1f", this.IN3));
    }

    public void setPercentOrUnits(int perorunit) {
        this.percents = perorunit;
        if (this.percents == 0) {
            this.pou = "%";
        } else {
            this.unit = Ecad2007.getCalcmod() < 7 ? "MJ/m\u00b2" : "kWH/m\u00b2";
        }
    }

    public void setUnits(int units) {
        this.unit = units == 0 ? "MJ/m\u00b2" : "kWh/m\u00b2";
    }

    @Override
    protected void paintBorder(Graphics g) {
        if (this.g2 == null) {
            this.g2 = (Graphics2D)g.create();
        }
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.b_print) {
            graphics.setColor(new Color(255, 255, 255, 0));
            graphics.fillRect(this.rect.x, this.rect.y, this.rect.width, this.rect.height);
        }
        this.paintComponentX(graphics);
    }

    public void paintComponentX(Graphics g) {
        double I_U;
        double I_O;
        double K_O;
        double G_U;
        double C_O;
        double B_U;
        double A_U;
        this.g2 = (Graphics2D)g.create();
        this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.b_print) {
            this.g2.setColor(new Color(255, 255, 255, 0));
        } else {
            this.g2.setColor(new Color(63, 63, 63));
        }
        this.g2.fillRect(0, 0, this.dx, this.dy);
        FontMetrics fm = null;
        int[] aaa = new int[]{0, 1622, 1036, 1683, 1036, 1622, 1036, 1758, 1036, 1312, 1036, 1374, 1406, 1312, 1776, 2743, 1776, 2527, 1776, 2030, 2269, 1312, 2269, 1374, 2269, 1312, 2269, 2030, 2269, 2527, 1776, 3046, 1776, 3046, 2638, 3603, 2638, 3758, 2638, 3603, 2638, 3046, 2638, 3046, 1776, 3151, 1776, 3337, 1776, 3603, 1776, 3758, 1776, 3603, 1776, 3343, 1776, 3157, 1776, 3046, 1776, 3603, 1776, 3758, 1406, 3603, 1036, 3046, 1036, 3151, 1036, 3337, 1036, 3603, 1036, 3758, 1036, 3603, 1036, 3337, 1036, 3151, 1036, 3046, 1036, 3046, 482, 3603, 482, 3758, 482, 3603, 482, 3046, 482, 3046, 1036};
        int dim = aaa.length;
        double[] vv = new double[dim];
        for (int ii = 0; ii < dim; ++ii) {
            vv[ii] = aaa[ii];
        }
        double S2 = this.IN1 + this.IN2 + this.IN3;
        double[] S1 = new double[]{0.0, this.IN1 * 100.0 / S2, this.IN2 * 100.0 / S2, this.IN3 * 100.0 / S2};
        double A_O = aaa[2];
        double C_U = aaa[28];
        double U_M = aaa[32];
        double PR = (U_M - A_O) / 100.0;
        double DA = S1[1] * PR;
        vv[6] = A_U = A_O + DA;
        vv[8] = A_U;
        vv[10] = A_U;
        vv[4] = ((double)((int)A_U) + A_O) / 2.0;
        double DB = S1[2] * PR;
        vv[14] = B_U = A_U + DB;
        vv[16] = B_U;
        vv[18] = B_U;
        vv[12] = (B_U + A_U) / 2.0;
        double DC = S1[3] * PR;
        vv[20] = C_O = C_U - DC;
        vv[22] = C_O;
        vv[24] = (C_U + C_O) / 2.0;
        vv[17] = vv[17] - DC * 0.5;
        vv[19] = vv[19] - DC * 0.5;
        double out = this.OUT1 + this.OUT2 + this.OUT3 + this.OUT4 + this.OUT5;
        double[] S3 = new double[]{0.0, this.OUT1 * 100.0 / out, this.OUT2 * 100.0 / out, this.OUT3 * 100.0 / out, this.OUT4 * 100.0 / out, this.OUT5 * 100.0 / out};
        double K_U = aaa[34];
        double G_O = aaa[92];
        double DG = S3[1] * PR;
        vv[86] = G_U = G_O + DG;
        vv[88] = G_U;
        vv[90] = (G_U + G_O) / 2.0;
        vv[84] = A_O + DG;
        vv[82] = A_O + DG;
        vv[93] = vv[85] - DG;
        vv[95] = vv[85] - DG;
        double DK = S3[5] * PR;
        vv[40] = K_O = K_U - DK;
        vv[42] = K_O;
        vv[38] = (K_U + K_O) / 2.0;
        vv[44] = U_M - DK;
        vv[46] = U_M - DK;
        vv[33] = vv[41] - DK;
        vv[31] = vv[41] - DK;
        double DH = S3[2] * PR;
        vv[66] = I_O = A_O + DG + DH;
        vv[68] = I_O;
        vv[70] = I_O;
        vv[78] = A_O - DH;
        vv[80] = A_O - DH;
        vv[76] = (A_O + A_O - DH) / 2.0;
        vv[69] = vv[69] + DH * 0.5;
        vv[71] = vv[71] + DH * 0.5;
        double DJ = S3[4] * PR;
        vv[58] = I_U = U_M - DK - DJ;
        vv[60] = I_U;
        vv[62] = I_U;
        vv[48] = U_M + DJ;
        vv[50] = U_M + DJ;
        vv[52] = (U_M + U_M + DJ) / 2.0;
        vv[55] = vv[55] + DJ * 0.5;
        vv[57] = vv[57] + DJ * 0.5;
        vv[64] = (I_U + I_O) / 2.0;
        double R = 128.0;
        double G = 128.0;
        double B = 128.0;
        this.g2.setPaint(new Color((int)R, (int)G, (int)B));
        this.g2.fill(new Rectangle2D.Double((double)this.dx * 2.7 / 10.0, (double)this.dy * 1.8 / 10.0, (double)this.dx * 4.3 / 10.0, (double)this.dx * 4.1 / 10.0));
        double zoom = 0.066 * (double)this.dx / 300.0;
        int offsetX = -20 * this.dx / 300;
        int offsetY = -10 * this.dx / 300;
        GeneralPath polygonFlux = new GeneralPath(0, (vv.length - 1) / 2);
        polygonFlux.moveTo((int)(vv[1] * zoom) + offsetX, (int)(vv[2] * zoom) + offsetY);
        for (int i = 3; i < vv.length - 1; i += 2) {
            polygonFlux.lineTo((int)(vv[i] * zoom) + offsetX, (int)(vv[i + 1] * zoom) + offsetY);
        }
        polygonFlux.closePath();
        R = 192.0;
        G = 192.0;
        B = 192.0;
        this.g2.setPaint(new Color((int)R, (int)G, (int)B));
        this.g2.fill(polygonFlux);
        if (!this.b_print) {
            this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            int yPos = 0;
            int marge = this.dx / 40;
            this.g2.setFont(this.font);
            this.g2.setPaint(Color.red);
            yPos = this.dy / 10 + 10;
            this.g2.drawString(this.txt_flux_Qi, marge, yPos);
            if (this.percents == 0) {
                this.g2.drawString(String.format("%.0f", this.IN1 / S2 * 100.0) + " %", marge, yPos + 12);
            } else {
                this.g2.drawString(Globals.format("%.1f", this.IN1) + " " + this.unit, marge, yPos + 12);
            }
            this.g2.setPaint(Color.yellow);
            yPos = this.dy / 10 + (this.dy - 15) / 3 + 10;
            this.g2.drawString(this.txt_flux_Qs, marge, yPos);
            if (this.percents == 0) {
                this.g2.drawString(Globals.format("%.0f", this.IN2 / S2 * 100.0) + " %", marge, yPos + 12);
            } else {
                this.g2.drawString(Globals.format("%.1f", this.IN2) + " " + this.unit, marge, yPos + 12);
            }
            this.g2.setPaint(Color.orange);
            yPos = this.dy / 10 + (this.dy - 15) * 2 / 3 + 10;
            this.g2.drawString(this.txt_flux_Qh, marge, yPos);
            if (this.percents == 0) {
                this.g2.drawString(Globals.format("%.0f", this.IN3 / S2 * 100.0) + " %", marge, yPos + 12);
            } else {
                this.g2.drawString(Globals.format("%.1f", this.IN3) + " " + this.unit, marge, yPos + 12);
            }
            fm = this.g2.getFontMetrics();
            this.g2.setPaint(Color.lightGray);
            yPos = this.dy / 20 + 10;
            dim = fm.stringWidth(this.txt_flux_Qtoit);
            this.g2.drawString(this.txt_flux_Qtoit, this.dx - marge - dim, yPos);
            String txt = this.percents == 0 ? Globals.format("%.0f", this.OUT1 / out * 100.0) + " %" : Globals.format("%.1f", this.OUT1) + " " + this.unit;
            dim = fm.stringWidth(txt);
            this.g2.drawString(txt, this.dx - marge - dim, yPos + 12);
            this.g2.setPaint(Color.lightGray);
            yPos = this.dy / 20 + (this.dy - 15) / 5 + 10;
            dim = fm.stringWidth(this.txt_flux_Qmurs);
            this.g2.drawString(this.txt_flux_Qmurs, this.dx - marge - dim, yPos);
            txt = this.percents == 0 ? Globals.format("%.0f", this.OUT2 / out * 100.0) + " %" : Globals.format("%.1f", this.OUT2) + " " + this.unit;
            dim = fm.stringWidth(txt);
            this.g2.drawString(txt, this.dx - marge - dim, yPos + 12);
            R = 166.0;
            G = 199.0;
            B = 239.0;
            this.g2.setPaint(new Color((int)R, (int)G, (int)B));
            yPos = this.dy / 20 + (this.dy - 15) * 2 / 5 + 10;
            dim = fm.stringWidth(this.txt_flux_Qfen);
            this.g2.drawString(this.txt_flux_Qfen, this.dx - marge - dim, yPos);
            txt = this.percents == 0 ? Globals.format("%.0f", this.OUT3 / out * 100.0) + " %" : Globals.format("%.1f", this.OUT3) + " " + this.unit;
            dim = fm.stringWidth(txt);
            this.g2.drawString(txt, this.dx - marge - dim, yPos + 12);
            this.g2.setPaint(Color.lightGray);
            yPos = this.dy / 20 + (this.dy - 15) * 3 / 5 + 10;
            dim = fm.stringWidth(this.txt_flux_Qv);
            this.g2.drawString(this.txt_flux_Qv, this.dx - marge - dim, yPos);
            txt = this.percents == 0 ? Globals.format("%.0f", this.OUT4 / out * 100.0) + " %" : Globals.format("%.1f", this.OUT4) + " " + this.unit;
            dim = fm.stringWidth(txt);
            this.g2.drawString(txt, this.dx - marge - dim, yPos + 12);
            this.g2.setPaint(Color.lightGray);
            yPos = this.dy / 20 + (this.dy - 15) * 4 / 5 + 10;
            dim = fm.stringWidth(this.txt_flux_Qsol);
            this.g2.drawString(this.txt_flux_Qsol, this.dx - marge - dim, yPos);
            txt = this.percents == 0 ? Globals.format("%.0f", this.OUT5 / out * 100.0) + " %" : Globals.format("%.1f", this.OUT5) + " " + this.unit;
            dim = fm.stringWidth(txt);
            this.g2.drawString(txt, this.dx - marge - dim, yPos + 12);
        }
    }

    public void paintComponentP(Graphics g) {
        double I_U;
        double N_O;
        double I_O;
        double M_O;
        double K_O;
        double L_U;
        double G_U;
        double C_O;
        double B_U;
        double A_U;
        this.g2 = (Graphics2D)g.create();
        this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.g2.setColor(new Color(63, 63, 63));
        this.g2.fillRect(0, 0, this.dx, this.dy);
        FontMetrics fm = null;
        int[] vList = new int[]{0, 1622, 1036, 1683, 1036, 1622, 1036, 1758, 1036, 1312, 1036, 1374, 1406, 1312, 1776, 2743, 1776, 2527, 1776, 2030, 2269, 1312, 2269, 1374, 2269, 1312, 2269, 2030, 2269, 2527, 1776, 3046, 1776, 3046, 2638, 3603, 2638, 3758, 2638, 3603, 2638, 3046, 2638, 3046, 1776, 3151, 1776, 3337, 1776, 3603, 1776, 3758, 1776, 3603, 1776, 3343, 1776, 3157, 1776, 3046, 1776, 3603, 1776, 3758, 1406, 3603, 1036, 3046, 1036, 3151, 1036, 3337, 1036, 3603, 1036, 3758, 1036, 3603, 1036, 3337, 1036, 3151, 1036, 3046, 1036, 3046, 482, 3603, 482, 3758, 482, 3603, 482, 3046, 482, 3046, 1036};
        int dim = vList.length;
        double[] vv = new double[dim];
        double[] vp = new double[dim];
        for (int ii = 0; ii < dim; ++ii) {
            vv[ii] = vList[ii];
            vp[ii] = vList[ii];
        }
        double S2 = this.IN1 + this.IN2 + this.IN3;
        double[] S1 = new double[]{0.0, this.IN1 * 100.0 / S2, this.IN2 * 100.0 / S2, this.IN3 * 100.0 / S2};
        double A_O = vList[2];
        double C_U = vList[28];
        double U_M = vList[32];
        double PR = (U_M - A_O) / 100.0;
        double DA = S1[1] * PR;
        vv[6] = A_U = A_O + DA;
        vv[8] = A_U;
        vv[10] = A_U;
        vv[4] = (A_U + A_O) / 2.0;
        double DB = S1[2] * PR;
        vv[14] = B_U = A_U + DB;
        vv[16] = B_U;
        vv[18] = B_U;
        vv[12] = (B_U + A_U) / 2.0;
        double DC = (double)((int)S1[3]) * PR;
        vv[20] = C_O = C_U - DC;
        vv[22] = C_O;
        vv[24] = (C_U + C_O) / 2.0;
        vv[17] = vv[17] - DC * 0.5;
        vv[19] = vv[19] - DC * 0.5;
        double out = this.OUT1 + this.OUT2 + this.OUT3 + this.OUT4 + this.OUT5;
        double[] S3 = new double[]{0.0, this.OUT1 * 100.0 / out, this.OUT2 * 100.0 / out, this.OUT3 * 100.0 / out, this.OUT4 * 100.0 / out, this.OUT5 * 100.0 / out};
        double K_U = vList[34];
        double G_O = vList[92];
        double DG = S3[1] * PR;
        vv[86] = G_U = G_O + DG;
        vv[88] = G_U;
        vv[90] = (G_U + G_O) / 2.0;
        vv[84] = A_O + DG;
        vv[82] = A_O + DG;
        vv[93] = vv[85] - DG;
        vv[95] = vv[85] - DG;
        double DL = this.OUTp1 * 100.0 / out * PR;
        vp[86] = L_U = G_O + DL;
        vp[88] = L_U;
        vp[90] = (L_U + G_O) / 2.0;
        vp[84] = A_O + DL;
        vp[82] = A_O + DL;
        vp[93] = vp[85] - DL;
        vp[95] = vp[85] - DL;
        double DK = S3[5] * PR;
        vv[40] = K_O = K_U - DK;
        vv[42] = K_O;
        vv[38] = (K_U + K_O) / 2.0;
        vv[44] = U_M - DK;
        vv[46] = U_M - DK;
        vv[33] = vv[41] - DK;
        vv[31] = vv[41] - DK;
        double DM = this.OUTp5 * 100.0 / out * PR;
        vp[40] = M_O = K_U - DM;
        vp[42] = M_O;
        vp[38] = (K_U + K_O) / 2.0;
        vp[44] = U_M - DM;
        vp[46] = U_M - DM;
        vp[33] = vp[41] - DM;
        vp[31] = vp[41] - DM;
        double DH = S3[2] * PR;
        vv[66] = I_O = A_O + DG + DH;
        vv[68] = I_O;
        vv[70] = I_O;
        vv[78] = A_O - DH;
        vv[80] = A_O - DH;
        vv[76] = (A_O + A_O - DH) / 2.0;
        vv[69] = vv[69] + DH * 0.5;
        vv[71] = vv[71] + DH * 0.5;
        double DN = this.OUTp2 * 100.0 / out * PR;
        vp[66] = N_O = A_O + DG + DN;
        vp[68] = N_O;
        vp[70] = N_O;
        vp[78] = A_O - DN;
        vp[80] = A_O - DN;
        vp[76] = (A_O + A_O - DN) / 2.0;
        vp[69] = vp[69] + DN * 0.5;
        vp[71] = vp[71] + DN * 0.5;
        double DJ = S3[4] * PR;
        vv[58] = I_U = U_M - DK - DJ;
        vv[60] = I_U;
        vv[62] = I_U;
        vv[48] = U_M + DJ;
        vv[50] = U_M + DJ;
        vv[52] = (U_M + U_M + DJ) / 2.0;
        vv[55] = vv[55] + DJ * 0.5;
        vv[57] = vv[57] + DJ * 0.5;
        vv[64] = (I_U + I_O) / 2.0;
        vp[64] = (I_U + I_O) / 2.0;
        double R = 128.0;
        double G = 128.0;
        double B = 128.0;
        this.g2.setPaint(new Color((int)R, (int)G, (int)B));
        this.g2.fill(new Rectangle2D.Double((double)this.dx * 2.7 / 10.0, (double)this.dy * 1.8 / 10.0, (double)this.dx * 4.3 / 10.0, (double)this.dx * 4.1 / 10.0));
        double zoom = 0.066 * (double)this.dx / 300.0;
        int offsetX = -20 * this.dx / 300;
        int offsetY = -10 * this.dx / 300;
        GeneralPath polygonFlux = new GeneralPath(0, (vv.length - 1) / 2);
        polygonFlux.moveTo((int)(vv[1] * zoom) + offsetX, (int)(vv[2] * zoom) + offsetY);
        for (int i = 3; i < vv.length - 1; i += 2) {
            polygonFlux.lineTo((int)(vv[i] * zoom) + offsetX, (int)(vv[i + 1] * zoom) + offsetY);
        }
        polygonFlux.closePath();
        R = 192.0;
        G = 192.0;
        B = 192.0;
        this.g2.setPaint(new Color((int)R, (int)G, (int)B));
        this.g2.fill(polygonFlux);
        if (!this.b_print) {
            this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            int yPos = 0;
            int marge = this.dx / 40;
            this.g2.setFont(this.font);
            this.g2.setPaint(Color.red);
            yPos = this.dy / 10 + 10;
            this.g2.drawString(this.txt_flux_Qi, marge, yPos);
            this.g2.drawString(String.format("%.0f", this.IN1 / S2 * 100.0) + " %", marge, yPos + 12);
            this.g2.setPaint(Color.yellow);
            yPos = this.dy / 10 + (this.dy - 15) / 3 + 10;
            this.g2.drawString(this.txt_flux_Qs, marge, yPos);
            this.g2.drawString(String.format("%.0f", this.IN2 / S2 * 100.0) + " %", marge, yPos + 12);
            this.g2.setPaint(Color.orange);
            yPos = this.dy / 10 + (this.dy - 15) * 2 / 3 + 10;
            this.g2.drawString(this.txt_flux_Qh, marge, yPos);
            this.g2.drawString(String.format("%.0f", this.IN3 / S2 * 100.0) + " %", marge, yPos + 12);
            fm = this.g2.getFontMetrics();
            this.g2.setPaint(Color.lightGray);
            yPos = this.dy / 20 + 10;
            dim = fm.stringWidth(this.txt_flux_Qtoit);
            this.g2.drawString(this.txt_flux_Qtoit, this.dx - marge - dim, yPos);
            String txt = Globals.format("%.0f", this.OUT1 / out * 100.0) + " %";
            dim = fm.stringWidth(txt);
            this.g2.drawString(txt, this.dx - marge - dim, yPos + 12);
            this.g2.setPaint(Color.lightGray);
            yPos = this.dy / 20 + (this.dy - 15) / 5 + 10;
            dim = fm.stringWidth(this.txt_flux_Qmurs);
            this.g2.drawString(this.txt_flux_Qmurs, this.dx - marge - dim, yPos);
            txt = Globals.format("%.0f", this.OUT2 / out * 100.0) + " %";
            dim = fm.stringWidth(txt);
            this.g2.drawString(txt, this.dx - marge - dim, yPos + 12);
            R = 166.0;
            G = 199.0;
            B = 239.0;
            this.g2.setPaint(new Color((int)R, (int)G, (int)B));
            yPos = this.dy / 20 + (this.dy - 15) * 2 / 5 + 10;
            dim = fm.stringWidth(this.txt_flux_Qfen);
            this.g2.drawString(this.txt_flux_Qfen, this.dx - marge - dim, yPos);
            txt = Globals.format("%.0f", this.OUT3 / out * 100.0) + " %";
            dim = fm.stringWidth(txt);
            this.g2.drawString(txt, this.dx - marge - dim, yPos + 12);
            this.g2.setPaint(Color.lightGray);
            yPos = this.dy / 20 + (this.dy - 15) * 3 / 5 + 10;
            dim = fm.stringWidth(this.txt_flux_Qv);
            this.g2.drawString(this.txt_flux_Qv, this.dx - marge - dim, yPos);
            txt = Globals.format("%.0f", this.OUT4 / out * 100.0) + " %";
            dim = fm.stringWidth(txt);
            this.g2.drawString(txt, this.dx - marge - dim, yPos + 12);
            this.g2.setPaint(Color.lightGray);
            yPos = this.dy / 20 + (this.dy - 15) * 4 / 5 + 10;
            dim = fm.stringWidth(this.txt_flux_Qsol);
            this.g2.drawString(this.txt_flux_Qsol, this.dx - marge - dim, yPos);
            txt = String.format("%.0f", this.OUT5 / out * 100.0) + " %";
            dim = fm.stringWidth(txt);
            this.g2.drawString(txt, this.dx - marge - dim, yPos + 12);
        }
    }

    @Override
    public void setBounds(Rectangle rect) {
        this.rect = rect;
        this.dx = rect.width;
        this.dy = rect.height;
        this.setSize(this.dx + 1, this.dy + 1);
        this.setLocation(rect.x, rect.y);
    }
}

