/*
 * Decompiled with CFR 0.152.
 */
package jecadcomp;

import enercad2007.DM_Zone;
import enercad2007.Ecad2007;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class Out_Graph2016
extends JPanel {
    private static final long serialVersionUID = 1L;
    int dx = 0;
    int dy = 0;
    int px = 15;
    double eMin = 0.0;
    double eMax = 150.0;
    double div = 10.0;
    double[] listQt = new double[12];
    double[] listQv = new double[12];
    double[] listQs = new double[12];
    double[] listQep = new double[12];
    Rectangle rect;
    Rectangle rectp;
    boolean b_solar = false;
    JComponent component;
    Font FT_STAND1;
    Font font = this.FT_STAND1 = new Font("Dialog", 0, 11);
    static String unit = "kWh";
    static double F_EXT = 4.0;
    boolean b_print = false;
    boolean b_scale = false;
    boolean b_tip = false;
    String[] tp_html = new String[]{"<html><body>Q<sub>t</sub> = \\s</body></html>", "<html><body>Q<sub>v</sub> = \\s</body></html>", "<html><body>Q<sub>h</sub> = \\s</body></html>", "<html><body>Q<sub>ep</sub> = \\s</body></html>", "<html><body>Q<sub>s</sub> = \\s</body></html>"};
    int ldxc = 0;
    String toolTipText = "";
    Color toolTipColor;
    Color[] colors = new Color[]{new Color(166, 199, 239), new Color(127, 127, 255), new Color(255, 255, 31), new Color(255, 64, 64), new Color(255, 128, 64)};
    Color[] tp_colors = new Color[]{new Color(184, 207, 229), new Color(145, 173, 255), new Color(255, 255, 187), new Color(255, 210, 210), new Color(237, 203, 166)};
    Rectangle[] rect_qv = new Rectangle[12];
    Rectangle[] rect_qt = new Rectangle[12];
    Rectangle[] rect_qs = new Rectangle[12];
    Rectangle[] rect_qe = new Rectangle[12];
    Rectangle[] rect_qh = new Rectangle[12];
    DecimalFormat df1;
    private final JLabel jLa_tip = new JLabel();

    public Out_Graph2016() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Out_Graph2016(boolean b_print) {
        this.b_print = b_print;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            Ecad2007.trace(ex);
        }
    }

    private void jbInit() throws Exception {
        this.df1 = Ecad2007.getDecimalFormat("0.0");
        this.setLayout(null);
        this.jLa_tip.setOpaque(true);
        this.jLa_tip.setBounds(0, 0, 200, 18);
        this.jLa_tip.setBorder(BorderFactory.createEmptyBorder(2, 5, 0, 0));
        this.addMouseMotionListener(new Out_Graph_MouseMotionAdapter(this));
    }

    public void setToolTipMode(boolean b_tip) {
        this.b_tip = b_tip;
    }

    public void setVal(DM_Zone dm_zone) {
        this.setValeurs(dm_zone.getQtM(), dm_zone.getQvM(), dm_zone.getQsM(), dm_zone.getQpM(), dm_zone.getQeM(), dm_zone.getFapM());
    }

    public void setScale(int min, int max, int div) {
        this.eMin = min;
        this.eMax = max;
        this.div = div;
        this.b_scale = true;
        Font prevFont = this.font;
        this.updateUI();
        this.setFont(prevFont);
    }

    @Override
    public void setToolTipText(String text) {
        if (this.b_tip) {
            this.toolTipText = text;
            this.repaint();
        } else {
            super.setToolTipText(text);
        }
    }

    public void setToolTipText(String[] html) {
        this.tp_html = html;
    }

    public void addAdditionalToolTipTextWidth(int dx) {
        this.ldxc = dx;
    }

    public void setUnit(String unit) {
        Out_Graph2016.unit = unit;
    }

    public void setValeurs(double[] QT, double[] QV, double[] QS, double[] QP, double[] QE, double[] FAP) {
        this.setValeurs(QT, QV, QS, QP, QE, FAP, true);
    }

    public void setValeurs(double[] QT, double[] QV, double[] QS, double[] QP, double[] QE, double[] FAP, boolean b_sre) {
        this.b_solar = false;
        double SRE = 1.0;
        if (b_sre) {
            SRE = Ecad2007.getDM_Zone(0).getSRE();
        }
        int dm = 5;
        for (int m = 0; m < 12; ++m) {
            if (++dm > 11) {
                dm = 0;
            }
            if (QT != null) {
                this.listQt[dm] = QT[m] / SRE;
            }
            if (QV != null) {
                this.listQv[dm] = QV[m] / SRE;
            }
            this.listQs[dm] = QS[m] * FAP[m] / SRE;
            this.listQep[dm] = QE != null ? (QP[m] + QE[m]) * FAP[m] / SRE : QP[m] * FAP[m] / SRE;
        }
    }

    public void setSolarValues(double[] qs, double[] qsnu, double[] qsu, double sre) {
        String txt = "";
        this.b_solar = true;
        int dm = 5;
        for (int mm = 0; mm < 12; ++mm) {
            if (++dm > 11) {
                dm = 0;
            }
            this.listQt[dm] = 0.0;
            if (qs != null) {
                this.listQv[dm] = qs[mm] / sre;
            }
            if (qsu != null) {
                this.listQs[dm] = qsu[mm] / sre;
            }
            if (qsnu != null) {
                this.listQep[dm] = qsnu[mm] / sre;
            }
            txt = txt + String.valueOf(this.listQt[mm]) + " ";
        }
    }

    public void setSolarValues(double[] qs, double[] qsnu, double[] qssc, double[] qsu, double sre) {
        this.b_solar = true;
        int dm = 5;
        for (int mm = 0; mm < 12; ++mm) {
            if (++dm > 11) {
                dm = 0;
            }
            if (qs != null) {
                this.listQv[dm] = qs[mm] / sre;
            }
            if (qsu != null) {
                this.listQs[dm] = qsu[mm] / sre;
            }
            if (qssc != null) {
                this.listQt[dm] = qssc[mm] / sre;
            }
            if (qsnu == null) continue;
            this.listQep[dm] = qsnu[mm] / sre;
        }
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.b_print) {
            graphics.setColor(new Color(255, 255, 255, 0));
            graphics.fillRect(this.rect.x, this.rect.y, this.rect.width, this.rect.height);
        }
        this.paintComponentX(graphics);
    }

    @Override
    protected void paintBorder(Graphics g) {
    }

    @Override
    public void paintComponent(Graphics graphics) {
    }

    public void paintComponentX(Graphics graphics) {
        int ii;
        Graphics2D g2 = (Graphics2D)graphics.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.font != null) {
            g2.setFont(this.font);
        }
        FontMetrics fm = g2.getFontMetrics();
        int fh = fm.getHeight();
        if (this.b_print) {
            g2.setColor(new Color(255, 255, 255, 0));
            g2.fillRect(0, 0, this.dx, this.dy);
        } else {
            g2.setColor(new Color(63, 63, 63));
            g2.fillRect(0, 0, this.dx + this.px, this.dy + 20);
        }
        double yli = 0.0;
        double yh = (double)this.dy / this.div;
        if (this.b_scale) {
            ii = 0;
            while ((double)ii <= this.div) {
                yli = (double)this.dy - ((double)this.dy - 15.0) / (this.eMax - this.eMin) * (double)ii * (this.eMax - this.eMin) / this.div + 0.5;
                g2.setColor(new Color(120, 120, 120));
                g2.drawLine(2, (int)yli, this.dx + 9, (int)yli);
                g2.setColor(new Color(200, 200, 200));
                if (yh < (double)fh) {
                    g2.drawString(String.format("%d", (int)((double)ii * (this.eMax - this.eMin) / this.div)), 2, (int)yli - 1);
                } else if (ii % 2 == 0) {
                    g2.drawString(String.format("%d", (int)((double)ii * (this.eMax - this.eMin) / this.div)), 2, (int)yli - 1);
                }
                ++ii;
            }
        } else {
            ii = 0;
            while ((double)ii < this.eMax) {
                yli = (double)this.dy - ((double)ii - this.eMin - (double)ii / (this.eMax - this.eMin)) * (double)this.dy / (this.eMax - this.eMin);
                g2.setColor(new Color(120, 120, 120));
                g2.drawLine(0, (int)yli, this.dx + 9, (int)yli);
                if (!this.b_print) {
                    g2.setColor(new Color(200, 200, 200));
                    g2.drawString(String.valueOf(ii / 4), 2, (int)yli - 1);
                }
                ii += 20;
            }
        }
        double x = 0.0;
        double yy = 0.0;
        double ww = (double)this.dx / 12.0 * 3.5 / 10.0;
        double hh = 0.0;
        String[] mois = Ecad2007.getDM_Met().getNomMoisShort();
        for (int mm = 0; mm < 12; ++mm) {
            int fdx;
            x = this.b_print ? (double)mm * ((double)this.dx / 12.0) : (double)mm * ((double)this.dx / 12.0) + (double)this.px;
            hh = this.b_solar ? (this.listQv[mm] - this.eMin - this.listQv[mm] / (this.eMax - this.eMin)) * ((double)this.dy - 15.0) / (this.eMax - this.eMin) : (this.listQt[mm] + this.listQv[mm] - this.eMin - (this.listQt[mm] + this.listQv[mm]) / (this.eMax - this.eMin)) * (double)this.dy / (this.eMax - this.eMin);
            if (!this.b_solar) {
                hh *= F_EXT;
            }
            yy = (double)this.dy - hh;
            g2.setColor(new Color(32, 32, 32));
            g2.fillRect((int)x + this.dx / 12 * 1 / 10 + 1, (int)(yy + 1.0), (int)ww, (int)hh - 1);
            g2.setColor(this.colors[0]);
            this.rect_qv[mm] = new Rectangle((int)x + (int)((double)this.dx / 12.0 * 1.0 / 10.0), (int)(yy + 0.5), (int)ww, (int)(hh + 0.5));
            g2.fillRect(this.rect_qv[mm].x, this.rect_qv[mm].y, this.rect_qv[mm].width, this.rect_qv[mm].height);
            if (this.b_solar) {
                hh = (this.listQep[mm] - this.eMin - this.listQep[mm] / (this.eMax - this.eMin)) * ((double)this.dy - 15.0) / (this.eMax - this.eMin);
                yy = (double)this.dy - (hh *= F_EXT) - (this.listQs[mm] + this.listQt[mm] - this.eMin - (this.listQs[mm] + this.listQt[mm]) / (this.eMax - this.eMin)) * ((double)this.dy - 15.0) / (this.eMax - this.eMin);
                this.rect_qs[mm] = new Rectangle((int)x + (int)((double)this.dx / 12.0 * 5.0 / 10.0), (int)(yy + 0.5), (int)ww, (int)(hh + 0.5));
            } else {
                this.rect_qs[mm] = new Rectangle((int)x + (int)((double)this.dx / 12.0 * 5.0 / 10.0), (int)(yy + 0.5), (int)ww, (int)(hh + 0.5));
            }
            g2.setColor(new Color(32, 32, 32));
            if (this.b_solar) {
                double hh2 = (this.listQep[mm] + this.listQs[mm] + this.listQt[mm] - this.eMin - (this.listQep[mm] + this.listQs[mm] + this.listQt[mm]) / (this.eMax - this.eMin)) * ((double)this.dy - 15.0) / (this.eMax - this.eMin);
                g2.fillRect((int)x + this.dx / 12 * 5 / 10 + 1, (int)(yy + 0.5), (int)ww, (int)(hh2 + 0.5));
            } else {
                g2.fillRect((int)x + this.dx / 12 * 5 / 10 + 1, (int)(yy + 0.5), (int)ww, (int)(hh + 0.5));
            }
            g2.setColor(this.colors[2]);
            g2.fillRect(this.rect_qs[mm].x, this.rect_qs[mm].y, this.rect_qs[mm].width, this.rect_qs[mm].height);
            hh = this.b_solar ? 0.0 : (this.listQt[mm] - this.eMin - this.listQt[mm] / (this.eMax - this.eMin)) * (double)this.dy / (this.eMax - this.eMin);
            if (!this.b_solar) {
                hh *= F_EXT;
            }
            yy = (double)this.dy - hh;
            g2.setColor(this.colors[1]);
            this.rect_qt[mm] = new Rectangle((int)x + (int)((double)this.dx / 12.0 * 1.0 / 10.0), (int)(yy + 0.5), (int)ww, (int)(hh + 0.5));
            g2.fillRect(this.rect_qt[mm].x, this.rect_qt[mm].y, this.rect_qt[mm].width, this.rect_qt[mm].height);
            if (this.b_solar) {
                hh = (this.listQt[mm] - this.eMin - this.listQt[mm] / (this.eMax - this.eMin)) * ((double)this.dy - 15.0) / (this.eMax - this.eMin);
                yy = (double)this.dy - (hh *= F_EXT) - (this.listQs[mm] - this.eMin - this.listQs[mm] / (this.eMax - this.eMin)) * ((double)this.dy - 15.0) / (this.eMax - this.eMin);
            } else {
                hh = (this.listQt[mm] + this.listQv[mm] - this.listQs[mm] - this.eMin - (this.listQt[mm] + this.listQv[mm] - this.listQs[mm]) / (this.eMax - this.eMin)) * (double)this.dy / (this.eMax - this.eMin);
                yy = (double)this.dy - (hh *= F_EXT);
            }
            if (!this.b_solar) {
                hh *= F_EXT;
            }
            if (hh > 1.0 && this.b_solar) {
                hh += 0.5;
            }
            g2.setColor(this.colors[3]);
            this.rect_qe[mm] = new Rectangle((int)x + (int)((double)this.dx / 12.0 * 5.0 / 10.0), (int)(yy + 0.5), (int)ww, (int)(hh + 0.5));
            g2.fillRect(this.rect_qe[mm].x, this.rect_qe[mm].y, this.rect_qe[mm].width, this.rect_qe[mm].height);
            hh = this.b_solar ? (this.listQs[mm] - this.eMin - this.listQs[mm] / (this.eMax - this.eMin)) * ((double)this.dy - 15.0) / (this.eMax - this.eMin) : (this.listQt[mm] + this.listQv[mm] - this.listQs[mm] - this.listQep[mm] - this.eMin - (this.listQt[mm] + this.listQv[mm] - this.listQs[mm] - this.listQep[mm]) / (this.eMax - this.eMin)) * (double)this.dy / (this.eMax - this.eMin);
            if (!this.b_solar) {
                hh *= F_EXT;
            }
            yy = (double)this.dy - hh;
            g2.setColor(this.colors[4]);
            this.rect_qh[mm] = new Rectangle((int)x + (int)((double)this.dx / 12.0 * 5.0 / 10.0), (int)(yy + 0.5), (int)ww, (int)(hh + 0.5));
            g2.fillRect(this.rect_qh[mm].x, this.rect_qh[mm].y, this.rect_qh[mm].width, this.rect_qh[mm].height);
            g2.setColor(new Color(200, 200, 200));
            int dec = 6;
            if (mm < 6) {
                fdx = fm.stringWidth(mois[mm + 6]);
                g2.drawString(mois[mm + dec], (int)x + (int)ww + 2 - fdx / 2, this.dy + 14);
                continue;
            }
            fdx = fm.stringWidth(mois[mm - 6]);
            g2.drawString(mois[mm - dec], (int)x + (int)ww + 2 - fdx / 2, this.dy + 14);
        }
        if (!this.b_print && this.b_tip && this.toolTipText != null && !this.toolTipText.trim().equals("")) {
            String tmp = this.toolTipText;
            if (this.toolTipText.contains("<html><body>")) {
                tmp = this.toolTipText.replaceAll("<html><body>", "");
                tmp = tmp.replaceAll("</body></html>", "");
                tmp = tmp.replaceAll("<sub>", "");
                tmp = tmp.replaceAll("</sub>", "");
                tmp = tmp.replaceAll("<sup>", "");
                tmp = tmp.replaceAll("</sup>", "");
            }
            FontRenderContext frc = g2.getFontRenderContext();
            TextLayout layout = new TextLayout(tmp, this.font, frc);
            layout.draw(g2, 0.0f, 0.0f);
            int ldx = fm.stringWidth(tmp) + this.ldxc;
            int ldy = this.jLa_tip.getHeight();
            int lpx = this.dx - ldx;
            int lpy = 5;
            int rr = this.toolTipColor.getRed();
            int bb = this.toolTipColor.getBlue();
            int gg = this.toolTipColor.getGreen();
            g2.translate(lpx, lpy);
            this.jLa_tip.setFont(this.font);
            if (rr + gg + bb < 200) {
                this.jLa_tip.setForeground(Color.white);
            } else {
                this.jLa_tip.setForeground(Color.black);
            }
            this.jLa_tip.setText(this.toolTipText);
            this.jLa_tip.setBackground(this.toolTipColor);
            this.jLa_tip.setSize(ldx, ldy);
            this.jLa_tip.paint(g2);
            g2.translate(-lpx, -lpy);
            g2.setColor(Color.black);
            g2.drawLine(this.dx - ldx, ldy + lpy, this.dx, ldy + lpy);
            g2.drawLine(this.dx, lpy, this.dx, ldy + lpy);
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.font = font;
    }

    public void setParent(JComponent component) {
        this.component = component;
        this.rectp = component.getBounds();
    }

    public void refresh() {
        if (!this.b_solar) {
            this.updateUI();
        }
    }

    @Override
    public void setBounds(Rectangle rect) {
        this.rect = rect;
        this.dx = rect.width;
        this.dy = rect.height;
        if (this.b_print) {
            this.setSize(this.dx + 1, this.dy + 1);
        } else {
            this.setSize(this.dx + this.px + 1, this.dy + 21);
        }
        this.setLocation(rect.x, rect.y);
    }

    public void setColors(Color[] colors) {
        this.colors = colors;
    }

    public Color[] getColors() {
        return this.colors;
    }

    public Color[] getToolTipColors() {
        return this.tp_colors;
    }

    public void setToolTipColors(Color[] colors) {
        this.tp_colors = colors;
    }

    private void mouseMoved(MouseEvent me) {
        for (int ii = 0; ii < 12; ++ii) {
            if (this.rect_qt[ii].contains(me.getPoint())) {
                UIManager.put("ToolTip.background", this.tp_colors[1]);
                this.toolTipColor = this.colors[1];
                this.setToolTipText(this.tp_html[0].replaceAll("\\\\s", this.df1.format(this.listQt[ii]) + " " + unit));
                break;
            }
            if (this.rect_qv[ii].contains(me.getPoint())) {
                UIManager.put("ToolTip.background", this.tp_colors[0]);
                this.toolTipColor = this.colors[0];
                this.setToolTipText(this.tp_html[1].replaceAll("\\\\s", this.df1.format(this.listQv[ii]) + " " + unit));
                break;
            }
            if (this.rect_qh[ii].contains(me.getPoint())) {
                double qh = this.listQt[ii] + this.listQv[ii] - this.listQs[ii] - this.listQep[ii];
                if (this.b_solar) {
                    qh = this.listQs[ii];
                }
                UIManager.put("ToolTip.background", this.tp_colors[4]);
                this.toolTipColor = this.colors[4];
                this.setToolTipText(this.tp_html[2].replaceAll("\\\\s", this.df1.format(qh) + " " + unit));
                break;
            }
            if (this.rect_qe[ii].contains(me.getPoint())) {
                UIManager.put("ToolTip.background", this.tp_colors[3]);
                this.toolTipColor = this.colors[3];
                double qep = this.listQep[ii];
                if (this.b_solar) {
                    qep = this.listQt[ii];
                }
                this.setToolTipText(this.tp_html[3].replaceAll("\\\\s", this.df1.format(qep) + " " + unit));
                break;
            }
            if (this.rect_qs[ii].contains(me.getPoint())) {
                double qs = this.listQs[ii];
                if (this.b_solar) {
                    qs = this.listQep[ii];
                }
                UIManager.put("ToolTip.background", this.tp_colors[2]);
                this.toolTipColor = this.colors[2];
                this.setToolTipText(this.tp_html[4].replaceAll("\\\\s", this.df1.format(qs) + " " + unit));
                break;
            }
            UIManager.put("ToolTip.background", this.tp_colors[0]);
            this.setToolTipText((String)null);
        }
    }

    class Out_Graph_MouseMotionAdapter
    extends MouseMotionAdapter {
        Out_Graph2016 adaptee;

        public Out_Graph_MouseMotionAdapter(Out_Graph2016 adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void mouseMoved(MouseEvent me) {
            this.adaptee.mouseMoved(me);
        }
    }
}

