/*
 * Decompiled with CFR 0.152.
 */
package jecadcomp;

import enercad2007.Ecad2007;
import enercad2007.Globals;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class Out_Qh
extends JPanel {
    int dx = 0;
    int dy = 0;
    double eMin = 0.0;
    double eMax = 500.0;
    double[] listQh = new double[16];
    int[] listUnits = new int[16];
    Rectangle[] rectQh = new Rectangle[16];
    double f_lim = 1.0;
    double Qhli = 0.0;
    double Qhci = 0.0;
    DecimalFormatSymbols dfs;
    DecimalFormat df1;
    DecimalFormat df2;
    Rectangle rect;
    Globals globals = new Globals();
    Font FT_STAND1 = new Font("Dialog", 0, 11);
    Font font = new Font("Dialog", 0, 11);
    Font bigFont = new Font("Dialog", 1, 11);
    HashMap ic_output = this.globals.getResources("output");
    transient Graphics2D g2;
    String txt_Qh_Qhli = "limite =";
    static String unit = "MJ/m\u00b2";

    public Out_Qh() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.FT_STAND1 = Globals.FT_STAND1;
        this.font = Globals.FT_STAND1;
        this.bigFont = Globals.FT_BOLD1;
        this.setFont(this.FT_STAND1);
        this.font = this.FT_STAND1;
        this.addMouseMotionListener(new Out_Qh_MouseMotionAdapter(this));
    }

    public void setListQh(double Qh) {
        int units = 0;
        if (Ecad2007.getCalcmod() >= 7) {
            units = 1;
        }
        int dim = this.listQh.length;
        for (int ii = dim - 1; ii > 0; --ii) {
            this.listQh[ii] = this.listQh[ii - 1];
            this.listUnits[ii] = this.listUnits[ii - 1];
        }
        this.listQh[0] = Qh;
        this.listUnits[0] = units;
    }

    public void setFLim(double f_lim) {
        if (f_lim > 0.0 && f_lim <= 1.0) {
            this.f_lim = f_lim;
            this.Qhci = this.Qhli * 0.6 * f_lim;
        }
    }

    public void setQhli(double Qhli) {
        this.Qhli = Qhli;
        this.Qhci = Qhli * 0.6 * this.f_lim;
        Globals.println("Out_Qh : Qh limite pour DlgOutQh = " + Qhli);
    }

    public void setUnits(int units) {
        unit = units == 0 ? "MJ/m\u00b2" : "kWh/m\u00b2";
    }

    @Override
    protected void paintBorder(Graphics g) {
    }

    @Override
    public void paintComponent(Graphics g) {
        boolean units = false;
        if (Ecad2007.getCalcmod() >= 7) {
            units = true;
        }
        this.g2 = (Graphics2D)g.create();
        this.dfs = new DecimalFormatSymbols();
        this.dfs.setDecimalSeparator('.');
        this.df1 = new DecimalFormat("0.0", this.dfs);
        this.df2 = new DecimalFormat("0.00", this.dfs);
        this.g2.setColor(new Color(63, 63, 63));
        this.g2.fillRect(0, 0, this.dx, this.dy);
        double yli = (double)this.dy - (this.Qhli * this.f_lim - this.eMin - this.Qhli * this.f_lim / (this.eMax - this.eMin)) * (double)this.dy / (this.eMax - this.eMin);
        double yci = (double)this.dy - (this.Qhci - this.eMin - this.Qhci / (this.eMax - this.eMin)) * (double)this.dy / (this.eMax - this.eMin);
        if (units && Ecad2007.getIntCalcmod() < 7) {
            yli = (double)this.dy - (this.Qhli * this.f_lim - this.eMin - this.Qhli * this.f_lim / (this.eMax - this.eMin)) * (double)this.dy / (this.eMax - this.eMin) * 3.6;
            yci = (double)this.dy - (this.Qhci - this.eMin - this.Qhci / (this.eMax - this.eMin)) * (double)this.dy / (this.eMax - this.eMin) * 3.6;
        }
        this.g2.setColor(new Color(255, 255, 255));
        this.g2.drawLine(0, (int)yli, this.dx, (int)yli);
        this.g2.setColor(new Color(180, 180, 180));
        this.g2.drawLine(0, (int)yci, this.dx, (int)yci);
        double x = 0.0;
        double y = 0.0;
        double w = (double)(this.dx / 16) * 3.5 / 6.0;
        double hh = 0.0;
        for (int ii = 0; ii < 16; ++ii) {
            double B;
            double G;
            double R;
            x = ii * (this.dx / 16) + this.dx / 16 * 2 / 6;
            hh = (this.listQh[ii] - this.eMin - this.listQh[ii] / (this.eMax - this.eMin)) * (double)this.dy / (this.eMax - this.eMin);
            if (Ecad2007.getIntCalcmod() < 7) {
                if (this.listUnits[ii] == 1 && !units) {
                    hh *= 3.6;
                } else if (this.listUnits[ii] == 0 && units) {
                    hh *= 0.2777777777777778;
                }
                if (units && Ecad2007.getIntCalcmod() < 7) {
                    hh *= 3.6;
                }
            }
            y = (double)this.dy - hh;
            this.rectQh[ii] = new Rectangle((int)x + 1, (int)y + 1, (int)w, (int)hh - 1);
            this.g2.setColor(new Color(32, 32, 32));
            this.g2.fillRect((int)x + 1, (int)y + 1, (int)w, (int)hh - 1);
            if (ii == 0) {
                R = 255.0;
                G = 255.0;
                B = 31.0;
            } else {
                R = 256 - ii * 12;
                G = 85 - ii * 4;
                B = 0.0;
            }
            this.g2.setColor(new Color((int)R, (int)G, (int)B));
            this.g2.fillRect((int)x, (int)y, (int)w, (int)hh);
        }
        this.g2.setFont(this.font);
        this.g2.setColor(Color.white);
        this.g2.setXORMode(new Color(63, 63, 63));
        if (this.f_lim == 1.0) {
            this.g2.drawString("Qh " + this.txt_Qh_Qhli + " " + this.df1.format(this.Qhli), this.dx / 40, (int)yli - 3);
        } else {
            this.g2.drawString("Qh " + this.txt_Qh_Qhli + " " + this.df1.format(this.Qhli) + " x " + this.df2.format(this.f_lim) + " = " + this.df1.format(this.Qhli * this.f_lim), this.dx / 40, (int)yli - 3);
        }
        this.g2.setPaintMode();
        this.g2.setFont(this.bigFont);
        this.g2.setColor(Color.yellow);
        this.g2.setXORMode(new Color(63, 63, 63));
        this.g2.drawString("Qh = " + this.df1.format(this.listQh[0]), this.dx / 40, this.dy / 20 + 10);
        this.g2.setPaintMode();
        ImageIcon image = null;
        if (this.listQh[0] < this.Qhli * this.f_lim * 0.6) {
            image = (ImageIcon)this.ic_output.get("smiley_3");
        } else if (this.listQh[0] >= this.Qhli * this.f_lim * 0.6 && this.listQh[0] < this.Qhli * this.f_lim) {
            image = (ImageIcon)this.ic_output.get("smiley_2");
        } else if (this.listQh[0] > this.Qhli * this.f_lim) {
            image = (ImageIcon)this.ic_output.get("smiley_1");
        }
        if (image != null) {
            Image img = image.getImage();
            this.g2.drawImage(img, this.dx - 23, 4, 19, 19, null);
        }
    }

    @Override
    public void setFont(Font font) {
        this.font = font;
    }

    @Override
    public void repaint() {
        this.txt_Qh_Qhli = Ecad2007.getTraduction("out").getCodeLan("Qh_Qhli");
        unit = Ecad2007.getCalcmod() < 7 ? "MJ/m\u00b2" : "kWh/m\u00b2";
    }

    @Override
    public void setBounds(Rectangle rect) {
        this.rect = rect;
        this.dx = rect.width;
        this.dy = rect.height;
        this.setSize(this.dx + 1, this.dy + 1);
        this.setLocation(rect.x, rect.y);
    }

    private void mouseMoved(MouseEvent me) {
        int bar = -1;
        boolean units = false;
        if (Ecad2007.getCalcmod() >= 7) {
            units = true;
        }
        for (int ii = 0; ii < 16; ++ii) {
            if (!this.rectQh[ii].contains(me.getPoint())) continue;
            bar = ii;
            break;
        }
        if (bar > -1) {
            if (this.listUnits[bar] == 0 && units && Ecad2007.getIntCalcmod() < 7) {
                this.setToolTipText(this.df1.format(this.listQh[bar] * 0.2777777777777778) + " " + unit);
            } else if (this.listUnits[bar] == 1 && !units && Ecad2007.getIntCalcmod() < 7) {
                this.setToolTipText(this.df1.format(this.listQh[bar] * 3.6) + " " + unit);
            } else {
                this.setToolTipText(this.df1.format(this.listQh[bar]) + " " + unit);
            }
        } else {
            this.setToolTipText(null);
        }
    }

    private void mouseDragged(MouseEvent me) {
    }

    class Out_Qh_MouseMotionAdapter
    implements MouseMotionListener {
        Out_Qh adaptee;

        public Out_Qh_MouseMotionAdapter(Out_Qh adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void mouseMoved(MouseEvent me) {
            this.adaptee.mouseMoved(me);
        }

        @Override
        public void mouseDragged(MouseEvent me) {
            this.adaptee.mouseDragged(me);
        }
    }
}

