/*
 * Decompiled with CFR 0.152.
 */
package jecadcomp;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class ShapeButton
extends JLabel {
    ImageIcon[] imageicons = new ImageIcon[2];
    Point[] points1;
    Point[] points2;
    String toolTipText1;
    String toolTipText2;
    Shape shape1;
    Shape shape2;
    boolean b_mi = false;
    boolean debug = false;
    int status = 0;
    MouseListener ml;

    public ShapeButton() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ShapeButton(ImageIcon[] imageicons, Point[] points) {
        this.imageicons = imageicons;
        this.points1 = points;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ShapeButton(ImageIcon[] imageicons, Point[] points1, Point[] points2) {
        this.imageicons = imageicons;
        this.points1 = points1;
        this.points2 = points2;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setSize(new Dimension(100, 71));
        this.addMouseMotionListener(new ShapeButton_mouseMotionAdapter(this));
        this.createShapes();
    }

    private void createShapes() {
        int dim1 = -1;
        int dim2 = -1;
        if (this.points1 == null) {
            this.points1 = new Point[]{new Point(0, 0), new Point(this.getWidth(), 0), new Point(this.getWidth(), this.getHeight()), new Point(0, this.getHeight())};
        } else {
            dim1 = this.points1.length;
        }
        if (dim1 < 3) {
            this.points1 = new Point[]{new Point(0, 0), new Point(this.getWidth(), 0), new Point(this.getWidth(), this.getHeight()), new Point(0, this.getHeight())};
        }
        if (this.b_mi && this.points2 != null) {
            dim2 = this.points2.length;
        }
        if (dim2 < 3 & this.b_mi) {
            this.points2 = new Point[]{new Point(0, 0), new Point(this.getWidth(), 0), new Point(this.getWidth(), this.getHeight()), new Point(0, this.getHeight())};
        }
        AffineTransform at = new AffineTransform();
        GeneralPath p1 = new GeneralPath();
        p1.moveTo((float)this.points1[0].getX(), (float)this.points1[0].getY());
        for (int ii = 1; ii < this.points1.length; ++ii) {
            p1.lineTo((float)this.points1[ii].getX(), (float)this.points1[ii].getY());
        }
        p1.closePath();
        this.shape1 = p1.createTransformedShape(at);
        if (this.debug) {
            BufferedImage bi = new BufferedImage(this.getWidth(), this.getHeight(), 1);
            Graphics2D g2d = bi.createGraphics();
            g2d.setColor(Color.blue);
            g2d.fill(this.shape1);
            this.setIcon(new ImageIcon(bi));
        }
        if (this.b_mi) {
            GeneralPath p2 = new GeneralPath();
            p2.moveTo((float)this.points2[0].getX(), (float)this.points2[0].getY());
            for (int ii = 1; ii < this.points2.length; ++ii) {
                p2.lineTo((float)this.points2[ii].getX(), (float)this.points2[ii].getY());
            }
            p2.closePath();
            this.shape2 = p2.createTransformedShape(at);
        }
    }

    private ImageIcon defineButtonIcon(Point point) {
        Object res = null;
        if (this.b_mi) {
            if (this.shape2.contains(point)) {
                this.status = 2;
                this.setToolTipText(this.toolTipText1);
            } else if (this.shape1.contains(point)) {
                this.status = 1;
                this.setToolTipText(this.toolTipText2);
            } else {
                this.status = 0;
            }
        } else {
            this.status = this.shape1.contains(point) ? 1 : 0;
        }
        if (this.debug) {
            return null;
        }
        return this.imageicons[this.status];
    }

    private void drawComponent() {
        BufferedImage bi = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        Graphics2D g2d = bi.createGraphics();
        g2d.setColor(Color.black);
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    protected void fireMouseEvent(MouseEvent me) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MouseListener.class) continue;
            ((MouseListener)listeners[i + 1]).mousePressed(me);
        }
    }

    public int getStatus() {
        return this.status;
    }

    public Point[][] getPoints() {
        return new Point[][]{this.points1, this.points2};
    }

    public void reset() {
        if (this.imageicons != null) {
            this.setIcon(this.imageicons[0]);
        }
    }

    @Override
    public void setBounds(Rectangle rectangle) {
        this.setSize(rectangle.width, rectangle.height);
        this.setLocation(rectangle.x, rectangle.y);
    }

    public void setIconsAndShape(ImageIcon[] imageicons, Point[] points) {
        this.imageicons = imageicons;
        this.points1 = points;
        this.points2 = null;
        this.shape1 = null;
        this.shape2 = null;
        if (!this.debug && imageicons != null) {
            this.setIcon(imageicons[0]);
        }
        this.createShapes();
    }

    public void setIconsAndShape(ImageIcon[] imageicons, Point[] points1, Point[] points2) {
        this.imageicons = imageicons;
        this.points1 = points1;
        this.points2 = points2;
        if (points2 != null) {
            this.b_mi = true;
        }
        if (!this.debug && imageicons != null) {
            this.setIcon(imageicons[0]);
        }
        this.createShapes();
    }

    public void setToolTipText(String[] toolTipText) {
        if (toolTipText != null) {
            if (toolTipText.length > 0) {
                this.toolTipText2 = toolTipText[0];
            }
            if (toolTipText.length > 1) {
                this.toolTipText1 = toolTipText[1];
            }
        }
    }

    private void mouseMoved(MouseEvent me) {
        Point point = new Point(me.getX(), me.getY());
        if (this.isEnabled()) {
            this.setIcon(this.defineButtonIcon(point));
        }
    }

    private void mousePressed(MouseEvent me) {
        this.fireMouseEvent(me);
    }

    private void mouseReleased(MouseEvent me) {
    }

    private void mouseEntered(MouseEvent me) {
    }

    private void mouseExited(MouseEvent me) {
    }

    class ShapeButton_mouseAdapter
    extends MouseAdapter {
        ShapeButton adaptee;

        ShapeButton_mouseAdapter(ShapeButton adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void mousePressed(MouseEvent me) {
            this.adaptee.mousePressed(me);
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            this.adaptee.mouseReleased(me);
        }

        @Override
        public void mouseEntered(MouseEvent me) {
            this.adaptee.mouseEntered(me);
        }

        @Override
        public void mouseExited(MouseEvent me) {
            this.adaptee.mouseExited(me);
        }
    }

    class ShapeButton_mouseMotionAdapter
    extends MouseMotionAdapter {
        ShapeButton adaptee;

        ShapeButton_mouseMotionAdapter(ShapeButton adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void mouseMoved(MouseEvent me) {
            this.adaptee.mouseMoved(me);
        }
    }
}

