/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.goca;

import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.afp.goca.AbstractGraphicsDrawingOrder;

public class GraphicsSetProcessColor
extends AbstractGraphicsDrawingOrder {
    private static final byte RGB = 1;
    private static final byte CMYK = 4;
    private final Color color;
    private final float[] colorComponents;

    public GraphicsSetProcessColor(Color color) {
        this.color = color;
        this.colorComponents = color.getColorComponents(null);
    }

    public int getDataLength() {
        return 12 + this.colorComponents.length;
    }

    byte getOrderCode() {
        return -78;
    }

    public void writeToStream(OutputStream os) throws IOException {
        int colspace;
        int colSpaceType = this.color.getColorSpace().getType();
        if (colSpaceType == 9) {
            colspace = 4;
        } else if (colSpaceType == 5) {
            colspace = 1;
        } else {
            log.error("unsupported colorspace " + colSpaceType);
            colspace = 1;
        }
        byte[] colsizes = new byte[]{0, 0, 0, 0};
        for (int i = 0; i < this.colorComponents.length; ++i) {
            colsizes[i] = 8;
        }
        int len = this.getDataLength();
        byte[] data = new byte[len];
        data[0] = this.getOrderCode();
        data[1] = (byte)(len - 2);
        data[2] = 0;
        data[3] = colspace;
        data[4] = 0;
        data[5] = 0;
        data[6] = 0;
        data[7] = 0;
        data[8] = colsizes[0];
        data[9] = colsizes[1];
        data[10] = colsizes[2];
        data[11] = colsizes[3];
        for (int i = 0; i < this.colorComponents.length; ++i) {
            data[i + 12] = (byte)(this.colorComponents[i] * 255.0f);
        }
        os.write(data);
    }

    public String toString() {
        return "GraphicsSetProcessColor(col=" + this.color + ")";
    }
}

