/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.ptoca;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.afp.AFPLineDataInfo;
import org.apache.fop.afp.ptoca.PtocaBuilder;
import org.apache.fop.afp.ptoca.PtocaConstants;
import org.apache.fop.afp.ptoca.PtocaProducer;

public class LineDataInfoProducer
implements PtocaProducer,
PtocaConstants {
    private static final Log log = LogFactory.getLog(LineDataInfoProducer.class);
    private AFPLineDataInfo lineDataInfo;

    public LineDataInfoProducer(AFPLineDataInfo lineDataInfo) {
        this.lineDataInfo = lineDataInfo;
    }

    public void produce(PtocaBuilder builder) throws IOException {
        builder.setTextOrientation(this.lineDataInfo.getRotation());
        int x1 = LineDataInfoProducer.ensurePositive(this.lineDataInfo.getX1());
        int y1 = LineDataInfoProducer.ensurePositive(this.lineDataInfo.getY1());
        builder.absoluteMoveBaseline(y1);
        builder.absoluteMoveInline(x1);
        builder.setExtendedTextColor(this.lineDataInfo.getColor());
        int x2 = LineDataInfoProducer.ensurePositive(this.lineDataInfo.getX2());
        int y2 = LineDataInfoProducer.ensurePositive(this.lineDataInfo.getY2());
        int thickness = this.lineDataInfo.getThickness();
        if (y1 == y2) {
            builder.drawIaxisRule(x2 - x1, thickness);
        } else if (x1 == x2) {
            builder.drawBaxisRule(y2 - y1, thickness);
        } else {
            log.error("Invalid axis rule: unable to draw line");
            return;
        }
    }

    private static int ensurePositive(int value) {
        if (value < 0) {
            return 0;
        }
        return value;
    }
}

