/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.events;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.fop.events.Event;
import org.apache.fop.events.EventFormatter;
import org.apache.xmlgraphics.util.Service;

public class EventExceptionManager {
    private static final Map EXCEPTION_FACTORIES = new HashMap();

    public static void throwException(Event event, String exceptionClass) throws Throwable {
        if (exceptionClass != null) {
            ExceptionFactory factory = (ExceptionFactory)EXCEPTION_FACTORIES.get(exceptionClass);
            if (factory != null) {
                throw factory.createException(event);
            }
            throw new IllegalArgumentException("No such ExceptionFactory available: " + exceptionClass);
        }
        String msg = EventFormatter.format(event);
        Throwable t = null;
        Iterator iter = event.getParams().values().iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof Throwable)) continue;
            t = (Throwable)o;
            break;
        }
        if (t != null) {
            throw new RuntimeException(msg, t);
        }
        throw new RuntimeException(msg);
    }

    static {
        Iterator iter = Service.providers(ExceptionFactory.class, true);
        while (iter.hasNext()) {
            ExceptionFactory factory = (ExceptionFactory)iter.next();
            EXCEPTION_FACTORIES.put(factory.getExceptionClass().getName(), factory);
        }
    }

    public static interface ExceptionFactory {
        public Throwable createException(Event var1);

        public Class getExceptionClass();
    }
}

