/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image.loader.batik;

import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.parser.UnitProcessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.image.loader.batik.BatikImageFlavors;
import org.apache.fop.svg.SimpleSVGUserAgent;
import org.apache.fop.util.UnclosableInputStream;
import org.apache.xmlgraphics.image.loader.ImageContext;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageSize;
import org.apache.xmlgraphics.image.loader.impl.AbstractImagePreloader;
import org.apache.xmlgraphics.image.loader.impl.ImageXMLDOM;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class PreloaderSVG
extends AbstractImagePreloader {
    private static Log log = LogFactory.getLog(PreloaderSVG.class);
    private boolean batikAvailable = true;

    public ImageInfo preloadImage(String uri, Source src, ImageContext context) throws IOException {
        ImageInfo info = null;
        if (this.batikAvailable) {
            try {
                Loader loader = new Loader();
                if (!loader.isSupportedSource(src)) {
                    return null;
                }
                info = loader.getImage(uri, src, context);
            }
            catch (NoClassDefFoundError e) {
                this.batikAvailable = false;
                log.warn("Batik not in class path", e);
                return null;
            }
        }
        if (info != null) {
            ImageUtil.closeQuietly(src);
        }
        return info;
    }

    public static String getParserName() {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            return factory.newSAXParser().getXMLReader().getClass().getName();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static double px2mpt(double px, double resolution) {
        return px * 1000.0 * 72.0 / resolution;
    }

    class Loader {
        Loader() {
        }

        private ImageInfo getImage(String uri, Source src, ImageContext context) {
            InputStream in = null;
            try {
                SVGDocument doc;
                if (src instanceof DOMSource) {
                    DOMSource domSrc = (DOMSource)src;
                    doc = (SVGDocument)domSrc.getNode();
                } else {
                    in = new UnclosableInputStream(ImageUtil.needInputStream(src));
                    int length = in.available();
                    in.mark(length + 1);
                    SAXSVGDocumentFactory factory = new SAXSVGDocumentFactory(PreloaderSVG.getParserName());
                    doc = factory.createSVGDocument(src.getSystemId(), in);
                }
                ImageInfo info = this.createImageInfo(uri, context, doc);
                return info;
            }
            catch (NoClassDefFoundError ncdfe) {
                if (in != null) {
                    try {
                        in.reset();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                PreloaderSVG.this.batikAvailable = false;
                log.warn("Batik not in class path", ncdfe);
                return null;
            }
            catch (IOException e) {
                log.debug("Error while trying to load stream as an SVG file: " + e.getMessage());
                try {
                    in.reset();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                return null;
            }
        }

        private ImageInfo createImageInfo(String uri, ImageContext context, SVGDocument doc) {
            SVGSVGElement e = doc.getRootElement();
            float pxUnitToMillimeter = 25.4f / context.getSourceResolution();
            SimpleSVGUserAgent userAg = new SimpleSVGUserAgent(this, pxUnitToMillimeter, new AffineTransform()){
                private final /* synthetic */ Loader this$1;
                {
                    this.this$1 = this$1;
                    super(x0, x1);
                }

                public void displayMessage(String message) {
                    PreloaderSVG.access$300().debug(message);
                }
            };
            BridgeContext ctx = new BridgeContext(userAg);
            UnitProcessor.Context uctx = UnitProcessor.createContext(ctx, e);
            String s = e.getAttributeNS(null, "width");
            if (s.length() == 0) {
                s = "100%";
            }
            float width = UnitProcessor.svgHorizontalLengthToUserSpace(s, "width", uctx);
            s = e.getAttributeNS(null, "height");
            if (s.length() == 0) {
                s = "100%";
            }
            float height = UnitProcessor.svgVerticalLengthToUserSpace(s, "height", uctx);
            int widthMpt = (int)Math.round(PreloaderSVG.px2mpt(width, context.getSourceResolution()));
            int heightMpt = (int)Math.round(PreloaderSVG.px2mpt(height, context.getSourceResolution()));
            ImageInfo info = new ImageInfo(uri, "image/svg+xml");
            ImageSize size = new ImageSize();
            size.setSizeInMillipoints(widthMpt, heightMpt);
            size.setResolution(context.getSourceResolution());
            size.calcPixelsFromSize();
            info.setSize(size);
            ImageXMLDOM xmlImage = new ImageXMLDOM(info, (Document)doc, BatikImageFlavors.SVG_DOM);
            info.getCustomObjects().put(ImageInfo.ORIGINAL_IMAGE, xmlImage);
            return info;
        }

        private boolean isSupportedSource(Source src) {
            if (src instanceof DOMSource) {
                DOMSource domSrc = (DOMSource)src;
                return domSrc.getNode() instanceof SVGDocument;
            }
            return ImageUtil.hasInputStream(src);
        }
    }
}

