/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.Area;
import org.apache.fop.area.BlockParent;
import org.apache.fop.fo.pagination.Flow;
import org.apache.fop.layoutmgr.AreaAdditionUtil;
import org.apache.fop.layoutmgr.BlockContainerLayoutManager;
import org.apache.fop.layoutmgr.BlockLayoutManager;
import org.apache.fop.layoutmgr.BlockLevelLayoutManager;
import org.apache.fop.layoutmgr.BlockStackingLayoutManager;
import org.apache.fop.layoutmgr.ElementListUtils;
import org.apache.fop.layoutmgr.Keep;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.NonLeafPosition;
import org.apache.fop.layoutmgr.PageSequenceLayoutManager;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.SpaceResolver;

public class FlowLayoutManager
extends BlockStackingLayoutManager
implements BlockLevelLayoutManager {
    private static Log log;
    private BlockParent[] currentAreas = new BlockParent[6];
    static final /* synthetic */ boolean $assertionsDisabled;

    public FlowLayoutManager(PageSequenceLayoutManager pslm, Flow node) {
        super(node);
        this.setParent(pslm);
    }

    public List getNextKnuthElements(LayoutContext context, int alignment) {
        LayoutManager currentChildLM;
        LinkedList elements = new LinkedList();
        while ((currentChildLM = this.getChildLM()) != null) {
            if (this.addChildElements(elements, currentChildLM, context, alignment) == null) continue;
            return elements;
        }
        SpaceResolver.resolveElementList(elements);
        this.setFinished(true);
        if (!$assertionsDisabled && elements.isEmpty()) {
            throw new AssertionError();
        }
        return elements;
    }

    public List getNextKnuthElements(LayoutContext context, int alignment, Position positionAtIPDChange, LayoutManager restartAtLM) {
        LinkedList elements = new LinkedList();
        LayoutManager currentChildLM = positionAtIPDChange.getLM();
        if (currentChildLM == null) {
            throw new IllegalStateException("Cannot find layout manager from where to re-start layout after IPD change");
        }
        if (restartAtLM != null && restartAtLM.getParent() == this) {
            currentChildLM = restartAtLM;
            this.setCurrentChildLM(currentChildLM);
            currentChildLM.reset();
            if (this.addChildElements(elements, currentChildLM, context, alignment) != null) {
                return elements;
            }
        } else {
            Stack<LayoutManager> lmStack = new Stack<LayoutManager>();
            while (currentChildLM.getParent() != this) {
                lmStack.push(currentChildLM);
                currentChildLM = currentChildLM.getParent();
            }
            this.setCurrentChildLM(currentChildLM);
            if (this.addChildElements(elements, currentChildLM, context, alignment, lmStack, positionAtIPDChange, restartAtLM) != null) {
                return elements;
            }
        }
        while ((currentChildLM = this.getChildLM()) != null) {
            currentChildLM.reset();
            if (this.addChildElements(elements, currentChildLM, context, alignment) == null) continue;
            return elements;
        }
        SpaceResolver.resolveElementList(elements);
        this.setFinished(true);
        if (!$assertionsDisabled && elements.isEmpty()) {
            throw new AssertionError();
        }
        return elements;
    }

    private List addChildElements(List elements, LayoutManager childLM, LayoutContext context, int alignment) {
        return this.addChildElements(elements, childLM, context, alignment, null, null, null);
    }

    private List addChildElements(List elements, LayoutManager childLM, LayoutContext context, int alignment, Stack lmStack, Position position, LayoutManager restartAtLM) {
        if (this.handleSpanChange(childLM, elements, context)) {
            SpaceResolver.resolveElementList(elements);
            return elements;
        }
        LayoutContext childLC = new LayoutContext(0);
        List childrenElements = this.getNextChildElements(childLM, context, childLC, alignment, lmStack, position, restartAtLM);
        if (elements.isEmpty()) {
            context.updateKeepWithPreviousPending(childLC.getKeepWithPreviousPending());
        }
        if (!elements.isEmpty() && !ElementListUtils.startsWithForcedBreak(childrenElements)) {
            this.addInBetweenBreak(elements, context, childLC);
        }
        context.updateKeepWithNextPending(childLC.getKeepWithNextPending());
        elements.addAll(childrenElements);
        if (ElementListUtils.endsWithForcedBreak(elements)) {
            if (childLM.isFinished() && !this.hasNextChildLM()) {
                this.setFinished(true);
            }
            SpaceResolver.resolveElementList(elements);
            return elements;
        }
        return null;
    }

    private boolean handleSpanChange(LayoutManager childLM, List elements, LayoutContext context) {
        int span = 95;
        int disableColumnBalancing = 48;
        if (childLM instanceof BlockLayoutManager) {
            span = ((BlockLayoutManager)childLM).getBlockFO().getSpan();
            disableColumnBalancing = ((BlockLayoutManager)childLM).getBlockFO().getDisableColumnBalancing();
        } else if (childLM instanceof BlockContainerLayoutManager) {
            span = ((BlockContainerLayoutManager)childLM).getBlockContainerFO().getSpan();
            disableColumnBalancing = ((BlockContainerLayoutManager)childLM).getBlockContainerFO().getDisableColumnBalancing();
        }
        int currentSpan = context.getCurrentSpan();
        if (currentSpan != span) {
            if (span == 5) {
                context.setDisableColumnBalancing(disableColumnBalancing);
            }
            log.debug("span change from " + currentSpan + " to " + span);
            context.signalSpanChange(span);
            return true;
        }
        return false;
    }

    private List getNextChildElements(LayoutManager childLM, LayoutContext context, LayoutContext childLC, int alignment, Stack lmStack, Position restartPosition, LayoutManager restartLM) {
        childLC.setStackLimitBP(context.getStackLimitBP());
        childLC.setRefIPD(context.getRefIPD());
        childLC.setWritingMode(this.getCurrentPage().getSimplePageMaster().getWritingMode());
        List childrenElements = lmStack == null ? childLM.getNextKnuthElements(childLC, alignment) : childLM.getNextKnuthElements(childLC, alignment, lmStack, restartPosition, restartLM);
        if (!$assertionsDisabled && childrenElements.isEmpty()) {
            throw new AssertionError();
        }
        LinkedList tempList = childrenElements;
        childrenElements = new LinkedList();
        this.wrapPositionElements(tempList, childrenElements);
        return childrenElements;
    }

    public int negotiateBPDAdjustment(int adj, KnuthElement lastElement) {
        log.debug(" FLM.negotiateBPDAdjustment> " + adj);
        if (lastElement.getPosition() instanceof NonLeafPosition) {
            NonLeafPosition savedPos = (NonLeafPosition)lastElement.getPosition();
            lastElement.setPosition(savedPos.getPosition());
            int returnValue = ((BlockLevelLayoutManager)lastElement.getLayoutManager()).negotiateBPDAdjustment(adj, lastElement);
            lastElement.setPosition(savedPos);
            log.debug(" FLM.negotiateBPDAdjustment> result " + returnValue);
            return returnValue;
        }
        return 0;
    }

    public void discardSpace(KnuthGlue spaceGlue) {
        log.debug(" FLM.discardSpace> ");
        if (spaceGlue.getPosition() instanceof NonLeafPosition) {
            NonLeafPosition savedPos = (NonLeafPosition)spaceGlue.getPosition();
            spaceGlue.setPosition(savedPos.getPosition());
            ((BlockLevelLayoutManager)spaceGlue.getLayoutManager()).discardSpace(spaceGlue);
            spaceGlue.setPosition(savedPos);
        }
    }

    public Keep getKeepTogether() {
        return Keep.KEEP_AUTO;
    }

    public Keep getKeepWithNext() {
        return Keep.KEEP_AUTO;
    }

    public Keep getKeepWithPrevious() {
        return Keep.KEEP_AUTO;
    }

    public List getChangedKnuthElements(List oldList, int alignment) {
        ListIterator oldListIterator = oldList.listIterator();
        LinkedList<KnuthPenalty> returnedList = new LinkedList<KnuthPenalty>();
        LinkedList<KnuthElement> returnList = new LinkedList<KnuthElement>();
        ListElement prevElement = null;
        KnuthElement currElement = null;
        int fromIndex = 0;
        while (oldListIterator.hasNext()) {
            KnuthElement oldElement = (KnuthElement)oldListIterator.next();
            if (oldElement.getPosition() instanceof NonLeafPosition) {
                oldElement.setPosition(oldElement.getPosition().getPosition());
                continue;
            }
            oldListIterator.remove();
        }
        oldListIterator = oldList.listIterator();
        while (oldListIterator.hasNext()) {
            currElement = (KnuthElement)oldListIterator.next();
            if (prevElement != null && prevElement.getLayoutManager() != currElement.getLayoutManager()) {
                BlockLevelLayoutManager prevLM = (BlockLevelLayoutManager)prevElement.getLayoutManager();
                BlockLevelLayoutManager currLM = (BlockLevelLayoutManager)currElement.getLayoutManager();
                returnedList.addAll(prevLM.getChangedKnuthElements(oldList.subList(fromIndex, oldListIterator.previousIndex()), alignment));
                fromIndex = oldListIterator.previousIndex();
                if (prevLM.mustKeepWithNext() || currLM.mustKeepWithPrevious()) {
                    returnedList.add(new KnuthPenalty(0, 1000, false, new Position(this), false));
                } else if (!((KnuthElement)returnedList.get(returnedList.size() - 1)).isGlue()) {
                    returnedList.add(new KnuthPenalty(0, 0, false, new Position(this), false));
                }
            }
            prevElement = currElement;
        }
        if (currElement != null) {
            BlockLevelLayoutManager currLM = (BlockLevelLayoutManager)currElement.getLayoutManager();
            returnedList.addAll(currLM.getChangedKnuthElements(oldList.subList(fromIndex, oldList.size()), alignment));
        }
        ListIterator listIter = returnedList.listIterator();
        while (listIter.hasNext()) {
            KnuthElement returnedElement = (KnuthElement)listIter.next();
            if (returnedElement.getLayoutManager() != this) {
                returnedElement.setPosition(new NonLeafPosition((LayoutManager)this, returnedElement.getPosition()));
            }
            returnList.add(returnedElement);
        }
        return returnList;
    }

    public void addAreas(PositionIterator parentIter, LayoutContext layoutContext) {
        AreaAdditionUtil.addAreas(this, parentIter, layoutContext);
        this.flush();
    }

    public void addChildArea(Area childArea) {
        this.getParentArea(childArea);
        this.addChildToArea(childArea, this.currentAreas[childArea.getAreaClass()]);
    }

    public Area getParentArea(Area childArea) {
        BlockParent parentArea = null;
        int aclass = childArea.getAreaClass();
        if (aclass == 0) {
            parentArea = this.getCurrentPV().getCurrentFlow();
        } else if (aclass == 3) {
            parentArea = this.getCurrentPV().getBodyRegion().getBeforeFloat();
        } else if (aclass == 4) {
            parentArea = this.getCurrentPV().getBodyRegion().getFootnote();
        } else {
            throw new IllegalStateException("(internal error) Invalid area class (" + aclass + ") requested.");
        }
        this.currentAreas[aclass] = parentArea;
        this.setCurrentArea(parentArea);
        return parentArea;
    }

    public int getContentAreaIPD() {
        return this.getCurrentPV().getCurrentSpan().getColumnWidth();
    }

    public int getContentAreaBPD() {
        return this.getCurrentPV().getBodyRegion().getBPD();
    }

    public boolean isRestartable() {
        return true;
    }

    static {
        $assertionsDisabled = !FlowLayoutManager.class.desiredAssertionStatus();
        log = LogFactory.getLog(FlowLayoutManager.class);
    }
}

