/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.render.ImageHandlerBase;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.util.Service;

public abstract class AbstractImageHandlerRegistry {
    private static Log log = LogFactory.getLog(AbstractImageHandlerRegistry.class);
    private static final Comparator HANDLER_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            ImageHandlerBase h1 = (ImageHandlerBase)o1;
            ImageHandlerBase h2 = (ImageHandlerBase)o2;
            return h1.getPriority() - h2.getPriority();
        }
    };
    private final Map handlers = new HashMap();
    private final List handlerList = new LinkedList();
    private ImageFlavor[] supportedFlavors = new ImageFlavor[0];
    private int handlerRegistrations;
    private int lastSync;

    public AbstractImageHandlerRegistry() {
        this.discoverHandlers();
    }

    public void addHandler(String classname) {
        try {
            ImageHandlerBase handlerInstance = (ImageHandlerBase)Class.forName(classname).newInstance();
            this.addHandler(handlerInstance);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not find " + classname);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Could not instantiate " + classname);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Could not access " + classname);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(classname + " is not an " + this.getHandlerClass().getName());
        }
    }

    public synchronized void addHandler(ImageHandlerBase handler) {
        this.handlers.put(handler.getSupportedImageClass(), handler);
        ListIterator<ImageHandlerBase> iter = this.handlerList.listIterator();
        while (iter.hasNext()) {
            ImageHandlerBase h = (ImageHandlerBase)iter.next();
            if (this.getHandlerComparator().compare(handler, h) >= 0) continue;
            iter.previous();
            break;
        }
        iter.add(handler);
        ++this.handlerRegistrations;
    }

    public ImageHandlerBase getHandler(Image img) {
        return this.getHandler(img.getClass());
    }

    public synchronized ImageHandlerBase getHandler(Class imageClass) {
        ImageHandlerBase handler = null;
        for (Class cl = imageClass; cl != null && (handler = (ImageHandlerBase)this.handlers.get(cl)) == null; cl = cl.getSuperclass()) {
        }
        return handler;
    }

    public synchronized ImageFlavor[] getSupportedFlavors() {
        if (this.lastSync != this.handlerRegistrations) {
            ArrayList<ImageFlavor> flavors = new ArrayList<ImageFlavor>();
            Iterator iter = this.handlerList.iterator();
            while (iter.hasNext()) {
                ImageFlavor[] f = ((ImageHandlerBase)iter.next()).getSupportedImageFlavors();
                for (int i = 0; i < f.length; ++i) {
                    flavors.add(f[i]);
                }
            }
            this.supportedFlavors = flavors.toArray(new ImageFlavor[flavors.size()]);
            this.lastSync = this.handlerRegistrations;
        }
        return this.supportedFlavors;
    }

    private void discoverHandlers() {
        Class imageHandlerClass = this.getHandlerClass();
        Iterator providers = Service.providers(imageHandlerClass);
        if (providers != null) {
            while (providers.hasNext()) {
                ImageHandlerBase handler = (ImageHandlerBase)providers.next();
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Dynamically adding ImageHandler: " + handler.getClass().getName());
                    }
                    this.addHandler(handler);
                }
                catch (IllegalArgumentException e) {
                    log.error("Error while adding ImageHandler", e);
                }
            }
        }
    }

    public Comparator getHandlerComparator() {
        return HANDLER_COMPARATOR;
    }

    public abstract Class getHandlerClass();
}

