/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.pdf.PDFAMode;
import org.apache.fop.pdf.PDFEncryptionParams;
import org.apache.fop.pdf.PDFXMode;
import org.apache.fop.render.PrintRendererConfigurator;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.intermediate.IFDocumentHandler;
import org.apache.fop.render.pdf.PDFDocumentHandler;
import org.apache.fop.render.pdf.PDFRenderer;
import org.apache.fop.render.pdf.PDFRenderingUtil;
import org.apache.fop.util.LogUtil;

public class PDFRendererConfigurator
extends PrintRendererConfigurator {
    public PDFRendererConfigurator(FOUserAgent userAgent) {
        super(userAgent);
    }

    public void configure(Renderer renderer) throws FOPException {
        Configuration cfg = super.getRendererConfig(renderer);
        if (cfg != null) {
            PDFRenderer pdfRenderer = (PDFRenderer)renderer;
            super.configure(renderer);
            PDFRenderingUtil pdfUtil = pdfRenderer.getPDFUtil();
            this.configure(cfg, pdfUtil);
        }
    }

    private void configure(Configuration cfg, PDFRenderingUtil pdfUtil) throws FOPException {
        Configuration disableColorSpaceConfig;
        Configuration encryptionParamsConfig;
        try {
            Map filterMap = PDFRendererConfigurator.buildFilterMapFromConfiguration(cfg);
            if (filterMap != null) {
                pdfUtil.setFilterMap(filterMap);
            }
        }
        catch (ConfigurationException e) {
            LogUtil.handleException(log, e, false);
        }
        String s = cfg.getChild("pdf-a-mode", true).getValue(null);
        if (s != null) {
            pdfUtil.setAMode(PDFAMode.valueOf(s));
        }
        if ((s = cfg.getChild("pdf-x-mode", true).getValue(null)) != null) {
            pdfUtil.setXMode(PDFXMode.valueOf(s));
        }
        if ((encryptionParamsConfig = cfg.getChild("encryption-params", false)) != null) {
            Configuration noAnnotationsConfig;
            Configuration noEditContentConfig;
            Configuration noCopyContentConfig;
            Configuration noPrintConfig;
            String userPassword;
            Configuration userPasswordConfig;
            String ownerPassword;
            PDFEncryptionParams encryptionParams = new PDFEncryptionParams();
            Configuration ownerPasswordConfig = encryptionParamsConfig.getChild("owner-password", false);
            if (ownerPasswordConfig != null && (ownerPassword = ownerPasswordConfig.getValue(null)) != null) {
                encryptionParams.setOwnerPassword(ownerPassword);
            }
            if ((userPasswordConfig = encryptionParamsConfig.getChild("user-password", false)) != null && (userPassword = userPasswordConfig.getValue(null)) != null) {
                encryptionParams.setUserPassword(userPassword);
            }
            if ((noPrintConfig = encryptionParamsConfig.getChild("noprint", false)) != null) {
                encryptionParams.setAllowPrint(false);
            }
            if ((noCopyContentConfig = encryptionParamsConfig.getChild("nocopy", false)) != null) {
                encryptionParams.setAllowCopyContent(false);
            }
            if ((noEditContentConfig = encryptionParamsConfig.getChild("noedit", false)) != null) {
                encryptionParams.setAllowEditContent(false);
            }
            if ((noAnnotationsConfig = encryptionParamsConfig.getChild("noannotations", false)) != null) {
                encryptionParams.setAllowEditAnnotations(false);
            }
            pdfUtil.setEncryptionParams(encryptionParams);
        }
        if ((s = cfg.getChild("output-profile", true).getValue(null)) != null) {
            pdfUtil.setOutputProfileURI(s);
        }
        if ((disableColorSpaceConfig = cfg.getChild("disable-srgb-colorspace", false)) != null) {
            pdfUtil.setDisableSRGBColorSpace(disableColorSpaceConfig.getValueAsBoolean(false));
        }
    }

    public static Map buildFilterMapFromConfiguration(Configuration cfg) throws ConfigurationException {
        HashMap filterMap = new HashMap();
        Configuration[] filterLists = cfg.getChildren("filterList");
        for (int i = 0; i < filterLists.length; ++i) {
            Configuration filters = filterLists[i];
            String type = filters.getAttribute("type", null);
            Configuration[] filt = filters.getChildren("value");
            ArrayList<String> filterList = new ArrayList<String>();
            for (int j = 0; j < filt.length; ++j) {
                String name = filt[j].getValue();
                filterList.add(name);
            }
            if (type == null) {
                type = "default";
            }
            if (!filterList.isEmpty() && log.isDebugEnabled()) {
                StringBuffer debug = new StringBuffer("Adding PDF filter");
                if (filterList.size() != 1) {
                    debug.append("s");
                }
                debug.append(" for type ").append(type).append(": ");
                for (int j = 0; j < filterList.size(); ++j) {
                    if (j != 0) {
                        debug.append(", ");
                    }
                    debug.append(filterList.get(j));
                }
                log.debug(debug.toString());
            }
            if (filterMap.get(type) != null) {
                throw new ConfigurationException("A filterList of type '" + type + "' has already been defined");
            }
            filterMap.put(type, filterList);
        }
        return filterMap;
    }

    public void configure(IFDocumentHandler documentHandler) throws FOPException {
        Configuration cfg = super.getRendererConfig(documentHandler.getMimeType());
        if (cfg != null) {
            PDFDocumentHandler pdfDocumentHandler = (PDFDocumentHandler)documentHandler;
            PDFRenderingUtil pdfUtil = pdfDocumentHandler.getPDFUtil();
            this.configure(cfg, pdfUtil);
        }
    }
}

