/*
 * Decompiled with CFR 0.152.
 */
package privatecomponents;

import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class HTMLMessageDialog
extends JDialog {
    JOptionPane jop;
    Font FT_STAND = new Font("Dialog", 0, 11);
    JTextPane jTP_txt;
    Color bgcolor = (Color)UIManager.get("Panel.background");
    Object optionPaneBackground = UIManager.get("OptionPane.background");
    Object panelBackground = UIManager.get("Panel.background");
    String message;
    String title;
    int messageType;
    String description;
    boolean b_exit = false;
    boolean b_valid = true;
    int value = -1;
    final int ERROR_MESSAGE = 0;
    final int INFORMATION_MESSAGE = 1;
    final int QUESTION_MESSAGE = 3;
    final int WARING_MESSAGE = 2;
    private final String errMsgHttp = "Error attempting to launch web browser";

    public HTMLMessageDialog() {
        super.setModal(true);
        this.jbInit();
    }

    public HTMLMessageDialog(String title) {
        super.setTitle(title);
        super.setModal(true);
        this.jbInit();
    }

    public HTMLMessageDialog(Frame parent, String title) {
        super(parent, title, true);
        this.jbInit();
    }

    public HTMLMessageDialog(JDialog parent, String title) {
        super(parent, title, true);
        this.jbInit();
    }

    private void jbInit() {
        Container parent = this.getParent();
        this.optionPaneBackground = UIManager.get("OptionPane.background");
        this.panelBackground = UIManager.get("Panel.background");
        if (parent != null) {
            if (parent.getBackground() != null) {
                this.bgcolor = parent.getBackground();
            }
        } else if (this.getBackground() != null) {
            this.bgcolor = this.getBackground();
        }
        this.setResizable(false);
        this.addWindowListener(new HTMLMessageDialog_WindowAdapter(this));
        this.jop = new JOptionPane();
        this.jop.setBackground(new Color(0, 214, 0));
        this.jop.setOpaque(true);
        UIManager.put("OptionPane.background", this.bgcolor);
        UIManager.put("Panel.background", this.bgcolor);
        this.jop.addPropertyChangeListener(new HTMLMessageDialog_PropertyChangeListener(this));
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent ke) {
                boolean discardEvent = false;
                if (ke.getID() == 400) {
                    if (ke.getKeyChar() == '\n') {
                        HTMLMessageDialog.this.quit();
                    }
                    if (ke.getKeyChar() == '\u001b') {
                        HTMLMessageDialog.this.dispatchEvent(new WindowEvent(HTMLMessageDialog.this, 201));
                    }
                }
                return discardEvent;
            }
        });
        this.jTP_txt = new JTextPane();
        this.jTP_txt.addHyperlinkListener(new HTMLMessageDialog_HyperlinkAdapter(this));
        this.setVisible(false);
    }

    public void quit() {
        UIManager.put("OptionPane.background", this.optionPaneBackground);
        UIManager.put("Panel.background", this.panelBackground);
        this.dispose();
    }

    public String getDescription() {
        if (this.description == null) {
            return "";
        }
        return this.description;
    }

    public int getValue() {
        return this.value;
    }

    public void openURL(String url) {
        String osName = System.getProperty("os.name");
        try {
            if (osName.startsWith("Mac OS")) {
                Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, url);
            } else if (osName.startsWith("Windows")) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
            } else {
                String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                String browser = null;
                for (int count = 0; count < browsers.length && browser == null; ++count) {
                    if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() != 0) continue;
                    browser = browsers[count];
                }
                if (browser == null) {
                    throw new Exception("Could not find web browser");
                }
                Runtime.getRuntime().exec(new String[]{browser, url});
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error attempting to launch web browser:\n" + e.getLocalizedMessage());
        }
    }

    @Override
    public void setFont(Font font) {
        this.FT_STAND = font;
    }

    public void setBackgroundColor(Color bgcolor) {
        this.bgcolor = bgcolor;
        this.jop.setBackground(bgcolor);
        this.setBackground(bgcolor);
        UIManager.put("OptionPane.background", bgcolor);
        UIManager.put("Panel.background", bgcolor);
    }

    public void setHyperlinkExit(boolean b_exit) {
        this.b_exit = b_exit;
    }

    public void showMessageDialog(String message, int messageType) {
        Container parent = this.getParent();
        this.jTP_txt.setContentType("text/html");
        if (this.bgcolor == null) {
            this.bgcolor = (Color)UIManager.get("OptionPane.background");
        }
        this.jTP_txt.setBackground(this.bgcolor);
        this.jTP_txt.setEditable(false);
        String txt_message = this.transformToHTML(message, this.bgcolor);
        this.jTP_txt.setText(txt_message);
        this.jTP_txt.setOpaque(true);
        StyledDocument doc = this.jTP_txt.getStyledDocument();
        Style style = this.jTP_txt.addStyle("FT_STAND", null);
        StyleConstants.setFontFamily(style, this.FT_STAND.getFamily());
        StyleConstants.setFontSize(style, this.FT_STAND.getSize());
        StyleConstants.setBackground(style, this.bgcolor);
        doc.setCharacterAttributes(0, txt_message.length(), style, false);
        this.jop.setMessage(this.jTP_txt);
        this.jop.setMessageType(messageType);
        this.setContentPane(this.jop);
        this.pack();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        int x = (screenSize.width - this.getWidth()) / 2;
        int y = (screenSize.height - this.getHeight()) / 2;
        this.setLocation(x, y);
        if (parent == null) {
            this.validate();
        } else {
            parent.validate();
        }
        this.setVisible(true);
    }

    private String transformToHTML(String message, Color bgcolor) {
        String[] header = new String[]{"<html><body style=\"background-color: rgb(" + bgcolor.getRed() + ", " + bgcolor.getGreen() + ", " + bgcolor.getBlue() + ")\">", "</body></html>"};
        return header[0] + message + header[1];
    }

    private String transformToHTML(String message, Color bgcolor, String addStyles) {
        String[] header = new String[]{"<html><body style=\"background-color: rgb(" + bgcolor.getRed() + ", " + bgcolor.getGreen() + ", " + bgcolor.getBlue() + "); " + addStyles + "\">", "</body></html>"};
        return header[0] + message + header[1];
    }

    private void hyperlinkUpdate(HyperlinkEvent he) {
        if (he.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.description = he.getDescription();
            this.description = this.description.replaceAll(";", "");
            if (this.description != null) {
                if (this.description.startsWith("cmd:")) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            HTMLMessageDialog.this.quit();
                        }
                    });
                } else {
                    this.openURL("http://" + this.description);
                    if (this.b_exit) {
                        System.exit(0);
                    }
                }
            }
        } else if (he.getEventType() == HyperlinkEvent.EventType.ENTERED) {
            this.setCursor(new Cursor(12));
        } else if (he.getEventType() == HyperlinkEvent.EventType.EXITED) {
            this.setCursor(new Cursor(0));
        }
    }

    private void propertyChange(PropertyChangeEvent pce) {
        Object object = this.jop.getValue();
        if (object instanceof Integer) {
            this.value = (Integer)this.jop.getValue();
        }
        if (this.value == 0 || this.value == 2) {
            HTMLRunnable htmlRunnable = new HTMLRunnable(this);
            if (this.isVisible()) {
                SwingUtilities.invokeLater(htmlRunnable);
            }
            this.invalidate();
        }
    }

    private void windowClosing(WindowEvent we) {
        UIManager.put("OptionPane.background", this.optionPaneBackground);
        UIManager.put("Panel.background", this.panelBackground);
    }

    private class HTMLMessageDialog_WindowAdapter
    extends WindowAdapter {
        HTMLMessageDialog adaptee;

        HTMLMessageDialog_WindowAdapter(HTMLMessageDialog adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void windowClosing(WindowEvent we) {
            this.adaptee.windowClosing(we);
        }
    }

    private class HTMLMessageDialog_KeyAdapter
    extends KeyAdapter {
        HTMLMessageDialog adaptee;

        public HTMLMessageDialog_KeyAdapter(HTMLMessageDialog adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void keyPressed(KeyEvent ke) {
            System.out.println("keyPressed");
        }
    }

    private class HTMLMessageDialog_PropertyChangeListener
    implements PropertyChangeListener {
        HTMLMessageDialog adaptee;

        HTMLMessageDialog_PropertyChangeListener(HTMLMessageDialog adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            this.adaptee.propertyChange(pce);
        }
    }

    private class HTMLMessageDialog_HyperlinkAdapter
    implements HyperlinkListener {
        HTMLMessageDialog adaptee;

        HTMLMessageDialog_HyperlinkAdapter(HTMLMessageDialog adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent he) {
            this.adaptee.hyperlinkUpdate(he);
        }
    }

    private class HTMLRunnable
    implements Runnable {
        HTMLMessageDialog htmlMD;

        public HTMLRunnable(HTMLMessageDialog htmlMD) {
            this.htmlMD = htmlMD;
        }

        @Override
        public void run() {
            this.htmlMD.quit();
        }
    }
}

