/*
 * Decompiled with CFR 0.152.
 */
package privatecomponents;

import core.Calc_Met;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.SystemColor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class HorizonStereo
extends JPanel {
    protected boolean refreshBit = false;
    int dx = 200;
    int dy = 200;
    int mx = 15;
    int my = 15;
    double scale = 90.0;
    final int CRH = 3;
    final double DIVISOR = 9.0;
    double div = 0.0;
    int fh = 10;
    boolean b_inv = false;
    boolean b_gtv = true;
    Dimension dim = null;
    Rectangle rect = null;
    BufferedImage[] buffImg = null;
    Graphics2D[] gbi;
    int dim_bi = 1;
    boolean b_paint = false;
    GeneralPath[] gp90 = new GeneralPath[8];
    int orientation = -1;
    int elevation = -1;
    Color gridColor = Color.blue;
    Color gridTextColor = Color.blue;
    Color horizonColor = new Color(180, 180, 180, 210);
    Calc_Met calc_met = new Calc_Met();
    double dpt = 0.2;
    Font FT_STAND = new Font("Dialog", 0, 10);
    Font FT_BOLD = new Font("Dialog", 1, 10);
    Font ft_deg = new Font("Dialog", 0, 8);
    Color gridBackgroundColor;
    String txt_FSN = "N";
    String txt_FSNE = "N-E";
    String txt_FSE = "E";
    String txt_FSSE = "S-E";
    String txt_FSS = "S";
    String txt_FSSO = "S-O";
    String txt_FSO = "O";
    String txt_FSNO = "N-O";
    String[] gridValues = new String[]{"10", "20", "30", "40", "50", "60", "70", "80"};
    public static final String[][] MMS = new String[][]{{"Jan", "Feb", "M\u00e4r", "Apr", "Mai", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Dez"}, {"Jan", "F\u00e9v", "Mar", "Avr", "Mai", "Jun", "Jul", "Ao\u00fb", "Sep", "Oct", "Nov", "D\u00e9c"}, {"Gen", "Feb", "Mar", "Apr", "Mai", "Jiu", "Lug", "Ago", "Set", "Ott", "Nov", "Dic"}, {"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"}};

    public HorizonStereo() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            System.out.println("HorizonStereo default constructor: " + ex);
        }
    }

    public HorizonStereo(String[] fs) {
        this.setLan(fs);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            System.out.println("HorizonStereo default constructor: " + ex);
        }
    }

    public HorizonStereo(boolean b_inv) {
        this.b_inv = b_inv;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            System.out.println("HorizonStereo default constructor 2: " + ex);
        }
    }

    public HorizonStereo(boolean b_inv, boolean b_paint) {
        this.b_inv = b_inv;
        this.b_paint = b_paint;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            System.out.println("HorizonStereo default constructor 3: " + ex);
        }
    }

    public HorizonStereo(boolean b_inv, boolean b_paint, String[] fs) {
        this.b_inv = b_inv;
        this.b_paint = b_paint;
        this.setLan(fs);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            System.out.println("HorizonStereo default constructor 3: " + ex);
        }
    }

    private void jbInit() throws Exception {
        this.gridBackgroundColor = this.getBackground();
        this.setBackground(SystemColor.control);
        this.setFont(this.FT_STAND);
        this.setLayout(null);
        this.setOpaque(true);
        this.setBounds(new Rectangle(0, 0, this.dx, this.dy + 3));
        this.addMouseListener(new HorizonStereo_MouseAdapter(this));
        if (this.div > 20.0) {
            this.fh = (int)(this.div / 2.0);
            this.FT_STAND = new Font("Dialog", 0, this.fh);
            this.FT_BOLD = new Font("Dialog", 1, this.fh);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2p = (Graphics2D)g.create();
    }

    private void drawComponent() {
        this.buffImg = new BufferedImage[this.dim_bi];
        this.gbi = new Graphics2D[this.dim_bi];
        for (int bb = 0; bb < this.dim_bi; ++bb) {
            this.buffImg[bb] = new BufferedImage(this.dx, this.dy + 3, 2);
            this.gbi[bb] = this.buffImg[bb].createGraphics();
        }
    }

    public void drawSun(double lat, Date date, Color color, int sunDiameter) {
        double prev_dpt = this.dpt;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int doy = calendar.get(6);
        double hh = calendar.get(11);
        hh += (double)calendar.get(12) / 60.0;
        hh += (double)calendar.get(13) / 3600.0;
        this.setPointDiameter(sunDiameter);
        this.fillPoint(lat, doy, hh += (double)calendar.get(14) / 3600000.0, color);
        this.drawPoint(lat, doy, hh, Color.black);
        this.setPointDiameter(prev_dpt);
    }

    public void drawPoint(double az, double hc, Color color) {
        Arc2D arc2d = this.getPoint(az, hc);
        for (int bb = 0; bb < this.dim_bi; ++bb) {
            this.gbi[bb].setColor(color);
            this.gbi[bb].fill(arc2d);
        }
    }

    public void drawPoint(double az, double hc, Color[] colors) {
        int dim = colors.length;
        if (this.dim_bi < dim) {
            dim = this.dim_bi;
        }
        Arc2D arc2d = this.getPoint(az, hc);
        for (int bb = 0; bb < dim; ++bb) {
            this.gbi[bb].setColor(colors[bb]);
            this.gbi[bb].draw(arc2d);
        }
    }

    public void drawPoint(double lat, int doy, double hh, Color color) {
        double dec = this.calc_met.getDEC(doy);
        double rlat = Math.toRadians(lat);
        Map<String, Double> lcts = this.calc_met.getLCTS(rlat, dec);
        double lts = lcts.get("lts");
        double cts = lcts.get("cts");
        if (lts <= hh && hh <= cts) {
            Map<String, Double> map = this.calc_met.getHCAZ(rlat, dec, hh);
            double az = Math.toDegrees(map.get("az"));
            double hc = Math.toDegrees(map.get("hc"));
            this.drawPoint(az, hc, color);
        }
    }

    public void drawPoint(double lat, int doy, double hh, Color[] colors) {
        double dec = this.calc_met.getDEC(doy);
        double rlat = Math.toRadians(lat);
        Map<String, Double> lcts = this.calc_met.getLCTS(rlat, dec);
        double lts = lcts.get("lts");
        double cts = lcts.get("cts");
        if (hh >= lts && hh <= cts) {
            Map<String, Double> map = this.calc_met.getHCAZ(rlat, dec, hh);
            double az = Math.toDegrees(map.get("az"));
            double hc = Math.toDegrees(map.get("hc"));
            this.drawPoint(az, hc, colors);
        }
    }

    public void fillPoint(double lat, int doy, double hh, Color color) {
        double dec = this.calc_met.getDEC(doy);
        double rlat = Math.toRadians(lat);
        Map<String, Double> lcts = this.calc_met.getLCTS(rlat, dec);
        double lts = lcts.get("lts");
        double cts = lcts.get("cts");
        if (hh >= lts && hh <= cts) {
            Map<String, Double> map = this.calc_met.getHCAZ(rlat, dec, hh);
            double az = Math.toDegrees(map.get("az"));
            double hc = Math.toDegrees(map.get("hc"));
            this.fillPoint(az, hc, color);
        }
    }

    public void drawString(String string, double az, double hc, Color color) {
        if (!this.b_gtv) {
            return;
        }
        Arc2D arc2d = this.getPoint(az, hc);
        for (int bb = 0; bb < this.dim_bi; ++bb) {
            this.gbi[bb].setFont(this.ft_deg);
            this.gbi[bb].setColor(color);
            FontMetrics fmt = this.gbi[bb].getFontMetrics(this.ft_deg);
            this.gbi[bb].drawString(string, (int)arc2d.getX() - fmt.stringWidth(string) / 2, (int)arc2d.getY());
        }
    }

    public void fillPoint(double az, double hc, Color color) {
        Arc2D arc2d = this.getPoint(az, hc);
        for (int bb = 0; bb < this.dim_bi; ++bb) {
            this.gbi[bb].setColor(color);
            this.gbi[bb].fill(arc2d);
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public int getElevation() {
        return this.elevation;
    }

    private Arc2D getPoint(double az, double hc) {
        double dxx = -(90.0 - hc) * this.div / 10.0 * Math.cos(Math.toRadians(az + 90.0)) + (double)(this.dx / 2);
        double dyy = (double)(this.dy / 2) - (90.0 - hc) * this.div / 10.0 * Math.sin(Math.toRadians(az + 90.0));
        if (this.b_inv) {
            dxx = (90.0 - hc) * this.div / 10.0 * Math.cos(Math.toRadians(-az + 90.0)) + (double)(this.dx / 2);
            dyy = (double)(this.dy / 2) - (90.0 - hc) * this.div / 10.0 * Math.sin(Math.toRadians(-az + 90.0));
        }
        Point2D.Double p2d = new Point2D.Double(dxx, dyy);
        return new Arc2D.Double(new Rectangle2D.Double(((Point2D)p2d).getX() - this.dpt / 2.0, ((Point2D)p2d).getY() - this.dpt / 2.0, this.dpt, this.dpt), 10.0, 360.0, 1);
    }

    public void drawSolarPath(double lat, int doy, Color color) {
        double dec = this.calc_met.getDEC(doy);
        double rlat = Math.toRadians(lat);
        Map<String, Double> lcts = this.calc_met.getLCTS(rlat, dec);
        double lts = lcts.get("lts");
        double cts = lcts.get("cts");
        double delta_cl = cts - lts;
        double CAD = 0.1;
        int recs = (int)(delta_cl / 0.1);
        GeneralPath gpSun = new GeneralPath(0, recs);
        BasicStroke line = new BasicStroke(0.5f);
        for (int bb = 0; bb < this.dim_bi; ++bb) {
            this.gbi[bb].setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.gbi[bb].setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
            this.gbi[bb].setColor(color);
            this.gbi[bb].setStroke(line);
            boolean b_moveto = false;
            for (double hh = lts; hh < cts; hh += 0.1) {
                Map<String, Double> map = this.calc_met.getHCAZ(rlat, dec, hh);
                double az = Math.toDegrees(map.get("az"));
                double hc = Math.toDegrees(map.get("hc"));
                Arc2D arc2d = this.getPoint(az, hc);
                Point2D ep = arc2d.getEndPoint();
                if (!b_moveto) {
                    gpSun.moveTo(arc2d.getX(), arc2d.getY());
                    b_moveto = true;
                    continue;
                }
                gpSun.lineTo(ep.getX(), ep.getY());
            }
            this.gbi[bb].draw(gpSun);
        }
    }

    public void drawLabelForSolarPath(String string, double lat, int doy, double hh, Color color) {
        double dec = 0.0;
        double rlat = Math.toRadians(lat - 2.0);
        int cad = 2;
        if (this.dx > 600) {
            cad = 1;
        }
        dec = this.calc_met.getDEC(doy);
        Map<String, Double> lcts = this.calc_met.getLCTS(rlat, dec);
        double lts = lcts.get("lts");
        double cts = lcts.get("cts");
        if (hh < lts) {
            return;
        }
        if (hh > cts) {
            return;
        }
        Map<String, Double> map = this.calc_met.getHCAZ(rlat, dec, hh);
        double az = Math.toDegrees(map.get("az"));
        double hc = Math.toDegrees(map.get("hc"));
        this.drawString(string, az, hc, color);
    }

    public void drawSolarPath(double lat, int hh_from, int hh_to, Color color) {
        double dec = 0.0;
        double rlat = Math.toRadians(lat);
        int recs = (int)((double)(hh_to - hh_from) + 0.5);
        int cad = 2;
        if (this.dx > 600) {
            cad = 1;
        }
        GeneralPath gpSun = new GeneralPath(0, recs);
        BasicStroke line = new BasicStroke(0.5f);
        for (int bb = 0; bb < this.dim_bi; ++bb) {
            this.gbi[bb].setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.gbi[bb].setColor(color);
            this.gbi[bb].setStroke(line);
            boolean b_moveto = false;
            for (int hh = hh_from; hh < hh_to; ++hh) {
                for (int doy = 1; doy < 172; doy += cad) {
                    dec = this.calc_met.getDEC(doy);
                    Map<String, Double> lcts = this.calc_met.getLCTS(rlat, dec);
                    double lts = lcts.get("lts");
                    double cts = lcts.get("cts");
                    if (!(lts < (double)hh) || !((double)hh < cts)) continue;
                    Map<String, Double> map = this.calc_met.getHCAZ(rlat, dec, hh);
                    double az = Math.toDegrees(map.get("az"));
                    double hc = Math.toDegrees(map.get("hc"));
                    Arc2D arc2d = this.getPoint(az, hc);
                    Point2D ep = arc2d.getEndPoint();
                    if (!b_moveto) {
                        gpSun.moveTo(arc2d.getX(), arc2d.getY());
                        b_moveto = true;
                        continue;
                    }
                    gpSun.lineTo(ep.getX(), ep.getY());
                }
                b_moveto = false;
                this.gbi[bb].draw(gpSun);
            }
        }
    }

    public void drawSolarPathForDoys(double latitude, Color color) {
        double diam = 0.2;
        this.setPointDiameter(diam);
        this.drawSolarPath(latitude, 80, color);
        this.drawSolarPath(latitude, 172, color);
        this.drawSolarPath(latitude, 202, color);
        this.drawSolarPath(latitude, 235, color);
        this.drawSolarPath(latitude, 294, color);
        this.drawSolarPath(latitude, 322, color);
        this.drawSolarPath(latitude, 355, color);
    }

    public void drawSolarPathForHours(double latitude, Color color) {
        this.drawSolarPath(latitude, 0, 24, color);
    }

    public void drawLabelsForSolarPathForHours(double latitude, Color color) {
        for (int ii = 0; ii < 24; ++ii) {
            this.drawLabelForSolarPath(String.valueOf(ii), latitude, 172, ii, color);
        }
    }

    public void drawLabelsForSolarPathForMonths(String[] months, double latitude, int[] doys, Color color) {
        int[] sols = new int[]{20, 51, 79, 110, 140, 171, 201, 232, 263, 293, 324, 354};
        int[] eofm = new int[]{28, 59, 90, 118, 151, 181, 212, 243, 273, 304, 334, 365};
        boolean[] b_doys = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true};
        if (months == null) {
            return;
        }
        if (months.length < 12) {
            return;
        }
        if (color == null) {
            color = Color.black;
        }
        for (int ii = 0; ii < 12; ++ii) {
            if (doys[0] > sols[5] && eofm[ii] >= eofm[5]) {
                this.drawLabelForSolarPath(months[ii], latitude, sols[ii], 12.5, color);
                continue;
            }
            if (doys[0] > sols[5] || eofm[ii] > eofm[5]) continue;
            this.drawLabelForSolarPath(months[ii], latitude, sols[ii], 12.5, color);
        }
    }

    public void drawGrid() {
        this.drawGrid(true);
    }

    public void drawGrid(boolean b_background) {
        for (int bb = 0; bb < this.dim_bi; ++bb) {
            int dim = 9;
            int pxy = 0;
            int dxy = (int)(18.0 * this.div);
            if (this.buffImg[bb] != null) {
                this.gbi[bb].drawImage(this.buffImg[bb], null, 0, 0);
            }
            if (b_background) {
                this.gbi[bb].setColor(this.gridBackgroundColor);
                this.gbi[bb].fillOval(this.mx - 2, this.my - 2, dxy + 4, dxy + 4);
            }
            this.gbi[bb].setColor(this.gridTextColor);
            this.gbi[bb].setFont(this.FT_STAND);
            FontMetrics fm = this.gbi[bb].getFontMetrics(this.FT_STAND);
            FontMetrics fm_deg = this.gbi[bb].getFontMetrics(this.ft_deg);
            this.gbi[bb].setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.gbi[bb].setStroke(new BasicStroke(0.6f));
            int fc = (this.fh - 10) / 2;
            if (fc < 0) {
                fc = 0;
            }
            double sinex = this.div * 9.0 * Math.sin(0.7853981633974483);
            double sinix = this.div * Math.sin(0.7853981633974483);
            double cosey = this.div * 9.0 * Math.cos(0.7853981633974483);
            double cosiy = this.div * Math.cos(0.7853981633974483);
            if (this.b_gtv) {
                if (this.b_inv) {
                    this.gbi[bb].drawString(this.txt_FSO, 1, this.dy / 2 + this.fh / 2);
                    this.gbi[bb].drawString(this.txt_FSNO, this.mx + (int)(this.div * 9.0 - sinex) - fm.stringWidth(this.txt_FSNO), this.my + (int)(this.div * 9.0 - cosey - (double)(this.fh / 2)));
                    this.gbi[bb].drawString(this.txt_FSO, this.dx - 1 - fm.stringWidth(this.txt_FSO), this.dy / 2 + this.fh / 2);
                    this.gbi[bb].drawString(this.txt_FSNO, this.mx + (int)(this.div * 9.0 + sinex) + 3, this.my + (int)(this.div * 9.0 + cosey) + this.fh);
                    this.gbi[bb].drawString(this.txt_FSSE, this.mx + (int)(this.div * 9.0 - sinex) - fm.stringWidth(this.txt_FSSO) - 3, this.my + (int)(this.div * 9.0 + cosey) + this.fh);
                    this.gbi[bb].drawString(this.txt_FSSO, this.mx + (int)(this.div * 9.0 + sinex) + 3, this.my + (int)(this.div * 9.0 + cosey) + this.fh);
                } else {
                    this.gbi[bb].drawString(this.txt_FSO, 1, this.dy / 2 + this.fh / 2);
                    this.gbi[bb].drawString(this.txt_FSNO, this.mx + (int)(this.div * 9.0 - sinex) - fm.stringWidth(this.txt_FSNO), this.my + (int)(this.div * 9.0 - cosey - (double)(this.fh / 2)));
                    this.gbi[bb].drawString(this.txt_FSNE, this.mx + (int)(this.div * 9.0 + sinex) + 3, this.my + (int)(this.div * 9.0 - cosey - (double)(this.fh / 2)));
                    this.gbi[bb].drawString(this.txt_FSE, this.dx - 1 - fm.stringWidth(this.txt_FSO) + fc, this.dy / 2 + this.fh / 2);
                    this.gbi[bb].drawString(this.txt_FSSE, this.mx + (int)(this.div * 9.0 + sinex) + 3, this.my + (int)(this.div * 9.0 + cosey) + this.fh);
                    this.gbi[bb].drawString(this.txt_FSSO, this.mx + (int)(this.div * 9.0 - sinex) - fm.stringWidth(this.txt_FSSO) - 3 - fc, this.my + (int)(this.div * 9.0 + cosey) + this.fh);
                }
                this.gbi[bb].drawString(this.txt_FSN, this.dx / 2 - fm.stringWidth(this.txt_FSN) / 2, this.fh - 2 - fc);
                this.gbi[bb].drawString(this.txt_FSS, this.dx / 2 - fm.stringWidth(this.txt_FSS) / 2, this.dy + fc);
            }
            this.gbi[bb].setFont(this.ft_deg);
            this.gbi[bb].setColor(this.gridColor);
            this.gbi[bb].drawOval(this.mx - 2, this.my - 2, dxy + 4, dxy + 4);
            for (int ii = 0; ii < dim; ++ii) {
                pxy = (int)((double)ii * this.div);
                dxy = (int)((double)(dim - ii) * 2.0 * this.div);
                if (ii > 0 && this.b_gtv) {
                    this.gbi[bb].setColor(this.gridTextColor);
                    String value = this.gridValues[ii - 1];
                    this.gbi[bb].drawString(value, this.dx / 2 - fm_deg.stringWidth(value) / 2, this.my + (int)((double)ii * this.div) + this.fh);
                    this.gbi[bb].setColor(this.gridColor);
                }
                this.gbi[bb].drawOval(this.mx + pxy, this.my + pxy, dxy, dxy);
            }
            this.gbi[bb].drawLine(this.mx, this.dy / 2, this.mx + (int)(this.div * 8.0), this.dy / 2);
            this.gbi[bb].drawLine(this.mx + (int)(this.div * 10.0), this.dy / 2, this.dx - this.mx, this.dy / 2);
            if (!this.b_gtv) {
                this.gbi[bb].drawLine(this.dx / 2, this.my, this.dx / 2, this.my + (int)(this.div * 8.0));
            }
            this.gbi[bb].drawLine(this.dx / 2, this.my + (int)(this.div * 10.0), this.dx / 2, this.dy - this.my);
            this.gbi[bb].drawLine(this.mx + (int)(this.div * 9.0 - sinex), this.my + (int)(this.div * 9.0 - cosey), this.mx + (int)(this.div * 9.0 - sinix), this.my + (int)(this.div * 9.0 - cosiy));
            this.gbi[bb].drawLine(this.mx + (int)(this.div * 9.0 + sinix), this.my + (int)(this.div * 9.0 + cosiy), this.mx + (int)(this.div * 9.0 + sinex), this.my + (int)(this.div * 9.0 + cosey));
            this.gbi[bb].drawLine(this.mx + (int)(this.div * 9.0 + sinex), this.my + (int)(this.div * 9.0 - cosey), this.mx + (int)(this.div * 9.0 + sinix), this.my + (int)(this.div * 9.0 - cosiy));
            this.gbi[bb].drawLine(this.mx + (int)(this.div * 9.0 - sinix), this.my + (int)(this.div * 9.0 + cosiy), this.mx + (int)(this.div * 9.0 - sinex), this.my + (int)(this.div * 9.0 + cosey));
        }
    }

    public void drawHorizon(int orient, int degree) {
        double or = orient;
        if (!this.b_inv) {
            if (orient == 1) {
                or = 7.0;
            } else if (orient == 2) {
                or = 6.0;
            } else if (orient == 3) {
                or = 5.0;
            } else if (orient == 5) {
                or = 3.0;
            } else if (orient == 6) {
                or = 2.0;
            } else if (orient == 7) {
                or = 1.0;
            }
        }
        for (int bb = 0; bb < this.dim_bi; ++bb) {
            this.gbi[bb].setColor(Color.black);
            this.gbi[bb].setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.gbi[bb].setStroke(new BasicStroke(0.6f));
            this.gbi[bb].setColor(Color.black);
            double div90 = ((double)this.dx - (double)(2 * this.mx)) / 180.0;
            double mxy90 = 0.0;
            double dxy90 = 0.0;
            double mxy90e = this.mx;
            double dxy90e = 180.0 * div90;
            this.drawSIAHorizonLimits();
            mxy90 = (double)this.mx + (double)degree * div90;
            dxy90 = (90.0 - (double)degree) * 2.0 * div90;
            Arc2D.Double arc2Di = new Arc2D.Double(mxy90, mxy90, dxy90, dxy90, 67.5 + or * 45.0, 45.0, 0);
            Arc2D.Double arc2De = new Arc2D.Double(mxy90e, mxy90e, dxy90e, dxy90e, 112.5 + or * 45.0, -45.0, 0);
            GeneralPath gp = new GeneralPath();
            gp.append(arc2Di, false);
            gp.append(arc2De, true);
            gp.closePath();
            this.gbi[bb].setColor(this.horizonColor);
            this.gbi[bb].fill(gp);
            this.gbi[bb].setColor(Color.black);
            this.gbi[bb].draw(gp);
        }
    }

    public void drawHorizon(int[] degrees) {
        if (degrees == null) {
            return;
        }
        if (degrees.length < 8) {
            return;
        }
        int[] dgs = (int[])degrees.clone();
        if (!this.b_inv) {
            dgs[7] = degrees[1];
            dgs[6] = degrees[2];
            dgs[5] = degrees[3];
            dgs[3] = degrees[5];
            dgs[2] = degrees[6];
            dgs[1] = degrees[7];
        }
        for (int bb = 0; bb < this.dim_bi; ++bb) {
            this.gbi[bb].setColor(Color.black);
            this.gbi[bb].setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.gbi[bb].setStroke(new BasicStroke(0.6f));
            this.gbi[bb].setColor(Color.black);
            double div90 = ((double)this.dx - (double)(2 * this.mx)) / 180.0;
            double mxy90 = 0.0;
            double dxy90 = 0.0;
            Arc2D[] arc2Di = new Arc2D[8];
            Arc2D[] arc2De = new Arc2D[8];
            GeneralPath[] gp = new GeneralPath[8];
            double mxy90e = this.mx;
            double dxy90e = 180.0 * div90;
            this.drawSIAHorizonLimits();
            for (int ii = 0; ii < 8; ++ii) {
                mxy90 = (double)this.mx + (double)dgs[ii] * div90;
                dxy90 = (90.0 - (double)dgs[ii]) * 2.0 * div90;
                arc2Di[ii] = new Arc2D.Double(mxy90, mxy90, dxy90, dxy90, 67.5 + (double)ii * 45.0, 45.0, 0);
                arc2De[ii] = new Arc2D.Double(mxy90e, mxy90e, dxy90e, dxy90e, 112.5 + (double)ii * 45.0, -45.0, 0);
                gp[ii] = new GeneralPath();
                gp[ii].append(arc2Di[ii], false);
                gp[ii].append(arc2De[ii], true);
                gp[ii].closePath();
                this.gbi[bb].setColor(this.horizonColor);
                this.gbi[bb].fill(gp[ii]);
                this.gbi[bb].setColor(Color.black);
                this.gbi[bb].draw(gp[ii]);
            }
        }
    }

    public GeneralPath[] getDetailedShadeShapes(int orient) {
        int div = 90;
        double div90 = ((double)this.dx - (double)(2 * this.mx)) / 180.0;
        double mxy90 = 0.0;
        double dxy90 = 0.0;
        double mxy90e = this.mx;
        double dxy90e = 180.0 * div90;
        Arc2D[] arc2Di = new Arc2D[div];
        Arc2D[] arc2De = new Arc2D[div];
        GeneralPath[] gps = new GeneralPath[div];
        if (orient < 0) {
            return gps;
        }
        for (int ii = 0; ii < div; ++ii) {
            double degree = (double)ii * (90.0 / (double)div) + 90.0 / (double)div;
            mxy90 = (double)this.mx + degree * div90;
            dxy90 = (90.0 - degree) * 2.0 * div90;
            arc2Di[ii] = new Arc2D.Double(mxy90, mxy90, dxy90, dxy90, 67.5 + (double)orient * 45.0, 45.0, 0);
            arc2De[ii] = new Arc2D.Double(mxy90e, mxy90e, dxy90e, dxy90e, 112.5 + (double)orient * 45.0, -45.0, 0);
            gps[ii] = new GeneralPath();
            gps[ii].append(arc2Di[ii], false);
            gps[ii].append(arc2De[ii], true);
            gps[ii].closePath();
        }
        return gps;
    }

    private GeneralPath[] getShadeShapes(int degree) {
        Arc2D[] arc2Di = new Arc2D[8];
        Arc2D[] arc2De = new Arc2D[8];
        GeneralPath[] gps = new GeneralPath[8];
        double div90 = (double)this.dx / 180.0;
        double mxy90 = 0.0;
        double dxy90 = 0.0;
        double mxy90e = 0.0;
        double dxy90e = 180.0 * div90;
        mxy90 = (double)degree * div90;
        dxy90 = (90.0 - (double)degree) * 2.0 * div90;
        for (int ii = 0; ii < 8; ++ii) {
            arc2Di[ii] = new Arc2D.Double(mxy90, mxy90, dxy90, dxy90, 67.5 + (double)ii * 45.0, 45.0, 0);
            arc2De[ii] = new Arc2D.Double(mxy90e, mxy90e, dxy90e, dxy90e, 112.5 + (double)ii * 45.0, -45.0, 0);
            gps[ii] = new GeneralPath();
            gps[ii].append(arc2Di[ii], false);
            gps[ii].append(arc2De[ii], true);
            gps[ii].closePath();
        }
        return gps;
    }

    public void setGridBackground(Color gridBackgroundColor) {
        this.gridBackgroundColor = gridBackgroundColor;
    }

    public void drawSIAHorizonLimits() {
        double div90 = ((double)this.dx - (double)(2 * this.mx)) / 180.0;
        double mxy90 = 0.0;
        double dxy90 = 0.0;
        double mxy90e = this.mx;
        double dxy90e = 180.0 * div90;
        for (int bb = 0; bb < this.dim_bi; ++bb) {
            this.gbi[bb].setColor(new Color(0, 0, 191));
            Arc2D.Double circle15 = new Arc2D.Double(mxy90e, mxy90e, dxy90e, dxy90e, 0.0, 360.0, 1);
            this.gbi[bb].fill(circle15);
            this.gbi[bb].setColor(new Color(64, 64, 255));
            mxy90 = (double)this.mx + 15.0 * div90;
            dxy90 = 150.0 * div90;
            Arc2D.Double circle20 = new Arc2D.Double(mxy90, mxy90, dxy90, dxy90, 0.0, 360.0, 1);
            this.gbi[bb].fill(circle20);
            this.gbi[bb].setColor(new Color(64, 128, 255));
            mxy90 = (double)this.mx + 22.5 * div90;
            dxy90 = 135.0 * div90;
            Arc2D.Double circle25 = new Arc2D.Double(mxy90, mxy90, dxy90, dxy90, 0.0, 360.0, 1);
            this.gbi[bb].fill(circle25);
            this.gbi[bb].setColor(new Color(164, 200, 240));
            mxy90 = (double)this.mx + 30.0 * div90;
            dxy90 = 120.0 * div90;
            Arc2D.Double circle30 = new Arc2D.Double(mxy90, mxy90, dxy90, dxy90, 0.0, 360.0, 1);
            this.gbi[bb].fill(circle30);
        }
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.b_paint) {
            this.drawGrid();
        } else {
            for (int bb = 0; bb < this.dim_bi; ++bb) {
                ((Graphics2D)graphics).drawImage(this.buffImg[bb], null, null);
            }
        }
    }

    public BufferedImage getBufferedImage() {
        BufferedImage bi = new BufferedImage(this.dx * this.dim_bi, this.dy, 2);
        Graphics2D g2d = bi.createGraphics();
        for (int ii = 0; ii < this.buffImg.length; ++ii) {
            g2d.drawImage((Image)this.buffImg[ii], this.dx * ii, 0, null);
        }
        return bi;
    }

    public BufferedImage[] getBufferedImages() {
        return this.buffImg;
    }

    public Graphics2D[] getGraphics2D() {
        return this.gbi;
    }

    public boolean getRefreshBit() {
        return this.refreshBit;
    }

    @Override
    public void setBorder(Border border) {
    }

    @Override
    public void setBounds(Rectangle rect) {
        this.rect = rect;
        this.dx = rect.width;
        this.dy = rect.width;
        this.setSize(rect.width, rect.width + 3);
        this.setLocation(rect.x, rect.y);
        this.div = ((double)this.dx - 2.0 * (double)this.mx) / 18.0;
        if (this.dx > 300) {
            this.ft_deg = new Font("Dialog", 0, 8 + (this.dy - 300) / 100);
        }
        if (this.div > 20.0) {
            this.fh = (int)(this.div / 2.0);
            this.FT_STAND = new Font("Dialog", 0, this.fh);
            this.FT_BOLD = new Font("Dialog", 1, this.fh);
        }
        this.drawComponent();
    }

    public void setBounds(int dim_bi, Rectangle rect) {
        this.rect = rect;
        this.dim_bi = dim_bi;
        this.dx = rect.width / dim_bi;
        this.dy = rect.width / dim_bi;
        this.setSize(rect.width, rect.width + 3);
        this.setLocation(rect.x, rect.y);
        this.div = ((double)this.dx - 2.0 * (double)this.mx) / 18.0;
        if (this.dx > 300) {
            this.ft_deg = new Font("Dialog", 0, 8 + (this.dy - 300) / 100);
        }
        if (this.div > 20.0) {
            this.fh = (int)(this.div / 2.0);
            this.FT_STAND = new Font("Dialog", 0, this.fh);
            this.FT_BOLD = new Font("Dialog", 1, this.fh);
        }
        this.drawComponent();
    }

    public void setGridColor(Color gridColor) {
        this.gridColor = gridColor;
        this.repaint();
    }

    public void setGridTextColor(Color gridTextColor) {
        this.gridTextColor = gridTextColor;
        this.repaint();
    }

    public void setGridValues(String[] gridValues) {
        this.gridValues = gridValues;
    }

    public void setHorizonColor(Color horizonColor) {
        this.horizonColor = horizonColor;
    }

    public void setLan(String[] fs) {
        if (fs == null) {
            return;
        }
        if (fs.length > 0) {
            this.txt_FSN = fs[0];
        }
        if (fs.length > 1) {
            this.txt_FSNE = fs[1];
        }
        if (fs.length > 2) {
            this.txt_FSE = fs[2];
        }
        if (fs.length > 3) {
            this.txt_FSSE = fs[3];
        }
        if (fs.length > 4) {
            this.txt_FSS = fs[4];
        }
        if (fs.length > 5) {
            this.txt_FSSO = fs[5];
        }
        if (fs.length > 6) {
            this.txt_FSO = fs[6];
        }
        if (fs.length > 7) {
            this.txt_FSNO = fs[7];
        }
    }

    public void setPointDiameter(double pointDiameter) {
        this.dpt = pointDiameter;
    }

    public void setGridTextVisible(boolean visible) {
        this.b_gtv = visible;
        if (!this.b_gtv) {
            this.mx = 4;
            this.my = 4;
            this.div = ((double)this.dx - 2.0 * (double)this.mx) / 18.0;
        }
    }

    private void mouseMoved(MouseEvent me) {
    }

    private void mouseReleased(MouseEvent me) {
        GeneralPath[] gpd;
        if (this.gp90[0] == null) {
            this.gp90 = this.getShadeShapes(90);
        }
        for (int ii = 0; ii < this.gp90.length; ++ii) {
            if (!this.gp90[ii].contains(me.getPoint())) continue;
            this.orientation = ii;
            break;
        }
        if ((gpd = this.getDetailedShadeShapes(this.orientation))[0] == null) {
            return;
        }
        for (int ii = 0; ii < gpd.length; ++ii) {
            if (!gpd[ii].contains(me.getPoint())) continue;
            this.elevation = ii;
            break;
        }
        if (this.elevation == -1) {
            return;
        }
        this.drawHorizon(this.orientation, this.elevation);
    }

    class HorizonStereo_MouseAdapter
    extends MouseAdapter {
        HorizonStereo adaptee;

        public HorizonStereo_MouseAdapter(HorizonStereo adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            this.adaptee.mouseReleased(me);
        }
    }

    class HorizonStereo_MouseMotionAdapter
    extends MouseMotionAdapter {
        HorizonStereo adaptee;

        public HorizonStereo_MouseMotionAdapter(HorizonStereo adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void mouseMoved(MouseEvent me) {
            this.adaptee.mouseMoved(me);
        }
    }
}

