/*
 * Decompiled with CFR 0.152.
 */
package privatecomponents;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.ItemSelectable;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.text.JTextComponent;

public class JColumnComboBox
extends JComboBox
implements ItemListener,
ItemSelectable,
FocusListener,
ListDataListener,
Serializable {
    JComboBox jcb;
    ComboBoxRenderer renderer;
    ColorComboBoxEditor ccbed;
    String[] values;
    String editorText;
    String tooltip;
    Color[][] backgrounds;
    Color[][] foregrounds;
    Font[] fonts;
    int[] widths;
    int dx = 0;
    int dy = 0;
    int dimx = 0;
    int dimy = 0;
    int colNbr = 1;
    int colInEditor = 0;
    protected Object selectedItemReminder = null;
    protected ComboBoxModel dataModel;
    JColumnComboBox_mouseAdapter jccb_ma;
    private boolean firingActionEvent = false;
    protected String actionCommand = "comboBoxChanged";
    String prevId = "";
    int prevIndex = -1;
    int index = -1;
    Object item = null;
    String id = "";
    int maxRowCount = 8;
    Object[] selectedObjects;
    private boolean selectingItem = false;
    private boolean isPopupVisible = false;
    private boolean isBPopupVisible = false;
    private boolean isColumnVisible = false;
    int flag = 0;
    int timeout = 10;

    public JColumnComboBox() {
        ComboList[] cl = new ComboList[1];
        String[] col = new String[]{"", ""};
        cl[0] = new ComboList("", new String[]{"", ""});
        this.colNbr = col.length;
        this.widths = new int[this.colNbr];
        this.setColumnComboBox(cl);
    }

    public JColumnComboBox(String[][] droplist) {
        int dim = droplist.length;
        ComboList[] cl = new ComboList[dim];
        if (droplist[0].length > 1) {
            this.colNbr = droplist[0].length - 1;
        }
        for (int cter = 0; cter < dim; ++cter) {
            cl[cter] = new ComboList(droplist[cter]);
        }
        this.setColumnComboBox(cl);
    }

    public JColumnComboBox(Map droplist) {
        int dim = droplist.size();
        String[] row2 = null;
        int cter = 0;
        ComboList[] cl = new ComboList[dim];
        if (dim > 1) {
            Collection collection = droplist.values();
            for (String[] row2 : collection) {
                cl[cter] = new ComboList(row2);
            }
            this.colNbr = row2.length - 1;
        }
        this.setColumnComboBox(cl);
    }

    public void addItem(String[] value) {
        int dim = this.jcb.getItemCount() + 1;
        ComboList[] cl = new ComboList[dim];
        Object[][] list = this.getItemList();
        boolean editable = this.isEditable();
        if (value == null) {
            return;
        }
        if (value.length - 1 != this.colNbr) {
            return;
        }
        for (int cter = 0; cter < dim - 1; ++cter) {
            cl[cter] = new ComboList(list[cter]);
        }
        cl[dim - 1] = new ComboList(value);
        if (this.jcb != null) {
            this.remove(this.jcb);
        }
        this.setColumnComboBox(cl);
        this.setEditable(editable);
    }

    public boolean itemExists(String[] value) {
        boolean res = false;
        Object[][] list = this.getItemList();
        int cter = 0;
        if (list.length == 0) {
            return res;
        }
        for (int ii = 0; ii < list.length; ++ii) {
            cter = 0;
            int jj = 0;
            while (jj < value.length && list[ii][jj].equals(value[jj])) {
                if (++cter == list[0].length - 1) {
                    res = true;
                }
                ++ii;
            }
            if (res) break;
        }
        return res;
    }

    public void drawComponent() {
    }

    protected int[] getColumnWidths() {
        return this.widths;
    }

    protected Font[] getFonts() {
        return this.fonts;
    }

    protected Rectangle getRectangle() {
        Rectangle rectangle = new Rectangle(this.dx, this.dy, this.dimx, this.dimy);
        return rectangle;
    }

    public Object[][] getItemList() {
        ComboBoxModel cbm = this.jcb.getModel();
        int dim = cbm.getSize();
        Object[][] res = new Object[dim][this.colNbr + 1];
        for (int cter = 0; cter < dim; ++cter) {
            res[cter][0] = ((ComboList)cbm.getElementAt(cter)).getId();
            if (this.colNbr <= 1) continue;
            for (int cter2 = 0; cter2 < this.colNbr; ++cter2) {
                res[cter][cter2 + 1] = ((ComboList)cbm.getElementAt(cter)).getValue(cter2);
            }
        }
        return res;
    }

    public boolean isColumnVisible() {
        return this.isColumnVisible;
    }

    public void loadValues(String[][] values) {
        int dim = values.length;
        ComboList[] cl = new ComboList[dim];
        if (values == null) {
            return;
        }
        if (values.length == 0) {
            return;
        }
        if (values[0].length > 1) {
            this.colNbr = values[0].length - 1;
        }
        for (int cter = 0; cter < dim; ++cter) {
            cl[cter] = new ComboList(values[cter]);
        }
        if (this.jcb != null) {
            this.remove(this.jcb);
        }
        this.setColumnComboBox(cl);
        this.setEditorText();
    }

    public void loadValues(Object[][] values) {
        int dim = values.length;
        ComboList[] cl = new ComboList[dim];
        if (values == null) {
            return;
        }
        if (values[0].length > 1) {
            this.colNbr = values[0].length - 1;
        }
        for (int cter = 0; cter < dim; ++cter) {
            cl[cter] = new ComboList(values[cter]);
        }
        if (this.jcb != null) {
            this.remove(this.jcb);
        }
        this.setColumnComboBox(cl);
        this.setEditorText();
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setColor(Color.white);
        g2d.fillRect(this.dx, this.dy, this.dimx - 2 * this.dx, this.dimy - 2 * this.dy);
    }

    @Override
    public void setBackground(Color color) {
        if (color != null && this.jcb != null) {
            ComboBoxEditor ed = this.jcb.getEditor();
            JTextField component = (JTextField)ed.getEditorComponent();
            component.setBackground(color);
        }
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(this.dx, this.dy, this.dimx, this.dimy);
    }

    @Override
    public void setBounds(Rectangle rectangle) {
        this.dx = rectangle.x;
        this.dy = rectangle.y;
        this.dimx = rectangle.width;
        this.dimy = rectangle.height;
        int tot = 0;
        this.widths = new int[this.colNbr];
        for (int cter = 0; cter < this.colNbr - 1; ++cter) {
            this.widths[cter] = this.dimx / this.colNbr;
            tot += this.widths[cter];
        }
        this.widths[this.colNbr - 1] = this.dimx - tot;
        this.setSize(rectangle.width, rectangle.height);
        this.setLocation(rectangle.x, rectangle.y);
    }

    public void setColumnColors(Color[][] colors) {
        int rowdim = 0;
        int coldim = 0;
        if (colors != null) {
            rowdim = colors.length;
            coldim = colors[0].length;
            if (this.colNbr < coldim) {
                this.colNbr = coldim;
            }
            this.backgrounds = new Color[colors.length][coldim];
            for (int row = 0; row < rowdim; ++row) {
                for (int col = 0; col < this.colNbr; ++col) {
                    if (col >= coldim) continue;
                    this.backgrounds[row][col] = colors[row][col];
                }
            }
        }
    }

    public void setColumnColors(Color[] colors) {
        int dim = 0;
        if (colors != null) {
            dim = colors.length;
            this.backgrounds = new Color[1][dim];
            for (int cter = 0; cter < this.colNbr; ++cter) {
                if (cter >= dim) continue;
                this.backgrounds[0][cter] = colors[cter];
            }
        }
    }

    private void setColumnComboBox(ComboList[] cl) {
        this.renderer = new ComboBoxRenderer(this);
        this.jcb = new JComboBox<ComboList>(cl);
        this.setLayout(new BorderLayout());
        this.add(this.jcb);
        this.jcb.setRenderer(this.renderer);
        this.jcb.setMaximumRowCount(this.maxRowCount);
        this.jcb.addItemListener(this);
        this.jcb.addPopupMenuListener(new JColumnComboBox_popupMenuAdapter(this));
        this.jcb.getComponent(0).addMouseListener(new JColumnComboBox_mouseAdapter(this));
        this.jcb.setEditable(true);
        ComboBoxEditor ed = this.jcb.getEditor();
        ed.getEditorComponent().addFocusListener(this);
        ed.getEditorComponent().addMouseListener(new JColumnComboBox_mouseAdapter(this));
        ed.getEditorComponent().addKeyListener(new JColumnComboBox_keyAdapter(this));
        if (this.fonts != null) {
            this.jcb.setFont(this.fonts[0]);
        }
        if (cl.length <= this.index) {
            this.index = -1;
        }
        this.selectedItemReminder = this.index < 0 ? cl[0] : cl[this.index];
    }

    public void setColumnWidths(int[] widths) {
        int dim = 0;
        int tot = 0;
        if (widths != null) {
            dim = widths.length;
            this.widths = new int[dim];
            if (this.colNbr < widths.length) {
                this.colNbr = dim;
            }
            for (int cter = 0; cter < this.colNbr; ++cter) {
                if (cter < dim - 1) {
                    this.widths[cter] = widths[cter];
                    tot += widths[cter];
                    continue;
                }
                if (cter >= dim) continue;
                this.widths[cter] = this.dimx - tot;
            }
        }
    }

    @Override
    public boolean isEditable() {
        boolean res = false;
        if (this.jcb == null) {
            return false;
        }
        ComboBoxEditor ed = this.jcb.getEditor();
        Component cc = ed.getEditorComponent();
        if (cc instanceof JTextField) {
            JTextField component = (JTextField)cc;
            res = component.isEditable();
        } else if (cc instanceof JPanel) {
            res = false;
        }
        return res;
    }

    private void refresh() {
        int dim = this.jcb.getItemCount();
        ComboList[] cl = new ComboList[dim];
        Object[][] list = this.getItemList();
        boolean editable = this.isEditable();
        boolean columnVisible = this.isColumnVisible();
        for (int cter = 0; cter < dim; ++cter) {
            cl[cter] = new ComboList(list[cter]);
        }
        if (this.jcb != null) {
            this.remove(this.jcb);
        }
        this.selectedItemReminder = this.index < 0 ? cl[0] : (this.index < dim ? cl[this.index] : cl[0]);
        this.setColumnComboBox(cl);
        this.setEditorColumnsVisible(columnVisible);
        this.setEditable(editable);
    }

    @Override
    public void setEditable(boolean editable) {
        ComboBoxEditor ed = this.jcb.getEditor();
        Component object = ed.getEditorComponent();
        if (object instanceof JTextField) {
            JTextField component = (JTextField)object;
            component.setEditable(editable);
            if (!this.isColumnVisible() && this.editorText != null) {
                component.setText(this.editorText);
                this.jcb.setSelectedItem(this.editorText);
            }
        }
    }

    public void setEditorColumn(int col) {
        this.colInEditor = col < this.colNbr ? col : this.colNbr - 1;
    }

    public void setEditorColumnsVisible(boolean visible) {
        this.isColumnVisible = visible;
        if (visible) {
            this.ccbed = new ColorComboBoxEditor(this);
            this.setEditable(true);
            this.jcb.setEditor(this.ccbed);
            this.ccbed.setToolTipText(this.tooltip);
        } else {
            this.setEditable(this.isEditable());
        }
    }

    private void setEditorText() {
        Object[][] items = this.getItemList();
        Object[] item = null;
        item = this.index < 1 ? items[0] : items[this.index];
        this.editorText = (String)item[this.colInEditor + 1];
    }

    @Override
    public void setEnabled(boolean enabled) {
    }

    @Override
    public void setFont(Font font) {
        if (this.fonts != null) {
            this.fonts[0] = font;
            this.jcb.setFont(this.fonts[0]);
        }
    }

    public void setFonts(Font[] fonts) {
        int dim = fonts.length;
        if (this.colNbr > 0) {
            this.fonts = new Font[this.colNbr + 1];
            for (int cter = 0; cter < this.colNbr + 1; ++cter) {
                if (cter >= dim) continue;
                this.fonts[cter] = fonts[cter];
            }
        }
        if (fonts != null) {
            this.jcb.setFont(fonts[0]);
        }
    }

    public void setColumnForegroundColors(Color[][] colors) {
        int rowdim = 0;
        int coldim = 0;
        if (colors != null) {
            rowdim = colors.length;
            coldim = colors[0].length;
            this.foregrounds = new Color[colors.length][coldim];
            for (int row = 0; row < rowdim; ++row) {
                for (int col = 0; col < this.colNbr; ++col) {
                    if (col >= coldim) continue;
                    this.foregrounds[row][col] = colors[row][col];
                }
            }
        }
    }

    public void setColumnForeground(Color[] colors) {
        int dim = 0;
        if (colors != null) {
            dim = colors.length;
            this.foregrounds = new Color[1][dim];
            for (int cter = 0; cter < this.colNbr; ++cter) {
                if (cter >= dim) continue;
                this.foregrounds[0][cter] = colors[cter];
            }
        }
    }

    @Override
    public void setMaximumRowCount(int count) {
        this.maxRowCount = count;
        this.jcb.setMaximumRowCount(count);
    }

    public void setSelectedId(String id) {
        Component scrollpane;
        this.id = id;
        int tcter = 0;
        if (id != null) {
            int ii;
            int dim = this.jcb.getItemCount();
            this.index = -1;
            for (ii = 0; ii < dim; ++ii) {
                if (!((ComboList)this.jcb.getItemAt(ii)).getId().equals(id)) continue;
                this.index = ii;
                break;
            }
            if (this.index == -1) {
                for (ii = 0; ii < dim; ++ii) {
                    if (!((ComboList)this.jcb.getItemAt(ii)).values[0].equals(id)) continue;
                    this.index = ii;
                    break;
                }
            }
            while (tcter < this.timeout) {
                block14: {
                    Object object = this.jcb.getSelectedItem();
                    if (object != null) {
                        if (object instanceof ComboList) {
                            if (((ComboList)object).getId().equals(id)) break;
                            if (tcter == 2 || tcter == this.timeout / 2) {
                                this.refresh();
                            }
                            try {
                                this.jcb.setSelectedIndex(this.index);
                                Thread.sleep(100L);
                                break;
                            }
                            catch (InterruptedException ie) {
                                System.out.println("ColumnComboBox Interrupted Exception: " + ie.getMessage());
                                break block14;
                            }
                        }
                        try {
                            this.jcb.setSelectedIndex(this.index);
                            Thread.sleep(100L);
                            break;
                        }
                        catch (InterruptedException ie) {
                            System.out.println("ColumnComboBox Interrupted Exception: " + ie.getMessage());
                            break block14;
                        }
                    }
                    if (!id.equals("")) {
                        this.jcb.setSelectedIndex(this.index);
                    }
                }
                ++tcter;
            }
        }
        this.setEditorColumnsVisible(this.isColumnVisible);
        Accessible popup = this.jcb.getUI().getAccessibleChild(this.jcb, 0);
        if (!(popup instanceof ComboPopup) || (scrollpane = ((Container)((Object)popup)).getComponent(0)) instanceof JScrollPane) {
            // empty if block
        }
    }

    @Override
    public void setSelectedIndex(int index) {
        this.index = index;
        int tcter = 0;
        if (index > -1) {
            while (this.jcb.getSelectedIndex() != index) {
                try {
                    int itemCount = this.jcb.getItemCount();
                    if (tcter == 2 || tcter == this.timeout / 2) {
                        this.refresh();
                    }
                    if (index < itemCount) {
                        this.jcb.setSelectedIndex(index);
                    }
                    Thread.sleep(50L);
                    if (++tcter <= this.timeout) continue;
                    break;
                }
                catch (InterruptedException ie) {
                    System.out.println("ColumnComboBox Interrupted Exception: " + ie.getMessage());
                }
            }
        }
        this.setEditorColumnsVisible(this.isColumnVisible);
    }

    @Override
    public void setSelectedItem(Object object) {
        this.item = object;
        int tcter = 0;
        if (this.item != null) {
            int dim = this.jcb.getItemCount();
            this.index = -1;
            for (int ii = 0; ii < dim; ++ii) {
                String[] itlist = ((ComboList)this.jcb.getItemAt(ii)).getAllValues();
                int dimit = 0;
                int dimlist = 0;
                int cter = 0;
                if (itlist != null) {
                    dimlist = itlist.length;
                }
                if (!(this.item instanceof Object[]) || dimlist <= 0) continue;
                dimit = ((Object[])this.item).length;
                if (dimit > 0 && dimit == dimlist) {
                    for (int jj = 0; jj < dimit; ++jj) {
                        if (itlist == null || this.item == null || !itlist[jj].equals(String.valueOf(((Object[])this.item)[jj]))) continue;
                        ++cter;
                    }
                }
                if (cter != dimit) continue;
                this.index = ii;
                break;
            }
            if (!this.isColumnVisible()) {
                this.ccbed = new ColorComboBoxEditor(this);
                this.setEditable(true);
                this.jcb.setEditor(this.ccbed);
                this.ccbed.setToolTipText(this.tooltip);
            }
            while (this.jcb.getSelectedIndex() != this.index) {
                try {
                    if (tcter == 2 || tcter == this.timeout / 2) {
                        this.refresh();
                    }
                    this.jcb.setSelectedIndex(this.index);
                    Thread.sleep(50L);
                    if (++tcter <= this.timeout) continue;
                    break;
                }
                catch (InterruptedException ie) {
                    System.out.println("ColumnComboBox Interrupted Exception: " + ie.getMessage());
                }
            }
        }
        this.setEditorColumnsVisible(this.isColumnVisible);
    }

    @Override
    public void setToolTipText(String tooltip) {
        this.tooltip = tooltip;
        this.jcb.setToolTipText(tooltip);
        ComboBoxEditor ed = this.jcb.getEditor();
        Component object = ed.getEditorComponent();
        if (object instanceof JTextField) {
            ((JTextField)object).setToolTipText(tooltip);
        } else if (object instanceof JPanel) {
            ((JPanel)object).setToolTipText(tooltip);
            Component[] component = ((JPanel)object).getComponents();
            for (int ii = 0; ii < component.length; ++ii) {
                if (component[ii] instanceof JTextField) {
                    ((JTextField)component[ii]).setToolTipText(tooltip);
                    continue;
                }
                if (!(component[ii] instanceof JLabel)) continue;
                ((JLabel)component[ii]).setToolTipText(tooltip);
            }
        }
    }

    private void setFlag(int flag) {
        int notEqualTo = flag ^ this.flag;
        if ((notEqualTo & flag) == notEqualTo) {
            this.flag += notEqualTo;
        } else if ((this.flag & flag) == 0) {
            this.flag += flag;
        }
    }

    private void removeFlag(int flag) {
        if (flag <= 0) {
            return;
        }
        this.flag &= ~flag;
    }

    private void mousePressed(MouseEvent me) {
        boolean b_fire = false;
        if (me.getComponent() instanceof JButton) {
            this.jcb.setPopupVisible(!this.isBPopupVisible);
            b_fire = true;
        } else if (!this.isEditable()) {
            this.jcb.setPopupVisible(!this.isPopupVisible);
            b_fire = true;
        } else if (this.isPopupVisible) {
            this.jcb.setPopupVisible(false);
        }
        if (b_fire) {
            this.fireMouseClickedEvent(me);
        }
    }

    private void mouseReleased(MouseEvent me) {
        this.isPopupVisible = this.jcb.isPopupVisible();
        this.isBPopupVisible = this.jcb.isPopupVisible();
    }

    private void mouseEntered(MouseEvent me) {
        this.isPopupVisible = this.jcb.isPopupVisible();
        this.isBPopupVisible = this.jcb.isPopupVisible();
        if (me.getComponent() instanceof JButton && (this.flag & 4) == 4) {
            JTextField component;
            ComboBoxEditor ed = this.jcb.getEditor();
            Component object = ed.getEditorComponent();
            if (object instanceof JTextField && (component = (JTextField)object).isEditable() && component.isEnabled()) {
                Object[][] items = this.getItemList();
                Object[] item = null;
                int index = this.getSelectedIndex();
                this.editorText = component.getText();
                item = index < 1 ? items[0] : items[index];
                if (!this.isColumnVisible()) {
                    item[this.colInEditor + 1] = this.editorText;
                }
                this.UpdateSelectedItem(item);
            }
            this.removeFlag(4);
        }
    }

    private void mouseExited(MouseEvent me) {
    }

    private void popupMenuWillBecomeVisible(PopupMenuEvent pme) {
        this.isPopupVisible = true;
    }

    private void popupMenuWillBecomeInvisible(PopupMenuEvent pme) {
    }

    private void popupMenuCanceled(PopupMenuEvent pme) {
    }

    @Override
    public void addFocusListener(FocusListener aListener) {
        this.listenerList.add(FocusListener.class, aListener);
    }

    @Override
    public void removeFocusListener(FocusListener aListener) {
        this.listenerList.remove(FocusListener.class, aListener);
    }

    @Override
    public void focusGained(FocusEvent fe) {
        fe.setSource(this);
        this.fireFocusGainedEvent(fe);
    }

    @Override
    public void focusLost(FocusEvent fe) {
        if ((this.flag & 2) == 2) {
            this.removeFlag(2);
        } else {
            JTextField component;
            fe.setSource(this);
            this.fireFocusLostEvent(fe);
            ComboBoxEditor ed = this.jcb.getEditor();
            Component object = ed.getEditorComponent();
            if (object instanceof JTextField && (component = (JTextField)object).isEditable() && component.isEnabled()) {
                Object[][] items = this.getItemList();
                Object[] item = null;
                int index = this.getSelectedIndex();
                this.editorText = component.getText();
                item = index < 1 ? items[0] : items[index];
                if (!this.isColumnVisible()) {
                    item[this.colInEditor + 1] = this.editorText;
                }
                this.UpdateSelectedItem(item);
            }
        }
    }

    private void keyPressed(KeyEvent ke) {
        JTextField component;
        ComboBoxEditor ed;
        Component object;
        if (ke.getKeyCode() == 10 && (object = (ed = this.jcb.getEditor()).getEditorComponent()) instanceof JTextField && this.isEditable() && this.isEnabled() && (component = (JTextField)object).isEditable() && component.isEnabled()) {
            this.editorText = component.getText();
        }
    }

    private void keyReleased(KeyEvent ke) {
        if (ke.getKeyCode() == 10) {
            JTextField component;
            ComboBoxEditor ed = this.jcb.getEditor();
            Component object = ed.getEditorComponent();
            this.removeFlag(4);
            if (object instanceof JTextField && (component = (JTextField)object).isEditable() && component.isEnabled()) {
                Object[][] items = this.getItemList();
                Object[] item = null;
                int index = this.getSelectedIndex();
                item = index < 1 ? items[0] : items[index];
                if (!this.isColumnVisible()) {
                    item[this.colInEditor + 1] = this.editorText;
                }
                this.UpdateSelectedItem(item);
                this.setFlag(2);
            }
        } else if (ke.getKeyCode() == 9) {
            this.removeFlag(4);
        } else {
            this.setFlag(4);
        }
    }

    protected void fireMouseClickedEvent(MouseEvent me) {
        Object[] listeners = this.listenerList.getListenerList();
        me.setSource(this);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MouseListener.class) continue;
            ((MouseListener)listeners[i + 1]).mouseClicked(me);
        }
    }

    protected void fireFocusGainedEvent(FocusEvent fe) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != FocusListener.class) continue;
            ((FocusListener)listeners[i + 1]).focusGained(fe);
        }
    }

    protected void fireFocusLostEvent(FocusEvent fe) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != FocusListener.class) continue;
            ((FocusListener)listeners[i + 1]).focusLost(fe);
        }
    }

    @Override
    public void addItemListener(ItemListener aListener) {
        this.listenerList.add(ItemListener.class, aListener);
    }

    @Override
    public void addMouseListener(MouseListener aListener) {
        this.listenerList.add(MouseListener.class, aListener);
    }

    @Override
    public void removeItemListener(ItemListener aListener) {
        this.listenerList.remove(ItemListener.class, aListener);
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
        int index;
        if (this.jcb != null && (index = this.jcb.getSelectedIndex()) > -1) {
            if (this.prevIndex != index) {
                this.fireItemStateChanged(ie);
                this.prevIndex = index;
            }
            if (this.index != index) {
                this.index = index;
            }
            this.setEditorText();
            this.setEditable(this.isEditable());
        }
    }

    @Override
    public ItemListener[] getItemListeners() {
        return (ItemListener[])this.listenerList.getListeners(ItemListener.class);
    }

    @Override
    protected void fireItemStateChanged(ItemEvent ie) {
        Object[] listeners = this.listenerList.getListenerList();
        ie.setSource(this);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ItemListener.class || !this.jcb.isPopupVisible()) continue;
            this.jcb.setPopupVisible(false);
            ((ItemListener)listeners[i + 1]).itemStateChanged(ie);
        }
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        Object oldSelection = this.selectedItemReminder;
        if (this.dataModel == null) {
            return;
        }
        Object newSelection = this.dataModel.getSelectedItem();
        if (oldSelection == null || !oldSelection.equals(newSelection)) {
            this.selectedItemChanged();
            if (!this.selectingItem) {
                this.fireActionEvent();
            }
        }
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        if (this.selectedItemReminder != this.dataModel.getSelectedItem()) {
            this.selectedItemChanged();
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        this.contentsChanged(e);
    }

    @Override
    protected void fireActionEvent() {
        if (!this.firingActionEvent) {
            this.firingActionEvent = true;
            ActionEvent e = null;
            Object[] listeners = this.listenerList.getListenerList();
            long mostRecentEventTime = EventQueue.getMostRecentEventTime();
            int modifiers = 0;
            AWTEvent currentEvent = EventQueue.getCurrentEvent();
            if (currentEvent instanceof InputEvent) {
                modifiers = ((InputEvent)currentEvent).getModifiers();
            } else if (currentEvent instanceof ActionEvent) {
                modifiers = ((ActionEvent)currentEvent).getModifiers();
            }
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != ActionListener.class) continue;
                if (e == null) {
                    e = new ActionEvent(this, 1001, this.getActionCommand(), mostRecentEventTime, modifiers);
                }
                ((ActionListener)listeners[i + 1]).actionPerformed(e);
            }
            this.firingActionEvent = false;
        }
    }

    @Override
    public String getActionCommand() {
        return this.actionCommand;
    }

    @Override
    public Object[] getSelectedObjects() {
        Object selectedObject = this.getSelectedItem();
        if (selectedObject == null) {
            return new Object[0];
        }
        Object[] result = new Object[]{selectedObject};
        return result;
    }

    @Override
    public int getSelectedIndex() {
        int res = -1;
        if (this.jcb != null) {
            res = this.jcb.getSelectedIndex();
        }
        if (res == -1) {
            res = this.index;
        } else {
            this.index = res;
        }
        return res;
    }

    @Override
    public Object getSelectedItem() {
        ComboBoxModel cbm = this.jcb.getModel();
        this.item = cbm.getSelectedItem();
        if (this.item instanceof JPanel) {
            int index = this.getSelectedIndex();
            this.selectedItemReminder = cbm.getElementAt(index);
        } else {
            this.selectedItemReminder = this.item;
        }
        return this.item;
    }

    public String[] getSelectedItems() {
        ComboList cl = null;
        Object object = this.getSelectedItem();
        if (object instanceof JPanel) {
            if (this.selectedItemReminder instanceof ComboList) {
                cl = (ComboList)this.selectedItemReminder;
            }
        } else if (object instanceof ComboList) {
            cl = (ComboList)this.getSelectedItem();
        } else if (object instanceof String) {
            int index = this.getSelectedIndex();
            if (index == -1) {
                index = 0;
            }
            Object[][] content = this.getItemList();
            if (index > -1 && content.length > index - 1) {
                int dim = content[0].length;
                if (dim == 0) {
                    return null;
                }
                String[] item = new String[dim - 1];
                for (int ii = 0; ii < dim - 1; ++ii) {
                    item[ii] = (String)content[index][ii + 1];
                }
                return item;
            }
        }
        if (cl == null) {
            return null;
        }
        return cl.values;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String getSelectedId() {
        ComboList cl;
        block7: {
            cl = null;
            JColumnComboBox jccbtmp = this;
            Object object = jccbtmp.getSelectedItem();
            if (object instanceof JPanel || object instanceof String) {
                if (cl != null) {
                    int index;
                    if (cl.getId().equals("-1") && (index = this.getSelectedIndex()) >= 0) {
                        Object[][] tmp = this.getItemList();
                        return (String)tmp[index][0];
                    }
                    break block7;
                } else {
                    int index = this.getSelectedIndex();
                    if (index < 0) {
                        return null;
                    }
                    Object[][] tmp = this.getItemList();
                    return (String)tmp[index][0];
                }
            }
            if (object instanceof ComboList) {
                cl = (ComboList)this.getSelectedItem();
            }
        }
        if (cl == null) {
            return null;
        }
        return cl.getId();
    }

    public Object getSelectedItem(int col) {
        Component[] components;
        JComponent component;
        String res = null;
        String tmp = "";
        int selectedIndex = this.jcb.getSelectedIndex();
        ComboBoxEditor ed = this.jcb.getEditor();
        String cbText = "";
        if (ed.getEditorComponent() instanceof JTextField) {
            component = (JTextField)ed.getEditorComponent();
            cbText = ((JTextComponent)component).getText();
        } else if (ed.getEditorComponent() instanceof JPanel && (components = (component = (JPanel)ed.getEditorComponent()).getComponents()).length > col) {
            cbText = ((JLabel)components[col]).getText().trim();
        }
        ComboBoxModel cbm = this.jcb.getModel();
        if (cbm.getSelectedItem() instanceof ComboList) {
            res = ((ComboList)cbm.getSelectedItem()).getValue(col).trim();
            this.selectedItemReminder = cbm.getSelectedItem();
        } else {
            this.selectedItemReminder = cbm.getSelectedItem();
            tmp = this.selectedItemReminder instanceof ComboList ? ((ComboList)this.selectedItemReminder).getValue(col).trim() : cbText;
            ComboList cl = new ComboList(cbText, new String[]{tmp, cbText});
            int dim = cbm.getSize();
            ComboList[] jcbCl = new ComboList[dim];
            for (int cter = 0; cter < cbm.getSize(); ++cter) {
                if (tmp.equals(((ComboList)cbm.getElementAt(cter)).getValue(col).trim())) {
                    jcbCl[cter] = cl;
                    selectedIndex = cter;
                    continue;
                }
                jcbCl[cter] = (ComboList)cbm.getElementAt(cter);
            }
            this.jcb.setSelectedIndex(selectedIndex);
        }
        return res;
    }

    public boolean isEmpty() {
        boolean res = true;
        ComboBoxModel cbm = this.jcb.getModel();
        int dim = cbm.getSize();
        block0: for (int cter = 0; cter < dim; ++cter) {
            if (this.colNbr <= 1) continue;
            for (int cter2 = 1; cter2 < this.colNbr; ++cter2) {
                if (((ComboList)cbm.getElementAt(cter)).getValue(cter2).trim().equals("")) continue;
                res = false;
                continue block0;
            }
        }
        return res;
    }

    public void updateItem(String[] value) {
        int dim = this.jcb.getItemCount();
        ComboList[] cl = new ComboList[dim];
        Object[][] list = this.getItemList();
        boolean editable = this.isEditable();
        if (value == null) {
            return;
        }
        if (value.length - 1 != this.colNbr) {
            return;
        }
        for (int cter = 0; cter < dim; ++cter) {
            if (list[cter][0].equals(value[0])) {
                list[cter] = value;
            }
            cl[cter] = new ComboList(list[cter]);
        }
        if (this.jcb != null) {
            this.remove(this.jcb);
        }
        this.setColumnComboBox(cl);
        this.setEditable(editable);
    }

    public void UpdateSelectedItem(Object[] item) {
        int dim = this.jcb.getItemCount();
        ComboList[] cl = new ComboList[dim];
        Object[][] list = this.getItemList();
        boolean editable = this.isEditable();
        boolean columnVisible = this.isColumnVisible();
        int index = this.getSelectedIndex();
        if (index < 1) {
            list[0] = item;
        } else {
            list[index] = item;
        }
        for (int cter = 0; cter < dim; ++cter) {
            cl[cter] = new ComboList(list[cter]);
        }
        if (this.jcb != null) {
            this.remove(this.jcb);
        }
        this.setColumnComboBox(cl);
        this.setEditorColumnsVisible(columnVisible);
        this.setEditable(editable);
    }

    class JColumnComboBox_popupMenuAdapter
    implements PopupMenuListener {
        JColumnComboBox adaptee;

        JColumnComboBox_popupMenuAdapter(JColumnComboBox adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent pme) {
            this.adaptee.popupMenuWillBecomeVisible(pme);
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent pme) {
            this.adaptee.popupMenuWillBecomeInvisible(pme);
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent pme) {
            this.adaptee.popupMenuCanceled(pme);
        }
    }

    class JColumnComboBox_keyAdapter
    extends KeyAdapter {
        JColumnComboBox adaptee;

        JColumnComboBox_keyAdapter(JColumnComboBox adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void keyReleased(KeyEvent ke) {
            this.adaptee.keyReleased(ke);
        }

        @Override
        public void keyPressed(KeyEvent ke) {
            this.adaptee.keyPressed(ke);
        }
    }

    class JColumnComboBox_mouseAdapter
    extends MouseAdapter {
        JColumnComboBox adaptee;

        JColumnComboBox_mouseAdapter(JColumnComboBox adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void mousePressed(MouseEvent me) {
            this.adaptee.mousePressed(me);
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            this.adaptee.mouseReleased(me);
        }

        @Override
        public void mouseEntered(MouseEvent me) {
            this.adaptee.mouseEntered(me);
        }

        @Override
        public void mouseExited(MouseEvent me) {
            this.adaptee.mouseExited(me);
        }
    }

    class JColumnComboBoxThread
    extends Thread {
        JComboBox jcbox;
        int index = -1;
        Object item;
        String id;
        int tcter = 0;

        public JColumnComboBoxThread(JColumnComboBox jcb) {
            this.jcbox = jcb.jcb;
        }

        public void setSelectedIndex(int index) {
            this.index = index;
            this.start();
        }

        public void setSelectedItem(Object item) {
            this.item = item;
            this.start();
        }

        public void setSelectedId(String id) {
            this.id = id;
            this.start();
        }

        @Override
        public void run() {
            if (this.index > -1) {
                while (this.jcbox.getSelectedIndex() != this.index) {
                    try {
                        int itemCount = this.jcbox.getItemCount();
                        if (this.index < itemCount) {
                            this.jcbox.setSelectedIndex(this.index);
                        }
                        Thread.sleep(50L);
                        ++this.tcter;
                        if (this.tcter <= JColumnComboBox.this.timeout) continue;
                        break;
                    }
                    catch (InterruptedException ie) {
                        System.out.println("ColumnComboBox Interrupted Exception: " + ie.getMessage());
                    }
                }
            } else if (this.id != null) {
                int dim = this.jcbox.getItemCount();
                int index = -1;
                for (int ii = 0; ii < dim; ++ii) {
                    if (!((ComboList)this.jcbox.getItemAt(ii)).getId().equals(this.id)) continue;
                    index = ii;
                    break;
                }
                while (this.tcter < JColumnComboBox.this.timeout) {
                    Object object = this.jcbox.getSelectedItem();
                    if (object != null) {
                        if (object instanceof ComboList) {
                            if (((ComboList)object).getId().equals(this.id)) break;
                            try {
                                this.jcbox.setSelectedIndex(index);
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException ie) {
                                System.out.println("ColumnComboBox Interrupted Exception: " + ie.getMessage());
                            }
                        } else {
                            try {
                                this.jcbox.setSelectedIndex(index);
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException ie) {
                                System.out.println("ColumnComboBox Interrupted Exception: " + ie.getMessage());
                            }
                        }
                    } else if (!this.id.equals("")) {
                        this.jcbox.setSelectedIndex(index);
                    }
                    ++this.tcter;
                }
            } else if (this.item != null) {
                int dim = this.jcbox.getItemCount();
                int index = -1;
                for (int ii = 0; ii < dim; ++ii) {
                    String[] itlist = ((ComboList)this.jcbox.getItemAt(ii)).getAllValues();
                    int dimit = 0;
                    int dimlist = 0;
                    int cter = 0;
                    if (itlist != null) {
                        dimlist = itlist.length;
                    }
                    if (!(this.item instanceof Object[]) || dimlist <= 0) continue;
                    dimit = ((Object[])this.item).length;
                    if (dimit > 0 && dimit == dimlist) {
                        for (int jj = 0; jj < dimit; ++jj) {
                            if (itlist == null || this.item == null || !itlist[jj].equals(String.valueOf(((Object[])this.item)[jj]))) continue;
                            ++cter;
                        }
                    }
                    if (cter != dimit) continue;
                    index = ii;
                    break;
                }
                while (this.jcbox.getSelectedIndex() != index) {
                    try {
                        this.jcbox.setSelectedIndex(index);
                        Thread.sleep(50L);
                        ++this.tcter;
                        if (this.tcter <= JColumnComboBox.this.timeout) continue;
                        break;
                    }
                    catch (InterruptedException ie) {
                        System.out.println("ColumnComboBox Interrupted Exception: " + ie.getMessage());
                    }
                }
            }
            JColumnComboBox.this.setEditorColumnsVisible(JColumnComboBox.this.isColumnVisible);
        }
    }

    class ComboList {
        private String id;
        private String[] values = new String[2];

        public ComboList(String id, String[] values) {
            if (values != null) {
                this.values = new String[values.length];
            }
            this.id = id;
            for (int cter = 0; cter < values.length; ++cter) {
                this.values[cter] = values[cter];
            }
        }

        public ComboList(String[] values) {
            if (values != null) {
                this.values = new String[values.length];
            }
            this.id = values[0];
            for (int cter = 1; cter < values.length; ++cter) {
                this.values[cter - 1] = values[cter];
            }
        }

        public ComboList(Object[] values) {
            if (values != null) {
                this.values = new String[values.length];
            }
            this.id = (String)values[0];
            for (int cter = 1; cter < values.length; ++cter) {
                this.values[cter - 1] = (String)values[cter];
            }
        }

        public String getValue(int col) {
            return this.values[col];
        }

        public String[] getAllValues() {
            int dim = this.values.length;
            String[] res = new String[dim];
            res[0] = this.id;
            if (dim > 1) {
                for (int ii = 0; ii < dim - 1; ++ii) {
                    res[ii + 1] = this.values[ii];
                }
            }
            return res;
        }

        public String[] getValues() {
            return this.values;
        }

        public void setValue(int col, String value) {
            this.values[col] = value;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String newId) {
            this.id = newId;
        }

        public String toString() {
            return this.id;
        }
    }

    class ComboBoxRenderer
    extends JPanel
    implements ListCellRenderer {
        JTextField[] jtf;
        JColumnComboBox jcolcb;
        int col = 0;
        int[] widths;
        Color[][] foregrounds;
        Color[][] backgrounds;

        public ComboBoxRenderer(JColumnComboBox jcolcb) {
            this.jcolcb = jcolcb;
            this.widths = jcolcb.getColumnWidths();
            this.backgrounds = jcolcb.backgrounds;
            this.foregrounds = jcolcb.foregrounds;
            this.col = this.widths == null ? JColumnComboBox.this.colNbr : this.widths.length;
            this.jtf = this.col > 1 ? new JTextField[this.col] : new JTextField[1];
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            for (int cter = 0; cter < this.col; ++cter) {
                this.jtf[cter] = new JTextField();
                this.jtf[cter].addMouseListener(new JColumnComboBox_mouseAdapter(jcolcb));
                c.gridx = cter;
                c.gridy = 0;
                this.add((Component)this.jtf[cter], c);
            }
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            int cter;
            int coldim;
            int rowdim;
            int cter2;
            if (this.jcolcb != null && this.jcolcb.index == index) {
                isSelected = true;
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
                for (cter2 = 0; cter2 < this.jtf.length; ++cter2) {
                    this.jtf[cter2].setBackground(list.getSelectionBackground());
                }
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
                if (this.backgrounds != null) {
                    rowdim = this.backgrounds.length;
                    coldim = this.backgrounds[0].length;
                    for (cter = 0; cter < this.jtf.length; ++cter) {
                        if (cter >= coldim) continue;
                        if (rowdim > 0) {
                            if (index + 1 < rowdim) {
                                this.jtf[cter].setBackground(this.backgrounds[index + 1][cter]);
                                continue;
                            }
                            this.jtf[cter].setBackground(this.backgrounds[0][cter]);
                            continue;
                        }
                        this.jtf[cter].setBackground(this.backgrounds[0][cter]);
                    }
                } else if (this.col > 1) {
                    this.jtf[0].setBackground(new Color(223, 223, 223));
                    for (cter2 = 1; cter2 < this.col; ++cter2) {
                        this.jtf[cter2].setBackground(list.getBackground());
                    }
                }
            }
            if (this.foregrounds != null) {
                rowdim = this.foregrounds.length;
                coldim = this.foregrounds[0].length;
                for (cter = 0; cter < this.jtf.length; ++cter) {
                    if (cter >= coldim) continue;
                    if (rowdim > 0) {
                        if (index + 1 < rowdim) {
                            this.jtf[cter].setForeground(this.foregrounds[index + 1][cter]);
                            continue;
                        }
                        this.jtf[cter].setForeground(this.foregrounds[0][cter]);
                        continue;
                    }
                    this.jtf[cter].setForeground(this.foregrounds[0][cter]);
                }
            }
            ComboList cl = (ComboList)value;
            for (int cter3 = 0; cter3 < this.col; ++cter3) {
                this.jtf[cter3].setPreferredSize(new Dimension(this.widths[cter3], 20));
                this.jtf[cter3].setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
                if (value == null) continue;
                this.jtf[cter3].setText(cl.getValue(cter3));
            }
            if (JColumnComboBox.this.fonts != null) {
                int dim = JColumnComboBox.this.fonts.length;
                for (cter = 0; cter < this.col; ++cter) {
                    if (cter >= dim - 1) continue;
                    this.jtf[cter].setFont(JColumnComboBox.this.fonts[cter + 1]);
                }
            }
            return this;
        }
    }

    class ColorComboBoxEditor
    implements ComboBoxEditor {
        protected JPanel editor;
        protected Rectangle rec;
        JLabel[] label;
        int dim = 0;

        public ColorComboBoxEditor(JColumnComboBox jcb) {
            int[] widths = jcb.getColumnWidths();
            int xx = 2;
            if (widths != null) {
                this.dim = widths.length;
            }
            this.rec = jcb.getBounds();
            this.label = new JLabel[this.dim];
            this.editor = new JPanel();
            this.editor.setLayout(null);
            Color outside = new Color(123, 137, 156);
            Color inside = new Color(189, 206, 230);
            this.editor.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 0, outside), BorderFactory.createLineBorder(inside, 1)));
            for (int ii = 0; ii < this.dim; ++ii) {
                this.label[ii] = new JLabel();
                this.label[ii].setBounds(xx, 2, widths[ii], this.rec.height - 4);
                this.label[ii].addMouseListener(new JColumnComboBox_mouseAdapter(jcb));
                this.editor.add(this.label[ii]);
                xx += widths[ii];
            }
        }

        @Override
        public void setItem(Object newValue) {
            String[] items = null;
            if (newValue instanceof ComboList) {
                items = ((ComboList)newValue).getValues();
            } else if (newValue instanceof String[]) {
                items = (String[])newValue;
            }
            for (int ii = 0; ii < this.dim; ++ii) {
                if (items == null || items[ii] == null) continue;
                this.label[ii].setText(items[ii]);
            }
        }

        @Override
        public Object getItem() {
            return this.editor;
        }

        @Override
        public Component getEditorComponent() {
            return this.editor;
        }

        @Override
        public void selectAll() {
        }

        public void setToolTipText(String tooltip) {
            if (this.editor != null) {
                Component[] component = this.editor.getComponents();
                for (int ii = 0; ii < component.length; ++ii) {
                    if (!(component[ii] instanceof JLabel)) continue;
                    ((JLabel)component[ii]).setToolTipText(tooltip);
                }
            }
        }

        @Override
        public void addActionListener(ActionListener al) {
            JColumnComboBox.this.listenerList.add(ActionListener.class, al);
        }

        @Override
        public void removeActionListener(ActionListener l) {
            JColumnComboBox.this.listenerList.remove(ActionListener.class, l);
        }
    }
}

