/*
 * Decompiled with CFR 0.152.
 */
package privatecomponents;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.basic.BasicComboPopup;

public class JIconComboBox
extends JComboBox {
    ImageIcon editorIcon;
    ImageIcon selectedIcon;
    Object[] items;
    IconComboBoxEditor editor;
    IconComboBoxRenderer renderer;

    public JIconComboBox() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JIconComboBox(Object[] items) {
        super(items);
        this.items = items;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JIconComboBox(Object[] items, ImageIcon editorIcon, ImageIcon selectedIcon) {
        this.items = items;
        this.editorIcon = editorIcon;
        this.selectedIcon = selectedIcon;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setSize(100, 20);
        this.setEditable(true);
        if (this.editorIcon != null) {
            this.editor = new IconComboBoxEditor(this, this.editorIcon);
            this.setEditor(this.editor);
        }
        this.renderer = new IconComboBoxRenderer(this);
        this.setRenderer(this.renderer);
    }

    private void resizeComboPopup() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        BasicComboPopup popup = (BasicComboPopup)this.getUI().getAccessibleChild(this, 0);
        if (popup == null) {
            return;
        }
        int size = (int)this.getPreferredSize().getWidth();
        for (int ii = 0; ii < this.getItemCount(); ++ii) {
            String str = (String)this.getItemAt(ii);
            if (size >= fm.stringWidth(str)) continue;
            size = fm.stringWidth(str);
        }
        Component comp = popup.getComponent(0);
        JScrollPane scrollpane = null;
        int offset = 0;
        if (comp instanceof JScrollPane && (scrollpane = (JScrollPane)comp).getVerticalScrollBar().isVisible()) {
            offset += scrollpane.getVerticalScrollBar().getWidth();
        }
        popup.setPreferredSize(new Dimension(size + offset, popup.getPreferredSize().height));
        popup.setLayout(new BorderLayout());
        popup.add(comp, "Center");
    }

    public void setIcons(ImageIcon editorIcon, ImageIcon selectedIcon) {
        this.editorIcon = editorIcon;
        this.selectedIcon = selectedIcon;
        if (editorIcon != null) {
            this.editor = new IconComboBoxEditor(this, editorIcon);
            this.setEditor(this.editor);
            this.repaint();
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.resizeComboPopup();
    }

    class IconComboBoxRenderer
    extends JPanel
    implements ListCellRenderer {
        JTextField jtf;
        JComboBox jcb;

        public IconComboBoxRenderer(JComboBox jcb) {
            this.jcb = jcb;
            jcb.setPreferredSize(new Dimension(100, 20));
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            this.jtf = new JTextField();
            c.gridx = 1;
            c.gridy = 0;
            this.add((Component)this.jtf, c);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            System.out.println("value: " + value);
            this.jtf.setPreferredSize(new Dimension(100, 20));
            this.jtf.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.jtf.setText(String.valueOf(value));
            return this;
        }
    }

    class IconComboBoxEditor
    extends JPanel
    implements ComboBoxEditor {
        ImageIcon editorIcon;
        JComboBox cb;
        JPanel editor = new JPanel();
        JLabel ebutton = new JLabel();

        public IconComboBoxEditor(JComboBox cb, ImageIcon editorIcon) {
            this.editorIcon = editorIcon;
            this.cb = cb;
            int iconWidth = 0;
            int iconHeight = 0;
            this.editor.setLayout(null);
            Color outside = new Color(123, 137, 156);
            Color inside = new Color(189, 206, 230);
            this.editor.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 0, outside), BorderFactory.createLineBorder(inside, 1)));
            this.ebutton.setIcon(editorIcon);
            if (editorIcon != null) {
                iconWidth = editorIcon.getIconWidth();
                iconHeight = editorIcon.getIconHeight();
            }
            if (cb != null) {
                int width = cb.getWidth();
                int height = cb.getHeight();
                this.ebutton.setBounds(0, 0, width - 19, height);
            } else {
                this.ebutton.setBounds(1, 1, iconWidth + 2, iconHeight + 2);
            }
            this.editor.add((Component)this.ebutton, null);
        }

        @Override
        public void setItem(Object newValue) {
        }

        @Override
        public Object getItem() {
            return this;
        }

        @Override
        public Component getEditorComponent() {
            return this.editor;
        }

        @Override
        public void selectAll() {
        }

        @Override
        public void addActionListener(ActionListener al) {
            this.listenerList.add(ActionListener.class, al);
        }

        @Override
        public void removeActionListener(ActionListener al) {
            this.listenerList.remove(ActionListener.class, al);
        }
    }
}

