/*
 * Decompiled with CFR 0.152.
 */
package privatecomponents;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class MultipleAxisChart
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected boolean refreshBit = false;
    int dx = 200;
    int dy = 200;
    int mx = 10;
    int myt = 10;
    int myb = 10;
    int lfmx = 0;
    int rfmx = 0;
    final int CRH = 3;
    Dimension dim;
    Rectangle rect;
    transient BufferedImage buffImg = null;
    transient Graphics2D gbi;
    transient BufferedImage buffImgHM;
    transient Graphics2D gbiHM;
    transient BufferedImage buffImgTxt;
    transient Graphics2D gbiTxt;
    transient BufferedImage buffImgSec;
    transient Graphics2D gbiSec;
    transient BufferedImage buffImgDots;
    transient Graphics2D gbiDots;
    Color background = Color.white;
    Color foreground = Color.black;
    Color[] colors;
    int[] types;
    int fontSize = 11;
    Font font = new Font("Dialog", 0, this.fontSize);
    boolean b_font = false;
    int[] floor = new int[]{0, 0};
    int[] div = new int[]{10, 20};
    int[] divf = new int[]{5, 5};
    int dimg = 1;
    double floorForDots = 0.0;
    Map<Date, Double[]> values;
    transient ArrayList<Map<Date, Double>> al_values;
    Calendar cals;
    Calendar cale;
    SimpleDateFormat sdf_yMd = new SimpleDateFormat("yyyy-MM-dd");
    SimpleDateFormat sdf_hm = new SimpleDateFormat("HH:mm");
    String[] units;
    String lunit;
    String runit;
    int hourshift = 0;
    String title;
    boolean b_paint = true;
    boolean b_minmax = true;
    boolean b_dispose = false;
    public static final int TYPE_LINE = 1;
    public static final int TYPE_DASHED = 2;
    public static final int TYPE_HISTO = 3;
    public static final int TYPE_DOTED = 4;
    public static final int LEFT = 5;
    public static final int RIGHT = 6;
    int flags = 0;

    public MultipleAxisChart() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            System.out.println("MultipleAxisChart: " + ex);
        }
    }

    public MultipleAxisChart(int[] floor, int[] div, int[] nbr) {
        this.floor = floor;
        this.div = div;
        this.divf = nbr;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            System.out.println("MultipleAxisChart: " + ex);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(null);
        this.setOpaque(true);
        this.setBounds(new Rectangle(0, 0, this.dx, this.dy));
        this.cale = Calendar.getInstance();
        this.cals = (Calendar)this.cale.clone();
        this.cals.add(5, -2);
        this.addMouseListener(new Tacho_MouseAdapter(this));
    }

    @Override
    public void paintComponent(Graphics g) {
        System.out.println("MultipleAxisChart.paintComponent");
    }

    private void drawComponent() {
        this.buffImg = new BufferedImage(this.dx, this.dy, 2);
        this.gbi = this.buffImg.createGraphics();
        this.gbi.setColor(new Color(1.0f, 1.0f, 1.0f, 0.0f));
        this.gbi.fillRect(0, 0, this.dx, this.dy);
        this.buffImgHM = new BufferedImage(this.dx, this.dy, 2);
        this.buffImgTxt = new BufferedImage(this.dx, this.dy, 2);
        this.buffImgSec = new BufferedImage(this.dx, this.dy, 2);
        this.buffImgDots = new BufferedImage(this.dx, this.dy, 2);
        this.gbiHM = this.buffImgHM.createGraphics();
        this.gbiTxt = this.buffImgTxt.createGraphics();
        this.gbiSec = this.buffImgSec.createGraphics();
        this.gbiDots = this.buffImgDots.createGraphics();
    }

    public void setBackgroundColor(Color background) {
        this.background = background;
        this.drawChart();
    }

    public void setForegroundColor(Color foreground) {
        this.foreground = foreground;
        this.drawChart();
    }

    public void setFloorForDots(double floor) {
        this.floorForDots = floor;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
        if ((flags & 2) == 2) {
            this.foreground = Color.white;
            this.background = Color.black;
        }
        this.repaint();
    }

    public void setFixedXMarge(int px, int location) {
        if (location == 5) {
            this.lfmx = px;
        } else if (location == 6) {
            this.rfmx = px;
        }
    }

    protected void setPaintFlag(boolean b_paint) {
        this.b_paint = b_paint;
    }

    protected void drawChart() {
        int ii;
        if (!this.b_paint) {
            return;
        }
        if (!this.b_font) {
            this.fontSize = (int)(Math.sqrt(this.dy) / 1.2);
            if (this.fontSize < 7) {
                this.fontSize = 7;
            } else if (this.fontSize > 12) {
                this.fontSize = 12;
            }
            this.font = new Font("Dialog", 0, this.fontSize);
            this.b_font = true;
        }
        if (this.units != null || this.title != null) {
            this.myt = this.fontSize + 5;
        }
        this.myb = 2 * this.fontSize + 6;
        this.gbiTxt.setColor(this.foreground);
        this.gbiTxt.setFont(this.font);
        this.gbiTxt.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        FontMetrics fm = this.getFontMetrics(this.font);
        int mxl = 0;
        if (this.lfmx > 0) {
            mxl = this.lfmx;
        } else {
            for (int ii2 = 0; ii2 <= this.divf[0]; ++ii2) {
                if (mxl >= fm.stringWidth(String.valueOf(this.floor[0] + ii2 * this.div[0]))) continue;
                mxl = fm.stringWidth(String.valueOf(this.floor[0] + ii2 * this.div[0]));
            }
        }
        int mxr = 0;
        if (this.rfmx > 0) {
            mxr = this.rfmx;
        } else {
            int nn = this.divf.length - 1;
            for (int ii3 = 0; ii3 <= this.divf[nn]; ++ii3) {
                if (mxr >= fm.stringWidth(String.valueOf(this.floor[nn] + ii3 * this.div[nn]))) continue;
                mxr = fm.stringWidth(String.valueOf(this.floor[nn] + ii3 * this.div[nn]));
            }
            mxr += 10;
        }
        this.gbi.setColor(this.background);
        this.gbi.fillRect(0, 0, this.dx, this.dy);
        Rectangle2D.Double rect2D = new Rectangle2D.Double(this.mx + mxl, this.myt, this.dx - this.mx - mxl - mxr, this.dy - this.myt - this.myb);
        this.gbiHM.setColor(this.foreground);
        this.gbiHM.draw(rect2D);
        float[] dash = new float[]{1.0f};
        float[] dash2 = new float[]{2.0f};
        BasicStroke DASHED2 = new BasicStroke(1.0f, 0, 0, 1.0f, dash, 0.0f);
        BasicStroke DASHED = new BasicStroke(1.0f, 0, 0, 1.0f, dash2, 0.0f);
        BasicStroke LINE = new BasicStroke(0.5f);
        this.gbiHM.setStroke(DASHED);
        int dyy = this.dy - this.myt - this.myb;
        double divy = (double)dyy / (double)this.divf[0];
        double echsecy = 10.0;
        if (divy < 20.0) {
            echsecy = 5.0;
        }
        int sw = 0;
        for (ii = 0; ii <= this.divf[0]; ++ii) {
            if (ii < this.divf[0] && ii > 0) {
                Line2D.Double lineh = new Line2D.Double(this.mx + mxl, (double)this.myt + (double)ii * divy, this.dx - mxr, (double)this.myt + (double)ii * divy);
                this.gbiHM.draw(lineh);
            }
            String tmp = String.valueOf(this.floor[0] + this.div[0] * ii);
            sw = fm.stringWidth(tmp);
            if (this.colors != null) {
                if (this.colors.length > 0) {
                    this.gbiTxt.setColor(this.colors[0]);
                } else {
                    this.gbiTxt.setColor(this.foreground);
                }
            }
            this.gbiTxt.drawString(tmp, this.mx + mxl - sw - 6, this.myt + (int)((double)this.divf[0] * divy) - (int)((double)ii * divy) + this.fontSize / 2);
            if (this.floor.length <= 1) continue;
            if (this.floor.length == 2) {
                tmp = String.valueOf(this.floor[1] + this.div[1] * ii);
            } else if (this.floor.length == 3) {
                tmp = String.valueOf(this.floor[2] + this.div[2] * ii);
            }
            sw = fm.stringWidth(tmp);
            if (this.colors != null) {
                if (this.colors.length == 2) {
                    this.gbiTxt.setColor(this.colors[1]);
                } else if (this.colors.length == 3) {
                    this.gbiTxt.setColor(this.colors[2]);
                } else {
                    this.gbiTxt.setColor(this.foreground);
                }
            }
            this.gbiTxt.drawString(tmp, this.dx - sw - 4, this.myt + (int)((double)this.divf[1] * divy) - (int)((double)ii * divy) + this.fontSize / 2);
        }
        if (this.title != null) {
            sw = fm.stringWidth(this.title);
            int lsw = 0;
            int rsw = 0;
            if (this.units.length == 3) {
                lsw = fm.stringWidth(this.units[0] + "/" + this.units[1]);
                if (this.lunit != null) {
                    lsw += fm.stringWidth(" " + this.lunit);
                }
                rsw = fm.stringWidth(this.units[2]);
            }
            this.gbiTxt.setColor(this.foreground);
            this.gbiTxt.drawString(this.title, lsw + (this.dx - lsw - rsw) / 2 - sw / 2, this.fontSize);
        }
        if (this.units != null) {
            if (this.units.length == 1) {
                if (this.colors != null) {
                    if (this.colors.length > 0) {
                        this.gbiTxt.setColor(this.colors[0]);
                    } else {
                        this.gbiTxt.setColor(this.foreground);
                    }
                }
                if (this.mx + mxl - (sw = fm.stringWidth(this.units[0])) - 6 < 2) {
                    this.gbiTxt.drawString(this.units[0], 2, this.fontSize);
                } else {
                    this.gbiTxt.drawString(this.units[0], this.mx + mxl - sw - 6, this.fontSize);
                }
            } else if (this.units.length == 2) {
                if (this.colors != null) {
                    if (this.colors.length > 0) {
                        this.gbiTxt.setColor(this.colors[0]);
                    } else {
                        this.gbiTxt.setColor(this.foreground);
                    }
                }
                if (this.mx + mxl - (sw = fm.stringWidth(this.units[0])) - 6 < 2) {
                    this.gbiTxt.drawString(this.units[0], 2, this.fontSize);
                } else {
                    this.gbiTxt.drawString(this.units[0], this.mx + mxl - sw - 6, this.fontSize);
                }
                if (this.colors != null) {
                    if (this.colors.length > 1) {
                        this.gbiTxt.setColor(this.colors[1]);
                    } else {
                        this.gbiTxt.setColor(this.foreground);
                    }
                }
                sw = fm.stringWidth(this.units[1]);
                this.gbiTxt.drawString(this.units[1], this.dx - sw - 2, this.fontSize);
            } else if (this.units.length == 3) {
                if (this.colors != null) {
                    if (this.colors.length > 0) {
                        this.gbiTxt.setColor(this.colors[0]);
                    } else {
                        this.gbiTxt.setColor(this.foreground);
                    }
                }
                this.gbiTxt.drawString(this.units[0], 2, this.fontSize);
                sw = fm.stringWidth(this.units[0]);
                this.gbiTxt.setColor(this.foreground);
                this.gbiTxt.drawString("/", 2 + sw, this.fontSize);
                if (this.colors != null) {
                    if (this.colors.length > 1) {
                        this.gbiTxt.setColor(this.colors[1]);
                    } else {
                        this.gbiTxt.setColor(this.foreground);
                    }
                }
                sw = fm.stringWidth(this.units[0] + "/");
                this.gbiTxt.drawString(this.units[1], 2 + sw, this.fontSize);
                if (this.lunit != null) {
                    sw = fm.stringWidth(this.units[0] + "/" + this.units[1] + " ");
                    this.gbiTxt.setColor(this.foreground);
                    this.gbiTxt.drawString(this.lunit, 2 + sw, this.fontSize);
                }
                if (this.colors != null) {
                    if (this.colors.length > 2) {
                        this.gbiTxt.setColor(this.colors[2]);
                    } else {
                        this.gbiTxt.setColor(this.foreground);
                    }
                }
                sw = fm.stringWidth(this.units[2]);
                this.gbiTxt.drawString(this.units[2], this.dx - sw - 2, this.fontSize);
            }
        }
        this.gbiHM.setStroke(LINE);
        ii = 0;
        while ((double)ii <= (double)this.divf[0] * echsecy) {
            int lw = 2;
            if ((double)ii % echsecy == 0.0) {
                lw = 4;
            } else if ((double)ii % echsecy == 5.0) {
                lw = 3;
            }
            Line2D.Double sech1 = new Line2D.Double(this.mx + mxl - lw, (double)this.myt + (double)ii * divy / echsecy, this.mx + mxl, (double)this.myt + (double)ii * divy / echsecy);
            Line2D.Double sech2 = new Line2D.Double(this.dx - mxr, (double)this.myt + (double)ii * divy / echsecy, this.dx - mxr + lw, (double)this.myt + (double)ii * divy / echsecy);
            this.gbiHM.draw(sech1);
            this.gbiHM.draw(sech2);
            ++ii;
        }
        this.gbiTxt.setColor(this.foreground);
        String tmp = this.sdf_yMd.format(this.getCorrectedTime(this.cals));
        sw = fm.stringWidth(tmp);
        int hour = this.cals.get(11);
        int min = this.cals.get(12);
        double prev_sw = 0.0;
        if (hour == 0 && min == 0) {
            if (this.mx + mxl - sw / 2 < 2) {
                this.gbiTxt.drawString(tmp, 2, this.dy - this.myb + this.fontSize + 3);
                prev_sw = 2 + sw / 2;
            } else {
                this.gbiTxt.drawString(tmp, this.mx + mxl - sw / 2, this.dy - this.myb + this.fontSize + 3);
                prev_sw = this.mx + mxl + sw / 2;
            }
        }
        if ((this.flags & 4) != 4) {
            tmp = this.sdf_hm.format(this.getCorrectedTime(this.cals));
            sw = fm.stringWidth(tmp);
            this.gbiTxt.drawString(tmp, this.mx + mxl - sw / 2, this.dy - this.myb + 2 * this.fontSize + 4);
        }
        tmp = this.sdf_yMd.format(this.getCorrectedTime(this.cale));
        sw = fm.stringWidth(tmp);
        hour = this.cale.get(11);
        min = this.cale.get(12);
        if (hour == 0 && min == 0) {
            if (this.dx - mxr + sw / 2 > this.dx) {
                this.gbiTxt.drawString(tmp, this.dx - 2 - sw, this.dy - this.myb + this.fontSize + 3);
            } else {
                this.gbiTxt.drawString(tmp, this.dx - mxr - sw / 2, this.dy - this.myb + this.fontSize + 3);
            }
        }
        if ((this.flags & 4) != 4) {
            tmp = this.sdf_hm.format(this.getCorrectedTime(this.cale));
            sw = fm.stringWidth(tmp);
            this.gbiTxt.drawString(tmp, this.dx - mxr - sw / 2, this.dy - this.myb + 2 * this.fontSize + 4);
        }
        long st = this.cals.getTimeInMillis() / 1000L;
        long et = this.cale.getTimeInMillis() / 1000L;
        long diff = et - st;
        double dtx = (double)(this.dx - this.mx - mxl - mxr) / (double)diff;
        double[] dty = new double[this.div.length];
        for (int ii4 = 0; ii4 < dty.length; ++ii4) {
            dty[ii4] = (double)dyy / (double)(this.div[ii4] * this.divf[ii4]);
        }
        GeneralPath[] gp = null;
        if (this.values != null) {
            gp = new GeneralPath[this.dimg];
            for (int ii5 = 0; ii5 < gp.length; ++ii5) {
                gp[ii5] = new GeneralPath(0, this.values.size());
            }
        }
        double prev_px = this.mx + mxl;
        for (double ii6 = 0.0; ii6 < (double)diff; ii6 += 1.0) {
            int jj;
            Double[] vals;
            long test = st + (long)ii6;
            Calendar cal_test = Calendar.getInstance();
            Calendar cal_testSec = Calendar.getInstance();
            cal_test.setTimeInMillis(test * 1000L);
            cal_testSec.setTime(this.getCorrectedTime(cal_test));
            hour = cal_testSec.get(11);
            min = cal_testSec.get(12);
            if (hour % 6 == 0 && min == 0 && test % 100L == 0L) {
                if (hour % 24 == 0) {
                    if ((this.flags & 4) == 4) {
                        this.gbiHM.setStroke(DASHED);
                    } else {
                        this.gbiHM.setStroke(LINE);
                    }
                } else {
                    this.gbiHM.setStroke(DASHED);
                }
                Line2D.Double linev = new Line2D.Double((double)(this.mx + mxl) + dtx * ii6, this.myt, (double)(this.mx + mxl) + dtx * ii6, this.dy - this.myb);
                if ((this.flags & 4) == 4) {
                    if (hour % 24 == 0) {
                        this.gbiHM.draw(linev);
                    }
                } else {
                    this.gbiHM.draw(linev);
                }
                tmp = this.sdf_hm.format(cal_testSec.getTime());
                sw = fm.stringWidth(tmp);
                double px = (double)(this.mx + mxl) + dtx * ii6 - (double)(sw / 2) - prev_px;
                double px_max = (double)(this.mx + mxl) + dtx * (double)diff - (double)(sw / 2) - prev_px;
                if ((this.flags & 8) != 8 && px > (double)(sw / 2) && px_max - px > (double)sw) {
                    this.gbiTxt.drawString(tmp, this.mx + mxl + (int)(dtx * ii6) - sw / 2, this.dy - this.myb + 2 * this.fontSize + 4);
                }
                if (ii6 > 0.0) {
                    Line2D.Double linev2;
                    if ((this.flags & 4) != 4) {
                        this.gbiHM.setStroke(LINE);
                        linev2 = new Line2D.Double((double)(this.mx + mxl) + dtx * ii6 + 0.2, this.dy - this.myb, (double)(this.mx + mxl) + dtx * ii6 + 0.2, this.dy - this.myb + 3);
                        this.gbiHM.draw(linev2);
                    } else if (hour % 24 == 0) {
                        this.gbiHM.setStroke(LINE);
                        linev2 = new Line2D.Double((double)(this.mx + mxl) + dtx * ii6 + 0.2, this.dy - this.myb, (double)(this.mx + mxl) + dtx * ii6 + 0.2, this.dy - this.myb + 3);
                        this.gbiHM.draw(linev2);
                    }
                }
                prev_px = (double)(this.mx + mxl) + dtx * ii6;
            }
            if (min == 0 && test % 100L == 0L && ii6 > 0.0 && (this.flags & 4) != 4) {
                this.gbiHM.setStroke(LINE);
                Line2D.Double linev2 = new Line2D.Double((double)(this.mx + mxl) + dtx * ii6 + 0.2, this.dy - this.myb, (double)(this.mx + mxl) + dtx * ii6 + 0.2, this.dy - this.myb + 1);
                this.gbiHM.draw(linev2);
            }
            if (hour == 0 && min == 0 && test % 100L == 0L && ii6 > 0.0) {
                tmp = this.sdf_yMd.format(cal_testSec.getTime());
                sw = fm.stringWidth(tmp);
                if ((double)(this.mx + mxl + (int)(dtx * ii6)) > prev_sw) {
                    this.gbiTxt.drawString(tmp, this.mx + mxl + (int)(dtx * ii6) - sw / 2, this.dy - this.myb + this.fontSize + 3);
                    prev_sw = this.mx + mxl + (int)(dtx * ii6) + (sw + fm.stringWidth("0"));
                }
            }
            if (this.values == null || (vals = this.values.get(cal_test.getTime())) == null) continue;
            for (jj = 0; jj < vals.length; ++jj) {
                boolean b_histo = false;
                boolean b_dots = false;
                if (this.types != null && this.types.length > jj) {
                    if (this.types[jj] == 3) {
                        b_histo = true;
                    } else if (this.types[jj] == 4) {
                        b_dots = true;
                    }
                }
                if (b_histo) {
                    boolean b_null = false;
                    if (vals[jj] == null) {
                        b_null = true;
                    } else if (vals[jj] <= 0.0) {
                        b_null = true;
                    }
                    if (b_null) continue;
                    Line2D.Double linev = new Line2D.Double((double)(this.mx + mxl) + dtx * ii6, this.dy - this.myb, (double)(this.mx + mxl) + dtx * ii6, (double)(this.dy - this.myb) - dty[jj] * (vals[jj] - (double)this.floor[jj]));
                    if (this.colors.length > jj) {
                        this.gbiSec.setColor(this.colors[jj]);
                    }
                    this.gbiSec.draw(linev);
                    continue;
                }
                if (b_dots) {
                    Point2D.Double pt = null;
                    boolean b_null = false;
                    if (this.colors.length > jj) {
                        this.gbiDots.setColor(this.colors[jj]);
                    }
                    if (ii6 == 0.0) {
                        if (vals[jj] == null) {
                            b_null = true;
                        } else if (vals[jj] - (double)this.floor[jj] < this.floorForDots) {
                            b_null = true;
                        }
                        pt = b_null ? new Point2D.Double(this.mx + mxl, this.dy - this.myb) : new Point2D.Double(this.mx + mxl, (double)(this.dy - this.myb) - dty[jj] * (vals[jj] - (double)this.floor[jj]));
                    } else {
                        if (vals[jj] == null) {
                            b_null = true;
                        } else if (vals[jj] - (double)this.floor[jj] < this.floorForDots) {
                            b_null = true;
                        }
                        pt = b_null ? new Point2D.Double((double)(this.mx + mxl) + dtx * ii6, this.dy - this.myb) : new Point2D.Double((double)(this.mx + mxl) + dtx * ii6, (double)(this.dy - this.myb) - dty[jj] * (vals[jj] - (double)this.floor[jj]));
                    }
                    if (b_null) continue;
                    this.gbiDots.drawOval((int)((Point2D)pt).getX(), (int)((Point2D)pt).getY(), 2, 1);
                    this.gbiDots.drawOval((int)((Point2D)pt).getX(), (int)((Point2D)pt).getY(), 1, 2);
                    continue;
                }
                if (ii6 == 0.0) {
                    boolean b_null = false;
                    if (vals[jj] == null) {
                        b_null = true;
                    } else if (vals[jj] - (double)this.floor[jj] < 0.0) {
                        b_null = true;
                    }
                    if (b_null) {
                        if ((this.flags & 8) == 8) continue;
                        gp[jj].moveTo(this.mx + mxl, this.dy - this.myb);
                        continue;
                    }
                    gp[jj].moveTo((double)(this.mx + mxl), (double)(this.dy - this.myb) - dty[jj] * (vals[jj] - (double)this.floor[jj]));
                    continue;
                }
                boolean b_null = false;
                if (vals[jj] == null) {
                    b_null = true;
                } else if (vals[jj] - (double)this.floor[jj] < 0.0) {
                    b_null = true;
                }
                if (b_null) {
                    if ((this.flags & 8) == 8) continue;
                    if (gp[jj].getCurrentPoint() == null) {
                        gp[jj].moveTo((double)(this.mx + mxl) + dtx * ii6, (double)(this.dy - this.myb));
                        continue;
                    }
                    gp[jj].lineTo((double)(this.mx + mxl) + dtx * ii6, (double)(this.dy - this.myb));
                    continue;
                }
                if (gp[jj].getCurrentPoint() == null) {
                    gp[jj].moveTo((double)(this.mx + mxl) + dtx * ii6, (double)(this.dy - this.myb) - dty[jj] * (vals[jj] - (double)this.floor[jj]));
                    continue;
                }
                gp[jj].lineTo((double)(this.mx + mxl) + dtx * ii6, (double)(this.dy - this.myb) - dty[jj] * (vals[jj] - (double)this.floor[jj]));
            }
            for (jj = 0; jj < vals.length; ++jj) {
                boolean b_dots = false;
                if (this.types == null || this.types.length <= jj || this.types[jj] != 4) continue;
                b_dots = true;
            }
        }
        this.gbiHM.setStroke(LINE);
        Line2D.Double linev2 = new Line2D.Double((double)(this.mx + mxl) + 0.2, this.dy - this.myb, (double)(this.mx + mxl) + 0.2, this.dy - this.myb + 3);
        this.gbiHM.draw(linev2);
        linev2 = new Line2D.Double((double)(this.mx + mxl) + dtx * (double)diff + 0.2, this.dy - this.myb, (double)(this.mx + mxl) + dtx * (double)diff + 0.2, this.dy - this.myb + 3);
        this.gbiHM.draw(linev2);
        this.gbiSec.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        if (gp != null) {
            for (int ii7 = gp.length - 1; ii7 >= 0; --ii7) {
                if (this.colors.length > ii7) {
                    this.gbiSec.setColor(this.colors[ii7]);
                } else {
                    this.gbiSec.setColor(this.colors[this.colors.length - 1]);
                }
                int i_line = 1;
                if (this.types != null && this.types.length > ii7) {
                    i_line = this.types[ii7];
                }
                if (i_line == 1) {
                    this.gbiSec.setStroke(LINE);
                    this.gbiSec.draw(gp[ii7]);
                    continue;
                }
                if (i_line != 2) continue;
                this.gbiSec.setStroke(DASHED2);
                this.gbiSec.draw(gp[ii7]);
            }
        }
        this.gbi.drawImage(this.buffImgHM, null, null);
        this.gbi.drawImage(this.buffImgSec, null, null);
        this.gbi.drawImage(this.buffImgDots, null, null);
        this.gbi.drawImage(this.buffImgTxt, null, null);
        this.b_paint = false;
    }

    public void drawAdditionalChart(int index, int type, int lr, Color color) {
        if (this.al_values == null) {
            return;
        }
        Map<Date, Double> map = this.al_values.get(index);
        if (!this.b_font) {
            this.fontSize = (int)(Math.sqrt(this.dy) / 1.2);
            if (this.fontSize < 7) {
                this.fontSize = 7;
            } else if (this.fontSize > 12) {
                this.fontSize = 12;
            }
            this.font = new Font("Dialog", 0, this.fontSize);
            this.b_font = true;
        }
        FontMetrics fm = this.getFontMetrics(this.font);
        if (this.units != null || this.title != null) {
            this.myt = this.fontSize + 5;
        }
        this.myb = 2 * this.fontSize + 6;
        int lry = 0;
        if (this.floor.length > 1) {
            lry = lr - 5;
        }
        int mxl = 0;
        if (this.lfmx > 0) {
            mxl = this.lfmx;
        } else {
            for (int ii = 0; ii <= this.divf[0]; ++ii) {
                if (mxl >= fm.stringWidth(String.valueOf(this.floor[0] + ii * this.div[0]))) continue;
                mxl = fm.stringWidth(String.valueOf(this.floor[0] + ii * this.div[0]));
            }
        }
        int mxr = 0;
        if (this.rfmx > 0) {
            mxr = this.rfmx;
        } else {
            int nn = this.divf.length - 1;
            for (int ii = 0; ii <= this.divf[nn]; ++ii) {
                if (mxr >= fm.stringWidth(String.valueOf(this.floor[nn] + ii * this.div[nn]))) continue;
                mxr = fm.stringWidth(String.valueOf(this.floor[nn] + ii * this.div[nn]));
            }
            mxr += 10;
        }
        float[] dash = new float[]{1.0f};
        BasicStroke DASHED2 = new BasicStroke(1.0f, 0, 0, 1.0f, dash, 0.0f);
        BasicStroke LINE = new BasicStroke(0.5f);
        int dyy = this.dy - this.myt - this.myb;
        double divy = (double)dyy / (double)this.divf[0];
        long st = this.cals.getTimeInMillis() / 1000L;
        long et = this.cale.getTimeInMillis() / 1000L;
        long diff = et - st;
        double dtx = (double)(this.dx - this.mx - mxl - mxr) / (double)diff;
        double[] dty = new double[this.div.length];
        for (int ii = 0; ii < dty.length; ++ii) {
            dty[ii] = (double)dyy / (double)(this.div[ii] * this.divf[ii]);
        }
        GeneralPath gp = new GeneralPath(0, this.values.size());
        for (double ii = 0.0; ii < (double)diff; ii += 1.0) {
            Double vals;
            long test = st + (long)ii;
            Calendar cal_test = Calendar.getInstance();
            Calendar cal_testSec = Calendar.getInstance();
            cal_test.setTimeInMillis(test * 1000L);
            cal_testSec.setTime(this.getCorrectedTime(cal_test));
            if (!this.b_paint) {
                return;
            }
            if (map == null || (vals = map.get(cal_test.getTime())) == null) continue;
            boolean b_histo = false;
            boolean b_dots = false;
            if (type == 3) {
                b_histo = true;
            } else if (type == 4) {
                b_dots = true;
            }
            if (b_histo) {
                if (!(vals > 0.0)) continue;
                Line2D.Double linev = new Line2D.Double((double)(this.mx + mxl) + dtx * ii, this.dy - this.myb, (double)(this.mx + mxl) + dtx * ii, (double)(this.dy - this.myb) - dty[lry] * (vals - (double)this.floor[lry]));
                this.gbiSec.setColor(color);
                this.gbiSec.draw(linev);
                continue;
            }
            if (b_dots) {
                Point2D.Double pt = null;
                this.gbiDots.setColor(color);
                if (ii == 0.0) {
                    if (vals - (double)this.floor[lry] < 0.0) {
                        pt = new Point2D.Double(this.mx + mxl, this.dy - this.myb);
                        continue;
                    }
                    pt = new Point2D.Double(this.mx + mxl, (double)(this.dy - this.myb) - dty[lry] * (vals - (double)this.floor[lry]));
                    continue;
                }
                pt = vals - (double)this.floor[lry] < 0.0 ? new Point2D.Double((double)(this.mx + mxl) + dtx * ii, this.dy - this.myb) : new Point2D.Double((double)(this.mx + mxl) + dtx * ii, (double)(this.dy - this.myb) - dty[lry] * (vals - (double)this.floor[lry]));
                this.gbiDots.drawOval((int)((Point2D)pt).getX(), (int)((Point2D)pt).getY(), 2, 1);
                this.gbiDots.drawOval((int)((Point2D)pt).getX(), (int)((Point2D)pt).getY(), 1, 2);
                continue;
            }
            if (ii == 0.0) {
                if (vals - (double)this.floor[lry] < 0.0) {
                    if ((this.flags & 8) == 8) continue;
                    gp.moveTo(this.mx + mxl, this.dy - this.myb);
                    continue;
                }
                gp.moveTo((double)(this.mx + mxl), (double)(this.dy - this.myb) - dty[lry] * (vals - (double)this.floor[lry]));
                continue;
            }
            if (vals - (double)this.floor[lry] < 0.0) {
                if ((this.flags & 8) == 8) continue;
                if (gp.getCurrentPoint() == null) {
                    gp.moveTo((double)(this.mx + mxl) + dtx * ii, (double)(this.dy - this.myb));
                    continue;
                }
                gp.lineTo((double)(this.mx + mxl) + dtx * ii, (double)(this.dy - this.myb));
                continue;
            }
            if (gp.getCurrentPoint() == null) {
                gp.moveTo((double)(this.mx + mxl) + dtx * ii, (double)(this.dy - this.myb) - dty[lry] * (vals - (double)this.floor[lry]));
                continue;
            }
            gp.lineTo((double)(this.mx + mxl) + dtx * ii, (double)(this.dy - this.myb) - dty[lry] * (vals - (double)this.floor[lry]));
        }
        this.gbiSec.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        if (gp != null) {
            this.gbiSec.setColor(color);
            if (type == 1) {
                this.gbiSec.setStroke(LINE);
                this.gbiSec.draw(gp);
            } else if (type == 2) {
                this.gbiSec.setStroke(DASHED2);
                this.gbiSec.draw(gp);
            }
        }
        this.gbi.drawImage(this.buffImgSec, null, null);
        this.gbi.drawImage(this.buffImgDots, null, null);
        this.b_paint = true;
    }

    @Override
    public void paint(Graphics graphics) {
        this.drawChart();
        boolean b_point = false;
        if (this.rect != null && (this.rect.x > 0 || this.rect.y > 0)) {
            b_point = true;
        }
        if (this.getParent() instanceof JPanel) {
            b_point = false;
        }
        if (b_point) {
            graphics.drawImage(this.buffImg, this.rect.x, this.rect.y, null, null);
        } else {
            ((Graphics2D)graphics).drawImage(this.buffImg, null, null);
        }
    }

    public void paint(Graphics graphics, Point point) {
        this.drawChart();
        graphics.drawImage(this.buffImg, point.x, point.y, null, null);
    }

    public BufferedImage getBufferedImage() {
        return this.buffImg;
    }

    public Graphics2D getGraphics2D() {
        return this.gbi;
    }

    private Date getCorrectedTime(Calendar calendar) {
        Calendar cal = (Calendar)calendar.clone();
        cal.add(11, this.hourshift);
        return cal.getTime();
    }

    public void destroy() {
        this.b_dispose = true;
    }

    public boolean saveAsPng(String fullPath) {
        boolean b_res = false;
        try {
            File output = new File(fullPath);
            FileOutputStream fos = new FileOutputStream(output);
            ImageIO.write((RenderedImage)this.buffImg, "png", fos);
            b_res = true;
        }
        catch (IOException ioex) {
            System.out.println("MultipleAcisChart IOException: " + ioex.getMessage());
        }
        return b_res;
    }

    @Override
    public void setBounds(Rectangle rect) {
        this.rect = rect;
        this.dx = rect.width;
        this.dy = rect.height;
        this.setSize(this.dx, this.dy);
        this.setLocation(rect.x, rect.y);
        this.drawComponent();
    }

    public void setChartColors(Color[] colors) {
        this.colors = colors;
    }

    public void setChartTypes(int[] types) {
        this.types = types;
    }

    public void setXAxis(Date startingDate, Date endingDate) {
        this.cals = Calendar.getInstance();
        this.cals.setTime(startingDate);
        this.cale = Calendar.getInstance();
        this.cale.setTime(endingDate);
        this.updateUI();
    }

    public void setValues(ArrayList<Object[]> values) {
        this.setValues(values, 2);
    }

    public void setValues(ArrayList<Object[]> values, int days) {
        if (values == null) {
            return;
        }
        this.values = new HashMap<Date, Double[]>(values.size());
        for (Object[] objects : values) {
            Date date = (Date)objects[0];
            Date newdate = new Date(date.getTime() / 1000L * 1000L);
            int dim = objects.length - 1;
            if (this.dimg < dim) {
                this.dimg = dim;
            }
            Double[] vals = new Double[dim];
            for (int ii = 0; ii < dim; ++ii) {
                vals[ii] = (Double)objects[ii + 1];
            }
            this.values.put(newdate, vals);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime((Date)values.get(0)[0]);
        if (days < 1) {
            calendar.add(5, 1);
        } else {
            calendar.add(5, days);
        }
        this.setXAxis((Date)values.get(0)[0], calendar.getTime());
        this.updateUI();
    }

    public void setAdditionalValues(int index, ArrayList<Object[]> values) {
        if (values == null) {
            return;
        }
        if (this.al_values == null) {
            this.al_values = new ArrayList(2);
        }
        HashMap<Date, Double> add_values = new HashMap<Date, Double>(values.size());
        for (Object[] objects : values) {
            Date date = (Date)objects[0];
            Date newdate = new Date(date.getTime() / 1000L * 1000L);
            add_values.put(newdate, (Double)objects[1]);
        }
        this.al_values.add(index, add_values);
    }

    public void setTimeshift(int hour) {
        this.hourshift = hour;
        this.updateUI();
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setUnits(String[] units) {
        this.units = units;
    }

    public void setAdditionalUnit(int location, String unit) {
        if (location == 5) {
            this.lunit = unit;
        } else if (location == 6) {
            this.runit = unit;
        }
    }

    private void mouseMoved(MouseEvent me) {
    }

    private void mouseReleased(MouseEvent me) {
    }

    class Tacho_MouseAdapter
    extends MouseAdapter {
        MultipleAxisChart adaptee;

        public Tacho_MouseAdapter(MultipleAxisChart adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            this.adaptee.mouseReleased(me);
        }
    }

    class Tacho_MouseMotionAdapter
    extends MouseMotionAdapter {
        MultipleAxisChart adaptee;

        public Tacho_MouseMotionAdapter(MultipleAxisChart adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void mouseMoved(MouseEvent me) {
            this.adaptee.mouseMoved(me);
        }
    }
}

