/*
 * Decompiled with CFR 0.152.
 */
package privatecomponents;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class PrivateColorChooser
extends JPanel {
    static final int mxctrl = 20;
    Image img;
    Image img2;
    Color[][] color;
    Rectangle[][] rectangle;
    Color defColor = new Color(180, 180, 180);
    int grayCol = 0;
    int brightColors = 0;
    int floatingHL = 0;
    int linex = 24;
    int liney = 10;
    int rgbmin = 76;
    int rgbmax = 255;
    double minfactor = 0.0;
    int rgbdivisor = 4;
    int pausefactor = 8;
    int rr = 0;
    int gg = 0;
    int bb = 0;
    int dx;
    int dy;
    int mx = 1;
    int my = 1;
    int deltamy = 0;
    Point prevselpt = new Point(-1, -1);
    int prevselliney = -1;
    int prevsellinex = -1;
    Dimension dim = null;
    Rectangle rect = null;
    BufferedImage buffImg = null;
    Font FT_STAND = new Font("Dialog", 0, 11);
    Font FT_BOLD = new Font("Dialog", 1, 11);

    public PrivateColorChooser() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public PrivateColorChooser(int linex, int liney) {
        this.linex = linex;
        this.liney = liney;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public PrivateColorChooser(int linex, int liney, int grayCol) {
        this.linex = linex;
        this.liney = liney;
        this.grayCol = grayCol > 0 ? 1 : 0;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setBackground(SystemColor.control);
        this.setFont(this.FT_STAND);
        this.setLayout(null);
        this.setSize(new Dimension(146, 161));
        this.color = new Color[this.linex + 2][this.liney];
        this.rectangle = new Rectangle[this.linex + 2][this.liney];
        this.addMouseListener(new PrivateColorChooser_mouseAdapter(this));
        this.addMouseMotionListener(new PrivateColorChooser_mouseMotionAdapter(this));
    }

    @Override
    public void paintComponent(Graphics g) {
        int iy;
        int cter;
        int iy2;
        Graphics2D g2 = (Graphics2D)g.create();
        int dimx = this.rect.width - 20;
        int deltax = dimx / (this.linex - this.grayCol + 2);
        int deltay = this.rect.height / this.liney;
        this.deltamy = (this.rect.height - this.liney * deltay) / 2;
        if (this.linex < 1 || this.liney < 1) {
            System.out.println("Dimensions erronn\u00e9es.");
            return;
        }
        g2.setColor(this.getBackground());
        g2.fillRect(0, 0, this.dx, this.dy);
        for (iy2 = 0; iy2 < this.liney; ++iy2) {
            for (int ix = this.grayCol; ix < this.linex + 1; ++ix) {
                this.rectangle[ix][iy2] = new Rectangle((ix - this.grayCol) * deltax + this.mx + 1, iy2 * deltay + this.my + this.deltamy, deltax - 2, deltay - 1);
            }
        }
        for (iy2 = 0; iy2 < this.liney; ++iy2) {
            this.rectangle[this.linex + 1][iy2] = new Rectangle(this.rect.width - deltax + this.mx - 1, iy2 * deltay + this.my + this.deltamy, deltax - 1, deltay - 1);
        }
        g2.setColor(Color.black);
        for (cter = this.grayCol; cter < this.linex + 1; ++cter) {
            g2.drawLine(this.rectangle[cter][0].x + this.rectangle[cter][0].width + 1, this.my + this.deltamy, this.rectangle[cter][0].x + this.rectangle[cter][0].width + 1, this.rect.height - this.deltamy);
        }
        for (cter = 0; cter < this.liney; ++cter) {
            g2.drawLine(this.mx + 1, this.rectangle[1][cter].y + this.rectangle[1][cter].height, this.rectangle[this.linex][0].x + this.rectangle[this.linex][0].width, this.rectangle[1][cter].y + this.rectangle[1][cter].height);
            g2.drawLine(this.rectangle[this.linex + 1][0].x, this.rectangle[1][cter].y + this.rectangle[1][cter].height, this.rect.width - 1, this.rectangle[1][cter].y + this.rectangle[1][cter].height);
        }
        g2.drawLine(this.rect.width - 2 + this.mx, this.my + this.deltamy, this.rect.width - 2 + this.mx, this.rect.height - this.deltamy);
        g2.setColor(Color.white);
        for (cter = this.grayCol; cter < this.linex + 1; ++cter) {
            g2.drawLine(this.rectangle[cter][0].x, this.rectangle[cter][0].y, this.rectangle[cter][0].x, this.rect.height - this.deltamy);
        }
        for (cter = 0; cter < this.liney; ++cter) {
            g2.drawLine(this.mx + 1, this.rectangle[1][cter].y, this.rectangle[this.linex][0].x + this.rectangle[this.linex][0].width + this.mx, this.rectangle[1][cter].y);
            g2.drawLine(this.rectangle[this.linex + 1][0].x, this.rectangle[this.linex + 1][cter].y, this.rect.width, this.rectangle[this.linex + 1][cter].y);
        }
        g2.drawLine(this.rect.width - deltax - 2 + this.mx, this.my + this.deltamy, this.rect.width - deltax - 2 + this.mx, this.rect.height - this.deltamy);
        int dmax = this.pausefactor / 2 + this.rgbdivisor;
        HelperRGB hr = new HelperRGB(this, 2 * dmax);
        HelperRGB hg = new HelperRGB(this, dmax);
        HelperRGB hb = new HelperRGB(this, 0);
        HelperHSV hsv = new HelperHSV(this);
        int rr = 0;
        int gg = 0;
        int bb = 0;
        int gr = 0;
        for (int yy = 0; yy < this.liney; ++yy) {
            for (int xx = 0; xx < this.linex; ++xx) {
                if (this.brightColors == 0) {
                    if (yy < this.liney / 2) {
                        rr = hr.next(yy * 2);
                        gg = hg.next(yy * 2);
                        bb = hb.next(yy * 2);
                        this.color[xx + 1][yy] = new Color(rr, gg, bb);
                        continue;
                    }
                    if (yy == this.liney / 2) {
                        rr = hr.next(this.liney - 1);
                        gg = hg.next(this.liney - 1);
                        bb = hb.next(this.liney - 1);
                        this.color[xx + 1][yy] = new Color(rr, gg, bb);
                        continue;
                    }
                    this.color[xx + 1][yy] = hsv.next((this.liney - yy) * 2, xx);
                    continue;
                }
                rr = hr.next(yy);
                gg = hg.next(yy);
                bb = hb.next(yy);
                this.color[xx + 1][yy] = new Color(rr, gg, bb);
            }
            if (this.grayCol != 0) continue;
            gr = yy * (255 / this.liney);
            this.color[0][yy] = new Color(gr, gr, gr);
        }
        if (this.grayCol == 0) {
            this.color[0][this.liney - 1] = Color.white;
        }
        for (iy = 0; iy < this.liney; ++iy) {
            for (int ix = this.grayCol; ix < this.linex + 1; ++ix) {
                g2.setColor(this.color[ix][iy]);
                g2.fillRect(this.rectangle[ix][iy].x + 1, this.rectangle[ix][iy].y + 1, this.rectangle[ix][iy].width, this.rectangle[ix][iy].height - 1);
                if (ix != this.prevselpt.x || iy != this.prevselpt.y) continue;
                g2.setColor(Color.black);
                g2.drawLine(this.rectangle[ix][iy].x + 1, this.rectangle[ix][iy].y + 1, this.rectangle[ix][iy].x + 1, this.rectangle[ix][iy].y + this.rectangle[ix][iy].height - 1);
                g2.drawLine(this.rectangle[ix][iy].x + 1, this.rectangle[ix][iy].y + 1, this.rectangle[ix][iy].x + this.rectangle[ix][iy].width, this.rectangle[ix][iy].y + 1);
                g2.setColor(this.brighter(this.color[ix][iy]));
                g2.drawRect(this.rectangle[ix][iy].x + 3, this.rectangle[ix][iy].y + 3, this.rectangle[ix][iy].width - 4, this.rectangle[ix][iy].height - 5);
                g2.setColor(this.color[ix][iy]);
                g2.drawRect(this.rectangle[ix][iy].x + 2, this.rectangle[ix][iy].y + 2, this.rectangle[ix][iy].width - 1, this.rectangle[ix][iy].height - 2);
            }
        }
        for (iy = 0; iy < this.liney; ++iy) {
            if (this.color[this.linex + 1][iy] == null) {
                g2.setColor(this.defColor);
            } else {
                g2.setColor(this.color[this.linex + 1][iy]);
            }
            g2.fillRect(this.rectangle[this.linex + 1][iy].x, this.rectangle[this.linex + 1][iy].y + 1, this.rectangle[this.linex + 1][iy].width, this.rectangle[this.linex + 1][iy].height - 1);
        }
        for (iy = 0; iy < this.liney; ++iy) {
            if (iy != this.prevselpt.y || this.prevselpt.x <= this.linex) continue;
            g2.setColor(Color.black);
            g2.drawLine(this.rectangle[this.linex + 1][iy].x, this.rectangle[this.linex + 1][iy].y + 1, this.rectangle[this.linex + 1][iy].x, this.rectangle[this.linex + 1][iy].y + this.rectangle[this.linex + 1][iy].height);
            g2.drawLine(this.rectangle[this.linex + 1][iy].x, this.rectangle[this.linex + 1][iy].y + 1, this.rectangle[this.linex + 1][iy].x + this.rectangle[this.linex + 1][iy].width, this.rectangle[this.linex + 1][iy].y + 1);
            if (this.color[this.linex + 1][iy] == null) {
                g2.setColor(this.defColor);
            } else {
                g2.setColor(this.color[this.linex + 1][iy]);
            }
            g2.fillRect(this.rectangle[this.linex + 1][iy].x + 1, this.rectangle[this.linex + 1][iy].y + 2, this.rectangle[this.linex + 1][iy].width, this.rectangle[this.linex + 1][iy].height - 1);
            if (this.color[this.linex + 1][iy] == null) continue;
            g2.setColor(this.brighter(this.color[this.linex + 1][iy]));
            g2.drawRect(this.rectangle[this.linex + 1][iy].x + 2, this.rectangle[this.linex + 1][iy].y + 3, this.rectangle[this.linex + 1][iy].width - 3, this.rectangle[this.linex + 1][iy].height - 5);
        }
    }

    private void drawComponent() {
        if (this.buffImg == null) {
            this.buffImg = new BufferedImage(this.rect.width, this.rect.height, 2);
        }
        Graphics2D gbi = this.buffImg.createGraphics();
        gbi.setColor(Color.black);
    }

    public Color brighter(Color clr) {
        Color res = clr;
        long hc = 0L;
        if (clr == null) {
            return this.defColor;
        }
        hc = clr.hashCode() * -1;
        if (res.getRed() == res.getGreen() && res.getRed() == res.getBlue() && res.getGreen() == res.getBlue() && res.getRed() < 10) {
            res = new Color(25, 25, 25);
        }
        if (hc > 10000000L) {
            res = res.brighter().brighter();
        } else if (hc > 6000000L) {
            res = res.brighter();
        }
        return res;
    }

    public void clearSavedColors(boolean repaint) {
        for (int iy = 0; iy < this.liney; ++iy) {
            this.color[this.linex + 1][iy] = this.defColor;
        }
        this.refresh();
        if (repaint) {
            this.repaint();
        }
    }

    public ImageIcon getDarkerImageIcon(Rectangle clrRec, float darknessfactor) {
        BufferedImage originalImage = new BufferedImage(clrRec.width, clrRec.height, 1);
        BufferedImage darkenedImage = new BufferedImage(clrRec.width, clrRec.height, 1);
        Graphics2D g = originalImage.createGraphics();
        g.dispose();
        float[] brightKernel = new float[]{darknessfactor};
        ConvolveOp bright = new ConvolveOp(new Kernel(1, 1, brightKernel));
        bright.filter(originalImage, darkenedImage);
        return new ImageIcon(darkenedImage);
    }

    public double getMinFactor() {
        return this.minfactor;
    }

    private Point getMousePosition(int xx, int yy) {
        Point res = new Point();
        boolean valid = false;
        if (this.rectangle[this.grayCol][0] == null) {
            return null;
        }
        if (this.rectangle[this.grayCol][0].x < xx && this.rectangle[this.grayCol][0].y < yy && this.rectangle[this.linex][this.liney - 1].x + this.rectangle[this.grayCol][0].width + 2 > xx && this.rectangle[this.linex][this.liney - 1].y + this.rectangle[this.grayCol][0].height + 2 > yy) {
            res.x = (xx - this.rectangle[this.grayCol][0].x - 1 + this.grayCol * (this.rectangle[this.grayCol][0].width + 2)) / (this.rectangle[this.grayCol][0].width + 2);
            res.y = (yy - this.rectangle[this.grayCol][0].y - 1) / (this.rectangle[this.grayCol][0].height + 1);
            valid = true;
        } else if (this.rectangle[this.linex + 1][0].x < xx && this.rectangle[this.linex + 1][0].y < yy && this.rectangle[this.linex + 1][this.liney - 1].x + this.rectangle[this.grayCol][0].width + 2 > xx && this.rectangle[this.linex + 1][this.liney - 1].y + this.rectangle[this.grayCol][0].height + 2 > yy) {
            res.x = this.linex + 1;
            res.y = (yy - this.rectangle[this.grayCol][0].y - 1) / (this.rectangle[this.grayCol][0].height + 1);
            valid = true;
        }
        if (!valid) {
            res = null;
        }
        return res;
    }

    public int getPauseFactor() {
        return this.pausefactor;
    }

    public int getRGBDivisor() {
        return this.rgbdivisor;
    }

    public int getRGBMax() {
        return this.rgbmax;
    }

    public int getRGBMin() {
        return this.rgbmin;
    }

    public Color getSelectedColor() {
        Color res = this.defColor;
        res = this.prevselpt.x != -1 && this.prevselpt.y != -1 ? this.color[this.prevselpt.x][this.prevselpt.y] : null;
        return res;
    }

    public Color[] getSavedColors() {
        Color[] scolor = new Color[this.liney];
        for (int cter = 0; cter < this.liney; ++cter) {
            scolor[cter] = this.color[this.linex + 1][cter] == null ? this.defColor : this.color[this.linex + 1][cter];
        }
        return scolor;
    }

    public Point getXY() {
        return new Point(this.linex, this.liney);
    }

    public boolean isBrightColors() {
        boolean res = true;
        res = this.brightColors == 0;
        return res;
    }

    public boolean isGrayColumn() {
        boolean res = true;
        res = this.grayCol == 0;
        return res;
    }

    public void refresh() {
        int dimx = this.color.length - 1;
        int dimy = this.color[0].length;
        if (dimy > this.liney) {
            dimy = this.liney;
        }
        Color[] scolor = new Color[this.liney];
        for (int iy = 0; iy < dimy; ++iy) {
            scolor[iy] = this.color[dimx][iy];
        }
        this.color = new Color[this.linex + 2][this.liney];
        this.rectangle = new Rectangle[this.linex + 2][this.liney];
        this.prevselpt = new Point(-1, -1);
        this.prevselliney = -1;
        this.prevsellinex = -1;
        this.setSavedColors(scolor, false);
    }

    public void resetButtons() {
        Graphics2D g2 = (Graphics2D)this.getGraphics().create();
        Rectangle rectmp = null;
        if (this.prevselpt.x < 0) {
            return;
        }
        rectmp = this.rectangle[this.prevselpt.x][this.prevselpt.y];
        if (this.prevselliney == -1) {
            g2.setColor(Color.black);
            g2.drawLine(rectmp.x + rectmp.width + 1, rectmp.y + 1, rectmp.x + rectmp.width + 1, rectmp.y + rectmp.height);
            g2.drawLine(rectmp.x + 1, rectmp.y + rectmp.height, rectmp.x + rectmp.width, rectmp.y + rectmp.height);
            g2.setColor(this.color[this.prevselpt.x][this.prevselpt.y]);
            g2.fillRect(rectmp.x + 1, rectmp.y + 1, rectmp.width, rectmp.height - 1);
            this.prevselpt.x = -1;
            this.prevselpt.y = -1;
        } else if (this.prevselpt.y != -1) {
            g2.setColor(Color.black);
            g2.drawLine(rectmp.x + rectmp.width, rectmp.y + 1, rectmp.x + rectmp.width, rectmp.y + rectmp.height);
            g2.drawLine(rectmp.x, rectmp.y + rectmp.height, rectmp.x + rectmp.width, rectmp.y + rectmp.height);
            g2.setColor(this.color[this.prevselpt.x][this.prevselpt.y]);
            g2.fillRect(rectmp.x, rectmp.y + 1, rectmp.width, rectmp.height - 1);
            this.prevselliney = -1;
            this.prevselpt.x = -1;
            this.prevselpt.y = -1;
        }
    }

    @Override
    public void setBounds(Rectangle rect) {
        this.rect = new Rectangle(rect.x + this.mx, rect.y + this.my, rect.width - 2, rect.height - 2);
        this.dx = rect.width;
        this.dy = rect.height;
        this.setSize(this.dx, this.dy);
        this.setLocation(rect.x, rect.y);
        this.drawComponent();
    }

    public void setBrightColors(boolean bright) {
        boolean refresh = false;
        if (bright && this.brightColors == 1) {
            refresh = true;
        } else if (!bright && this.brightColors == 0) {
            refresh = true;
        }
        this.brightColors = bright ? 0 : 1;
        if (refresh) {
            this.repaint();
        }
    }

    public void setColumns(int columns, boolean repaint) {
        boolean refresh = false;
        int rest = columns % 6;
        double col = columns;
        if (this.linex == columns || columns <= 0) {
            return;
        }
        refresh = true;
        if (rest > 0) {
            columns = 6 - rest;
        }
        if (columns < 12) {
            columns = 12;
        } else if (columns > 252) {
            columns = 252;
        }
        this.linex = columns;
        this.pausefactor = (int)((col / 4.0 - 2.0) * 2.0);
        this.rgbdivisor = (int)(col / 12.0 + 0.5) + 2;
        if (this.linex <= 18) {
            this.pausefactor = this.linex / 3;
            this.rgbdivisor = this.pausefactor / 2;
        }
        this.refresh();
        if (repaint) {
            this.repaint();
        }
    }

    public void setGrayColumn(boolean visible) {
        boolean refresh = true;
        if (this.grayCol == 0 && visible || this.grayCol == 1 && !visible) {
            refresh = false;
        }
        this.grayCol = visible ? 0 : 1;
        if (refresh) {
            this.repaint();
        }
    }

    public void setRGBdivisor(int divisor, boolean repaint) {
        boolean refresh = false;
        if (divisor != this.rgbdivisor) {
            this.rgbdivisor = divisor;
            refresh = true;
        }
        if (refresh && repaint) {
            this.repaint();
        }
    }

    public void setMinFactor(int minfactor) {
        this.minfactor = minfactor > 1 ? 1.0 : (minfactor < 0 ? 0.0 : (double)minfactor);
    }

    public void setRGBmax(int rgbmax, boolean repaint) {
        this.rgbmax = rgbmax > 255 ? 255 : (rgbmax < 0 ? 0 : rgbmax);
        if (repaint) {
            this.repaint();
        }
    }

    public void setRGBmin(int rgbmin, boolean repaint) {
        this.rgbmin = rgbmin > 255 ? 255 : (rgbmin < 0 ? 0 : rgbmin);
        if (repaint) {
            this.repaint();
        }
    }

    public void setRows(int rows, boolean repaint) {
        if (rows % 2 == 1) {
            ++rows;
        }
        if (rows < 4) {
            rows = 4;
        }
        this.liney = rows;
        this.refresh();
        if (repaint) {
            this.repaint();
        }
    }

    public void setSavedColors(Color[] scolor, boolean repaint) {
        int dim = scolor.length;
        for (int iy = 0; iy < this.liney; ++iy) {
            if (iy < dim) {
                if (scolor[iy] == null) {
                    this.color[this.linex + 1][iy] = this.defColor;
                    continue;
                }
                this.color[this.linex + 1][iy] = scolor[iy];
                continue;
            }
            this.color[this.linex + 1][iy] = this.defColor;
        }
        if (repaint) {
            this.repaint();
        }
    }

    public void mouseMoved(MouseEvent me) {
        String tooltiptext = "";
        int sourisX = me.getX();
        int sourisY = me.getY();
        Point point = this.getMousePosition(sourisX, sourisY);
        try {
            tooltiptext = this.color[point.x][point.y].getRed() + "," + this.color[point.x][point.y].getGreen() + "," + this.color[point.x][point.y].getBlue();
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (point != null && !tooltiptext.equals("")) {
            this.setToolTipText(tooltiptext);
        } else {
            this.setToolTipText(null);
        }
    }

    public void mousePressed(MouseEvent me) {
        int sourisY;
        int sourisX = me.getX();
        Point point = this.getMousePosition(sourisX, sourisY = me.getY());
        if (point == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)this.getGraphics().create();
        Rectangle rectmp = this.rectangle[point.x][point.y];
        Rectangle recprev = null;
        if (this.prevselpt.x >= 0) {
            recprev = this.rectangle[this.prevselpt.x][this.prevselpt.y];
        } else if (this.prevselpt.x == -1 && this.prevselliney >= 0) {
            recprev = this.rectangle[this.linex + 1][this.prevselliney];
        }
        if (point.x == this.prevselpt.x && point.y == this.prevselpt.y) {
            this.prevselpt.y = -1;
            this.prevselpt.x = -1;
        } else if (point.x > this.linex) {
            g2.setColor(Color.black);
            g2.drawLine(rectmp.x, rectmp.y + 1, rectmp.x, rectmp.y + rectmp.height);
            g2.drawLine(rectmp.x, rectmp.y + 1, rectmp.x + rectmp.width, rectmp.y + 1);
            if (this.prevselpt.x >= 0 && this.prevselliney == -1) {
                this.color[point.x][point.y] = this.color[this.prevselpt.x][this.prevselpt.y];
                g2.setColor(this.color[point.x][point.y]);
            } else if (this.color[point.x][point.y] == null) {
                this.color[point.x][point.y] = this.defColor;
                g2.setColor(this.defColor);
            } else {
                g2.setColor(this.color[point.x][point.y]);
            }
            if (this.prevselpt.x != point.y || this.prevselliney != point.y) {
                g2.fillRect(rectmp.x + 1, rectmp.y + 2, rectmp.width, rectmp.height - 1);
                g2.setColor(this.brighter(this.color[point.x][point.y]));
                g2.drawRect(rectmp.x + 2, rectmp.y + 3, rectmp.width - 4, rectmp.height - 5);
            }
            if (recprev != null && this.prevselliney == -1) {
                g2.setColor(Color.black);
                g2.drawLine(recprev.x + recprev.width + 1, recprev.y + 1, recprev.x + recprev.width + 1, recprev.y + recprev.height);
                g2.drawLine(recprev.x + 1, recprev.y + recprev.height, recprev.x + recprev.width + 1, recprev.y + recprev.height);
                g2.setColor(this.color[point.x][point.y]);
                g2.fillRect(recprev.x + 1, recprev.y + 1, recprev.width, recprev.height - 1);
                this.prevselliney = point.y;
            } else {
                if (recprev != null && point.y != this.prevselliney) {
                    g2.setColor(Color.black);
                    if (this.prevselpt.x > this.linex) {
                        g2.drawLine(recprev.x + recprev.width, recprev.y + this.my, recprev.x + recprev.width, recprev.y + recprev.height);
                        g2.drawLine(recprev.x + 1, recprev.y + recprev.height, recprev.x + recprev.width - 1, recprev.y + recprev.height);
                    } else {
                        g2.drawLine(recprev.x + recprev.width, recprev.y + this.my, recprev.x + recprev.width, recprev.y + recprev.height);
                        g2.drawLine(recprev.x, recprev.y + recprev.height, recprev.x + recprev.width, recprev.y + recprev.height);
                    }
                    g2.setColor(this.color[this.linex + 1][this.prevselliney]);
                    g2.fillRect(recprev.x, recprev.y + 1, recprev.width, recprev.height - 1);
                }
                this.prevselliney = this.prevselpt.y != point.y ? point.y : -1;
            }
            this.prevselpt.x = point.x;
            this.prevselpt.y = point.y;
        } else {
            g2.setColor(Color.black);
            g2.drawLine(rectmp.x + 1, rectmp.y + 1, rectmp.x + 1, rectmp.y + rectmp.height);
            g2.drawLine(rectmp.x + 1, rectmp.y + 1, rectmp.x + rectmp.width + 1, rectmp.y + 1);
            if (recprev != null && this.prevselpt.x != -1 && this.prevselpt.y != -1) {
                if (this.prevselpt.x > this.linex) {
                    g2.drawLine(recprev.x + recprev.width, recprev.y + 1, recprev.x + recprev.width, recprev.y + recprev.height);
                    g2.drawLine(recprev.x, recprev.y + recprev.height, recprev.x + recprev.width, recprev.y + recprev.height);
                } else {
                    g2.drawLine(recprev.x + recprev.width + 1, recprev.y + 1, recprev.x + recprev.width + 1, recprev.y + recprev.height);
                    g2.drawLine(recprev.x + 1, recprev.y + recprev.height, recprev.x + recprev.width + 1, recprev.y + recprev.height);
                }
                if (this.prevselliney >= 0) {
                    g2.setColor(this.color[this.linex + 1][this.prevselliney]);
                    if (this.prevselpt.x > this.linex) {
                        g2.fillRect(recprev.x, recprev.y + 1, recprev.width, recprev.height - 1);
                    } else {
                        g2.fillRect(recprev.x + 1, recprev.y + 1, recprev.width, recprev.height - 1);
                    }
                } else {
                    g2.setColor(this.color[this.prevselpt.x][this.prevselpt.y]);
                    if (this.prevselpt.x > this.linex) {
                        g2.fillRect(recprev.x, recprev.y + 1, recprev.width, recprev.height - 1);
                    } else {
                        g2.fillRect(recprev.x + 1, recprev.y + 1, recprev.width, recprev.height - 1);
                    }
                }
            }
            g2.setColor(this.brighter(this.color[point.x][point.y]));
            g2.drawRect(rectmp.x + 3, rectmp.y + 3, rectmp.width - 4, rectmp.height - 5);
            g2.setColor(this.color[point.x][point.y]);
            g2.drawRect(rectmp.x + 2, rectmp.y + 2, rectmp.width - 1, rectmp.height - 2);
            this.prevselpt.x = point.x;
            this.prevselpt.y = point.y;
            this.prevselliney = -1;
        }
    }

    public void mouseReleased(MouseEvent me) {
        int sourisY;
        int sourisX = me.getX();
        Point point = this.getMousePosition(sourisX, sourisY = me.getY());
        if (point == null) {
            return;
        }
        if (!point.equals(this.prevselpt) && this.prevselpt.x != -1 && this.prevselpt.y != -1) {
            return;
        }
        Graphics2D g2 = (Graphics2D)this.getGraphics().create();
        Rectangle rectmp = this.rectangle[point.x][point.y];
        Rectangle recprev = null;
        if (this.prevselpt.x >= 0) {
            recprev = this.rectangle[this.prevselpt.x][this.prevselpt.y];
        }
        if (point.x != this.prevselpt.x || point.y != this.prevselpt.y || this.prevselliney >= 0) {
            if (this.prevselliney == -1) {
                g2.setColor(Color.black);
                g2.drawLine(rectmp.x + rectmp.width + 1, rectmp.y + 1, rectmp.x + rectmp.width + 1, rectmp.y + rectmp.height);
                g2.drawLine(rectmp.x + 1, rectmp.y + rectmp.height, rectmp.x + rectmp.width, rectmp.y + rectmp.height);
                g2.setColor(this.color[point.x][point.y]);
                g2.fillRect(rectmp.x + 1, rectmp.y + 1, rectmp.width, rectmp.height - 1);
                this.prevselpt.x = -1;
                this.prevselpt.y = -1;
            } else if (this.prevselpt.y != point.y) {
                g2.setColor(Color.black);
                g2.drawLine(rectmp.x + rectmp.width, rectmp.y + 1, rectmp.x + rectmp.width, rectmp.y + rectmp.height);
                g2.drawLine(rectmp.x, rectmp.y + rectmp.height, rectmp.x + rectmp.width, rectmp.y + rectmp.height);
                g2.setColor(this.color[point.x][point.y]);
                g2.fillRect(rectmp.x, rectmp.y + 1, rectmp.width, rectmp.height - 1);
                this.prevselliney = point.y;
                this.prevselpt.x = -1;
                this.prevselpt.y = -1;
            }
        }
    }

    class PrivateColorChooser_mouseMotionAdapter
    extends MouseMotionAdapter {
        PrivateColorChooser adaptee;

        PrivateColorChooser_mouseMotionAdapter(PrivateColorChooser adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void mouseMoved(MouseEvent me) {
            this.adaptee.mouseMoved(me);
        }
    }

    class PrivateColorChooser_mouseAdapter
    extends MouseAdapter {
        PrivateColorChooser adaptee;

        PrivateColorChooser_mouseAdapter(PrivateColorChooser adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.adaptee.mousePressed(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.adaptee.mouseReleased(e);
        }
    }

    class HelperHSV {
        PrivateColorChooser pcch;
        int liney;
        int linex;
        float[] hues;
        float huebase;
        float satbase;

        public HelperHSV(PrivateColorChooser pcch) {
            this.pcch = pcch;
            this.liney = pcch.getXY().y;
            this.linex = pcch.getXY().x;
            this.huebase = 1.0f / (float)this.linex;
            this.satbase = 1.0f / (float)this.liney;
            this.hues = new float[this.linex];
            for (int ii = 0; ii < this.linex; ++ii) {
                this.hues[ii] = this.huebase * (float)ii;
            }
        }

        public Color next(int yy, int xx) {
            Color res = null;
            res = new Color(Color.HSBtoRGB(this.hues[xx], this.satbase * (float)yy, 1.0f));
            return res;
        }
    }

    class HelperRGB {
        PrivateColorChooser pcch;
        int rgbmax = 0;
        int rgbmin = 0;
        int rgbdivisor;
        int liney;
        int linex;
        int[] rgbbase;
        int rgbbasefactor = 0;
        int pausefactor = 0;
        double minfactor = 0.0;
        int dmin = 0;
        int dmax = 0;
        int nryy = -1;
        int iirgb = 0;
        int jjrgb = 0;
        int rr = 0;
        int gg = 0;
        int bb = 0;

        public HelperRGB(PrivateColorChooser pcch) {
            this.pcch = pcch;
            this.rgbmax = pcch.getRGBMax();
            this.rgbmin = pcch.getRGBMin();
            this.rgbdivisor = pcch.getRGBDivisor();
            this.liney = pcch.getXY().y;
            this.linex = pcch.getXY().x;
            this.pausefactor = pcch.getPauseFactor();
            this.minfactor = pcch.getMinFactor();
            this.dmin = this.pausefactor / 2;
            this.dmax = this.pausefactor / 2 + this.rgbdivisor;
            this.rgbdivisor = this.dmin;
            this.rgbbase = new int[this.liney];
            this.rgbbasefactor = 0;
            for (int cter = 0; cter < this.liney - 1; ++cter) {
                this.rgbbase[cter] = this.rgbmin + (this.rgbmax - this.rgbmin) / this.liney * cter;
            }
            this.rgbbase[this.liney - 1] = this.rgbmax;
        }

        public HelperRGB(PrivateColorChooser pcch, int iirgb) {
            this(pcch);
            this.iirgb = iirgb;
        }

        public int next(int yy) {
            int res = 0;
            int rgbbasemin = (int)((double)this.rgbbase[yy] * this.minfactor);
            if (yy != this.nryy) {
                this.nryy = yy;
                this.rgbbasefactor = (this.rgbbase[yy] - rgbbasemin) / this.rgbdivisor;
            }
            if (this.iirgb > 0 && this.iirgb < this.dmax) {
                res = rgbbasemin;
                this.jjrgb = 0;
            } else if (this.iirgb >= this.dmax && this.iirgb < this.dmax + this.dmin) {
                if (this.jjrgb < this.rgbdivisor) {
                    res = this.jjrgb * this.rgbbasefactor + rgbbasemin;
                    ++this.jjrgb;
                }
            } else if (this.iirgb >= this.dmax + this.dmin && this.iirgb < 2 * this.dmax + this.dmin) {
                res = this.rgbbase[yy];
                this.jjrgb = 0;
            } else if (this.iirgb >= 2 * this.dmax + this.dmin && this.iirgb < this.linex) {
                if (this.jjrgb < this.rgbdivisor) {
                    res = this.rgbbase[yy] - this.jjrgb * this.rgbbasefactor;
                    ++this.jjrgb;
                }
            } else {
                res = rgbbasemin;
            }
            ++this.iirgb;
            if (this.iirgb >= this.linex) {
                this.iirgb = 0;
            }
            return res;
        }

        public void setCursor(int iirgb) {
            this.iirgb = iirgb;
        }
    }
}

