/*
 * Decompiled with CFR 0.152.
 */
package privatecomponents;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Arc2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class SNCFClock
extends JPanel {
    protected boolean refreshBit = false;
    int dx = 200;
    int dy = 200;
    int mx = 15;
    int my = 15;
    final int CRH = 3;
    Dimension dim = null;
    Rectangle rect = null;
    BufferedImage buffImg = null;
    Graphics2D gbi;
    BufferedImage buffImgHM;
    Graphics2D gbiHM;
    BufferedImage buffImgHH;
    Graphics2D gbiHH;
    BufferedImage buffImgMM;
    Graphics2D gbiMM;
    BufferedImage buffImgSec;
    Graphics2D gbiSec;
    Arc2D arc2DSec;
    Color clr_sncfy = new Color(251, 251, 95);
    SNCFClockThread sncfClockThread;
    boolean b_paint = true;
    boolean b_dispose = false;
    Date date;
    long diff = 0L;
    int flags = 0;

    public SNCFClock() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            System.out.println("CFFClock: " + ex);
        }
    }

    public SNCFClock(Date date) {
        this.date = date;
        this.diff = System.currentTimeMillis() - date.getTime();
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            System.out.println("CFFClock: " + ex);
        }
    }

    public SNCFClock(int flags) {
        this.flags = flags;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            System.out.println("CFFClock: " + ex);
        }
    }

    public SNCFClock(Date date, int flags) {
        this.date = date;
        this.flags = flags;
        this.diff = System.currentTimeMillis() - date.getTime();
    }

    private void jbInit() throws Exception {
        this.setLayout(null);
        this.setOpaque(true);
        this.setBounds(new Rectangle(0, 0, this.dx, this.dy));
        this.addMouseListener(new HorizonStereo_MouseAdapter(this));
        this.loop();
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2p = (Graphics2D)g.create();
        System.out.println("CFFClock.paintComponent");
    }

    private void drawComponent() {
        this.buffImg = new BufferedImage(this.dx, this.dx, 2);
        this.gbi = this.buffImg.createGraphics();
        this.gbi.setColor(new Color(1.0f, 1.0f, 1.0f, 0.0f));
        this.gbi.fillRect(0, 0, this.dx, this.dx);
        this.buffImgHH = new BufferedImage(this.dx, this.dx, 2);
        this.gbiHH = this.buffImgHH.createGraphics();
        this.buffImgMM = new BufferedImage(this.dx, this.dx, 2);
        this.gbiMM = this.buffImgMM.createGraphics();
        this.buffImgSec = new BufferedImage(this.dx, this.dx, 2);
        this.gbiSec = this.buffImgSec.createGraphics();
        this.buffImgHM = new BufferedImage(this.dx, this.dx, 2);
        this.gbiHM = this.buffImgHM.createGraphics();
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
        this.diff = System.currentTimeMillis() - date.getTime();
        this.loop();
    }

    public long getTimeDifference() {
        return this.diff;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
        this.loop();
        this.repaint();
    }

    protected void setPaintFlag(boolean b_paint) {
        this.b_paint = b_paint;
    }

    protected void drawSNCFClock(long millisec) {
        if (!this.b_paint) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        if ((this.flags & 2) == 2) {
            calendar.setTimeInMillis(millisec);
        } else {
            calendar.setTimeInMillis(millisec - 1000L);
        }
        double hh = calendar.get(10);
        double mm = calendar.get(12);
        double sec = calendar.get(13);
        double msec = calendar.get(14);
        double ahh = (hh * 60.0 + mm) * Math.PI / 360.0;
        double amm = mm * Math.PI / 30.0;
        double asec = (sec * 1000.0 + msec) * Math.PI / 30000.0;
        double DDX = this.dx;
        this.gbi.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Arc2D.Double arc2d = new Arc2D.Double(new Rectangle2D.Double(0.0, 0.0, this.dx, this.dx), 0.0, 360.0, 1);
        this.gbi.setColor(new Color(22, 22, 22));
        this.gbi.fill(arc2d);
        this.gbi.setColor(new Color(39, 39, 39));
        double mx = ((double)this.dx - 1.9 * (double)this.dx / 3.0) / 2.0;
        arc2d = new Arc2D.Double(new Rectangle2D.Double(mx, mx, 1.9 * (double)this.dx / 3.0, 1.9 * (double)this.dx / 3.0), 0.0, 360.0, 1);
        this.gbi.fill(arc2d);
        if ((this.flags & 1) != 1) {
            BasicStroke line = new BasicStroke((float)this.dx / 200.0f);
            arc2d = new Arc2D.Double(new Rectangle2D.Double(0.5, 0.5, (double)this.dx - 1.0, (double)this.dx - 1.0), 0.0, 360.0, 1);
            this.gbi.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.gbi.setStroke(line);
            this.gbi.setColor(new Color(131, 131, 131));
            this.gbi.draw(arc2d);
        }
        Rectangle2D.Double rect2DH = new Rectangle2D.Double(DDX / 2.0 - DDX / 90.0, DDX / 25.0, DDX / 45.0, DDX / 7.1);
        Rectangle2D.Double rect2DM = new Rectangle2D.Double(DDX / 2.0 - DDX / 180.0, DDX / 25.0, DDX / 90.0, DDX / 11.0);
        this.gbiHM.setColor(this.clr_sncfy);
        this.gbiHM.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (int ii = 0; ii < 60; ++ii) {
            if (ii % 5 == 0) {
                this.gbiHM.fill(rect2DH);
            } else if (this.dx >= 50) {
                this.gbiHM.fill(rect2DM);
            }
            this.gbiHM.rotate(0.10471975511965977, this.dx / 2, this.dx / 2);
        }
        Rectangle2D.Double rect2DHH = new Rectangle2D.Double(DDX / 2.0 - DDX / 40.0, DDX / 3.8, DDX / 20.0, DDX / 3.6);
        this.gbiHH.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.gbiHH.setColor(this.clr_sncfy);
        this.gbiHH.rotate(ahh, (double)this.dx / 2.0, (double)this.dx / 2.0);
        this.gbiHH.fill(rect2DHH);
        Rectangle2D.Double rect2DMM = new Rectangle2D.Double(DDX / 2.0 - DDX / 64.0, DDX / 5.4, DDX / 32.0, DDX / 2.7);
        this.gbiMM.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.gbiMM.setColor(this.clr_sncfy);
        this.gbiMM.rotate(amm, (double)this.dx / 2.0, (double)this.dx / 2.0);
        this.gbiMM.fill(rect2DMM);
        if ((this.flags & 2) != 2) {
            Rectangle2D.Double rec2DSec = new Rectangle2D.Double(DDX / 2.0 - DDX / 200.0, DDX / 5.4, DDX / 100.0, DDX / 2.7);
            this.arc2DSec = new Arc2D.Double(new Rectangle2D.Double(DDX / 2.0 - DDX / 40.0, DDX / 4.0, DDX / 20.0, DDX / 20.0), 0.0, 360.0, 1);
            this.gbiSec.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.gbiSec.setColor(this.clr_sncfy);
            this.gbiSec.rotate(asec, (double)this.dx / 2.0, (double)this.dx / 2.0);
            this.gbiSec.fill(rec2DSec);
            this.gbiSec.fill(this.arc2DSec);
            this.arc2DSec = new Arc2D.Double(new Rectangle2D.Double(DDX / 2.0 - DDX / 52.0, DDX / 3.92, DDX / 26.0, DDX / 26.0), 0.0, 360.0, 1);
            this.gbiSec.setColor(new Color(39, 39, 39));
            this.gbiSec.fill(this.arc2DSec);
        }
        this.gbi.drawImage(this.buffImgHM, null, null);
        this.gbi.drawImage(this.buffImgHH, null, null);
        this.gbi.drawImage(this.buffImgMM, null, null);
        if ((this.flags & 2) != 2) {
            this.gbi.drawImage(this.buffImgSec, null, null);
        }
        this.b_paint = false;
    }

    protected void resetTime(long millisec) {
        this.drawComponent();
        this.drawSNCFClock(millisec);
        this.b_paint = false;
        this.repaint();
    }

    @Override
    public void paint(Graphics graphics) {
        this.drawSNCFClock(System.currentTimeMillis() - this.diff);
        ((Graphics2D)graphics).drawImage(this.buffImg, null, null);
    }

    public BufferedImage getBufferedImage() {
        BufferedImage bi = new BufferedImage(this.dx, this.dy, 2);
        Graphics2D g2d = bi.createGraphics();
        g2d.drawImage((Image)this.buffImg, this.dx, 0, null);
        return bi;
    }

    public Graphics2D getGraphics2D() {
        return this.gbi;
    }

    public void destroy() {
        this.b_dispose = true;
    }

    private void loop() {
        if ((this.flags & 4) == 4) {
            return;
        }
        this.sncfClockThread = new SNCFClockThread(this);
        this.sncfClockThread.start();
    }

    public boolean saveAsPng(String fn) {
        if (this.date == null) {
            this.resetTime(System.currentTimeMillis());
        } else {
            this.resetTime(this.date.getTime());
        }
        try {
            File output = new File(fn);
            FileOutputStream fos = new FileOutputStream(output);
            ImageIO.write((RenderedImage)this.buffImg, "png", fos);
        }
        catch (IOException ioex) {
            System.out.println("SNCFClock IOException: " + ioex.getMessage());
        }
        return false;
    }

    @Override
    public void setBounds(Rectangle rect) {
        this.rect = rect;
        this.dx = rect.width;
        this.dy = rect.height;
        if (this.dy > this.dx) {
            this.dx = this.dy;
        }
        this.setSize(this.dx, this.dx + 3);
        this.setLocation(rect.x, rect.y);
        this.drawComponent();
    }

    private void mouseMoved(MouseEvent me) {
    }

    private void mouseReleased(MouseEvent me) {
    }

    class SNCFClockThread
    extends Thread
    implements Runnable {
        Graphics2D g2d;
        SNCFClock sncfClock;

        public SNCFClockThread(Graphics2D g2d) {
            this.g2d = g2d;
        }

        public SNCFClockThread(SNCFClock sncfClock) {
            this.sncfClock = sncfClock;
        }

        @Override
        public void run() {
            long cad = 50L;
            if ((this.sncfClock.getFlags() & 2) == 2) {
                cad = 1000L;
            }
            long startTime = System.currentTimeMillis() + cad - this.sncfClock.getTimeDifference();
            while (!SNCFClock.this.b_dispose) {
                long ct = System.currentTimeMillis() - this.sncfClock.getTimeDifference();
                if (startTime > ct) continue;
                startTime = ct + cad;
                if (this.sncfClock == null) continue;
                this.sncfClock.setPaintFlag(true);
                this.sncfClock.resetTime(startTime - cad);
            }
        }

        public void setSNCFClock(SNCFClock sncfClock) {
            this.sncfClock = sncfClock;
        }
    }

    class HorizonStereo_MouseAdapter
    extends MouseAdapter {
        SNCFClock adaptee;

        public HorizonStereo_MouseAdapter(SNCFClock adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            this.adaptee.mouseReleased(me);
        }
    }

    class HorizonStereo_MouseMotionAdapter
    extends MouseMotionAdapter {
        SNCFClock adaptee;

        public HorizonStereo_MouseMotionAdapter(SNCFClock adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void mouseMoved(MouseEvent me) {
            this.adaptee.mouseMoved(me);
        }
    }
}

