/*
 * Decompiled with CFR 0.152.
 */
package privatecomponents;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Arc2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class Tacho
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected boolean refreshBit = false;
    int dx = 200;
    int dy = 200;
    final int CRH = 3;
    Dimension dim = null;
    Rectangle rect = null;
    transient BufferedImage buffImg;
    transient Graphics2D gbi;
    transient BufferedImage buffImgTics;
    transient Graphics2D gbiTics;
    transient BufferedImage buffImgText;
    transient Graphics2D gbiText;
    transient BufferedImage buffImgSubTics;
    transient Graphics2D gbiSubTics;
    transient Arc2D arc2DSubTics;
    Color background = Color.white;
    Color foreground = Color.black;
    Color clr_sec = new Color(255, 126, 0);
    Font font = new Font("Dialog", 0, 11);
    int base = 960;
    int subtics = 10;
    int tics = 5;
    String units = "";
    boolean b_paint = true;
    boolean b_dispose = false;
    int flags = 0;
    static final int DELTA_BETWEEN_MAINTICS_5 = 5;
    static final int DELTA_BETWEEN_MAINTICS_10 = 10;

    public Tacho() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            System.out.println("Tacho: " + ex);
        }
    }

    public Tacho(int base, int subtics) {
        this.base = base;
        subtics = subtics <= 5 ? 5 : 10;
        this.subtics = subtics;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            System.out.println("Tacho: " + ex);
        }
    }

    public Tacho(int base, int tics, int subtics) {
        this.base = base;
        this.tics = tics;
        subtics = subtics <= 5 ? 5 : 10;
        this.subtics = subtics;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            System.out.println("Tacho: " + ex);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(null);
        this.setOpaque(true);
        this.setBounds(new Rectangle(0, 0, this.dx, this.dy));
        this.addMouseListener(new Tacho_MouseAdapter(this));
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2p = (Graphics2D)g.create();
        System.out.println("Tacho.paintComponent");
    }

    private void drawComponent() {
        this.buffImg = new BufferedImage(this.dx, this.dx, 2);
        this.gbi = this.buffImg.createGraphics();
        this.gbi.setColor(new Color(1.0f, 1.0f, 1.0f, 0.0f));
        this.gbi.fillRect(0, 0, this.dx, this.dx);
        this.buffImgTics = new BufferedImage(this.dx, this.dx, 2);
        this.gbiTics = this.buffImgTics.createGraphics();
        this.buffImgSubTics = new BufferedImage(this.dx, this.dx, 2);
        this.gbiSubTics = this.buffImgSubTics.createGraphics();
        this.buffImgText = new BufferedImage(this.dx, this.dx, 2);
        this.gbiText = this.buffImgTics.createGraphics();
    }

    public void setBackgroundColor(Color background) {
        this.background = background;
        this.drawTacho();
    }

    public void setForegroundColor(Color foreground) {
        this.foreground = foreground;
        this.drawTacho();
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
        if ((flags & 2) == 2) {
            this.foreground = Color.white;
            this.background = Color.black;
        }
        this.repaint();
    }

    protected void setPaintFlag(boolean b_paint) {
        this.b_paint = b_paint;
    }

    protected void drawTacho() {
        if (!this.b_paint) {
            return;
        }
        int fontSize = (int)(Math.sqrt(this.dx) / 1.3);
        if (fontSize < 6) {
            fontSize = 6;
        } else if (fontSize > 12) {
            fontSize = 12;
        }
        this.font = new Font("Dialog", 0, fontSize);
        FontMetrics fm = this.getFontMetrics(this.font);
        int sw = fm.stringWidth(String.valueOf(this.base + 4 * this.subtics));
        double DDX = this.dx - sw;
        this.gbi.setColor(this.background);
        this.gbi.fillRect(0, 0, this.dx, this.dx);
        Rectangle2D.Double rect2DH = new Rectangle2D.Double((double)this.dx / 2.0 - DDX / 160.0, DDX - (DDX / 10.0 + 3.0), DDX / 80.0, DDX / 12.0);
        Rectangle2D.Double rect2DHsec = new Rectangle2D.Double((double)this.dx / 2.0 - DDX / 160.0, DDX - (DDX / 10.0 + 3.0), DDX / 80.0, DDX / 17.0);
        Rectangle2D.Double rect2DM = new Rectangle2D.Double((double)this.dx / 2.0 - DDX / 320.0, DDX - (DDX / 10.0 + 3.0), DDX / 160.0, DDX / 25.0);
        this.gbiTics.setColor(this.foreground);
        this.gbiTics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.gbiText.setColor(this.foreground);
        this.gbiText.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.gbiText.setFont(this.font);
        int tt = this.tics * 10;
        for (int ii = 0; ii < tt + 10; ++ii) {
            if ((ii + 5) % (50 / this.subtics) == 0) {
                if (ii != 0) {
                    this.gbiTics.fill(rect2DH);
                }
            } else if ((ii + 5) % 5 == 0) {
                if (ii != 0) {
                    this.gbiTics.fill(rect2DHsec);
                }
            } else if (this.dx >= tt && ii > 5 && ii < tt + 5) {
                this.gbiTics.fill(rect2DM);
            }
            if (ii < 5) {
                this.gbiTics.rotate(0.10471975511965977, this.dx / 2, this.dy / 2);
                continue;
            }
            this.gbiTics.rotate(Math.PI * 2 / (double)(6 * tt / 5), this.dx / 2, this.dy / 2);
        }
        String tmp = String.valueOf(this.base + 2 * this.tics * this.subtics);
        sw = fm.stringWidth(tmp);
        this.gbiText.drawString(tmp, (float)((double)(this.dx - sw - 2) - ((double)this.dx / 2.0 - Math.cos(0.7853981633974483) * (double)this.dx / 2.0)), (float)this.dy - (float)this.dy / 5.0f + (float)this.font.getSize() / 2.0f);
        tmp = String.valueOf(this.base);
        this.gbiText.drawString(tmp, (float)(2.0 + ((double)this.dx / 2.0 - Math.cos(0.7853981633974483) * (double)this.dx / 2.0)), (float)this.dy - (float)this.dy / 5.0f + (float)this.font.getSize() / 2.0f);
        double div = this.tics;
        if (this.subtics == 10) {
            div *= 2.0;
        }
        for (double ii = 1.0; ii < div; ii += 1.0) {
            int value = this.base + this.subtics * (int)ii;
            double ang0 = 0.5235987755982988;
            if (this.subtics == 5) {
                ang0 += 2.0 * ii * Math.PI / (double)(this.tics + 1);
                value = this.base + 2 * this.subtics * (int)ii;
            } else {
                ang0 += ii * Math.PI / (double)(this.tics + 1);
            }
            tmp = String.valueOf(value);
            sw = ii < div / 2.0 ? 0 : (ii == div / 2.0 ? fm.stringWidth(tmp) / 2 : fm.stringWidth(tmp));
            int dx0 = (int)((double)this.dx / 2.0 - Math.sin(ang0) * ((double)this.dx / 2.0));
            int dy0 = (int)((double)this.dy / 2.0 + Math.cos(ang0) * ((double)this.dy / 2.0 - (double)this.dy / 10.0));
            dy0 = ii <= div / 2.0 ? (dy0 += this.font.getSize() / 2) : (dy0 -= this.font.getSize() / 2);
            this.gbiText.drawString(tmp, dx0 -= sw, dy0);
        }
        Rectangle2D.Double recCenter = new Rectangle2D.Double((double)this.dx / 2.0 - DDX / 21.0, (double)this.dx / 2.0 - DDX / 21.0, DDX / 10.5, DDX / 10.5);
        this.arc2DSubTics = new Arc2D.Double(recCenter, 0.0, 360.0, 1);
        double cy = ((RectangularShape)recCenter).getY() + ((RectangularShape)recCenter).getHeight() / 2.0;
        double radius = ((RectangularShape)rect2DH).getY() - cy;
        Rectangle2D.Double rec2DSec = new Rectangle2D.Double((double)this.dx / 2.0 - DDX / 200.0, (double)this.dx / 2.0 - DDX / 10.0, DDX / 100.0, DDX / 10.0 + radius * 0.9);
        this.gbiSubTics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.gbiSubTics.setColor(this.clr_sec);
        double asec = 0.5235987755982988;
        this.gbiSubTics.rotate(asec, (double)this.dx / 2.0, (double)this.dx / 2.0);
        this.gbiSubTics.fill(rec2DSec);
        this.gbiSubTics.fill(this.arc2DSubTics);
        this.gbi.drawImage(this.buffImgTics, null, null);
        this.gbi.drawImage(this.buffImgSubTics, null, null);
        this.gbi.drawImage(this.buffImgText, null, null);
        this.b_paint = false;
    }

    @Override
    public void paint(Graphics graphics) {
        this.drawTacho();
        boolean b_point = false;
        if (this.rect != null && (this.rect.x > 0 || this.rect.y > 0)) {
            b_point = true;
        }
        if (this.getParent() instanceof JPanel) {
            b_point = false;
        }
        if (b_point) {
            graphics.drawImage(this.buffImg, this.rect.x, this.rect.y, null, null);
        } else {
            ((Graphics2D)graphics).drawImage(this.buffImg, null, null);
        }
    }

    public void paint(Graphics graphics, Point point) {
        this.drawTacho();
        graphics.drawImage(this.buffImg, point.x, point.y, null, null);
    }

    public BufferedImage getBufferedImage() {
        return this.buffImg;
    }

    public Graphics2D getGraphics2D() {
        return this.gbi;
    }

    public void destroy() {
        this.b_dispose = true;
    }

    public boolean saveAsPng(String fullPath) {
        boolean b_res = false;
        try {
            File output = new File(fullPath);
            FileOutputStream fos = new FileOutputStream(output);
            ImageIO.write((RenderedImage)this.buffImg, "png", fos);
            b_res = true;
        }
        catch (IOException ioex) {
            System.out.println("Tacho IOException: " + ioex.getMessage());
        }
        return b_res;
    }

    @Override
    public void setBorder(Border border) {
    }

    @Override
    public void setBounds(Rectangle rect) {
        this.rect = rect;
        this.dx = rect.width;
        this.dy = rect.height;
        if (this.dy > this.dx) {
            this.dx = this.dy;
        }
        this.setSize(this.dx, this.dx + 3);
        this.setLocation(rect.x, rect.y);
        this.drawComponent();
    }

    public void setTachoColor(Color color) {
        this.clr_sec = color;
        this.updateUI();
    }

    public void setUnits(String units) {
        this.units = units;
    }

    public void showTachoValue(int value) {
        double val = value;
        if (value < this.base) {
            val = this.base;
        }
        if (value > this.base + 50 * this.tics * this.subtics) {
            val = this.base + 50 * this.tics * this.subtics;
        }
        double tt = this.tics * 10;
        if (this.subtics == 10) {
            tt *= 2.0;
        }
        double unit = 5.235987755982989 / tt;
        double addval = val - (double)this.base;
        double asec = addval * unit;
        this.gbiSubTics.rotate(asec, (double)this.dx / 2.0, (double)this.dx / 2.0);
        if ((this.flags & 1) == 1) {
            int fontSize = (int)(Math.sqrt(this.dx) / 1.3);
            if (fontSize < 6) {
                fontSize = 6;
            } else if (fontSize > 12) {
                fontSize = 12;
            }
            this.font = new Font("Dialog", 0, fontSize);
            this.gbiTics.setFont(this.font);
            String tmp = String.valueOf(value) + " " + this.units;
            FontMetrics fm = this.getFontMetrics(this.font);
            int sw = fm.stringWidth(tmp);
            this.gbiTics.setColor(this.foreground);
            this.gbiTics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.gbiTics.drawString(tmp, this.dx / 2 - sw / 2, (int)((double)(this.dy * 5) / 8.0));
        }
        this.updateUI();
    }

    private void mouseMoved(MouseEvent me) {
    }

    private void mouseReleased(MouseEvent me) {
    }

    class Tacho_MouseAdapter
    extends MouseAdapter {
        Tacho adaptee;

        public Tacho_MouseAdapter(Tacho adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            this.adaptee.mouseReleased(me);
        }
    }

    class Tacho_MouseMotionAdapter
    extends MouseMotionAdapter {
        Tacho adaptee;

        public Tacho_MouseMotionAdapter(Tacho adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void mouseMoved(MouseEvent me) {
            this.adaptee.mouseMoved(me);
        }
    }
}

