/*
 * Decompiled with CFR 0.152.
 */
package privatecomponents;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class Tacho90
extends JPanel {
    protected boolean refreshBit = false;
    int dx = 200;
    int dy = 200;
    int mx = 15;
    int my = 15;
    final int CRH = 3;
    Dimension dim = null;
    Rectangle rect = null;
    BufferedImage buffImg = null;
    Graphics2D gbi;
    BufferedImage buffImgHM;
    Graphics2D gbiHM;
    BufferedImage buffImgTxt;
    Graphics2D gbiTxt;
    BufferedImage buffImgSec;
    Graphics2D gbiSec;
    Arc2D arc2DSec;
    BufferedImage buffImgSec2;
    Graphics2D gbiSec2;
    double amax = -1.0;
    Point2D pt2D;
    Color background = Color.white;
    Color foreground = Color.black;
    Color clr_sec = new Color(255, 126, 0);
    Color clr_txt;
    Color clr_sec2 = new Color(255, 175, 100);
    Font font = new Font("Dialog", 0, 11);
    Font txtFont;
    int floor = 0;
    int div = 15;
    String units = "";
    boolean b_max = false;
    boolean b_paint = true;
    boolean b_dispose = false;
    int flags = 0;

    public Tacho90() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            System.out.println("Tacho90: " + ex);
        }
    }

    public Tacho90(int floor, int div) {
        this.floor = floor;
        this.div = div;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            System.out.println("Tacho90: " + ex);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(null);
        this.setOpaque(true);
        this.setBounds(new Rectangle(0, 0, this.dx, this.dy));
        this.addMouseListener(new Tacho_MouseAdapter(this));
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2p = (Graphics2D)g.create();
        System.out.println("Tacho90.paintComponent");
    }

    private void drawComponent() {
        this.buffImg = new BufferedImage(this.dx, this.dx, 2);
        this.gbi = this.buffImg.createGraphics();
        this.gbi.setColor(new Color(1.0f, 1.0f, 1.0f, 0.0f));
        this.gbi.fillRect(0, 0, this.dx, this.dx);
        this.buffImgHM = new BufferedImage(this.dx, this.dx, 2);
        this.gbiHM = this.buffImgHM.createGraphics();
        this.buffImgTxt = new BufferedImage(this.dx, this.dx, 2);
        this.gbiTxt = this.buffImgTxt.createGraphics();
        this.buffImgSec = new BufferedImage(this.dx, this.dx, 2);
        this.gbiSec = this.buffImgSec.createGraphics();
        this.buffImgSec2 = new BufferedImage(this.dx, this.dx, 2);
        this.gbiSec2 = this.buffImgSec2.createGraphics();
    }

    public void setBackgroundColor(Color background) {
        this.background = background;
        this.drawTacho();
    }

    public void setForegroundColor(Color foreground) {
        this.foreground = foreground;
        this.drawTacho();
    }

    public void setTextColor(Color color) {
        this.clr_txt = color;
        this.updateUI();
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
        if ((flags & 2) == 2) {
            this.foreground = Color.white;
            this.background = Color.black;
        }
        this.repaint();
    }

    protected void setPaintFlag(boolean b_paint) {
        this.b_paint = b_paint;
    }

    protected void drawTacho() {
        if (!this.b_paint) {
            return;
        }
        int fontSize = (int)(Math.sqrt(this.dx) / 1.2);
        if (fontSize < 6) {
            fontSize = 6;
        } else if (fontSize > 12) {
            fontSize = 12;
        }
        this.font = new Font("Dialog", 0, fontSize);
        FontMetrics fm = this.getFontMetrics(this.font);
        int sw = fm.stringWidth(String.valueOf(this.floor + 4 * this.div));
        double DDX = this.dx - sw;
        Rectangle2D.Double recCenter = new Rectangle2D.Double(this.pt2D.getX() - DDX / 21.0, this.pt2D.getY() - DDX / 21.0, DDX / 10.5, DDX / 10.5);
        this.gbi.setColor(this.background);
        this.gbi.fillRect(0, 0, this.dx, this.dx);
        Rectangle2D.Double rect2DH = new Rectangle2D.Double(this.pt2D.getX() - DDX / 100.0, DDX / 5.0 + 3.0 - DDX / 24.0, DDX / 80.0, DDX / 12.0);
        Rectangle2D.Double rect2DM = new Rectangle2D.Double(this.pt2D.getX() - DDX / 100.0, DDX / 5.0 + 3.0, DDX / 160.0, DDX / 25.0);
        this.gbiHM.setColor(this.foreground);
        this.gbiHM.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.gbiHM.setFont(this.font);
        for (int ii = 0; ii <= 30; ++ii) {
            if (ii % 5 == 0) {
                this.gbiHM.fill(rect2DH);
            } else if (this.dx >= 50) {
                this.gbiHM.fill(rect2DM);
            }
            this.gbiHM.rotate(-0.05235987755982988, this.pt2D.getX(), this.pt2D.getY());
        }
        this.gbiTxt.setFont(this.font);
        this.gbiTxt.setColor(this.foreground);
        this.gbiTxt.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double cy = ((RectangularShape)recCenter).getY() + ((RectangularShape)recCenter).getHeight() / 2.0;
        double radius = ((RectangularShape)rect2DH).getY() - cy;
        String tmp = String.valueOf(this.floor);
        sw = fm.stringWidth(tmp);
        this.gbiTxt.drawString(tmp, (int)(this.pt2D.getX() - DDX / 200.0 + radius - DDX / 12.0 - (double)sw), (int)(this.pt2D.getY() + (double)fontSize / 2.0));
        for (double ii = 1.0; ii <= 6.0; ii += 1.0) {
            tmp = String.valueOf((int)((double)this.floor + ii * (double)this.div));
            sw = fm.stringWidth(tmp);
            double dxh = (radius - DDX / 13.0 - (double)sw) * Math.cos(0.2617993877991494 * ii);
            double dyh = (radius - DDX / 10.0 + (double)fontSize / 2.0) * Math.sin(0.2617993877991494 * ii);
            this.gbiTxt.drawString(tmp, (int)(this.pt2D.getX() - DDX / 200.0 + dxh), (int)(this.pt2D.getY() + dyh));
        }
        tmp = String.valueOf(this.floor + 2 * this.div);
        sw = fm.stringWidth(tmp);
        double yh = this.pt2D.getY() - ((RectangularShape)recCenter).getHeight() / 2.0 - Math.sin(0.5235987755982988) * radius;
        this.gbiTxt.drawString(tmp, (int)(radius - (double)sw + Math.sin(yh)), (int)yh);
        this.arc2DSec = new Arc2D.Double(recCenter, 0.0, 360.0, 1);
        Rectangle2D.Double rec2DSec = new Rectangle2D.Double(this.pt2D.getX() - DDX / 200.0, this.pt2D.getY() - DDX / 10.0, DDX / 100.0, DDX / 10.0 + -radius * 0.82);
        this.gbiSec.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.gbiSec.setColor(this.clr_sec);
        double asec = Math.PI;
        this.gbiSec.rotate(asec, this.pt2D.getX(), this.pt2D.getY());
        this.gbiSec.fill(rec2DSec);
        this.gbiSec.fill(this.arc2DSec);
        Rectangle2D.Double rec2DSec2 = new Rectangle2D.Double(this.pt2D.getX() - DDX / 200.0, this.pt2D.getY() - DDX / 1.85, DDX / 100.0, DDX / 15.0 - radius * 0.01);
        this.gbiSec2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.gbiSec2.setColor(this.clr_sec2);
        this.gbiSec2.rotate(-asec / 2.0, this.pt2D.getX(), this.pt2D.getY());
        if (this.amax >= 0.0) {
            if (this.b_max) {
                for (double ii = 0.0; ii < 12.0 * (double)this.div * this.amax / Math.PI; ii += 1.0) {
                    this.gbiSec2.rotate(Math.PI / (12.0 * (double)this.div), this.pt2D.getX(), this.pt2D.getY());
                    this.gbiSec2.fill(rec2DSec2);
                }
            } else {
                this.gbiSec2.rotate(this.amax, this.pt2D.getX(), this.pt2D.getY());
                this.gbiSec2.fill(rec2DSec2);
            }
        }
        this.gbi.drawImage(this.buffImgHM, null, null);
        this.gbi.drawImage(this.buffImgTxt, null, null);
        this.gbi.drawImage(this.buffImgSec, null, null);
        if (this.amax >= 0.0) {
            this.gbi.drawImage(this.buffImgSec2, null, null);
        }
        this.b_paint = false;
    }

    @Override
    public void paint(Graphics graphics) {
        this.drawTacho();
        boolean b_point = false;
        if (this.rect != null && (this.rect.x > 0 || this.rect.y > 0)) {
            b_point = true;
        }
        if (this.getParent() instanceof JPanel) {
            b_point = false;
        }
        if (b_point) {
            graphics.drawImage(this.buffImg, this.rect.x, this.rect.y, null, null);
        } else {
            ((Graphics2D)graphics).drawImage(this.buffImg, null, null);
        }
    }

    public void paint(Graphics graphics, Point point) {
        this.drawTacho();
        graphics.drawImage(this.buffImg, point.x, point.y, null, null);
    }

    public BufferedImage getBufferedImage() {
        BufferedImage bi = new BufferedImage(this.dx, this.dy, 2);
        Graphics2D g2d = bi.createGraphics();
        g2d.drawImage((Image)this.buffImg, this.dx, 0, null);
        return bi;
    }

    public Graphics2D getGraphics2D() {
        return this.gbi;
    }

    public void destroy() {
        this.b_dispose = true;
    }

    public boolean saveAsPng(String fullPath) {
        boolean b_res = false;
        try {
            File output = new File(fullPath);
            FileOutputStream fos = new FileOutputStream(output);
            ImageIO.write((RenderedImage)this.buffImg, "png", fos);
            b_res = true;
        }
        catch (IOException ioex) {
            System.out.println("Tacho IOException: " + ioex.getMessage());
        }
        return b_res;
    }

    @Override
    public void setBorder(Border border) {
    }

    @Override
    public void setBounds(Rectangle rect) {
        this.rect = rect;
        this.dx = rect.width;
        this.dy = rect.height;
        if (this.dy > this.dx) {
            this.dx = this.dy;
        }
        this.setSize(this.dx, this.dx + 3);
        this.setLocation(rect.x, rect.y);
        this.pt2D = new Point2D.Double((double)this.dx * 4.0 / 5.0, (double)this.dy * 4.0 / 5.0);
        this.drawComponent();
    }

    public void setMaximaMode(boolean b_max) {
        this.b_max = b_max;
    }

    public void setTachoColor(Color color) {
        this.clr_sec = color;
        this.updateUI();
    }

    public void setMaximaTachoColor(Color color) {
        this.clr_sec2 = color;
        this.updateUI();
    }

    public void setTextFont(Font txtFont) {
        this.txtFont = txtFont;
        this.updateUI();
    }

    public void setUnits(String units) {
        this.units = units;
    }

    public void showTachoValue(double value) {
        this.showTachoValue(value, null);
    }

    public void showTachoValue(double value, String format) {
        double val = value;
        if (value < 0.0) {
            val = 0.0;
        }
        if (value > (double)(6 * this.div)) {
            val = 6 * this.div;
        }
        double unit = Math.PI / (2.0 * (double)(6 * this.div));
        double diffval = (double)(6 * this.div) - val;
        double asec = diffval * unit;
        this.gbiSec.rotate(-asec, this.pt2D.getX(), this.pt2D.getY());
        if ((this.flags & 1) == 1) {
            int fontSize = (int)(Math.sqrt(this.dx) / 1.2);
            if (fontSize < 6) {
                fontSize = 6;
            } else if (fontSize > 12) {
                fontSize = 12;
            }
            this.font = fontSize < 8 ? new Font("Dialog", 0, fontSize + 1) : new Font("Dialog", 0, fontSize);
            if (this.txtFont == null) {
                this.gbiTxt.setFont(this.font);
            } else {
                this.gbiTxt.setFont(this.txtFont);
                fontSize = this.txtFont.getSize();
            }
            String tmp = "";
            Locale locale = new Locale("FRA", "CH");
            tmp = format == null ? String.format(locale, "%.1f %s", value, this.units) : String.format(locale, format + " %s", value, this.units);
            FontMetrics fm = this.getFontMetrics(this.font);
            int sw = fm.stringWidth(tmp);
            if (this.clr_txt == null) {
                this.gbiTxt.setColor(this.foreground);
            } else {
                this.gbiTxt.setColor(this.clr_txt);
            }
            this.gbiTxt.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.amax >= 0.0) {
                this.gbiTxt.drawString(tmp, 4, (int)(this.pt2D.getY() + (double)this.dy / 9.0 + (double)fontSize / 2.0));
            } else {
                this.gbiTxt.drawString(tmp, (int)((double)this.dx / 2.0 - (double)(sw / 2)), (int)(this.pt2D.getY() + (double)this.dy / 9.0 + (double)fontSize / 2.0));
            }
        }
        this.updateUI();
    }

    public void showTachoMaxima(double value) {
        this.showTachoMaxima(value, null);
    }

    public void showTachoMaxima(double value, String format) {
        double val = value;
        if (value < 0.0) {
            val = 0.0;
        }
        if (value > (double)(6 * this.div)) {
            val = 6 * this.div;
        }
        double unit = Math.PI / (2.0 * (double)(6 * this.div));
        double diffval = (double)(6 * this.div) - val;
        double asec = diffval * unit;
        this.amax = 1.5707963267948966 - asec;
        if ((this.flags & 1) == 1) {
            int fontSize = (int)(Math.sqrt(this.dx) / 1.2);
            if (fontSize < 6) {
                fontSize = 6;
            } else if (fontSize > 12) {
                fontSize = 12;
            }
            this.font = fontSize < 8 ? new Font("Dialog", 0, fontSize + 1) : new Font("Dialog", 0, fontSize);
            if (this.txtFont == null) {
                this.gbiTxt.setFont(this.font);
            } else {
                this.gbiTxt.setFont(this.txtFont);
                fontSize = this.txtFont.getSize();
            }
            String tmp = "";
            Locale locale = new Locale("FRA", "CH");
            tmp = format == null ? String.format(locale, "%.1f %s", value, this.units) : String.format(locale, format + " %s", value, this.units);
            FontMetrics fm = this.getFontMetrics(this.font);
            int sw = fm.stringWidth(tmp);
            this.gbiTxt.setColor(this.clr_sec2);
            this.gbiTxt.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.gbiTxt.drawString(tmp, (int)((double)this.dx - 2.0 - (double)sw), (int)(this.pt2D.getY() + (double)this.dy / 9.0 + (double)fontSize / 2.0));
        }
        this.updateUI();
    }

    private void mouseMoved(MouseEvent me) {
    }

    private void mouseReleased(MouseEvent me) {
    }

    class Tacho_MouseAdapter
    extends MouseAdapter {
        Tacho90 adaptee;

        public Tacho_MouseAdapter(Tacho90 adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            this.adaptee.mouseReleased(me);
        }
    }

    class Tacho_MouseMotionAdapter
    extends MouseMotionAdapter {
        Tacho90 adaptee;

        public Tacho_MouseMotionAdapter(Tacho90 adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void mouseMoved(MouseEvent me) {
            this.adaptee.mouseMoved(me);
        }
    }
}

