/*
 * Decompiled with CFR 0.152.
 */
package privatecomponents;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Arc2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class Windrose
extends JPanel {
    protected boolean refreshBit = false;
    int dx = 200;
    int dy = 200;
    int mx = 15;
    int my = 15;
    final int CRH = 3;
    Dimension dim = null;
    Rectangle rect = null;
    BufferedImage buffImg = null;
    Graphics2D gbi;
    BufferedImage buffImgHM;
    Graphics2D gbiHM;
    BufferedImage buffImgTxt;
    Graphics2D gbiTxt;
    BufferedImage buffImgSec;
    Graphics2D gbiSec;
    Arc2D arc2DSec;
    Color background = Color.white;
    Color foreground = Color.black;
    Color txtfg;
    Color clr_sec = new Color(255, 126, 0);
    Font font = new Font("Dialog", 0, 11);
    int fontSizeTxt = 0;
    String[] txt_wr = new String[]{"N", "NE", "E", "SE", "S", "SW", "W", "NW"};
    double[][] wr = new double[][]{{3.0, 7.0, 7.0, 6.0, 1.0, 3.4, 6.0, 3.5}, {10.0, 5.0, 1.0, 8.0, 6.0, 10.0, 1.0, 5.0}};
    boolean b_paint = true;
    boolean b_dispose = false;
    int flags = 0;

    public Windrose() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            System.out.println("Tacho: " + ex);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(null);
        this.setOpaque(true);
        this.setBounds(new Rectangle(0, 0, this.dx, this.dy));
        this.addMouseListener(new Tacho_MouseAdapter(this));
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2p = (Graphics2D)g.create();
        System.out.println("Windrose.paintComponent");
    }

    private void drawComponent() {
        this.buffImg = new BufferedImage(this.dx, this.dx, 2);
        this.gbi = this.buffImg.createGraphics();
        this.gbi.setColor(new Color(1.0f, 1.0f, 1.0f, 0.0f));
        this.gbi.fillRect(0, 0, this.dx, this.dx);
        this.buffImgHM = new BufferedImage(this.dx, this.dx, 2);
        this.gbiHM = this.buffImgHM.createGraphics();
        this.buffImgTxt = new BufferedImage(this.dx, this.dx, 2);
        this.gbiTxt = this.buffImgTxt.createGraphics();
        this.buffImgSec = new BufferedImage(this.dx, this.dx, 2);
        this.gbiSec = this.buffImgSec.createGraphics();
    }

    public void setBackgroundColor(Color background) {
        this.background = background;
    }

    public void setValueForegroundColor(Color txtColor) {
        this.txtfg = txtColor;
    }

    public void setForegroundColor(Color foreground) {
        this.foreground = foreground;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
        if ((flags & 2) == 2) {
            this.foreground = Color.white;
            this.background = Color.black;
        }
        this.repaint();
    }

    protected void setPaintFlag(boolean b_paint) {
        this.b_paint = b_paint;
    }

    protected void drawWindrose() {
        if (!this.b_paint) {
            return;
        }
        int fontSize = (int)(Math.sqrt(this.dx) / 1.1);
        if (fontSize < 7) {
            fontSize = 7;
        } else if (fontSize > 12) {
            fontSize = 12;
        }
        this.font = new Font("Dialog", 0, fontSize);
        FontMetrics fm = this.getFontMetrics(this.font);
        double DDX = this.dx - 2 * fontSize;
        this.gbi.setColor(this.background);
        this.gbi.fillRect(0, 0, this.dx, this.dx);
        Rectangle2D.Double rect2DH = new Rectangle2D.Double((double)this.dx / 2.0 - DDX / 160.0, DDX - DDX / 16.0, DDX / 80.0, DDX / 12.0);
        Rectangle2D.Double rect2DM = new Rectangle2D.Double((double)this.dx / 2.0 - DDX / 320.0, DDX - DDX / 16.0, DDX / 160.0, DDX / 25.0);
        this.gbiHM.setColor(this.foreground);
        this.gbiHM.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.gbiHM.setFont(this.font);
        for (int ii = 0; ii < 16; ++ii) {
            if (ii % 2 == 0) {
                this.gbiHM.fill(rect2DH);
            } else if (this.dx >= 50) {
                this.gbiHM.fill(rect2DM);
            }
            this.gbiHM.rotate(0.39269908169872414, this.dx / 2, this.dy / 2);
        }
        this.gbiTxt.setFont(this.font);
        this.gbiTxt.setColor(this.foreground);
        this.gbiTxt.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double radius = ((RectangularShape)rect2DH).getY() - (double)this.dy / 2.0;
        String tmp = this.txt_wr[0];
        int sw = fm.stringWidth(tmp);
        this.gbiTxt.drawString(tmp, (float)((double)this.dx / 2.0 - (double)((float)sw / 2.0f)), (float)(this.dx / 10));
        for (int ii = 1; ii < 8; ++ii) {
            tmp = this.txt_wr[ii];
            sw = fm.stringWidth(tmp);
            double dxh = (radius + DDX / this.wr[0][ii]) * Math.cos(0.7853981633974483 * (double)ii - 1.5707963267948966);
            double dyh = (radius + DDX / this.wr[1][ii]) * Math.sin(0.7853981633974483 * (double)ii - 1.5707963267948966) + (double)fontSize / 2.0;
            if (ii < 4) {
                this.gbiTxt.drawString(tmp, (int)((double)this.dx / 2.0 - DDX / 200.0 + dxh) + sw / 2, (int)((double)this.dy / 2.0 + dyh));
                continue;
            }
            this.gbiTxt.drawString(tmp, (int)((double)this.dx / 2.0 - DDX / 200.0 + dxh) - sw / 2, (int)((double)this.dy / 2.0 + dyh));
        }
        if (this.fontSizeTxt == 0) {
            this.fontSizeTxt = fontSize;
        }
        double diam = (double)this.fontSizeTxt * 2.7;
        Rectangle2D.Double recCenter = new Rectangle2D.Double((double)this.dx / 2.0 - diam / 2.0, (double)this.dx / 2.0 - diam / 2.0, diam, diam);
        this.arc2DSec = new Arc2D.Double(recCenter, 0.0, 360.0, 1);
        Rectangle2D.Double rec2DSec = new Rectangle2D.Double((double)this.dx / 2.0 - DDX / 200.0, (double)this.dx / 2.0 - DDX / 5.0, DDX / 100.0, DDX / 5.0 + radius * 0.92);
        this.gbiSec.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.gbiSec.setColor(this.clr_sec);
        double asec = Math.PI;
        this.gbiSec.rotate(asec, (double)this.dx / 2.0, (double)this.dx / 2.0);
        this.gbiSec.fill(rec2DSec);
        if (this.dx > 100) {
            BasicStroke stroke = new BasicStroke((float)this.dx / 100.0f);
            this.gbiSec.setStroke(stroke);
        }
        this.gbiSec.setColor(this.background);
        this.gbiSec.fill(this.arc2DSec);
        this.gbiSec.setColor(this.clr_sec);
        this.gbiSec.draw(this.arc2DSec);
        this.gbi.drawImage(this.buffImgHM, null, null);
        this.gbi.drawImage(this.buffImgSec, null, null);
        this.gbi.drawImage(this.buffImgTxt, null, null);
        this.b_paint = false;
    }

    @Override
    public void paint(Graphics graphics) {
        this.drawWindrose();
        boolean b_point = false;
        if (this.rect != null && (this.rect.x > 0 || this.rect.y > 0)) {
            b_point = true;
        }
        if (this.getParent() instanceof JPanel) {
            b_point = false;
        }
        if (b_point) {
            graphics.drawImage(this.buffImg, this.rect.x, this.rect.y, null, null);
        } else {
            ((Graphics2D)graphics).drawImage(this.buffImg, null, null);
        }
    }

    public void paint(Graphics graphics, Point point) {
        this.drawWindrose();
        graphics.drawImage(this.buffImg, point.x, point.y, null, null);
    }

    public BufferedImage getBufferedImage() {
        BufferedImage bi = new BufferedImage(this.dx, this.dy, 2);
        Graphics2D g2d = bi.createGraphics();
        g2d.drawImage((Image)this.buffImg, this.dx, 0, null);
        return bi;
    }

    public Graphics2D getGraphics2D() {
        return this.gbi;
    }

    public void destroy() {
        this.b_dispose = true;
    }

    public boolean saveAsPng(String fullPath) {
        boolean b_res = false;
        try {
            File output = new File(fullPath);
            FileOutputStream fos = new FileOutputStream(output);
            ImageIO.write((RenderedImage)this.buffImg, "png", fos);
            b_res = true;
        }
        catch (IOException ioex) {
            System.out.println("Windrose IOException: " + ioex.getMessage());
        }
        return b_res;
    }

    @Override
    public void setBounds(Rectangle rect) {
        this.rect = rect;
        this.dx = rect.width;
        this.dy = rect.height;
        if (this.dy > this.dx) {
            this.dx = this.dy;
        }
        this.setSize(this.dx, this.dx + 3);
        this.setLocation(rect.x, rect.y);
        this.drawComponent();
    }

    public void setTachoColor(Color color) {
        this.clr_sec = color;
        this.updateUI();
    }

    public void showWindroseValue(int value) {
        double val = value;
        boolean b_error = false;
        if (value < 0) {
            val = 0.0;
            b_error = true;
        }
        if (value > 360) {
            val = 360.0;
            b_error = true;
        }
        double asec = Math.PI * 2 * val / 360.0;
        this.gbiSec.rotate(asec, (double)this.dx / 2.0, (double)this.dx / 2.0);
        if ((this.flags & 1) == 1) {
            this.fontSizeTxt = (int)(Math.sqrt(this.dx) / 1.2);
            if (this.fontSizeTxt < 7) {
                this.fontSizeTxt = 7;
            } else if (this.fontSizeTxt > 12) {
                this.fontSizeTxt = 12;
            }
            this.font = new Font("Dialog", 0, this.fontSizeTxt);
            this.gbiTxt.setFont(this.font);
            String tmp = String.format("%3.0f", val) + "\u00b0";
            if (b_error) {
                tmp = value <= 0 ? "-X" : (value >= 360 ? "+X" : "X");
            }
            FontMetrics fm = this.getFontMetrics(this.font);
            int sw = fm.stringWidth(tmp);
            this.gbiTxt.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.txtfg == null) {
                if (b_error) {
                    this.gbiTxt.setColor(Color.red);
                } else {
                    this.gbiTxt.setColor(this.foreground);
                }
            } else {
                this.gbiTxt.setColor(this.txtfg);
            }
            this.gbiTxt.drawString(tmp, this.dx / 2 - sw / 2, this.dy / 2 + this.fontSizeTxt / 2 - 1);
        }
        this.updateUI();
    }

    private void mouseMoved(MouseEvent me) {
    }

    private void mouseReleased(MouseEvent me) {
    }

    class Tacho_MouseAdapter
    extends MouseAdapter {
        Windrose adaptee;

        public Tacho_MouseAdapter(Windrose adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            this.adaptee.mouseReleased(me);
        }
    }

    class Tacho_MouseMotionAdapter
    extends MouseMotionAdapter {
        Windrose adaptee;

        public Tacho_MouseMotionAdapter(Windrose adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void mouseMoved(MouseEvent me) {
            this.adaptee.mouseMoved(me);
        }
    }
}

