/*
 * Decompiled with CFR 0.152.
 */
package scy;

import enercad2007.Globals;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class AddressMACInfo {
    public static final void main(String[] args) {
        try {
            new AddressMACInfo().getInfo();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void getInfo() {
        Globals.println("Information R\u00e9seau Local");
        Globals.println("Syst\u00e8me d'exploitation : " + System.getProperty("os.name"));
        try {
            Globals.println("IP/Localhost: " + InetAddress.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException uhex) {
            Globals.println("IP/Localhost substitution: localhost");
        }
        try {
            Globals.println("Adresse MAC : " + AddressMACInfo.getMacAddress());
        }
        catch (IOException ioex) {
            Globals.println("Could not retrieve MAC address");
        }
    }

    public static final String getMacAddress() throws IOException {
        String os = System.getProperty("os.name");
        try {
            if (os.startsWith("Windows")) {
                return AddressMACInfo.windowsParseMacAddress(AddressMACInfo.windowsRunIpConfigCommand());
            }
            if (os.startsWith("Linux")) {
                return AddressMACInfo.linuxParseMacAddress(AddressMACInfo.linuxRunIfConfigCommand());
            }
            if (os.startsWith("Mac OS X")) {
                return AddressMACInfo.osxParseMacAddress(AddressMACInfo.osxRunIfConfigCommand());
            }
            throw new IOException("Syst\u00e8me d'exploitation non support\u00e9 : " + os);
        }
        catch (ParseException ex) {
            ex.printStackTrace();
            throw new IOException(ex.getMessage());
        }
    }

    public final String[] getMacAddresses() throws IOException {
        String os = System.getProperty("os.name");
        try {
            if (os.startsWith("Windows")) {
                return this.getMacAddressesForWindows(AddressMACInfo.windowsRunIpConfigCommand());
            }
            if (os.startsWith("Linux")) {
                return this.getMacAddressesForLinux(AddressMACInfo.linuxRunIfConfigCommand());
            }
            if (os.startsWith("Mac OS X")) {
                return this.getMacAddressesForApple(AddressMACInfo.osxRunIfConfigCommand());
            }
            throw new IOException("Syst\u00e8me d'exploitation non support\u00e9 : " + os);
        }
        catch (ParseException ex) {
            ex.printStackTrace();
            throw new IOException(ex.getMessage());
        }
    }

    private static final String getMacAddressHelper() {
        String res = "";
        try {
            Globals.println("Getting mac address from AddressMACInfo.getMacAddressHelper.");
            Enumeration<NetworkInterface> iterNetwork = NetworkInterface.getNetworkInterfaces();
            while (iterNetwork.hasMoreElements()) {
                NetworkInterface network = iterNetwork.nextElement();
                if (!network.isUp()) continue;
                if (network.isLoopback()) {
                    res = "localhost";
                    continue;
                }
                Enumeration<InetAddress> iterAddress = network.getInetAddresses();
                while (iterAddress.hasMoreElements()) {
                    InetAddress address = iterAddress.nextElement();
                    if (address.isAnyLocalAddress() || address.isLoopbackAddress() || address.isMulticastAddress()) continue;
                    res = address.getHostAddress();
                }
            }
        }
        catch (SocketException sex) {
            System.out.println("AddressMACInfo.getMacAddressHelper: " + sex.getMessage());
        }
        return res;
    }

    public static final String getUniqueMacAddress() {
        String os = System.getProperty("os.name");
        if (os.startsWith("Windows")) {
            return AddressMACInfo.getMacAddressForOS("-");
        }
        if (os.startsWith("Linux")) {
            return AddressMACInfo.getMacAddressForOS(":");
        }
        if (os.startsWith("Mac OS X")) {
            return AddressMACInfo.getMacAddressForOS(":");
        }
        return "Error: os not supported.";
    }

    private static final String windowsRunIpConfigCommand() throws IOException {
        int c;
        Process p = Runtime.getRuntime().exec("ipconfig /all");
        BufferedInputStream stdoutStream = new BufferedInputStream(p.getInputStream());
        StringBuffer buffer = new StringBuffer();
        while ((c = ((InputStream)stdoutStream).read()) != -1) {
            buffer.append((char)c);
        }
        String outputText = buffer.toString();
        ((InputStream)stdoutStream).close();
        return outputText;
    }

    private static final String linuxRunIfConfigCommand() {
        String outputText;
        Process process;
        block10: {
            process = null;
            outputText = null;
            try {
                process = Runtime.getRuntime().exec("ifconfig");
            }
            catch (IOException ioEx) {
                String absolutePath = "/sbin/ifconfig";
                File file = new File(absolutePath);
                if (!file.exists()) break block10;
                try {
                    process = Runtime.getRuntime().exec(absolutePath);
                }
                catch (IOException ioEx2) {
                    Globals.println(ioEx2.getMessage());
                }
            }
        }
        if (process == null) {
            try {
                process = Runtime.getRuntime().exec("ip a");
            }
            catch (IOException ioEx3) {
                Globals.println(ioEx3.getMessage());
            }
        }
        BufferedInputStream stdoutStream = new BufferedInputStream(process.getInputStream());
        StringBuffer buffer = new StringBuffer();
        try {
            int cc;
            while ((cc = ((InputStream)stdoutStream).read()) != -1) {
                buffer.append((char)cc);
            }
            outputText = buffer.toString();
            ((InputStream)stdoutStream).close();
        }
        catch (IOException ioEx) {
            Globals.println("linuxRinIfComfigCommand: " + ioEx.getMessage());
        }
        return outputText;
    }

    private static final String osxRunIfConfigCommand() throws IOException {
        int c;
        Process p = Runtime.getRuntime().exec("ifconfig");
        BufferedInputStream stdoutStream = new BufferedInputStream(p.getInputStream());
        StringBuffer buffer = new StringBuffer();
        while ((c = ((InputStream)stdoutStream).read()) != -1) {
            buffer.append((char)c);
        }
        String outputText = buffer.toString();
        ((InputStream)stdoutStream).close();
        return outputText;
    }

    private static final String windowsParseMacAddress(String ipConfigResponse) throws ParseException {
        String localHost = "localhost";
        try {
            localHost = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        StringTokenizer tokenizer = new StringTokenizer(ipConfigResponse, "\n");
        String lastMacAddress = null;
        while (tokenizer.hasMoreTokens()) {
            String macAddressCandidate;
            String line = tokenizer.nextToken().trim();
            if (lastMacAddress != null) {
                return lastMacAddress;
            }
            int macAddressPosition = line.indexOf(":");
            if (macAddressPosition <= 0 || !AddressMACInfo.windowsIsMacAddress(macAddressCandidate = line.substring(macAddressPosition + 1).trim())) continue;
            lastMacAddress = macAddressCandidate;
        }
        return lastMacAddress;
    }

    private final String[] getMacAddressesForWindows(String ipConfigResponse) throws ParseException {
        Vector<String> macs = new Vector<String>(2);
        StringTokenizer tokenizer = new StringTokenizer(ipConfigResponse, "\n");
        while (tokenizer.hasMoreTokens()) {
            String macAddressCandidate;
            String line = tokenizer.nextToken().trim();
            int macAddressPosition = line.indexOf(":");
            if (macAddressPosition <= 0 || !AddressMACInfo.windowsIsMacAddress(macAddressCandidate = line.substring(macAddressPosition + 1).trim())) continue;
            macs.add(macAddressCandidate);
        }
        String[] ma = new String[macs.size()];
        return macs.toArray(ma);
    }

    private static final String linuxParseMacAddress(String ipConfigResponse) throws ParseException {
        int macAddressPosition;
        String line;
        String localHost = "localhost";
        try {
            localHost = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        StringTokenizer tokenizer = new StringTokenizer(ipConfigResponse, "\n");
        String lastMacAddress = null;
        while (tokenizer.hasMoreTokens()) {
            String macAddressCandidate;
            line = tokenizer.nextToken().trim();
            if (lastMacAddress != null) {
                return lastMacAddress;
            }
            macAddressPosition = line.indexOf("HWaddr");
            if (macAddressPosition <= 0 || !AddressMACInfo.linuxIsMacAddress(macAddressCandidate = line.substring(macAddressPosition + 6).trim())) continue;
            lastMacAddress = macAddressCandidate;
        }
        if (lastMacAddress == null) {
            tokenizer = new StringTokenizer(ipConfigResponse, "\n");
            while (tokenizer.hasMoreTokens()) {
                int start;
                String macAddressCandidate;
                line = tokenizer.nextToken().trim();
                if (lastMacAddress != null) {
                    return lastMacAddress;
                }
                macAddressPosition = line.indexOf("link/ether");
                if (macAddressPosition < 0 || !AddressMACInfo.linuxIsMacAddress(macAddressCandidate = line.substring(start = macAddressPosition + 11, start + 17).trim())) continue;
                lastMacAddress = macAddressCandidate;
            }
        }
        return lastMacAddress;
    }

    private final String[] getMacAddressesForLinux(String ipConfigResponse) throws ParseException {
        Vector<String> macs = new Vector<String>(2);
        StringTokenizer tokenizer = new StringTokenizer(ipConfigResponse, "\n");
        while (tokenizer.hasMoreTokens()) {
            String macAddressCandidate;
            String line = tokenizer.nextToken().trim();
            int macAddressPosition = line.indexOf("HWaddr");
            if (macAddressPosition <= 0 || !AddressMACInfo.linuxIsMacAddress(macAddressCandidate = line.substring(macAddressPosition + 6).trim())) continue;
            macs.add(macAddressCandidate);
        }
        String[] ma = new String[macs.size()];
        return macs.toArray(ma);
    }

    private static final String getMacAddressForOS(String ip_sep) {
        String ip_str;
        InetAddress ip = null;
        String res = "";
        try {
            ip = InetAddress.getLocalHost();
        }
        catch (UnknownHostException uhex) {
            ip_str = AddressMACInfo.getMacAddressHelper();
            try {
                ip = InetAddress.getByName(ip_str);
            }
            catch (UnknownHostException uhex2) {
                Globals.println(uhex2.getMessage());
            }
        }
        try {
            byte[] mac;
            NetworkInterface network = NetworkInterface.getByInetAddress(ip);
            if (network == null) {
                ip_str = AddressMACInfo.getMacAddressHelper();
                try {
                    ip = InetAddress.getByName(ip_str);
                    network = NetworkInterface.getByInetAddress(ip);
                }
                catch (UnknownHostException uhex) {
                    Globals.println(uhex.getMessage());
                }
            }
            if ((mac = network.getHardwareAddress()) != null) {
                StringBuilder sb = new StringBuilder();
                for (int ii = 0; ii < mac.length; ++ii) {
                    sb.append(String.format("%02X%s", mac[ii], ii < mac.length - 1 ? ip_sep : ""));
                }
                res = sb.toString();
            } else {
                try {
                    res = AddressMACInfo.getMacAddress();
                    Globals.println("Mac address retrieved over deprecated function: (" + res + ")");
                }
                catch (IOException iOException) {}
            }
        }
        catch (SocketException sex) {
            System.out.println("AddressMacInfo: " + sex.getMessage());
        }
        return res;
    }

    private static final String osxParseMacAddress(String ipConfigResponse) throws ParseException {
        String localHost = "localhost";
        try {
            localHost = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        StringTokenizer tokenizer = new StringTokenizer(ipConfigResponse, "\n");
        String lastMacAddress = null;
        while (tokenizer.hasMoreTokens()) {
            String macAddressCandidate;
            boolean containsLocalHost;
            String line = tokenizer.nextToken().trim();
            boolean bl = containsLocalHost = line.indexOf(localHost) >= 0;
            if (lastMacAddress != null) {
                return lastMacAddress;
            }
            int macAddressPosition = line.indexOf("ether");
            if (macAddressPosition != 0 || !AddressMACInfo.osxIsMacAddress(macAddressCandidate = line.substring(macAddressPosition + 6).trim())) continue;
            lastMacAddress = macAddressCandidate;
        }
        return lastMacAddress;
    }

    private final String[] getMacAddressesForApple(String ipConfigResponse) throws ParseException {
        Vector<String> macs = new Vector<String>(2);
        StringTokenizer tokenizer = new StringTokenizer(ipConfigResponse, "\n");
        while (tokenizer.hasMoreTokens()) {
            String macAddressCandidate;
            String line = tokenizer.nextToken().trim();
            int macAddressPosition = line.indexOf("ether");
            if (macAddressPosition != 0 || !AddressMACInfo.osxIsMacAddress(macAddressCandidate = line.substring(macAddressPosition + 6).trim())) continue;
            macs.add(macAddressCandidate);
        }
        String[] ma = new String[macs.size()];
        return macs.toArray(ma);
    }

    private static final boolean windowsIsMacAddress(String macAddressCandidate) {
        Pattern macPattern = Pattern.compile("[0-9a-fA-F]{2}-[0-9a-fA-F]{2}-[0-9a-fA-F]{2}-[0-9a-fA-F]{2}-[0-9a-fA-F]{2}-[0-9a-fA-F]{2}");
        Matcher matcher = macPattern.matcher(macAddressCandidate);
        Globals.println("MacAddress Windows:" + macAddressCandidate + " matcher: " + matcher.matches());
        return matcher.matches();
    }

    private static final boolean linuxIsMacAddress(String macAddressCandidate) {
        if (macAddressCandidate.length() != 17) {
            return false;
        }
        Globals.println("MacAddress Linux: " + macAddressCandidate);
        return true;
    }

    private static final boolean osxIsMacAddress(String macAddressCandidate) {
        return macAddressCandidate.length() == 17;
    }
}

