/*
 * Decompiled with CFR 0.152.
 */
package security;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyAgreement;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import security.HexWriter;
import security.Parameters;

public class DecryptGenerator {
    String ppka = "DH";
    String ska = "DES";
    String ca = "DES/ECB/PKCS5Padding";
    String separator = "<br>";
    int bufSize = 16;
    String charsetName = "UTF-8";
    SecureRandom random;
    KeyPairGenerator keyGen;
    PrivateKey privateKey;
    PublicKey publicKey;
    PrivateKey privateKey2;
    PublicKey publicKey2;

    public DecryptGenerator() {
        this.jbInit();
    }

    public DecryptGenerator(String ppka, String ska) {
        this.ppka = ppka;
        this.ska = ska;
        this.jbInit();
    }

    public DecryptGenerator(String ppka, String ska, String ca) {
        this.ppka = ppka;
        this.ska = ska;
        this.ca = ca;
        this.jbInit();
    }

    private void jbInit() {
        Parameters parameters = new Parameters();
        this.ppka = parameters.getPpka();
        this.ska = parameters.getSka();
        this.ca = parameters.getCa();
        this.separator = parameters.getSeparator();
        this.bufSize = parameters.getBufSize();
        this.charsetName = parameters.getCharsetName();
    }

    public String decryptFile(String algorithm, String inFile) {
        String res = "";
        HexWriter hexWriter = new HexWriter(this.charsetName);
        if (algorithm == null) {
            algorithm = this.ca;
        }
        if (algorithm.trim().equals("")) {
            algorithm = this.ca;
        }
        try {
            byte[] in = this.readFromFile(inFile);
            byte[] hrs = hexWriter.hexToByte(new String(in, this.charsetName));
            KeyAgreement ka = KeyAgreement.getInstance(this.ppka);
            ka.init(this.privateKey2);
            ka.doPhase(this.publicKey, true);
            SecretKey key = ka.generateSecret(this.ska);
            Cipher cipher = Cipher.getInstance(algorithm);
            cipher.init(2, key);
            byte[] text = cipher.doFinal(hrs);
            res = new String(text, this.charsetName);
        }
        catch (NoSuchAlgorithmException nosalex) {
            System.out.println(nosalex.getMessage());
        }
        catch (NoSuchPaddingException nospaex) {
            System.out.println(nospaex.getMessage());
        }
        catch (InvalidKeyException ikex) {
            System.out.println(ikex.getMessage());
        }
        catch (IllegalBlockSizeException ibsex) {
            System.out.println(ibsex.getMessage());
        }
        catch (BadPaddingException bpex) {
            System.out.println(bpex.getMessage());
        }
        catch (UnsupportedEncodingException useex) {
            System.out.println(useex.getMessage());
        }
        return res;
    }

    public String decryptDocument(String algorithm, String document) {
        String res = "";
        if (document == null) {
            return res;
        }
        HexWriter hexWriter = new HexWriter(this.charsetName);
        if (algorithm == null) {
            algorithm = this.ca;
        }
        if (algorithm.trim().equals("")) {
            algorithm = this.ca;
        }
        try {
            byte[] hrs = hexWriter.hexToByte(document);
            KeyAgreement ka = KeyAgreement.getInstance(this.ppka);
            ka.init(this.privateKey2);
            ka.doPhase(this.publicKey, true);
            SecretKey key = ka.generateSecret(this.ska);
            Cipher cipher = Cipher.getInstance(algorithm);
            cipher.init(2, key);
            byte[] text = cipher.doFinal(hrs);
            res = new String(text, this.charsetName);
        }
        catch (NoSuchAlgorithmException nosalex) {
            System.out.println(nosalex.getMessage());
        }
        catch (NoSuchPaddingException nospaex) {
            System.out.println(nospaex.getMessage());
        }
        catch (InvalidKeyException ikex) {
            System.out.println(ikex.getMessage());
        }
        catch (IllegalBlockSizeException ibsex) {
            System.out.println(ibsex.getMessage());
        }
        catch (BadPaddingException bpex) {
            System.out.println(bpex.getMessage());
        }
        catch (UnsupportedEncodingException useex) {
            System.out.println(useex.getMessage());
        }
        return res;
    }

    public PrivateKey getPrivateKey(String hex) {
        HexWriter hexWriter = new HexWriter(this.charsetName);
        byte[] encoded = hexWriter.hexToByte(hex);
        return this.getPrivateKey(encoded);
    }

    public PrivateKey getPrivateKey(byte[] encoded) {
        PrivateKey prk = null;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(this.ppka);
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(encoded);
            prk = keyFactory.generatePrivate(pkcs8KeySpec);
        }
        catch (NoSuchAlgorithmException nsalex) {
            System.out.println(nsalex.getMessage());
        }
        catch (InvalidKeySpecException iksex) {
            System.out.println(iksex.getMessage());
        }
        return prk;
    }

    public PublicKey getPublicKey(String hex) {
        HexWriter hexWriter = new HexWriter(this.charsetName);
        byte[] encoded = hexWriter.hexToByte(hex);
        return this.getPublicKey(encoded);
    }

    public PublicKey getPublicKey(byte[] encoded) {
        PublicKey puk = null;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(this.ppka);
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(encoded);
            puk = keyFactory.generatePublic(x509KeySpec);
        }
        catch (NoSuchAlgorithmException nsalex) {
            System.out.println(nsalex.getMessage());
        }
        catch (InvalidKeySpecException iksex) {
            System.out.println(iksex.getMessage());
        }
        return puk;
    }

    public PrivateKey getPrK1() {
        return this.privateKey;
    }

    public void setPrivateKey1(PrivateKey prk1) {
        this.privateKey = prk1;
    }

    public void setPrivateKey1(String prkHex1) {
        this.privateKey = this.getPrivateKey(prkHex1);
    }

    public PrivateKey getPrK2() {
        return this.privateKey2;
    }

    public void setPrivateKey2(PrivateKey prk2) {
        this.privateKey2 = prk2;
    }

    public void setPrivateKey2(String prkHex2) {
        this.privateKey2 = this.getPrivateKey(prkHex2);
    }

    public PublicKey getPuK1() {
        return this.publicKey;
    }

    public void setPublicKey1(PublicKey puk1) {
        this.publicKey = puk1;
    }

    public void setPublicKey1(String pukHex1) {
        this.publicKey = this.getPublicKey(pukHex1);
    }

    public PublicKey getPuK2() {
        return this.publicKey2;
    }

    public void setPublicKey2(PublicKey puk2) {
        this.publicKey2 = puk2;
    }

    public void setPublicKey2(String pukHex2) {
        this.publicKey2 = this.getPublicKey(pukHex2);
    }

    public int getBufferSize() {
        return this.bufSize;
    }

    public void setBufSize(int bufSize) {
        this.bufSize = bufSize;
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public void setCharsetName(String charsetName) {
        this.charsetName = charsetName;
    }

    public String[] getSCParameters(String prk2hex, String puk1hex, String scode) {
        String[] res = null;
        this.privateKey2 = this.getPrivateKey(prk2hex);
        this.publicKey = this.getPublicKey(puk1hex);
        String document = this.decryptDocument(this.ca, scode);
        if (document == null) {
            return res;
        }
        return document.split(this.separator);
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public String[] retrieveValuesFromSignature(byte[] signature, String document) {
        String[] res = null;
        try {
            Signature sig = Signature.getInstance("SHA1withDSA", "SUN");
            sig.initVerify(this.publicKey);
            sig.update(document.getBytes(this.charsetName));
            boolean verify = sig.verify(signature);
            System.out.println("Verify signature: " + verify);
            if (verify) {
                res = document.split("<br>");
            }
        }
        catch (NoSuchAlgorithmException nsaEx) {
            System.out.println(nsaEx.getMessage());
        }
        catch (SignatureException sEx) {
            System.out.println(sEx.getMessage());
        }
        catch (InvalidKeyException ikEx) {
            System.out.println(ikEx.getMessage());
        }
        catch (NoSuchProviderException nspex) {
            System.out.println(nspex.getMessage());
        }
        catch (UnsupportedEncodingException useex) {
            System.out.println(useex.getMessage());
        }
        return res;
    }

    public void writeSignatureToFile(byte[] signature, String outFile) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(outFile);
            fos.write(signature);
            fos.close();
        }
        catch (FileNotFoundException fnfEx) {
            System.out.println(fnfEx.getMessage());
        }
        catch (IOException ioEx) {
            System.out.println(ioEx.getMessage());
        }
    }

    public void writeHexToFile(byte[] encoded, String outFile) {
        byte[] buffer = new byte[this.bufSize];
        String crlf = System.getProperty("line.separator");
        HexWriter hexWriter = new HexWriter(this.charsetName);
        try {
            OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(outFile));
            String tmp = null;
            int count = 0;
            int nn = 0;
            for (int ii = 0; ii < encoded.length; ++ii) {
                if (count < this.bufSize) {
                    buffer[count] = encoded[ii];
                    ++count;
                }
                if (count != this.bufSize) continue;
                nn = buffer.length;
                tmp = hexWriter.bytesToHex(buffer, 0, nn);
                out.write(tmp);
                out.write(crlf);
                count = 0;
                buffer = new byte[this.bufSize];
            }
            if (count > 0) {
                nn = count;
                tmp = hexWriter.bytesToHex(buffer, 0, nn);
                out.write(tmp);
                out.write(crlf);
            }
            out.close();
        }
        catch (FileNotFoundException fnfEx) {
            System.out.println(fnfEx.getMessage());
        }
        catch (IOException ioEx) {
            System.out.println(ioEx.getMessage());
        }
    }

    public String writeHexToString(byte[] encoded) {
        byte[] buffer = new byte[this.bufSize];
        String crlf = System.getProperty("line.separator");
        HexWriter hexWriter = new HexWriter(this.charsetName);
        String res = "";
        int count = 0;
        int nn = 0;
        for (int ii = 0; ii < encoded.length; ++ii) {
            if (count < this.bufSize) {
                buffer[count] = encoded[ii];
                ++count;
            }
            if (count != this.bufSize) continue;
            nn = buffer.length;
            res = res + hexWriter.bytesToHex(buffer, 0, nn);
            res = res + crlf;
            count = 0;
            buffer = new byte[this.bufSize];
        }
        if (count > 0) {
            nn = count;
            res = res + hexWriter.bytesToHex(buffer, 0, nn);
            res = res + crlf;
        }
        return res;
    }

    public byte[] readFromFile(String inFile) {
        byte[] res = null;
        try {
            FileInputStream fis = new FileInputStream(inFile);
            res = new byte[fis.available()];
            fis.read(res);
            fis.close();
        }
        catch (FileNotFoundException fnfEx) {
            System.out.println(fnfEx.getMessage());
        }
        catch (IOException ioex) {
            System.out.println(ioex.getMessage());
        }
        return res;
    }

    public static void main(String[] args) {
        DecryptGenerator dgen = new DecryptGenerator("DH", "DES");
        String help = "";
        String decrypt = "java DecryptGenerator -decrypt inFile";
        help = help + "Usage: " + decrypt + "\n";
        help = help + "Decrypt content of \"inFile\" with privateKey2 and publicKey1.\n";
        if (args.length < 1) {
            System.out.println(help);
            return;
        }
        if (args[0].equals("-help")) {
            System.out.println(help);
            return;
        }
        if (args[0].equals("-decrypt")) {
            if (args.length < 2) {
                System.out.println("Encrypt Usage: " + decrypt);
                return;
            }
            try {
                System.out.println("privateKey2 (hex format): ");
                BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
                char chr = (char)br.read();
                String prk2hex = String.valueOf(chr);
                int f_exit = 0;
                while (f_exit < 2) {
                    chr = (char)br.read();
                    prk2hex = prk2hex + chr;
                    if (chr == '\n') {
                        ++f_exit;
                        continue;
                    }
                    f_exit = 0;
                }
                PrivateKey prk2 = dgen.getPrivateKey(prk2hex);
                System.out.println("publicKey1 (hex format): ");
                chr = (char)br.read();
                String puk1hex = String.valueOf(chr);
                f_exit = 0;
                while (f_exit < 2) {
                    chr = (char)br.read();
                    puk1hex = puk1hex + chr;
                    if (chr == '\n') {
                        ++f_exit;
                        continue;
                    }
                    f_exit = 0;
                }
                PublicKey puk1 = dgen.getPublicKey(puk1hex);
                dgen.setPrivateKey2(prk2);
                dgen.setPublicKey1(puk1);
                String document = dgen.decryptFile("DES/ECB/PKCS5Padding", args[1] + ".crpt");
                System.out.println("Decrypted document:\n" + document);
            }
            catch (IOException ioex) {
                ioex.getMessage();
            }
        }
    }
}

