/*
 * Decompiled with CFR 0.152.
 */
package security;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;

public class HexWriter {
    char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String HEXINDEX = "0123456789ABCDEF";
    String charsetName = "utf-8";
    private static int bufSize = 32;

    public HexWriter() {
    }

    public HexWriter(String charsetName) {
        this.charsetName = charsetName;
    }

    public HexWriter(String charsetName, int bufSize) {
        this.charsetName = charsetName;
        HexWriter.bufSize = bufSize;
    }

    public String bytesToHex(byte[] bb, int offset, int length) {
        StringBuffer buffer = new StringBuffer();
        for (int ii = 0; ii < length; ++ii) {
            buffer.append(this.byteToHex(bb[offset + ii]));
        }
        return buffer.toString();
    }

    public String byteToHex(byte bb) {
        char[] chars = new char[]{this.hexDigit[bb >> 4 & 0xF], this.hexDigit[bb & 0xF]};
        return new String(chars);
    }

    public byte[] hexToByte(String hex) {
        int ii;
        hex = hex.replaceAll("[^0-9ABCDEF]", "");
        int dim = hex.length() / 2;
        byte[] data = null;
        ArrayList<Integer> al = new ArrayList<Integer>(dim);
        int jj = 0;
        int cc = 0;
        if (hex.length() % 2 != 0) {
            System.out.println("Warning: Hexadecimal string with odd number of characters.");
        }
        for (ii = 0; ii < dim; ++ii) {
            char ch;
            int nn;
            if ((nn = HEXINDEX.indexOf(ch = hex.charAt(jj++))) == -1) {
                if (cc == 0) {
                    System.out.println("Waring: Hexadecimal string contains non hex character.");
                }
                ++cc;
                ++jj;
                continue;
            }
            int bb = (nn & 0xF) << 4;
            ch = hex.charAt(jj++);
            nn = HEXINDEX.indexOf(ch);
            al.add(new Integer(bb += nn & 0xF));
        }
        dim = al.size();
        data = new byte[dim];
        for (ii = 0; ii < dim; ++ii) {
            data[ii] = (byte)((Integer)al.get(ii)).intValue();
        }
        return data;
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Usage:");
            System.out.println("java HexWriter input-file output-file");
            return;
        }
        HexWriter hexWriter = new HexWriter();
        String inFile = args[0];
        String outFile = args[1];
        byte[] buffer = new byte[bufSize];
        String crlf = System.getProperty("line.separator");
        try {
            FileInputStream in = new FileInputStream(inFile);
            OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(outFile));
            int nn = in.read(buffer, 0, bufSize);
            String tmp = null;
            int count = 0;
            while (nn != -1) {
                count += nn;
                tmp = hexWriter.bytesToHex(buffer, 0, nn);
                out.write(tmp);
                out.write(crlf);
                nn = in.read(buffer, 0, bufSize);
            }
            in.close();
            out.close();
            System.out.println("Number of input bytes: " + count);
        }
        catch (IOException ioEx) {
            System.out.println(ioEx.toString());
        }
    }
}

